/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class AtomicLongArrayTest
extends JSR166TestCase {
    static final long COUNTDOWN = 100000L;

    public static Test suite() {
        return new TestSuite(AtomicLongArrayTest.class);
    }

    public void testConstructor() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            AtomicLongArrayTest.assertEquals((long)0L, (long)ai.get(i));
        }
    }

    public void testConstructor2NPE() {
        try {
            long[] a = null;
            AtomicLongArray ai = new AtomicLongArray(a);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        long[] a = new long[]{17L, 3L, -42L, 99L, -7L};
        AtomicLongArray ai = new AtomicLongArray(a);
        AtomicLongArrayTest.assertEquals((int)a.length, (int)ai.length());
        for (int i = 0; i < a.length; ++i) {
            AtomicLongArrayTest.assertEquals((long)a[i], (long)ai.get(i));
        }
    }

    public void testIndexing() {
        AtomicLongArray ai = new AtomicLongArray(20);
        try {
            ai.get(20);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.get(-1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.set(20, 0L);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.set(-1, 0L);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.get(i));
            ai.set(i, 2L);
            AtomicLongArrayTest.assertEquals((long)2L, (long)ai.get(i));
            ai.set(i, -3L);
            AtomicLongArrayTest.assertEquals((long)-3L, (long)ai.get(i));
        }
    }

    public void testGetLazySet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.lazySet(i, 1L);
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.get(i));
            ai.lazySet(i, 2L);
            AtomicLongArrayTest.assertEquals((long)2L, (long)ai.get(i));
            ai.lazySet(i, -3L);
            AtomicLongArrayTest.assertEquals((long)-3L, (long)ai.get(i));
        }
    }

    public void testCompareAndSet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertTrue((boolean)ai.compareAndSet(i, 1L, 2L));
            AtomicLongArrayTest.assertTrue((boolean)ai.compareAndSet(i, 2L, -4L));
            AtomicLongArrayTest.assertEquals((long)-4L, (long)ai.get(i));
            AtomicLongArrayTest.assertFalse((boolean)ai.compareAndSet(i, -5L, 7L));
            AtomicLongArrayTest.assertEquals((long)-4L, (long)ai.get(i));
            AtomicLongArrayTest.assertTrue((boolean)ai.compareAndSet(i, -4L, 7L));
            AtomicLongArrayTest.assertEquals((long)7L, (long)ai.get(i));
        }
    }

    public void testCompareAndSetInMultipleThreads() throws InterruptedException {
        final AtomicLongArray a = new AtomicLongArray(1);
        a.set(0, 1L);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                while (!a.compareAndSet(0, 2L, 3L)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicLongArrayTest.assertTrue((boolean)a.compareAndSet(0, 1L, 2L));
        t.join(LONG_DELAY_MS);
        AtomicLongArrayTest.assertFalse((boolean)t.isAlive());
        AtomicLongArrayTest.assertEquals((long)a.get(0), (long)3L);
    }

    public void testWeakCompareAndSet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            while (!ai.weakCompareAndSet(i, 1L, 2L)) {
            }
            while (!ai.weakCompareAndSet(i, 2L, -4L)) {
            }
            AtomicLongArrayTest.assertEquals((long)-4L, (long)ai.get(i));
            while (!ai.weakCompareAndSet(i, -4L, 7L)) {
            }
            AtomicLongArrayTest.assertEquals((long)7L, (long)ai.get(i));
        }
    }

    public void testGetAndSet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.getAndSet(i, 0L));
            AtomicLongArrayTest.assertEquals((long)0L, (long)ai.getAndSet(i, -10L));
            AtomicLongArrayTest.assertEquals((long)-10L, (long)ai.getAndSet(i, 1L));
        }
    }

    public void testGetAndAdd() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.getAndAdd(i, 2L));
            AtomicLongArrayTest.assertEquals((long)3L, (long)ai.get(i));
            AtomicLongArrayTest.assertEquals((long)3L, (long)ai.getAndAdd(i, -4L));
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.get(i));
        }
    }

    public void testGetAndDecrement() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.getAndDecrement(i));
            AtomicLongArrayTest.assertEquals((long)0L, (long)ai.getAndDecrement(i));
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.getAndDecrement(i));
        }
    }

    public void testGetAndIncrement() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.getAndIncrement(i));
            AtomicLongArrayTest.assertEquals((long)2L, (long)ai.get(i));
            ai.set(i, -2L);
            AtomicLongArrayTest.assertEquals((long)-2L, (long)ai.getAndIncrement(i));
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.getAndIncrement(i));
            AtomicLongArrayTest.assertEquals((long)0L, (long)ai.getAndIncrement(i));
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.get(i));
        }
    }

    public void testAddAndGet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)3L, (long)ai.addAndGet(i, 2L));
            AtomicLongArrayTest.assertEquals((long)3L, (long)ai.get(i));
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.addAndGet(i, -4L));
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.get(i));
        }
    }

    public void testDecrementAndGet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)0L, (long)ai.decrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.decrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)-2L, (long)ai.decrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)-2L, (long)ai.get(i));
        }
    }

    public void testIncrementAndGet() {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1L);
            AtomicLongArrayTest.assertEquals((long)2L, (long)ai.incrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)2L, (long)ai.get(i));
            ai.set(i, -2L);
            AtomicLongArrayTest.assertEquals((long)-1L, (long)ai.incrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)0L, (long)ai.incrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.incrementAndGet(i));
            AtomicLongArrayTest.assertEquals((long)1L, (long)ai.get(i));
        }
    }

    public void testCountingInMultipleThreads() throws InterruptedException {
        AtomicLongArray ai = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 100000L);
        }
        Counter c1 = new Counter(ai);
        Counter c2 = new Counter(ai);
        Thread t1 = new Thread(c1);
        Thread t2 = new Thread(c2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        AtomicLongArrayTest.assertEquals((long)(c1.counts + c2.counts), (long)2000000L);
    }

    public void testSerialization() throws Exception {
        AtomicLongArray l = new AtomicLongArray(20);
        for (int i = 0; i < 20; ++i) {
            l.set(i, -i);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicLongArray r = (AtomicLongArray)in.readObject();
        for (int i = 0; i < 20; ++i) {
            AtomicLongArrayTest.assertEquals((long)l.get(i), (long)r.get(i));
        }
    }

    public void testToString() {
        long[] a = new long[]{17L, 3L, -42L, 99L, -7L};
        AtomicLongArray ai = new AtomicLongArray(a);
        AtomicLongArrayTest.assertEquals((String)Arrays.toString(a), (String)ai.toString());
    }

    class Counter
    implements Runnable {
        final AtomicLongArray ai;
        volatile long counts;

        Counter(AtomicLongArray a) {
            this.ai = a;
        }

        public void run() {
            boolean done;
            do {
                done = true;
                for (int i = 0; i < this.ai.length(); ++i) {
                    long v = this.ai.get(i);
                    AtomicLongArrayTest.this.threadAssertTrue(v >= 0L);
                    if (v == 0L) continue;
                    done = false;
                    if (!this.ai.compareAndSet(i, v, v - 1L)) continue;
                    ++this.counts;
                }
            } while (!done);
        }
    }
}

