/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class AtomicBooleanTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(AtomicBooleanTest.class);
    }

    public void testConstructor() {
        AtomicBooleanTest.assertTrue((boolean)new AtomicBoolean(true).get());
        AtomicBooleanTest.assertFalse((boolean)new AtomicBoolean(false).get());
    }

    public void testConstructor2() {
        AtomicBoolean ai = new AtomicBoolean();
        AtomicBooleanTest.assertFalse((boolean)ai.get());
    }

    public void testGetSet() {
        AtomicBoolean ai = new AtomicBoolean(true);
        AtomicBooleanTest.assertTrue((boolean)ai.get());
        ai.set(false);
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        ai.set(true);
        AtomicBooleanTest.assertTrue((boolean)ai.get());
    }

    public void testGetLazySet() {
        AtomicBoolean ai = new AtomicBoolean(true);
        AtomicBooleanTest.assertTrue((boolean)ai.get());
        ai.lazySet(false);
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        ai.lazySet(true);
        AtomicBooleanTest.assertTrue((boolean)ai.get());
    }

    public void testCompareAndSet() {
        AtomicBoolean ai = new AtomicBoolean(true);
        AtomicBooleanTest.assertTrue((boolean)ai.compareAndSet(true, false));
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        AtomicBooleanTest.assertTrue((boolean)ai.compareAndSet(false, false));
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        AtomicBooleanTest.assertFalse((boolean)ai.compareAndSet(true, false));
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        AtomicBooleanTest.assertTrue((boolean)ai.compareAndSet(false, true));
        AtomicBooleanTest.assertTrue((boolean)ai.get());
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicBoolean ai = new AtomicBoolean(true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                while (!ai.compareAndSet(false, true)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicBooleanTest.assertTrue((boolean)ai.compareAndSet(true, false));
        t.join(LONG_DELAY_MS);
        AtomicBooleanTest.assertFalse((boolean)t.isAlive());
    }

    public void testWeakCompareAndSet() {
        AtomicBoolean ai = new AtomicBoolean(true);
        while (!ai.weakCompareAndSet(true, false)) {
        }
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        while (!ai.weakCompareAndSet(false, false)) {
        }
        AtomicBooleanTest.assertFalse((boolean)ai.get());
        while (!ai.weakCompareAndSet(false, true)) {
        }
        AtomicBooleanTest.assertTrue((boolean)ai.get());
    }

    public void testGetAndSet() {
        AtomicBoolean ai = new AtomicBoolean(true);
        AtomicBooleanTest.assertEquals((boolean)true, (boolean)ai.getAndSet(false));
        AtomicBooleanTest.assertEquals((boolean)false, (boolean)ai.getAndSet(false));
        AtomicBooleanTest.assertEquals((boolean)false, (boolean)ai.getAndSet(true));
        AtomicBooleanTest.assertTrue((boolean)ai.get());
    }

    public void testSerialization() throws Exception {
        AtomicBoolean l = new AtomicBoolean();
        l.set(true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicBoolean r = (AtomicBoolean)in.readObject();
        AtomicBooleanTest.assertEquals((boolean)l.get(), (boolean)r.get());
    }

    public void testToString() {
        AtomicBoolean ai = new AtomicBoolean();
        AtomicBooleanTest.assertEquals((String)ai.toString(), (String)Boolean.toString(false));
        ai.set(true);
        AtomicBooleanTest.assertEquals((String)ai.toString(), (String)Boolean.toString(true));
    }
}

