/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ArrayDequeTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ArrayDequeTest.class);
    }

    private ArrayDeque populatedDeque(int n) {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            ArrayDequeTest.assertTrue((boolean)q.offerLast(new Integer(i)));
        }
        ArrayDequeTest.assertFalse((boolean)q.isEmpty());
        ArrayDequeTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        ArrayDequeTest.assertEquals((int)0, (int)new ArrayDeque().size());
    }

    public void testConstructor3() {
        try {
            ArrayDeque q = new ArrayDeque(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ArrayDeque<Integer> q = new ArrayDeque<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testEmpty() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        ArrayDequeTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.removeFirst();
        q.removeFirst();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        ArrayDeque q = this.populatedDeque(20);
        for (i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((int)(20 - i), (int)q.size());
            q.removeFirst();
        }
        for (i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testPushNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>(1);
            q.push(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPush() {
        ArrayDeque q = this.populatedDeque(3);
        q.pollLast();
        q.push(four);
        ArrayDequeTest.assertSame((Object)four, q.peekFirst());
    }

    public void testPop() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.pop());
        }
        try {
            q.pop();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOfferFirstNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.offerFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOfferFirst() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.offerFirst(new Integer(0)));
        ArrayDequeTest.assertTrue((boolean)q.offerFirst(new Integer(1)));
    }

    public void testOfferLast() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.offerLast(new Integer(0)));
        ArrayDequeTest.assertTrue((boolean)q.offerLast(new Integer(1)));
    }

    public void testAdd() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((int)i, (int)q.size());
            ArrayDequeTest.assertTrue((boolean)q.add(new Integer(i)));
        }
    }

    public void testAddAll1() {
        try {
            ArrayDeque q = new ArrayDeque();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ArrayDequeTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)ints[i], q.pollFirst());
        }
    }

    public void testPollFirst() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.pollFirst());
        }
        ArrayDequeTest.assertNull(q.pollFirst());
    }

    public void testPollLast() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, q.pollLast());
        }
        ArrayDequeTest.assertNull(q.pollLast());
    }

    public void testPoll() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.poll());
        }
        ArrayDequeTest.assertNull(q.poll());
    }

    public void testRemove() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testPeekFirst() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.peekFirst());
            ArrayDequeTest.assertEquals((Object)i, q.pollFirst());
            ArrayDequeTest.assertTrue((q.peekFirst() == null || !q.peekFirst().equals(i) ? 1 : 0) != 0);
        }
        ArrayDequeTest.assertNull(q.peekFirst());
    }

    public void testPeek() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.peek());
            ArrayDequeTest.assertEquals((Object)i, q.poll());
            ArrayDequeTest.assertTrue((q.peek() == null || !q.peek().equals(i) ? 1 : 0) != 0);
        }
        ArrayDequeTest.assertNull(q.peek());
    }

    public void testPeekLast() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, q.peekLast());
            ArrayDequeTest.assertEquals((Object)i, q.pollLast());
            ArrayDequeTest.assertTrue((q.peekLast() == null || !q.peekLast().equals(i) ? 1 : 0) != 0);
        }
        ArrayDequeTest.assertNull(q.peekLast());
    }

    public void testFirstElement() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.getFirst());
            ArrayDequeTest.assertEquals((Object)i, q.pollFirst());
        }
        try {
            q.getFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLastElement() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, q.getLast());
            ArrayDequeTest.assertEquals((Object)i, q.pollLast());
        }
        try {
            q.getLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ArrayDequeTest.assertNull(q.peekLast());
    }

    public void testRemoveFirst() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, q.removeFirst());
        }
        try {
            q.removeFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveFirstOccurrence() {
        int i;
        ArrayDeque q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
            ArrayDequeTest.assertFalse((boolean)q.removeFirstOccurrence(new Integer(i + 1)));
        }
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemoveLastOccurrence() {
        int i;
        ArrayDeque q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
            ArrayDequeTest.assertFalse((boolean)q.removeLastOccurrence(new Integer(i + 1)));
        }
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        ArrayDeque q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertTrue((boolean)q.contains(new Integer(i)));
            ArrayDequeTest.assertEquals((Object)i, q.pollFirst());
            ArrayDequeTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        ArrayDeque q = this.populatedDeque(20);
        q.clear();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        ArrayDequeTest.assertEquals((int)0, (int)q.size());
        ArrayDequeTest.assertTrue((boolean)q.add(new Integer(1)));
        ArrayDequeTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        ArrayDeque q = this.populatedDeque(20);
        ArrayDeque<Integer> p = new ArrayDeque<Integer>();
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertTrue((boolean)q.containsAll(p));
            ArrayDequeTest.assertFalse((boolean)p.containsAll(q));
            ArrayDequeTest.assertTrue((boolean)p.add(new Integer(i)));
        }
        ArrayDequeTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        ArrayDeque q = this.populatedDeque(20);
        ArrayDeque p = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            ArrayDequeTest.assertEquals((boolean)changed, (i > 0 ? 1 : 0) != 0);
            ArrayDequeTest.assertTrue((boolean)q.containsAll(p));
            ArrayDequeTest.assertEquals((int)(20 - i), (int)q.size());
            p.removeFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            ArrayDeque q = this.populatedDeque(20);
            ArrayDeque p = this.populatedDeque(i);
            ArrayDequeTest.assertTrue((boolean)q.removeAll(p));
            ArrayDequeTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                ArrayDequeTest.assertFalse((boolean)q.contains(p.removeFirst()));
            }
        }
    }

    public void testToArray() {
        ArrayDeque q = this.populatedDeque(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            ArrayDequeTest.assertEquals((Object)o[i], q.pollFirst());
        }
    }

    public void testToArray2() {
        ArrayDeque q = this.populatedDeque(20);
        Object[] ints = new Integer[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            ArrayDequeTest.assertEquals((Object)ints[i], q.pollFirst());
        }
    }

    public void testToArray_BadArg() {
        ArrayDeque<Object> l = new ArrayDeque<Object>();
        l.add(new Object());
        try {
            T[] o = l.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        ArrayDeque<Integer> l = new ArrayDeque<Integer>();
        l.add(new Integer(5));
        try {
            String[] o = l.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        ArrayDeque q = this.populatedDeque(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ArrayDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ArrayDequeTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorOrdering() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        q.add(new Integer(1));
        q.add(new Integer(2));
        q.add(new Integer(3));
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ArrayDequeTest.assertEquals((Object)(++k), it.next());
        }
        ArrayDequeTest.assertEquals((int)3, (int)k);
    }

    public void testIteratorRemove() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        Random rng = new Random();
        for (int iters = 0; iters < 100; ++iters) {
            int j;
            int max = rng.nextInt(5) + 2;
            int split = rng.nextInt(max - 1) + 1;
            for (int j2 = 1; j2 <= max; ++j2) {
                q.add(new Integer(j2));
            }
            Iterator it = q.iterator();
            for (j = 1; j <= split; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
            }
            it.remove();
            ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(split + 1));
            for (j = 1; j <= split; ++j) {
                q.remove(new Integer(j));
            }
            it = q.iterator();
            for (j = split + 1; j <= max; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
                it.remove();
            }
            ArrayDequeTest.assertFalse((boolean)it.hasNext());
            ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        }
    }

    public void testDescendingIterator() {
        ArrayDeque q = this.populatedDeque(20);
        int i = 0;
        Iterator it = q.descendingIterator();
        while (it.hasNext()) {
            ArrayDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ArrayDequeTest.assertEquals((int)i, (int)20);
        ArrayDequeTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            this.shouldThrow();
        }
        catch (NoSuchElementException success) {
            // empty catch block
        }
    }

    public void testDescendingIteratorOrdering() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        for (int iters = 0; iters < 100; ++iters) {
            q.add(new Integer(3));
            q.add(new Integer(2));
            q.add(new Integer(1));
            int k = 0;
            Iterator it = q.descendingIterator();
            while (it.hasNext()) {
                ArrayDequeTest.assertEquals((Object)(++k), it.next());
            }
            ArrayDequeTest.assertEquals((int)3, (int)k);
            q.remove();
            q.remove();
            q.remove();
        }
    }

    public void testDescendingIteratorRemove() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        Random rng = new Random();
        for (int iters = 0; iters < 100; ++iters) {
            int j;
            int max = rng.nextInt(5) + 2;
            int split = rng.nextInt(max - 1) + 1;
            for (int j2 = max; j2 >= 1; --j2) {
                q.add(new Integer(j2));
            }
            Iterator it = q.descendingIterator();
            for (j = 1; j <= split; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
            }
            it.remove();
            ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(split + 1));
            for (j = 1; j <= split; ++j) {
                q.remove(new Integer(j));
            }
            it = q.descendingIterator();
            for (j = split + 1; j <= max; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
                it.remove();
            }
            ArrayDequeTest.assertFalse((boolean)it.hasNext());
            ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        }
    }

    public void testToString() {
        ArrayDeque q = this.populatedDeque(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAddFirst() {
        ArrayDeque q = this.populatedDeque(3);
        q.addFirst(four);
        ArrayDequeTest.assertSame((Object)four, q.peekFirst());
    }

    public void testAddLast() {
        ArrayDeque q = this.populatedDeque(3);
        q.addLast(four);
        ArrayDequeTest.assertSame((Object)four, q.peekLast());
    }
}

