/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util.concurrent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import tests.api.java.util.concurrent.JSR166TestCase;

public class ArrayBlockingQueueTest
extends JSR166TestCase {
    public static Test suite() {
        return new TestSuite(ArrayBlockingQueueTest.class);
    }

    private ArrayBlockingQueue populatedQueue(int n) {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(n);
        ArrayBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            ArrayBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        ArrayBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        ArrayBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
        ArrayBlockingQueueTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        ArrayBlockingQueueTest.assertEquals((int)20, (int)new ArrayBlockingQueue(20).remainingCapacity());
    }

    public void testConstructor2() {
        try {
            ArrayBlockingQueue q = new ArrayBlockingQueue(0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            ArrayBlockingQueue q = new ArrayBlockingQueue(1, true, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20, false, Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20, false, Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 20; ++i) {
                ints[i] = new Integer(i);
            }
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(1, false, Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor7() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20, true, Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmptyFull() {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(2);
        ArrayBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        ArrayBlockingQueueTest.assertEquals((int)2, (int)q.remainingCapacity());
        q.add(one);
        ArrayBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        q.add(two);
        ArrayBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        ArrayBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
        ArrayBlockingQueueTest.assertFalse((boolean)q.offer(three));
    }

    public void testRemainingCapacity() {
        int i;
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((int)i, (int)q.remainingCapacity());
            ArrayBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((int)(20 - i), (int)q.remainingCapacity());
            ArrayBlockingQueueTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            ArrayBlockingQueue<Object> q = new ArrayBlockingQueue<Object>(1);
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            ArrayBlockingQueue<Object> q = new ArrayBlockingQueue<Object>(1);
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(1);
        ArrayBlockingQueueTest.assertTrue((boolean)q.offer(zero));
        ArrayBlockingQueueTest.assertFalse((boolean)q.offer(one));
    }

    public void testAdd() {
        try {
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20);
            for (int i = 0; i < 20; ++i) {
                ArrayBlockingQueueTest.assertTrue((boolean)q.add(new Integer(i)));
            }
            ArrayBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
            q.add(new Integer(20));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            ArrayBlockingQueue q = new ArrayBlockingQueue(1);
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            ArrayBlockingQueue q = this.populatedQueue(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll4() {
        try {
            ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(1);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 20; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20);
        ArrayBlockingQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ArrayBlockingQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPutNull() throws InterruptedException {
        try {
            ArrayBlockingQueue<Object> q = new ArrayBlockingQueue<Object>(20);
            q.put(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut() throws InterruptedException {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            Integer I2 = new Integer(i);
            q.put(I2);
            ArrayBlockingQueueTest.assertTrue((boolean)q.contains(I2));
        }
        ArrayBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testBlockingPut() throws InterruptedException {
        final ArrayBlockingQueue q = new ArrayBlockingQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    q.put(i);
                }
                Assert.assertEquals((int)20, (int)q.size());
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
                try {
                    q.put(99);
                    ArrayBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        ArrayBlockingQueueTest.assertEquals((int)20, (int)q.size());
        ArrayBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testPutWithTake() throws InterruptedException {
        int capacity = 2;
        final ArrayBlockingQueue q = new ArrayBlockingQueue(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                for (int i = 0; i < 3; ++i) {
                    q.put(i);
                }
                try {
                    q.put(99);
                    ArrayBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        ArrayBlockingQueueTest.assertEquals((int)q.remainingCapacity(), (int)0);
        ArrayBlockingQueueTest.assertEquals((Object)0, q.take());
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        ArrayBlockingQueueTest.assertEquals((int)q.remainingCapacity(), (int)0);
    }

    public void testTimedOffer() throws InterruptedException {
        final ArrayBlockingQueue q = new ArrayBlockingQueue(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                q.put(new Object());
                q.put(new Object());
                Assert.assertFalse((boolean)q.offer(new Object(), JSR166TestCase.SHORT_DELAY_MS / 2L, TimeUnit.MILLISECONDS));
                try {
                    q.offer(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    ArrayBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTake() throws InterruptedException {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.take());
        }
    }

    public void testTakeFromEmpty() throws InterruptedException {
        final ArrayBlockingQueue q = new ArrayBlockingQueue(2);
        JSR166TestCase.ThreadShouldThrow t = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

            public void realRun() throws InterruptedException {
                q.take();
            }
        };
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testBlockingTake() throws InterruptedException {
        final ArrayBlockingQueue q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.take());
                }
                try {
                    q.take();
                    ArrayBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPoll() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.poll());
        }
        ArrayBlockingQueueTest.assertNull(q.poll());
    }

    public void testTimedPoll0() throws InterruptedException {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.poll(0L, TimeUnit.MILLISECONDS));
        }
        ArrayBlockingQueueTest.assertNull(q.poll(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPoll() throws InterruptedException {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        ArrayBlockingQueueTest.assertNull(q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                ArrayBlockingQueue q = ArrayBlockingQueueTest.this.populatedQueue(20);
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                }
                try {
                    q.poll(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
                    ArrayBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollWithOffer() throws InterruptedException {
        final ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)JSR166TestCase.zero, q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    ArrayBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(SMALL_DELAY_MS);
        ArrayBlockingQueueTest.assertTrue((boolean)q.offer(zero, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        t.interrupt();
        t.join();
    }

    public void testPeek() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.peek());
            ArrayBlockingQueueTest.assertEquals((Object)i, q.poll());
            ArrayBlockingQueueTest.assertTrue((q.peek() == null || !q.peek().equals(i) ? 1 : 0) != 0);
        }
        ArrayBlockingQueueTest.assertNull(q.peek());
    }

    public void testElement() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.element());
            ArrayBlockingQueueTest.assertEquals((Object)i, q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)i, q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            ArrayBlockingQueueTest.assertTrue((boolean)q.remove(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ArrayBlockingQueueTest.assertTrue((boolean)q.remove(new Integer(i)));
            ArrayBlockingQueueTest.assertFalse((boolean)q.remove(new Integer(i + 1)));
        }
        ArrayBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertTrue((boolean)q.contains(new Integer(i)));
            ArrayBlockingQueueTest.assertEquals((Object)i, q.poll());
            ArrayBlockingQueueTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        q.clear();
        ArrayBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        ArrayBlockingQueueTest.assertEquals((int)0, (int)q.size());
        ArrayBlockingQueueTest.assertEquals((int)20, (int)q.remainingCapacity());
        q.add(one);
        ArrayBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        ArrayBlockingQueueTest.assertTrue((boolean)q.contains(one));
        q.clear();
        ArrayBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        ArrayBlockingQueue<Integer> p = new ArrayBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertTrue((boolean)q.containsAll(p));
            ArrayBlockingQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        ArrayBlockingQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        ArrayBlockingQueue p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                ArrayBlockingQueueTest.assertFalse((boolean)changed);
            } else {
                ArrayBlockingQueueTest.assertTrue((boolean)changed);
            }
            ArrayBlockingQueueTest.assertTrue((boolean)q.containsAll(p));
            ArrayBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            ArrayBlockingQueue q = this.populatedQueue(20);
            ArrayBlockingQueue p = this.populatedQueue(i);
            ArrayBlockingQueueTest.assertTrue((boolean)q.removeAll(p));
            ArrayBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I2 = (Integer)p.remove();
                ArrayBlockingQueueTest.assertFalse((boolean)q.contains(I2));
            }
        }
    }

    public void testToArray() throws InterruptedException {
        ArrayBlockingQueue q = this.populatedQueue(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)o[i], q.take());
        }
    }

    public void testToArray2() throws InterruptedException {
        ArrayBlockingQueue q = this.populatedQueue(20);
        Integer[] ints = new Integer[20];
        ints = q.toArray(ints);
        for (int i = 0; i < ints.length; ++i) {
            ArrayBlockingQueueTest.assertEquals((Object)ints[i], q.take());
        }
    }

    public void testToArray_BadArg() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        try {
            T[] o = q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        try {
            String[] o = q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() throws InterruptedException {
        ArrayBlockingQueue q = this.populatedQueue(20);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ArrayBlockingQueueTest.assertEquals(it.next(), q.take());
        }
    }

    public void testIteratorRemove() {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(3);
        q.add(two);
        q.add(one);
        q.add(three);
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        ArrayBlockingQueueTest.assertSame(it.next(), (Object)one);
        ArrayBlockingQueueTest.assertSame(it.next(), (Object)three);
        ArrayBlockingQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testIteratorOrdering() {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(3);
        q.add(one);
        q.add(two);
        q.add(three);
        ArrayBlockingQueueTest.assertEquals((String)"queue should be full", (int)0, (int)q.remainingCapacity());
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ArrayBlockingQueueTest.assertEquals((Object)(++k), it.next());
        }
        ArrayBlockingQueueTest.assertEquals((int)3, (int)k);
    }

    public void testWeaklyConsistentIteration() {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(3);
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            q.remove();
            it.next();
        }
        ArrayBlockingQueueTest.assertEquals((int)0, (int)q.size());
    }

    public void testToString() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testOfferInExecutor() {
        final ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(2);
        q.add(one);
        q.add(two);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)q.offer(JSR166TestCase.three));
                Assert.assertTrue((boolean)q.offer(JSR166TestCase.three, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertSame((Object)JSR166TestCase.one, q.take());
            }
        });
        this.joinPool(executor);
    }

    public void testPollInExecutor() {
        final ArrayBlockingQueue q = new ArrayBlockingQueue(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll());
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.isEmpty());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                Thread.sleep(JSR166TestCase.SMALL_DELAY_MS);
                q.put(JSR166TestCase.one);
            }
        });
        this.joinPool(executor);
    }

    public void testSerialization() throws Exception {
        ArrayBlockingQueue q = this.populatedQueue(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ArrayBlockingQueue r = (ArrayBlockingQueue)in.readObject();
        ArrayBlockingQueueTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ArrayBlockingQueueTest.assertEquals(q.remove(), r.remove());
        }
    }

    public void testDrainToNull() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        int i;
        ArrayBlockingQueue q = this.populatedQueue(20);
        ArrayList l = new ArrayList();
        q.drainTo(l);
        ArrayBlockingQueueTest.assertEquals((int)q.size(), (int)0);
        ArrayBlockingQueueTest.assertEquals((int)l.size(), (int)20);
        for (i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        q.add(zero);
        q.add(one);
        ArrayBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        ArrayBlockingQueueTest.assertTrue((boolean)q.contains(zero));
        ArrayBlockingQueueTest.assertTrue((boolean)q.contains(one));
        l.clear();
        q.drainTo(l);
        ArrayBlockingQueueTest.assertEquals((int)q.size(), (int)0);
        ArrayBlockingQueueTest.assertEquals((int)l.size(), (int)2);
        for (i = 0; i < 2; ++i) {
            ArrayBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final ArrayBlockingQueue q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() throws InterruptedException {
                q.put(new Integer(21));
            }
        });
        t.start();
        ArrayList l = new ArrayList();
        q.drainTo(l);
        ArrayBlockingQueueTest.assertTrue((l.size() >= 20 ? 1 : 0) != 0);
        for (int i = 0; i < 20; ++i) {
            ArrayBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        t.join();
        ArrayBlockingQueueTest.assertTrue((q.size() + l.size() >= 20 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(null, 0);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        ArrayBlockingQueue q = this.populatedQueue(20);
        try {
            q.drainTo(q, 0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() {
        ArrayBlockingQueue<Integer> q = new ArrayBlockingQueue<Integer>(40);
        for (int i = 0; i < 22; ++i) {
            for (int j = 0; j < 20; ++j) {
                ArrayBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(j)));
            }
            ArrayList l = new ArrayList();
            q.drainTo(l, i);
            int k = i < 20 ? i : 20;
            ArrayBlockingQueueTest.assertEquals((int)l.size(), (int)k);
            ArrayBlockingQueueTest.assertEquals((int)q.size(), (int)(20 - k));
            for (int j = 0; j < k; ++j) {
                ArrayBlockingQueueTest.assertEquals(l.get(j), (Object)new Integer(j));
            }
            while (q.poll() != null) {
            }
        }
    }
}

