/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import junit.framework.TestCase;
import tests.support.Support_MapTest2;

@TestTargetClass(value=WeakHashMap.class)
public class WeakHashMapTest
extends TestCase {
    Object[] keyArray = new Object[100];
    Object[] valueArray = new Object[100];
    WeakHashMap whm;

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="WeakHashMap", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})})
    public void test_Constructor() {
        int i;
        new Support_MapTest2(new WeakHashMap<String, String>()).runTest();
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Incorrect value retrieved", (this.whm.get(this.keyArray[i]) == this.valueArray[i] ? 1 : 0) != 0);
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="WeakHashMap", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})})
    public void test_ConstructorI() {
        int i;
        this.whm = new WeakHashMap(50);
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Incorrect value retrieved", (this.whm.get(this.keyArray[i]) == this.valueArray[i] ? 1 : 0) != 0);
        }
        WeakHashMap<String, String> empty = new WeakHashMap<String, String>(0);
        WeakHashMapTest.assertNull((String)"Empty weakhashmap access", empty.get("nothing"));
        empty.put("something", "here");
        WeakHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
        try {
            new WeakHashMap(-50);
            WeakHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="WeakHashMap", args={int.class, float.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})})
    public void test_ConstructorIF() {
        int i;
        this.whm = new WeakHashMap(50, 0.5f);
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Incorrect value retrieved", (this.whm.get(this.keyArray[i]) == this.valueArray[i] ? 1 : 0) != 0);
        }
        WeakHashMap<String, String> empty = new WeakHashMap<String, String>(0, 0.75f);
        WeakHashMapTest.assertNull((String)"Empty hashtable access", empty.get("nothing"));
        empty.put("something", "here");
        WeakHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
        try {
            new WeakHashMap(50, -0.5f);
            WeakHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new WeakHashMap(-50, 0.5f);
            WeakHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="WeakHashMap", args={Map.class})
    public void test_ConstructorLjava_util_Map() {
        MockMap mockMap = new MockMap();
        WeakHashMap map = new WeakHashMap(mockMap);
        WeakHashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)map.size());
        try {
            new WeakHashMap(null);
            WeakHashMapTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})})
    public void test_clear() {
        int i;
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        this.whm.clear();
        WeakHashMapTest.assertTrue((String)"Cleared map should be empty", (boolean)this.whm.isEmpty());
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertNull((String)"Cleared map should only return null", this.whm.get(this.keyArray[i]));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsKey", args={Object.class})
    public void test_containsKeyLjava_lang_Object() {
        int i;
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Should contain referenced key", (boolean)this.whm.containsKey(this.keyArray[i]));
        }
        this.keyArray[25] = null;
        this.keyArray[50] = null;
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsValue", args={Object.class})
    public void test_containsValueLjava_lang_Object() {
        int i;
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Should contain referenced value", (boolean)this.whm.containsValue(this.valueArray[i]));
        }
        this.keyArray[25] = null;
        this.keyArray[50] = null;
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="entrySet", args={})
    public void test_entrySet() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        List<Object> keys = Arrays.asList(this.keyArray);
        List<Object> values = Arrays.asList(this.valueArray);
        Set entrySet = this.whm.entrySet();
        WeakHashMapTest.assertTrue((String)("Incorrect number of entries returned--wanted 100, got: " + entrySet.size()), (entrySet.size() == 100 ? 1 : 0) != 0);
        for (Map.Entry entry : entrySet) {
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad key", (boolean)keys.contains(entry.getKey()));
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad key", (boolean)values.contains(entry.getValue()));
        }
        keys = null;
        values = null;
        this.keyArray[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && entrySet.size() == 100);
        WeakHashMapTest.assertTrue((String)("Incorrect number of entries returned after gc--wanted 99, got: " + entrySet.size()), (entrySet.size() == 99 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        this.whm = new WeakHashMap();
        WeakHashMapTest.assertTrue((String)"New map should be empty", (boolean)this.whm.isEmpty());
        Object myObject = new Object();
        this.whm.put(myObject, myObject);
        WeakHashMapTest.assertTrue((String)"Map should not be empty", (!this.whm.isEmpty() ? 1 : 0) != 0);
        this.whm.remove(myObject);
        WeakHashMapTest.assertTrue((String)"Map with elements removed should be empty", (boolean)this.whm.isEmpty());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="put", args={Object.class, Object.class})
    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        WeakHashMap map = new WeakHashMap();
        map.put(null, "value");
        System.gc();
        System.runFinalization();
        map.remove("nothing");
        WeakHashMapTest.assertEquals((String)"null key was removed", (int)1, (int)map.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="putAll", args={Map.class})
    public void test_putAllLjava_util_Map() {
        MockMap mockMap = new MockMap();
        WeakHashMap map = new WeakHashMap();
        map.putAll(mockMap);
        WeakHashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)map.size());
        try {
            map.putAll(null);
            WeakHashMapTest.fail((String)"NullPointerException exected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        WeakHashMapTest.assertTrue((String)"Remove returned incorrect value", (this.whm.remove(this.keyArray[25]) == this.valueArray[25] ? 1 : 0) != 0);
        WeakHashMapTest.assertNull((String)"Remove returned incorrect value", this.whm.remove(this.keyArray[25]));
        WeakHashMapTest.assertEquals((String)"Size should be 99 after remove", (int)99, (int)this.whm.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        this.whm = new WeakHashMap();
        WeakHashMapTest.assertEquals((int)0, (int)this.whm.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keySet", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})})
    public void test_keySet() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        List<Object> keys = Arrays.asList(this.keyArray);
        List<Object> values = Arrays.asList(this.valueArray);
        Set keySet = this.whm.keySet();
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned,", (int)100, (int)keySet.size());
        for (Object key : keySet) {
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad key", (boolean)keys.contains(key));
        }
        keys = null;
        values = null;
        this.keyArray[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && keySet.size() == 100);
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned after gc,", (int)99, (int)keySet.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="values", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})})
    public void test_values() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        List<Object> keys = Arrays.asList(this.keyArray);
        List<Object> values = Arrays.asList(this.valueArray);
        Collection valuesCollection = this.whm.values();
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned,", (int)100, (int)valuesCollection.size());
        for (Object value : valuesCollection) {
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad value", (boolean)values.contains(value));
        }
        keys = null;
        values = null;
        this.keyArray[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && valuesCollection.size() == 100);
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned after gc,", (int)99, (int)valuesCollection.size());
    }

    protected void setUp() {
        for (int i = 0; i < 100; ++i) {
            this.keyArray[i] = new Object();
            this.valueArray[i] = new Object();
        }
    }

    protected void tearDown() {
    }

    class MockMap
    extends AbstractMap {
        MockMap() {
        }

        public Set entrySet() {
            return null;
        }

        public int size() {
            return 0;
        }
    }
}

