/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import tests.support.Support_ListTest;

@TestTargetClass(value=Vector.class)
public class VectorTest
extends TestCase {
    private Vector tVector = new Vector();
    Object[] objArray;
    private String vString = "[Test 0, Test 1, Test 2, Test 3, Test 4, Test 5, Test 6, Test 7, Test 8, Test 9, Test 10, Test 11, Test 12, Test 13, Test 14, Test 15, Test 16, Test 17, Test 18, Test 19, Test 20, Test 21, Test 22, Test 23, Test 24, Test 25, Test 26, Test 27, Test 28, Test 29, Test 30, Test 31, Test 32, Test 33, Test 34, Test 35, Test 36, Test 37, Test 38, Test 39, Test 40, Test 41, Test 42, Test 43, Test 44, Test 45, Test 46, Test 47, Test 48, Test 49, Test 50, Test 51, Test 52, Test 53, Test 54, Test 55, Test 56, Test 57, Test 58, Test 59, Test 60, Test 61, Test 62, Test 63, Test 64, Test 65, Test 66, Test 67, Test 68, Test 69, Test 70, Test 71, Test 72, Test 73, Test 74, Test 75, Test 76, Test 77, Test 78, Test 79, Test 80, Test 81, Test 82, Test 83, Test 84, Test 85, Test 86, Test 87, Test 88, Test 89, Test 90, Test 91, Test 92, Test 93, Test 94, Test 95, Test 96, Test 97, Test 98, Test 99]";

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Vector", args={})
    public void test_Constructor() {
        int i;
        Vector<Integer> tv = new Vector<Integer>(100);
        for (i = 0; i < 100; ++i) {
            tv.addElement(new Integer(i));
        }
        new Support_ListTest("", tv).runTest();
        tv = new Vector(200);
        for (i = -50; i < 150; ++i) {
            tv.addElement(new Integer(i));
        }
        new Support_ListTest("", tv.subList(50, 150)).runTest();
        Vector v = new Vector();
        VectorTest.assertEquals((String)"Vector creation failed", (int)0, (int)v.size());
        VectorTest.assertEquals((String)"Wrong capacity", (int)10, (int)v.capacity());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Vector", args={int.class})
    public void test_ConstructorI() {
        Vector v = new Vector(100);
        VectorTest.assertEquals((String)"Vector creation failed", (int)0, (int)v.size());
        VectorTest.assertEquals((String)"Wrong capacity", (int)100, (int)v.capacity());
        try {
            new Vector(-1);
            VectorTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Vector", args={int.class, int.class})
    public void test_ConstructorII() {
        Vector<Object> v = new Vector<Object>(2, 10);
        v.addElement(new Object());
        v.addElement(new Object());
        v.addElement(new Object());
        VectorTest.assertEquals((String)"Failed to inc capacity by proper amount", (int)12, (int)v.capacity());
        Vector<String> grow = new Vector<String>(3, -1);
        grow.addElement("one");
        grow.addElement("two");
        grow.addElement("three");
        grow.addElement("four");
        VectorTest.assertEquals((String)"Wrong size", (int)4, (int)grow.size());
        VectorTest.assertEquals((String)"Wrong capacity", (int)6, (int)grow.capacity());
        try {
            new Vector(-1, 1);
            VectorTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Vector", args={Collection.class})
    public void test_ConstructorLjava_util_Collection() {
        LinkedList<String> l = new LinkedList<String>();
        for (int i = 0; i < 100; ++i) {
            l.add("Test " + i);
        }
        Vector myVector = new Vector(l);
        VectorTest.assertTrue((String)"Vector is not correct size", (myVector.size() == this.objArray.length ? 1 : 0) != 0);
        for (int counter = 0; counter < this.objArray.length; ++counter) {
            VectorTest.assertTrue((String)"Vector does not contain correct elements", (boolean)myVector.contains(((List)l).get(counter)));
        }
        try {
            new Vector(null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={int.class, Object.class})
    public void test_addILjava_lang_Object() {
        Object o = new Object();
        Object prev = this.tVector.get(45);
        this.tVector.add(45, o);
        VectorTest.assertTrue((String)"Failed to add Object", (this.tVector.get(45) == o ? 1 : 0) != 0);
        VectorTest.assertTrue((String)"Failed to fix-up existing indices", (this.tVector.get(46) == prev ? 1 : 0) != 0);
        VectorTest.assertEquals((String)"Wrong size after add", (int)101, (int)this.tVector.size());
        prev = this.tVector.get(50);
        this.tVector.add(50, null);
        VectorTest.assertNull((String)"Failed to add null", this.tVector.get(50));
        VectorTest.assertTrue((String)"Failed to fix-up existing indices after adding null", (this.tVector.get(51) == prev ? 1 : 0) != 0);
        VectorTest.assertEquals((String)"Wrong size after add", (int)102, (int)this.tVector.size());
        try {
            this.tVector.add(-5, null);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.add(this.tVector.size() + 1, null);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void test_addLjava_lang_Object() {
        Object o = new Object();
        this.tVector.add(o);
        VectorTest.assertTrue((String)"Failed to add Object", (this.tVector.lastElement() == o ? 1 : 0) != 0);
        VectorTest.assertEquals((String)"Wrong size after add", (int)101, (int)this.tVector.size());
        this.tVector.add(null);
        VectorTest.assertNull((String)"Failed to add null", this.tVector.lastElement());
        VectorTest.assertEquals((String)"Wrong size after add", (int)102, (int)this.tVector.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={int.class, Collection.class})
    public void test_addAllILjava_util_Collection() {
        LinkedList<String> l = new LinkedList<String>();
        for (int i = 0; i < 100; ++i) {
            l.add("Test " + i);
        }
        Vector<String> v = new Vector<String>();
        this.tVector.addAll(50, l);
        for (int i = 50; i < 100; ++i) {
            VectorTest.assertTrue((String)"Failed to add all elements", (this.tVector.get(i) == ((List)l).get(i - 50) ? 1 : 0) != 0);
        }
        v = new Vector();
        v.add("one");
        int r = 0;
        try {
            v.addAll(3, Arrays.asList("two", "three"));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            r = 1;
        }
        catch (IndexOutOfBoundsException e) {
            r = 2;
        }
        VectorTest.assertTrue((String)("Invalid add: " + r), (r == 1 ? 1 : 0) != 0);
        l = new LinkedList();
        l.add(null);
        l.add("gah");
        l.add(null);
        this.tVector.addAll(50, l);
        VectorTest.assertNull((String)"Wrong element at position 50--wanted null", this.tVector.get(50));
        VectorTest.assertEquals((String)"Wrong element at position 51--wanted 'gah'", (Object)"gah", this.tVector.get(51));
        VectorTest.assertNull((String)"Wrong element at position 52--wanted null", this.tVector.get(52));
        try {
            this.tVector.addAll(-5, Arrays.asList("two", "three"));
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.addAll(this.tVector.size() + 1, Arrays.asList("two", "three"));
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.addAll(this.tVector.size() / 2, null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={Collection.class})
    public void test_addAllLjava_util_Collection() {
        Vector v = new Vector();
        LinkedList<String> l = new LinkedList<String>();
        for (int i = 0; i < 100; ++i) {
            l.add("Test " + i);
        }
        v.addAll(l);
        VectorTest.assertTrue((String)"Failed to add all elements", (boolean)this.tVector.equals(v));
        v.addAll(l);
        int vSize = this.tVector.size();
        for (int counter = vSize - 1; counter >= 0; --counter) {
            VectorTest.assertTrue((String)"Failed to add elements correctly", (v.get(counter) == v.get(counter + vSize) ? 1 : 0) != 0);
        }
        l = new LinkedList();
        l.add(null);
        l.add("gah");
        l.add(null);
        this.tVector.addAll(l);
        VectorTest.assertNull((String)"Wrong element at 3rd last position--wanted null", this.tVector.get(vSize));
        VectorTest.assertEquals((String)"Wrong element at 2nd last position--wanted 'gah'", (Object)"gah", this.tVector.get(vSize + 1));
        VectorTest.assertNull((String)"Wrong element at last position--wanted null", this.tVector.get(vSize + 2));
        try {
            this.tVector.addAll(this.tVector.size() / 2, null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addElement", args={Object.class})
    public void test_addElementLjava_lang_Object() {
        Vector v = this.vectorClone(this.tVector);
        v.addElement("Added Element");
        VectorTest.assertTrue((String)"Failed to add element", (boolean)v.contains("Added Element"));
        VectorTest.assertEquals((String)"Added Element to wrong slot", (String)"Added Element", (String)((String)v.elementAt(100)));
        v.addElement(null);
        VectorTest.assertTrue((String)"Failed to add null", (boolean)v.contains(null));
        VectorTest.assertNull((String)"Added null to wrong slot", v.elementAt(101));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addElement", args={Object.class})
    public void test_addElementLjava_lang_Object_subtest0() {
        Vector v = this.vectorClone(this.tVector);
        v.addElement("Added Element");
        VectorTest.assertTrue((String)"Failed to add element", (boolean)v.contains("Added Element"));
        VectorTest.assertEquals((String)"Added Element to wrong slot", (String)"Added Element", (String)((String)v.elementAt(100)));
        v.addElement(null);
        VectorTest.assertTrue((String)"Failed to add null", (boolean)v.contains(null));
        VectorTest.assertNull((String)"Added null to wrong slot", v.elementAt(101));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="capacity", args={})
    public void test_capacity() {
        Vector v = new Vector(9);
        VectorTest.assertEquals((String)"Incorrect capacity returned", (int)9, (int)v.capacity());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        Vector orgVector = this.vectorClone(this.tVector);
        this.tVector.clear();
        VectorTest.assertEquals((String)"a) Cleared Vector has non-zero size", (int)0, (int)this.tVector.size());
        Enumeration e = orgVector.elements();
        while (e.hasMoreElements()) {
            VectorTest.assertTrue((String)"a) Cleared vector contained elements", (!this.tVector.contains(e.nextElement()) ? 1 : 0) != 0);
        }
        this.tVector.add(null);
        this.tVector.clear();
        VectorTest.assertEquals((String)"b) Cleared Vector has non-zero size", (int)0, (int)this.tVector.size());
        e = orgVector.elements();
        while (e.hasMoreElements()) {
            VectorTest.assertTrue((String)"b) Cleared vector contained elements", (!this.tVector.contains(e.nextElement()) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        this.tVector.add(25, null);
        this.tVector.add(75, null);
        Vector v = (Vector)this.tVector.clone();
        Enumeration orgNum = this.tVector.elements();
        Enumeration cnum = v.elements();
        while (orgNum.hasMoreElements()) {
            VectorTest.assertTrue((String)"Not enough elements copied", (boolean)cnum.hasMoreElements());
            VectorTest.assertTrue((String)"Vector cloned improperly, elements do not match", (orgNum.nextElement() == cnum.nextElement() ? 1 : 0) != 0);
        }
        VectorTest.assertTrue((String)"Not enough elements copied", (!cnum.hasMoreElements() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="contains", args={Object.class})
    public void test_containsLjava_lang_Object() {
        VectorTest.assertTrue((String)"Did not find element", (boolean)this.tVector.contains("Test 42"));
        VectorTest.assertTrue((String)"Found bogus element", (!this.tVector.contains("Hello") ? 1 : 0) != 0);
        VectorTest.assertTrue((String)"Returned true looking for null in vector without null element", (!this.tVector.contains(null) ? 1 : 0) != 0);
        this.tVector.insertElementAt(null, 20);
        VectorTest.assertTrue((String)"Returned false looking for null in vector with null element", (boolean)this.tVector.contains(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsAll", args={Collection.class})
    public void test_containsAllLjava_util_Collection() {
        HashSet<Object> s = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            s.add("Test " + i);
        }
        VectorTest.assertTrue((String)"Returned false for valid collection", (boolean)this.tVector.containsAll(s));
        s.add(null);
        VectorTest.assertTrue((String)"Returned true for invlaid collection containing null", (!this.tVector.containsAll(s) ? 1 : 0) != 0);
        this.tVector.add(25, null);
        VectorTest.assertTrue((String)"Returned false for valid collection containing null", (boolean)this.tVector.containsAll(s));
        s = new HashSet();
        s.add(new Object());
        VectorTest.assertTrue((String)"Returned true for invalid collection", (!this.tVector.containsAll(s) ? 1 : 0) != 0);
        try {
            this.tVector.containsAll(null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="copyInto", args={Object[].class})
    public void test_copyInto$Ljava_lang_Object() {
        Object[] a = new Object[100];
        this.tVector.setElementAt(null, 20);
        this.tVector.copyInto(a);
        for (int i = 0; i < 100; ++i) {
            VectorTest.assertTrue((String)"copyInto failed", (a[i] == this.tVector.elementAt(i) ? 1 : 0) != 0);
        }
        try {
            this.tVector.copyInto(null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="elementAt", args={int.class})
    public void test_elementAtI() {
        VectorTest.assertEquals((String)"Incorrect element returned", (String)"Test 18", (String)((String)this.tVector.elementAt(18)));
        this.tVector.setElementAt(null, 20);
        VectorTest.assertNull((String)"Incorrect element returned--wanted null", this.tVector.elementAt(20));
        try {
            this.tVector.elementAt(-5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.elementAt(this.tVector.size() + 1);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="elements", args={})
    public void test_elements() {
        this.tVector.insertElementAt(null, 20);
        Enumeration e = this.tVector.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            VectorTest.assertTrue((String)("Enumeration returned incorrect element at pos: " + i), (e.nextElement() == this.tVector.elementAt(i) ? 1 : 0) != 0);
            ++i;
        }
        VectorTest.assertTrue((String)"Invalid enumeration", (i == this.tVector.size() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="elements", args={})
    public void test_elements_subtest0() {
        int iterations = 10000;
        final Vector v = new Vector();
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    Vector vector = v;
                    synchronized (vector) {
                        v.addElement(String.valueOf(i));
                        v.removeElementAt(0);
                        continue;
                    }
                }
            }
        };
        t1.start();
        for (int i = 0; i < 10000; ++i) {
            Enumeration en = v.elements();
            try {
                while (true) {
                    Object result;
                    if ((result = en.nextElement()) != null) {
                        continue;
                    }
                    VectorTest.fail((String)("Null result: " + i));
                }
            }
            catch (NoSuchElementException e) {
                continue;
            }
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ensureCapacity", args={int.class})
    public void test_ensureCapacityI() {
        Vector v = new Vector(9);
        v.ensureCapacity(20);
        VectorTest.assertEquals((String)"ensureCapacity failed to set correct capacity", (int)20, (int)v.capacity());
        v = new Vector(100);
        VectorTest.assertEquals((String)"ensureCapacity reduced capacity", (int)100, (int)v.capacity());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < 100; ++i) {
            v.addElement("Test " + i);
        }
        VectorTest.assertTrue((String)"a) Equal vectors returned false", (boolean)this.tVector.equals(v));
        v.addElement(null);
        VectorTest.assertTrue((String)"b) UnEqual vectors returned true", (!this.tVector.equals(v) ? 1 : 0) != 0);
        this.tVector.addElement(null);
        VectorTest.assertTrue((String)"c) Equal vectors returned false", (boolean)this.tVector.equals(v));
        this.tVector.removeElementAt(22);
        VectorTest.assertTrue((String)"d) UnEqual vectors returned true", (!this.tVector.equals(v) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="firstElement", args={})
    public void test_firstElement() {
        VectorTest.assertEquals((String)"Returned incorrect firstElement", (Object)"Test 0", this.tVector.firstElement());
        this.tVector.insertElementAt(null, 0);
        VectorTest.assertNull((String)"Returned incorrect firstElement--wanted null", this.tVector.firstElement());
        this.tVector = new Vector(10);
        try {
            this.tVector.firstElement();
            VectorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={int.class})
    public void test_getI() {
        VectorTest.assertEquals((String)"Get returned incorrect object", (Object)"Test 80", this.tVector.get(80));
        this.tVector.add(25, null);
        VectorTest.assertNull((String)"Returned incorrect element--wanted null", this.tVector.get(25));
        try {
            this.tVector.get(-5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.get(this.tVector.size() + 1);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        int hashCode = 1;
        this.tVector.insertElementAt(null, 20);
        for (int i = 0; i < this.tVector.size(); ++i) {
            Object obj = this.tVector.elementAt(i);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        VectorTest.assertTrue((String)("Incorrect hashCode returned.  Wanted: " + hashCode + " got: " + this.tVector.hashCode()), (this.tVector.hashCode() == hashCode ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="indexOf", args={Object.class})
    public void test_indexOfLjava_lang_Object() {
        VectorTest.assertEquals((String)"Incorrect index returned", (int)10, (int)this.tVector.indexOf("Test 10"));
        VectorTest.assertEquals((String)"Index returned for invalid Object", (int)-1, (int)this.tVector.indexOf("XXXXXXXXXXX"));
        this.tVector.setElementAt(null, 20);
        this.tVector.setElementAt(null, 40);
        VectorTest.assertTrue((String)("Incorrect indexOf returned for null: " + this.tVector.indexOf(null)), (this.tVector.indexOf(null) == 20 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="indexOf", args={Object.class, int.class})
    public void test_indexOfLjava_lang_ObjectI() {
        VectorTest.assertTrue((String)"Failed to find correct index", (this.tVector.indexOf("Test 98", 50) == 98 ? 1 : 0) != 0);
        VectorTest.assertTrue((String)"Found index of bogus element", (this.tVector.indexOf("Test 1001", 50) == -1 ? 1 : 0) != 0);
        this.tVector.setElementAt(null, 20);
        this.tVector.setElementAt(null, 40);
        this.tVector.setElementAt(null, 60);
        VectorTest.assertTrue((String)("a) Incorrect indexOf returned for null: " + this.tVector.indexOf(null, 25)), (this.tVector.indexOf(null, 25) == 40 ? 1 : 0) != 0);
        VectorTest.assertTrue((String)("b) Incorrect indexOf returned for null: " + this.tVector.indexOf(null, 20)), (this.tVector.indexOf(null, 20) == 20 ? 1 : 0) != 0);
        try {
            this.tVector.indexOf(null, -1);
            VectorTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="insertElementAt", args={Object.class, int.class})
    public void test_insertElementAtLjava_lang_ObjectI() {
        Vector v = this.vectorClone(this.tVector);
        String prevElement = (String)v.elementAt(99);
        v.insertElementAt("Inserted Element", 99);
        VectorTest.assertEquals((String)"Element not inserted", (String)"Inserted Element", (String)((String)v.elementAt(99)));
        VectorTest.assertTrue((String)"Elements shifted incorrectly", (boolean)((String)v.elementAt(100)).equals(prevElement));
        v.insertElementAt(null, 20);
        VectorTest.assertNull((String)"null not inserted", v.elementAt(20));
        try {
            this.tVector.insertElementAt(null, -5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.insertElementAt(null, this.tVector.size() + 1);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        Vector<Object> v = new Vector<Object>();
        VectorTest.assertTrue((String)"Empty vector returned false", (boolean)v.isEmpty());
        v.addElement(new Object());
        VectorTest.assertTrue((String)"non-Empty vector returned true", (!v.isEmpty() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty_subtest0() {
        final Vector<String> v = new Vector<String>();
        v.addElement("initial");
        Thread t1 = new Thread(){

            public void run() {
                while (!v.isEmpty()) {
                }
                v.addElement("final");
            }
        };
        t1.start();
        for (int i = 0; i < 10000; ++i) {
            Vector<String> vector = v;
            synchronized (vector) {
                v.removeElementAt(0);
                v.addElement(String.valueOf(i));
            }
            int size = v.size();
            if (size == 1) continue;
            String result = "Size is not 1: " + size + " " + v;
            v.removeAllElements();
            VectorTest.fail((String)result);
        }
        v.removeElementAt(0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastElement", args={})
    public void test_lastElement() {
        VectorTest.assertEquals((String)"Incorrect last element returned", (Object)"Test 99", this.tVector.lastElement());
        this.tVector.addElement(null);
        VectorTest.assertNull((String)"Incorrect last element returned--wanted null", this.tVector.lastElement());
        this.tVector = new Vector(10);
        try {
            this.tVector.lastElement();
            VectorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastIndexOf", args={Object.class})
    public void test_lastIndexOfLjava_lang_Object() {
        Vector<String> v = new Vector<String>(9);
        for (int i = 0; i < 9; ++i) {
            v.addElement("Test");
        }
        v.addElement("z");
        VectorTest.assertEquals((String)"Failed to return correct index", (int)8, (int)v.lastIndexOf("Test"));
        this.tVector.setElementAt(null, 20);
        this.tVector.setElementAt(null, 40);
        VectorTest.assertTrue((String)("Incorrect lastIndexOf returned for null: " + this.tVector.lastIndexOf(null)), (this.tVector.lastIndexOf(null) == 40 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastIndexOf", args={Object.class, int.class})
    public void test_lastIndexOfLjava_lang_ObjectI() {
        VectorTest.assertEquals((String)"Failed to find object", (int)0, (int)this.tVector.lastIndexOf("Test 0", 0));
        VectorTest.assertTrue((String)"Found Object outside of index", (this.tVector.lastIndexOf("Test 0", 10) > -1 ? 1 : 0) != 0);
        this.tVector.setElementAt(null, 20);
        this.tVector.setElementAt(null, 40);
        this.tVector.setElementAt(null, 60);
        VectorTest.assertTrue((String)("Incorrect lastIndexOf returned for null: " + this.tVector.lastIndexOf(null, 15)), (this.tVector.lastIndexOf(null, 15) == -1 ? 1 : 0) != 0);
        VectorTest.assertTrue((String)("Incorrect lastIndexOf returned for null: " + this.tVector.lastIndexOf(null, 45)), (this.tVector.lastIndexOf(null, 45) == 40 ? 1 : 0) != 0);
        try {
            this.tVector.lastIndexOf(null, this.tVector.size());
            VectorTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={int.class})
    public void test_removeI() {
        this.tVector.remove(36);
        VectorTest.assertTrue((String)"Contained element after remove", (!this.tVector.contains("Test 36") ? 1 : 0) != 0);
        VectorTest.assertEquals((String)"Failed to decrement size after remove", (int)99, (int)this.tVector.size());
        this.tVector.add(20, null);
        this.tVector.remove(19);
        VectorTest.assertNull((String)"Didn't move null element over", this.tVector.get(19));
        this.tVector.remove(19);
        VectorTest.assertNotNull((String)"Didn't remove null element", this.tVector.get(19));
        VectorTest.assertEquals((String)"Failed to decrement size after removing null", (int)98, (int)this.tVector.size());
        try {
            this.tVector.remove(-5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.remove(this.tVector.size() + 1);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        this.tVector.remove("Test 0");
        VectorTest.assertTrue((String)"Contained element after remove", (!this.tVector.contains("Test 0") ? 1 : 0) != 0);
        VectorTest.assertEquals((String)"Failed to decrement size after remove", (int)99, (int)this.tVector.size());
        this.tVector.add(null);
        this.tVector.remove(null);
        VectorTest.assertTrue((String)"Contained null after remove", (!this.tVector.contains(null) ? 1 : 0) != 0);
        VectorTest.assertEquals((String)"Failed to decrement size after removing null", (int)99, (int)this.tVector.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeAll", args={Collection.class})
    public void test_removeAllLjava_util_Collection() {
        Vector<Object> v = new Vector<Object>();
        LinkedList<String> l = new LinkedList<String>();
        for (int i = 0; i < 5; ++i) {
            l.add("Test " + i);
        }
        v.addElement(l);
        HashSet s = new HashSet();
        Object o = v.firstElement();
        s.add(o);
        v.removeAll(s);
        VectorTest.assertTrue((String)"Failed to remove items in collection", (!v.contains(o) ? 1 : 0) != 0);
        v.removeAll(l);
        VectorTest.assertTrue((String)"Failed to remove all elements", (boolean)v.isEmpty());
        v.add(null);
        v.add(null);
        v.add("Boom");
        v.removeAll(s);
        VectorTest.assertEquals((String)"Should not have removed any elements", (int)3, (int)v.size());
        l = new LinkedList();
        l.add(null);
        v.removeAll(l);
        VectorTest.assertEquals((String)"Should only have one element", (int)1, (int)v.size());
        VectorTest.assertEquals((String)"Element should be 'Boom'", (Object)"Boom", v.firstElement());
        try {
            v.removeAll(null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeAllElements", args={})
    public void test_removeAllElements() {
        Vector v = this.vectorClone(this.tVector);
        v.removeAllElements();
        VectorTest.assertEquals((String)"Failed to remove all elements", (int)0, (int)v.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Doesn't check negative case.", method="removeElement", args={Object.class})
    public void test_removeElementLjava_lang_Object() {
        Vector v = this.vectorClone(this.tVector);
        v.removeElement("Test 98");
        VectorTest.assertEquals((String)"Element not removed", (String)"Test 99", (String)((String)v.elementAt(98)));
        VectorTest.assertTrue((String)("Vector is wrong size after removal: " + v.size()), (v.size() == 99 ? 1 : 0) != 0);
        this.tVector.addElement(null);
        v.removeElement(null);
        VectorTest.assertTrue((String)("Vector is wrong size after removing null: " + v.size()), (v.size() == 99 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeElementAt", args={int.class})
    public void test_removeElementAtI() {
        Vector v = this.vectorClone(this.tVector);
        v.removeElementAt(50);
        VectorTest.assertEquals((String)"Failed to remove element", (int)-1, (int)v.indexOf("Test 50", 0));
        this.tVector.insertElementAt(null, 60);
        this.tVector.removeElementAt(60);
        VectorTest.assertNotNull((String)"Element at 60 should not be null after removal", this.tVector.elementAt(60));
        try {
            this.tVector.elementAt(-5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.elementAt(this.tVector.size() + 1);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="retainAll", args={Collection.class})
    public void test_retainAllLjava_util_Collection() {
        Object o = this.tVector.firstElement();
        this.tVector.add(null);
        HashSet s = new HashSet();
        s.add(o);
        s.add(null);
        this.tVector.retainAll(s);
        VectorTest.assertTrue((String)"Retained items other than specified", (this.tVector.size() == 2 && this.tVector.contains(o) && this.tVector.contains(null) ? 1 : 0) != 0);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            VectorTest.assertTrue((boolean)this.tVector.contains(i.next()));
        }
        try {
            this.tVector.retainAll(null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, Object.class})
    public void test_setILjava_lang_Object() {
        Object o = new Object();
        this.tVector.set(23, o);
        VectorTest.assertTrue((String)"Failed to set Object", (this.tVector.get(23) == o ? 1 : 0) != 0);
        try {
            this.tVector.set(-5, "Wrong position");
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.set(this.tVector.size() + 1, "Wrong position");
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setElementAt", args={Object.class, int.class})
    public void test_setElementAtLjava_lang_ObjectI() {
        Vector v = this.vectorClone(this.tVector);
        v.setElementAt("Inserted Element", 99);
        VectorTest.assertEquals((String)"Element not set", (String)"Inserted Element", (String)((String)v.elementAt(99)));
        try {
            this.tVector.setElementAt("Wrong position", -5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.setElementAt("Wrong position", this.tVector.size() + 1);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setSize", args={int.class})
    public void test_setSizeI() {
        Vector v = this.vectorClone(this.tVector);
        v.setSize(10);
        VectorTest.assertEquals((String)"Failed to set size", (int)10, (int)v.size());
        try {
            this.tVector.setSize(-5);
            VectorTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        VectorTest.assertEquals((String)"Returned incorrect size", (int)100, (int)this.tVector.size());
        final Vector<String> v = new Vector<String>();
        v.addElement("initial");
        Thread t1 = new Thread(){

            public void run() {
                while (v.size() > 0) {
                }
                v.addElement("final");
            }
        };
        t1.start();
        for (int i = 0; i < 10000; ++i) {
            Vector<String> vector = v;
            synchronized (vector) {
                v.removeElementAt(0);
                v.addElement(String.valueOf(i));
            }
            int size = v.size();
            if (size == 1) continue;
            String result = "Size is not 1: " + size + " " + v;
            v.removeAllElements();
            VectorTest.fail((String)result);
        }
        v.removeElementAt(0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="subList", args={int.class, int.class})
    public void test_subListII() {
        List sl = this.tVector.subList(10, 25);
        VectorTest.assertEquals((String)"Returned sublist of incorrect size", (int)15, (int)sl.size());
        for (int i = 10; i < 25; ++i) {
            VectorTest.assertTrue((String)"Returned incorrect sublist", (boolean)sl.contains(this.tVector.get(i)));
        }
        VectorTest.assertEquals((String)"Not synchronized random access", (String)"java.util.Collections$SynchronizedRandomAccessList", (String)sl.getClass().getName());
        try {
            this.tVector.subList(-10, 25);
            VectorTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.subList(10, this.tVector.size() + 1);
            VectorTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.tVector.subList(25, 10);
            VectorTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={})
    public void test_toArray() {
        VectorTest.assertTrue((String)"Returned incorrect array", (boolean)Arrays.equals(this.objArray, this.tVector.toArray()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={Object[].class})
    public void test_toArray$Ljava_lang_Object() {
        int i;
        Object[] o = new Object[1000];
        Object f = new Object();
        for (i = 0; i < o.length; ++i) {
            o[i] = f;
        }
        this.tVector.toArray(o);
        VectorTest.assertNull((String)"Failed to set slot to null", (Object)o[100]);
        for (i = 0; i < this.tVector.size(); ++i) {
            VectorTest.assertTrue((String)"Returned incorrect array", (this.tVector.elementAt(i) == o[i] ? 1 : 0) != 0);
        }
        try {
            this.tVector.toArray((T[])null);
            VectorTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.tVector = new Vector();
        this.tVector.add(new Integer(1));
        this.tVector.add(new Integer(2));
        this.tVector.add(new Integer(3));
        try {
            this.tVector.toArray(new String[this.tVector.size()]);
            VectorTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        VectorTest.assertTrue((String)"Incorrect String returned", (boolean)this.tVector.toString().equals(this.vString));
        Vector<Object> v = new Vector<Object>();
        v.addElement("one");
        v.addElement(v);
        v.addElement("3");
        v.addElement(v);
        String result = v.toString();
        VectorTest.assertTrue((String)"should contain self ref", (result.indexOf("(this") > -1 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="trimToSize", args={})
    public void test_trimToSize() {
        Vector<Object> v = new Vector<Object>(10);
        v.addElement(new Object());
        v.trimToSize();
        VectorTest.assertEquals((String)"Failed to trim capacity", (int)1, (int)v.capacity());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeRange", args={int.class, int.class})
    public void test_removeRangeII() {
        Mock_Vector mv = new Mock_Vector();
        mv.add("First");
        mv.add("Second");
        mv.add("One more");
        mv.add("Last");
        mv.removeRange(1, 3);
        VectorTest.assertTrue((boolean)mv.contains("First"));
        VectorTest.assertFalse((boolean)mv.contains("Second"));
        VectorTest.assertFalse((boolean)mv.contains("One more"));
        VectorTest.assertTrue((boolean)mv.contains("Last"));
    }

    protected Vector vectorClone(Vector s) {
        return (Vector)s.clone();
    }

    protected void setUp() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.tVector.addElement("Test " + i);
        }
        this.objArray = new Object[100];
        for (i = 0; i < 100; ++i) {
            this.objArray[i] = "Test " + i;
        }
    }

    protected void tearDown() {
    }

    class Mock_Vector
    extends Vector {
        Mock_Vector() {
        }

        protected void removeRange(int from, int to) {
            super.removeRange(from, to);
        }
    }
}

