/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

@TestTargetClass(value=Timer.class)
public class TimerTest
extends TestCase {
    int timerCounter = 0;
    Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Timer", args={boolean.class})
    public void test_ConstructorZ() {
        Timer t = null;
        try {
            t = new Timer(true);
            TimerTestTask testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 200L);
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.sync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Timer", args={})
    public void test_Constructor() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 200L);
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.sync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Timer", args={String.class, boolean.class})
    public void test_ConstructorSZ() {
        Timer t = null;
        try {
            t = new Timer("test_ConstructorSZThread", true);
            TimerTestTask testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 200L);
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.sync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
        try {
            new Timer(null, true);
            TimerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new Timer(null, false);
            TimerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Timer", args={String.class})
    public void test_ConstructorS() {
        Timer t = null;
        try {
            t = new Timer("test_ConstructorSThread");
            TimerTestTask testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 200L);
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.sync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
        try {
            new Timer(null);
            TimerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="cancel", args={})
    public void test_cancel() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.cancel();
            boolean exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L, 200L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 100L, 500L);
            Object e = this.sync;
            synchronized (e) {
                try {
                    this.sync.wait(1000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
            e = this.sync;
            synchronized (e) {
                try {
                    this.sync.wait(500L);
                }
                catch (InterruptedException e3) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method should not have been called after cancel", (int)1, (int)testTask.wasRun());
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 100L, 500L);
            e = this.sync;
            synchronized (e) {
                try {
                    this.sync.wait(500L);
                }
                catch (InterruptedException e4) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
            t.cancel();
            t.cancel();
            e = this.sync;
            synchronized (e) {
                try {
                    this.sync.wait(500L);
                }
                catch (InterruptedException e5) {
                    // empty catch block
                }
            }
            TimerTest.assertEquals((String)"TimerTask.run() method should not have been called after cancel", (int)1, (int)testTask.wasRun());
            t = new Timer();
            testTask = new TimerTestTask(t);
            testTask.incrementCount(true);
            testTask.terminateCount(5);
            t.schedule((TimerTask)testTask, 100L, 100L);
            e = this.sync;
            synchronized (e) {
                try {
                    this.sync.wait(200L);
                    this.sync.wait(200L);
                    this.sync.wait(200L);
                    this.sync.wait(200L);
                    this.sync.wait(200L);
                    this.sync.wait(200L);
                }
                catch (InterruptedException e6) {
                    // empty catch block
                }
            }
            TimerTest.assertTrue((String)("TimerTask.run() method should be called 5 times not " + testTask.wasRun()), (testTask.wasRun() == 5 ? 1 : 0) != 0);
            t.cancel();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="purge", args={})
    public void test_purge() throws Exception {
        Timer t = null;
        try {
            int i;
            t = new Timer();
            TimerTest.assertEquals((int)0, (int)t.purge());
            TimerTestTask[] tasks = new TimerTestTask[100];
            int[] delayTime = new int[]{50, 80, 20, 70, 40, 10, 90, 30, 60};
            int j = 0;
            for (i = 0; i < 100; ++i) {
                tasks[i] = new TimerTestTask();
                t.schedule((TimerTask)tasks[i], delayTime[j++], 200L);
                if (j != 9) continue;
                j = 0;
            }
            for (i = 0; i < 50; ++i) {
                tasks[i].cancel();
            }
            TimerTest.assertTrue((t.purge() <= 50 ? 1 : 0) != 0);
            TimerTest.assertEquals((int)0, (int)t.purge());
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="schedule", args={TimerTask.class, Date.class})
    public void test_scheduleLjava_util_TimerTaskLjava_util_Date() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            Date d = new Date(System.currentTimeMillis() + 100L);
            t.cancel();
            boolean exception = false;
            try {
                t.schedule((TimerTask)testTask, d);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            testTask = new TimerTestTask();
            d = new Date(System.currentTimeMillis() + 100L);
            testTask.cancel();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, d);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after cancelling it should throw exception", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            d = new Date(-100L);
            exception = false;
            try {
                t.schedule((TimerTask)testTask, d);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with negative date should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            d = new Date(System.currentTimeMillis() + 100L);
            try {
                t.schedule(null, d);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, null);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null date should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            d = new Date(-100L);
            exception = false;
            try {
                t.schedule(null, d);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task with negative date should throw IllegalArgumentException first", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            d = new Date(System.currentTimeMillis() + 200L);
            t.schedule((TimerTask)testTask, d);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 100L);
            t.schedule((TimerTask)testTask, d);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 150L);
            t.schedule((TimerTask)testTask, d);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 70L);
            t.schedule((TimerTask)testTask, d);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 10L);
            t.schedule((TimerTask)testTask, d);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("Multiple tasks should have incremented counter 4 times not " + this.timerCounter), (this.timerCounter == 4 ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="schedule", args={TimerTask.class, long.class})
    public void test_scheduleLjava_util_TimerTaskJ() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.cancel();
            boolean exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.cancel();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after cancelling it should throw exception", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, -100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with negative delay should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            try {
                t.schedule(null, 10L);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            try {
                t.schedule(null, -10L);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task with negative delays should throw IllegalArgumentException first", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 200L);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertEquals((String)"TimerTask.run() method not called after 200ms", (int)1, (int)testTask.wasRun());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 100L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 150L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 70L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 10L);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("Multiple tasks should have incremented counter 4 times not " + this.timerCounter), (this.timerCounter == 4 ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="schedule", args={TimerTask.class, long.class, long.class})
    public void test_scheduleLjava_util_TimerTaskJJ() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.cancel();
            boolean exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.cancel();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after cancelling it should throw exception", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, -100L, 100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with negative delay should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L, -100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with negative period should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, 100L, 0L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with 0 period should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            try {
                t.schedule(null, 10L, 10L);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            try {
                t.schedule(null, -10L, -10L);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task with negative delays should throw IllegalArgumentException first", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 100L, 100L);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("TimerTask.run() method should have been called at least twice (" + testTask.wasRun() + ")"), (testTask.wasRun() >= 2 ? 1 : 0) != 0);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 100L, 100L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 200L, 100L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 300L, 200L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            t.schedule((TimerTask)testTask, 100L, 200L);
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("Multiple tasks should have incremented counter 24 times not " + this.timerCounter), (this.timerCounter >= 24 ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="schedule", args={TimerTask.class, Date.class, long.class})
    public void test_scheduleLjava_util_TimerTaskLjava_util_DateJ() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            Date d = new Date(System.currentTimeMillis() + 100L);
            t.cancel();
            boolean exception = false;
            try {
                t.schedule((TimerTask)testTask, d, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            d = new Date(System.currentTimeMillis() + 100L);
            testTask = new TimerTestTask();
            testTask.cancel();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, d, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task after cancelling it should throw exception", (boolean)exception);
            t.cancel();
            t = new Timer();
            d = new Date(-100L);
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, d, 100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with negative delay should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            d = new Date(System.currentTimeMillis() + 100L);
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, d, -100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a task with negative period should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            d = new Date(System.currentTimeMillis() + 100L);
            exception = false;
            try {
                t.schedule(null, d, 10L);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.schedule((TimerTask)testTask, null, 10L);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            d = new Date(-100L);
            exception = false;
            try {
                t.schedule(null, d, 10L);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task with negative dates should throw IllegalArgumentException first", (boolean)exception);
            t.cancel();
            t = new Timer();
            d = new Date(System.currentTimeMillis() + 100L);
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, d, 100L);
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("TimerTask.run() method should have been called at least twice (" + testTask.wasRun() + ")"), (testTask.wasRun() >= 2 ? 1 : 0) != 0);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 100L);
            t.schedule((TimerTask)testTask, d, 100L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 200L);
            t.schedule((TimerTask)testTask, d, 100L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 300L);
            t.schedule((TimerTask)testTask, d, 200L);
            testTask = new TimerTestTask();
            testTask.incrementCount(true);
            d = new Date(System.currentTimeMillis() + 100L);
            t.schedule((TimerTask)testTask, d, 200L);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("Multiple tasks should have incremented counter 24 times not " + this.timerCounter), (this.timerCounter >= 24 ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="scheduleAtFixedRate", args={TimerTask.class, long.class, long.class})
    public void test_scheduleAtFixedRateLjava_util_TimerTaskJJ() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.cancel();
            boolean exception = false;
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, 100L, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, -100L, 100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate with negative delay should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, 100L, -100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate with negative period should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.scheduleAtFixedRate((TimerTask)testTask, 100L, 100L);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("TimerTask.run() method should have been called at least twice (" + testTask.wasRun() + ")"), (testTask.wasRun() >= 2 ? 1 : 0) != 0);
            t.cancel();
            t = new Timer();
            class SlowThenFastTask
            extends TimerTask {
                int wasRun = 0;
                long startedAt;
                long lastDelta;

                SlowThenFastTask() {
                }

                public void run() {
                    if (this.wasRun == 0) {
                        this.startedAt = System.currentTimeMillis();
                    }
                    this.lastDelta = System.currentTimeMillis() - (this.startedAt + (long)(100 * this.wasRun));
                    ++this.wasRun;
                    if (this.wasRun == 2) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }

                public long lastDelta() {
                    return this.lastDelta;
                }

                public int wasRun() {
                    return this.wasRun;
                }
            }
            SlowThenFastTask slowThenFastTask = new SlowThenFastTask();
            t.scheduleAtFixedRate((TimerTask)slowThenFastTask, 100L, 100L);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long lastDelta = slowThenFastTask.lastDelta();
            TimerTest.assertTrue((String)("Fixed Rate Schedule should catch up, but is off by " + lastDelta + " ms"), (slowThenFastTask.lastDelta < 300L ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="scheduleAtFixedRate", args={TimerTask.class, Date.class, long.class})
    public void test_scheduleAtFixedRateLjava_util_TimerTaskLjava_util_DateJ() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.cancel();
            boolean exception = false;
            Date d = new Date(System.currentTimeMillis() + 100L);
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, d, 100L);
            }
            catch (IllegalStateException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate after Timer.cancel() should throw exception", (boolean)exception);
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            d = new Date(-100L);
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, d, 100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate with negative Date should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, d, -100L);
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate with negative period should throw IllegalArgumentException", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            exception = false;
            try {
                t.scheduleAtFixedRate((TimerTask)testTask, null, 100L);
            }
            catch (NullPointerException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"scheduleAtFixedRate with null date should throw NullPointerException", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            d = new Date(-100L);
            try {
                t.scheduleAtFixedRate(null, d, 10L);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task with negative date should throw IllegalArgumentException first", (boolean)exception);
            t.cancel();
            t = new Timer();
            exception = false;
            try {
                t.scheduleAtFixedRate(null, null, -10L);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                exception = true;
            }
            TimerTest.assertTrue((String)"Scheduling a null task & null date & negative period should throw IllegalArgumentException first", (boolean)exception);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            d = new Date(System.currentTimeMillis() + 100L);
            t.scheduleAtFixedRate((TimerTask)testTask, d, 100L);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTest.assertTrue((String)("TimerTask.run() method should have been called at least twice (" + testTask.wasRun() + ")"), (testTask.wasRun() >= 2 ? 1 : 0) != 0);
            t.cancel();
            t = new Timer();
            class SlowThenFastTask
            extends TimerTask {
                int wasRun = 0;
                long startedAt;
                long lastDelta;

                SlowThenFastTask() {
                }

                public void run() {
                    if (this.wasRun == 0) {
                        this.startedAt = System.currentTimeMillis();
                    }
                    this.lastDelta = System.currentTimeMillis() - (this.startedAt + (long)(100 * this.wasRun));
                    ++this.wasRun;
                    if (this.wasRun == 2) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }

                public long lastDelta() {
                    return this.lastDelta;
                }

                public int wasRun() {
                    return this.wasRun;
                }
            }
            SlowThenFastTask slowThenFastTask = new SlowThenFastTask();
            d = new Date(System.currentTimeMillis() + 100L);
            t.scheduleAtFixedRate((TimerTask)slowThenFastTask, d, 100L);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long lastDelta = slowThenFastTask.lastDelta();
            TimerTest.assertTrue((String)("Fixed Rate Schedule should catch up, but is off by " + lastDelta + " ms"), (lastDelta < 300L ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    public void testThrowingTaskKillsTimerThread() throws InterruptedException {
        final AtomicReference threadRef = new AtomicReference();
        new Timer().schedule(new TimerTask(){

            public void run() {
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread thread, Throwable ex) {
                    }
                });
                threadRef.set(Thread.currentThread());
                throw new RuntimeException("task failure!");
            }
        }, 1L);
        Thread.sleep(400L);
        Thread timerThread = (Thread)threadRef.get();
        TimerTest.assertFalse((boolean)timerThread.isAlive());
    }

    protected void setUp() {
        this.timerCounter = 0;
    }

    protected void tearDown() {
    }

    class TimerTestTask
    extends TimerTask {
        int wasRun = 0;
        boolean sleepInRun = false;
        boolean incrementCount = false;
        int terminateCount = -1;
        Timer timer = null;

        public TimerTestTask() {
        }

        public TimerTestTask(Timer t) {
            this.timer = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                ++this.wasRun;
            }
            if (this.incrementCount) {
                ++TimerTest.this.timerCounter;
            }
            if (this.terminateCount == TimerTest.this.timerCounter && this.timer != null) {
                this.timer.cancel();
            }
            if (this.sleepInRun) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = TimerTest.this.sync;
            synchronized (object) {
                TimerTest.this.sync.notify();
            }
        }

        public synchronized int wasRun() {
            return this.wasRun;
        }

        public void sleepInRun(boolean sleepInRun) {
            this.sleepInRun = sleepInRun;
        }

        public void incrementCount(boolean incrementCount) {
            this.incrementCount = incrementCount;
        }

        public void terminateCount(int terminateCount) {
            this.terminateCount = terminateCount;
        }
    }
}

