/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.TestCase;

@TestTargetClass(value=TimerTask.class)
public class TimerTaskTest
extends TestCase {
    Object sync = new Object();
    Object start = new Object();

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="TimerTask", args={})
    public void test_Constructor() {
        new TimerTestTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="cancel", args={})
    public void test_cancel() {
        Timer t = null;
        try {
            TimerTestTask testTask = new TimerTestTask();
            TimerTaskTest.assertTrue((String)"Unsheduled tasks should return false for cancel()", (!testTask.cancel() ? 1 : 0) != 0);
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 500L);
            TimerTaskTest.assertTrue((String)"TimerTask should not have run yet", (boolean)testTask.cancel());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 50L);
            while (testTask.wasRun() == 0) {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {}
            }
            TimerTaskTest.assertFalse((String)"TimerTask.cancel() should return false if task has run", (boolean)testTask.cancel());
            TimerTaskTest.assertFalse((String)"TimerTask.cancel() should return false if called a second time", (boolean)testTask.cancel());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 500L, 500L);
            TimerTaskTest.assertTrue((String)"TimerTask.cancel() should return true if sheduled for repeated execution even if not run", (boolean)testTask.cancel());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 50L, 50L);
            while (testTask.wasRun() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TimerTaskTest.assertTrue((String)"TimerTask.cancel() should return true if sheduled for repeated execution and run", (boolean)testTask.cancel());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 5000L);
            TimerTaskTest.assertTrue((String)"TimerTask.cancel() should return true if task has never run", (boolean)testTask.cancel());
            TimerTaskTest.assertFalse((String)"TimerTask.cancel() should return false if called a second time", (boolean)testTask.cancel());
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            testTask.sleepInRun(true);
            Object object = this.start;
            synchronized (object) {
                t.schedule((TimerTask)testTask, 0L);
                try {
                    this.start.wait();
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            TimerTaskTest.assertFalse((String)"TimerTask should have been cancelled", (boolean)testTask.cancel());
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="scheduledExecutionTime", args={})
    public void test_scheduledExecutionTime() {
        Timer t = null;
        try {
            t = new Timer();
            TimerTestTask testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 100L);
            long time = System.currentTimeMillis() + 100L;
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.sync.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            long scheduledExecutionTime = testTask.scheduledExecutionTime();
            TimerTaskTest.assertTrue((scheduledExecutionTime <= time ? 1 : 0) != 0);
            t.cancel();
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 100L, 500L);
            long estNow = System.currentTimeMillis() + 100L;
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    this.sync.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            scheduledExecutionTime = testTask.scheduledExecutionTime();
            TimerTaskTest.assertTrue((scheduledExecutionTime <= estNow ? 1 : 0) != 0);
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="run", args={})
    public void test_run() {
        Timer t = null;
        try {
            TimerTestTask testTask = new TimerTestTask();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TimerTaskTest.assertEquals((String)"TimerTask.run() method should not have been called", (int)0, (int)testTask.wasRun());
            t = new Timer();
            testTask = new TimerTestTask();
            t.schedule((TimerTask)testTask, 200L);
            while (testTask.wasRun() < 1) {
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TimerTaskTest.assertFalse((boolean)testTask.cancel());
            t.cancel();
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }

    class TimerTestTask
    extends TimerTask {
        private int wasRun = 0;
        private boolean sleepInRun = false;

        TimerTestTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                ++this.wasRun;
            }
            object = TimerTaskTest.this.start;
            synchronized (object) {
                TimerTaskTest.this.start.notify();
            }
            if (this.sleepInRun) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = TimerTaskTest.this.sync;
            synchronized (object) {
                TimerTaskTest.this.sync.notify();
            }
        }

        public synchronized int wasRun() {
            return this.wasRun;
        }

        public void sleepInRun(boolean value) {
            this.sleepInRun = value;
        }
    }
}

