/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import junit.framework.TestCase;

@TestTargetClass(value=StringTokenizer.class)
public class StringTokenizerTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="StringTokenizer", args={String.class})
    public void test_ConstructorLjava_lang_String() {
        try {
            new StringTokenizer(null);
            StringTokenizerTest.fail((String)"NullPointerException is not thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="StringTokenizer", args={String.class, String.class})
    public void test_ConstructorLjava_lang_StringLjava_lang_String() {
        StringTokenizer st = new StringTokenizer("This:is:a:test:String", ":");
        StringTokenizerTest.assertTrue((String)"Created incorrect tokenizer", (st.countTokens() == 5 && st.nextElement().equals("This") ? 1 : 0) != 0);
        st = new StringTokenizer("This:is:a:test:String", null);
        try {
            new StringTokenizer(null, ":");
            StringTokenizerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="StringTokenizer", args={String.class, String.class, boolean.class})
    public void test_ConstructorLjava_lang_StringLjava_lang_StringZ() {
        StringTokenizer st = new StringTokenizer("This:is:a:test:String", ":", true);
        st.nextElement();
        StringTokenizerTest.assertTrue((String)"Created incorrect tokenizer", (st.countTokens() == 8 && st.nextElement().equals(":") ? 1 : 0) != 0);
        st = new StringTokenizer("This:is:a:test:String", null, true);
        st = new StringTokenizer("This:is:a:test:String", null, false);
        try {
            new StringTokenizer(null, ":", true);
            StringTokenizerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="countTokens", args={})
    public void test_countTokens() {
        StringTokenizer st = new StringTokenizer("This is a test String");
        StringTokenizerTest.assertEquals((String)"Incorrect token count returned", (int)5, (int)st.countTokens());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasMoreElements", args={})
    public void test_hasMoreElements() {
        StringTokenizer st = new StringTokenizer("This is a test String");
        st.nextElement();
        StringTokenizerTest.assertTrue((String)"hasMoreElements returned incorrect value", (boolean)st.hasMoreElements());
        st.nextElement();
        st.nextElement();
        st.nextElement();
        st.nextElement();
        StringTokenizerTest.assertTrue((String)"hasMoreElements returned incorrect value", (!st.hasMoreElements() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasMoreTokens", args={})
    public void test_hasMoreTokens() {
        StringTokenizer st = new StringTokenizer("This is a test String");
        for (int counter = 0; counter < 5; ++counter) {
            StringTokenizerTest.assertTrue((String)"StringTokenizer incorrectly reports it has no more tokens", (boolean)st.hasMoreTokens());
            st.nextToken();
        }
        StringTokenizerTest.assertTrue((String)"StringTokenizer incorrectly reports it has more tokens", (!st.hasMoreTokens() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextElement", args={})
    public void test_nextElement() {
        StringTokenizer st = new StringTokenizer("This is a test String");
        StringTokenizerTest.assertEquals((String)"nextElement returned incorrect value", (String)"This", (String)((String)st.nextElement()));
        StringTokenizerTest.assertEquals((String)"nextElement returned incorrect value", (String)"is", (String)((String)st.nextElement()));
        StringTokenizerTest.assertEquals((String)"nextElement returned incorrect value", (String)"a", (String)((String)st.nextElement()));
        StringTokenizerTest.assertEquals((String)"nextElement returned incorrect value", (String)"test", (String)((String)st.nextElement()));
        StringTokenizerTest.assertEquals((String)"nextElement returned incorrect value", (String)"String", (String)((String)st.nextElement()));
        try {
            st.nextElement();
            StringTokenizerTest.fail((String)"nextElement failed to throw a NoSuchElementException when it should have been out of elements");
        }
        catch (NoSuchElementException e) {
            return;
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextToken", args={})
    public void test_nextToken() {
        StringTokenizer st = new StringTokenizer("This is a test String");
        StringTokenizerTest.assertEquals((String)"nextToken returned incorrect value", (String)"This", (String)st.nextToken());
        StringTokenizerTest.assertEquals((String)"nextToken returned incorrect value", (String)"is", (String)st.nextToken());
        StringTokenizerTest.assertEquals((String)"nextToken returned incorrect value", (String)"a", (String)st.nextToken());
        StringTokenizerTest.assertEquals((String)"nextToken returned incorrect value", (String)"test", (String)st.nextToken());
        StringTokenizerTest.assertEquals((String)"nextToken returned incorrect value", (String)"String", (String)st.nextToken());
        try {
            st.nextToken();
            StringTokenizerTest.fail((String)"nextToken failed to throw a NoSuchElementException when it should have been out of elements");
        }
        catch (NoSuchElementException e) {
            return;
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextToken", args={String.class})
    public void test_nextTokenLjava_lang_String() {
        StringTokenizer st = new StringTokenizer("This is a test String");
        StringTokenizerTest.assertEquals((String)"nextToken(String) returned incorrect value with normal token String", (String)"This", (String)st.nextToken(" "));
        StringTokenizerTest.assertEquals((String)"nextToken(String) returned incorrect value with custom token String", (String)" is a ", (String)st.nextToken("tr"));
        StringTokenizerTest.assertEquals((String)"calling nextToken() did not use the new default delimiter list", (String)"es", (String)st.nextToken());
        st = new StringTokenizer("This:is:a:test:String", " ");
        StringTokenizerTest.assertTrue((boolean)st.nextToken(":").equals("This"));
        StringTokenizerTest.assertTrue((boolean)st.nextToken(":").equals("is"));
        StringTokenizerTest.assertTrue((boolean)st.nextToken(":").equals("a"));
        StringTokenizerTest.assertTrue((boolean)st.nextToken(":").equals("test"));
        StringTokenizerTest.assertTrue((boolean)st.nextToken(":").equals("String"));
        try {
            st.nextToken(":");
            StringTokenizerTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            st.nextToken(null);
            StringTokenizerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

