/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.EmptyStackException;
import java.util.Stack;
import junit.framework.TestCase;

@TestTargetClass(value=Stack.class)
public class StackTest
extends TestCase {
    Stack s;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Stack", args={})
    public void test_Constructor() {
        StackTest.assertEquals((String)"Stack creation failed", (int)0, (int)this.s.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="empty", args={})
    public void test_empty() {
        StackTest.assertTrue((String)"New stack answers non-empty", (boolean)this.s.empty());
        this.s.push("blah");
        StackTest.assertTrue((String)"Stack should not be empty but answers empty", (!this.s.empty() ? 1 : 0) != 0);
        this.s.pop();
        StackTest.assertTrue((String)"Stack should be empty but answers non-empty", (boolean)this.s.empty());
        this.s.push(null);
        StackTest.assertTrue((String)"Stack with null should not be empty but answers empty", (!this.s.empty() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="peek", args={})
    public void test_peek() {
        String item1 = "Ichi";
        String item2 = "Ni";
        String item3 = "San";
        this.s.push(item1);
        StackTest.assertTrue((String)"Peek did not return top item when it was the only item", (this.s.peek() == item1 ? 1 : 0) != 0);
        this.s.push(item2);
        this.s.push(item3);
        StackTest.assertTrue((String)"Peek did not return top item amoung many other items", (this.s.peek() == item3 ? 1 : 0) != 0);
        this.s.pop();
        StackTest.assertTrue((String)"Peek did not return top item after a pop", (this.s.pop() == item2 ? 1 : 0) != 0);
        this.s.push(null);
        StackTest.assertNull((String)"Peek did not return top item (wanted: null)", this.s.peek());
        this.s.pop();
        this.s.pop();
        try {
            this.s.pop();
            StackTest.fail((String)"EmptyStackException expected");
        }
        catch (EmptyStackException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="pop", args={})
    public void test_pop() {
        Object lastPopped;
        String item1 = "Ichi";
        String item2 = "Ni";
        this.s.push(item1);
        this.s.push(item2);
        try {
            lastPopped = this.s.pop();
            StackTest.assertTrue((String)"a) Pop did not return top item", (lastPopped == item2 ? 1 : 0) != 0);
        }
        catch (EmptyStackException e) {
            StackTest.fail((String)"a) Pop threw EmptyStackException when stack should not have been empty");
        }
        try {
            lastPopped = this.s.pop();
            StackTest.assertTrue((String)"b) Pop did not return top item", (lastPopped == item1 ? 1 : 0) != 0);
        }
        catch (EmptyStackException e) {
            StackTest.fail((String)"b) Pop threw EmptyStackException when stack should not have been empty");
        }
        this.s.push(null);
        try {
            lastPopped = this.s.pop();
            StackTest.assertNull((String)"c) Pop did not return top item", lastPopped);
        }
        catch (EmptyStackException e) {
            StackTest.fail((String)"c) Pop threw EmptyStackException when stack should not have been empty");
        }
        try {
            lastPopped = this.s.pop();
            StackTest.fail((String)"d) Pop did not throw EmptyStackException when stack should have been empty");
        }
        catch (EmptyStackException e) {
            return;
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="push", args={Object.class})
    public void test_pushLjava_lang_Object() {
        int i;
        Object[] array = new Object[]{new Integer(0), new Object(), new Float(0.0f), new String()};
        Stack<Object> stack = new Stack<Object>();
        for (i = 0; i < array.length; ++i) {
            stack.push(array[i]);
        }
        for (i = 0; i < array.length; ++i) {
            StackTest.assertEquals((int)(array.length - i), (int)stack.search(array[i]));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="search", args={Object.class})
    public void test_searchLjava_lang_Object() {
        String item1 = "Ichi";
        String item2 = "Ni";
        String item3 = "San";
        this.s.push(item1);
        this.s.push(item2);
        this.s.push(item3);
        StackTest.assertEquals((String)"Search returned incorrect value for equivalent object", (int)3, (int)this.s.search(item1));
        StackTest.assertEquals((String)"Search returned incorrect value for equal object", (int)3, (int)this.s.search("Ichi"));
        this.s.pop();
        StackTest.assertEquals((String)"Search returned incorrect value for equivalent object at top of stack", (int)1, (int)this.s.search(item2));
        StackTest.assertEquals((String)"Search returned incorrect value for equal object at top of stack", (int)1, (int)this.s.search("Ni"));
        this.s.push(null);
        StackTest.assertEquals((String)"Search returned incorrect value for search for null at top of stack", (int)1, (int)this.s.search(null));
        this.s.push("Shi");
        StackTest.assertEquals((String)"Search returned incorrect value for search for null", (int)2, (int)this.s.search(null));
        this.s.pop();
        this.s.pop();
        StackTest.assertEquals((String)"Search returned incorrect value for search for null--wanted -1", (int)-1, (int)this.s.search(null));
    }

    protected void setUp() {
        this.s = new Stack();
    }

    protected void tearDown() {
    }
}

