/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.TestCase;

@TestTargetClass(value=SimpleTimeZone.class)
public class SimpleTimeZoneTest
extends TestCase {
    SimpleTimeZone st1;
    SimpleTimeZone st2;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="SimpleTimeZone", args={int.class, String.class})
    public void test_ConstructorILjava_lang_String() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "TEST");
        SimpleTimeZoneTest.assertEquals((String)"Incorrect TZ constructed", (String)"TEST", (String)st.getID());
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed: returned wrong offset", (st.getRawOffset() == 1000 ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructedusing daylight savings", (!st.useDaylightTime() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="SimpleTimeZone", args={int.class, String.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorILjava_lang_StringIIIIIIII() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "TEST", 10, 1, 1, 0, 10, -1, 1, 0);
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (boolean)st.inDaylightTime(new GregorianCalendar(1998, 10, 13).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertEquals((String)"Incorrect TZ constructed", (String)"TEST", (String)st.getID());
        SimpleTimeZoneTest.assertEquals((String)"Incorrect TZ constructed", (int)1000, (int)st.getRawOffset());
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (boolean)st.useDaylightTime());
        try {
            new SimpleTimeZone(1000, "TEST", 12, 1, 1, 0, 10, -1, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 10, 10, 1, 0, 10, -1, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 10, 1, 10, 0, 10, -1, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 11, 1, 1, 0, 10, -10, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="SimpleTimeZone", args={int.class, String.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorILjava_lang_StringIIIIIIIII() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "TEST", 10, 1, 1, 0, 10, -1, 1, 0, 3600000);
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (boolean)st.inDaylightTime(new GregorianCalendar(1998, 10, 13).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertEquals((String)"Incorrect TZ constructed", (String)"TEST", (String)st.getID());
        SimpleTimeZoneTest.assertEquals((String)"Incorrect TZ constructed", (int)1000, (int)st.getRawOffset());
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"Incorrect TZ constructed", (st.getDSTSavings() == 3600000 ? 1 : 0) != 0);
        try {
            new SimpleTimeZone(1000, "TEST", 12, 1, 1, 0, 10, -1, 1, 0, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 10, 10, 1, 0, 10, -1, 1, 0, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 10, 1, 10, 0, 10, -1, 1, 0, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 11, 1, 1, 0, 10, -10, 1, 0, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="SimpleTimeZone", args={int.class, String.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorILjava_lang_StringIIIIIIIIIII() {
        SimpleTimeZoneTest.assertNotNull((Object)new SimpleTimeZone(1, "Europe/Paris", 1, 1, 2, 0, 0, 0, 1, 1, 2, 1, 1));
        SimpleTimeZoneTest.assertNotNull((Object)new SimpleTimeZone(1, "Europe/Paris", 1, 1, 2, 0, Integer.MAX_VALUE, 0, 1, 1, 2, Integer.MIN_VALUE, 1));
        try {
            new SimpleTimeZone(1000, "TEST", 12, 1, 1, 0, Integer.MAX_VALUE, 10, -1, 1, 0, Integer.MAX_VALUE, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 10, 10, 1, 0, Integer.MAX_VALUE, 10, -1, 1, 0, Integer.MAX_VALUE, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 10, 1, 10, 0, 10, Integer.MAX_VALUE, -1, 1, 0, Integer.MAX_VALUE, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SimpleTimeZone(1000, "TEST", 11, 1, 1, 0, 10, Integer.MAX_VALUE, -10, 1, 0, Integer.MAX_VALUE, 3600000);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        SimpleTimeZone st1 = new SimpleTimeZone(1000, "TEST", 10, 1, 1, 0, 10, -1, 1, 0);
        SimpleTimeZone stA = new SimpleTimeZone(1, "Gah");
        SimpleTimeZoneTest.assertTrue((String)"Clone resulted in same reference", (st1.clone() != st1 ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"Clone resulted in unequal object", (boolean)((SimpleTimeZone)st1.clone()).equals(st1));
        SimpleTimeZoneTest.assertTrue((String)"Clone resulted in same reference", (stA.clone() != stA ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"Clone resulted in unequal object", (boolean)((SimpleTimeZone)stA.clone()).equals(stA));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        TimeZone tz = TimeZone.getTimeZone("EST");
        this.st1 = new SimpleTimeZone(tz.getRawOffset(), "EST");
        this.st2 = new SimpleTimeZone(0, "EST");
        SimpleTimeZoneTest.assertFalse((boolean)this.st1.equals(this.st2));
        this.st1.setRawOffset(this.st2.getRawOffset());
        SimpleTimeZoneTest.assertTrue((boolean)this.st1.equals(this.st2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDSTSavings", args={})
    public void test_getDSTSavings() {
        this.st1 = new SimpleTimeZone(0, "TEST");
        SimpleTimeZoneTest.assertEquals((String)"Non-zero default daylight savings", (int)0, (int)this.st1.getDSTSavings());
        this.st1.setStartRule(0, 1, 1, 1);
        this.st1.setEndRule(11, 1, 1, 1);
        SimpleTimeZoneTest.assertEquals((String)"Incorrect default daylight savings", (int)3600000, (int)this.st1.getDSTSavings());
        this.st1 = new SimpleTimeZone(-18000000, "EST", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 0x6DDD00);
        SimpleTimeZoneTest.assertEquals((String)"Incorrect daylight savings from constructor", (int)0x6DDD00, (int)this.st1.getDSTSavings());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getOffset", args={int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_getOffsetIIIIII() {
        this.st1 = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        SimpleTimeZoneTest.assertTrue((String)"Incorrect offset returned", (this.st1.getOffset(1, 1998, 10, 11, 4, 0) == -18000000 ? 1 : 0) != 0);
        this.st1 = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        SimpleTimeZoneTest.assertEquals((String)"Incorrect offset returned", (int)-18000000, (int)this.st1.getOffset(1, 1998, 5, 11, 5, 0));
        this.st1 = new SimpleTimeZone(TimeZone.getDefault().getRawOffset(), TimeZone.getDefault().getID());
        int fourHours = 14400000;
        this.st1.setRawOffset(fourHours);
        SimpleTimeZoneTest.assertEquals((int)fourHours, (int)this.st1.getOffset(1, 2099, 1, 1, 5, 0));
        try {
            this.st1.getOffset(-1, 2099, 1, 1, 5, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.st1.getOffset(1, 2099, 15, 1, 5, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.st1.getOffset(1, 2099, 1, 100, 5, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.st1.getOffset(1, 2099, 1, 1, 50, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.st1.getOffset(1, 2099, 1, 1, 5, -10);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getRawOffset", args={})
    public void test_getRawOffset() {
        this.st1 = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        SimpleTimeZoneTest.assertTrue((String)"Incorrect offset returned", (this.st1.getRawOffset() == -18000000 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        this.st1 = new SimpleTimeZone(-18000000, "EST", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        SimpleTimeZoneTest.assertTrue((TimeZone.getTimeZone("EST").hashCode() != 0 ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((this.st1.hashCode() != 0 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasSameRules", args={TimeZone.class})
    public void test_hasSameRulesLjava_util_TimeZone() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "TEST", 10, 1, 1, 0, 10, -1, 1, 0);
        SimpleTimeZone sameAsSt = new SimpleTimeZone(1000, "REST", 10, 1, 1, 0, 10, -1, 1, 0);
        SimpleTimeZone notSameAsSt = new SimpleTimeZone(1000, "PEST", 10, 2, 1, 0, 10, -1, 1, 0);
        SimpleTimeZoneTest.assertTrue((String)"Time zones have same rules but return false", (boolean)st.hasSameRules(sameAsSt));
        SimpleTimeZoneTest.assertTrue((String)"Time zones have different rules but return true", (!st.hasSameRules(notSameAsSt) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="inDaylightTime", args={Date.class})
    public void test_inDaylightTimeLjava_util_Date() {
        TimeZone tz = TimeZone.getTimeZone("EST");
        SimpleTimeZone zone = new SimpleTimeZone(tz.getRawOffset(), "EST", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000);
        GregorianCalendar gc = new GregorianCalendar(1998, 5, 11);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value1", (boolean)zone.inDaylightTime(gc.getTime()));
        gc = new GregorianCalendar(1998, 10, 11);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value2", (!zone.inDaylightTime(gc.getTime()) ? 1 : 0) != 0);
        gc = new GregorianCalendar(zone);
        gc.set(1999, 3, 4, 1, 59, 59);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value3", (!zone.inDaylightTime(gc.getTime()) ? 1 : 0) != 0);
        Date date = new Date(gc.getTime().getTime() + 1000L);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value4", (boolean)zone.inDaylightTime(date));
        gc.set(1999, 9, 31, 1, 0, 0);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value5", (!zone.inDaylightTime(gc.getTime()) ? 1 : 0) != 0);
        date = new Date(gc.getTime().getTime() - 1000L);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value6", (boolean)zone.inDaylightTime(date));
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value7", (!zone.inDaylightTime(new Date(891759599999L)) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value8", (boolean)zone.inDaylightTime(new Date(891759600000L)));
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value9", (boolean)zone.inDaylightTime(new Date(909295199999L)));
        SimpleTimeZoneTest.assertTrue((String)"Returned incorrect daylight value10", (!zone.inDaylightTime(new Date(909295200000L)) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setDSTSavings", args={int.class})
    public void test_setDSTSavingsI() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(0, 1, 1, 1);
        st.setEndRule(11, 1, 1, 1);
        st.setDSTSavings(1);
        SimpleTimeZoneTest.assertEquals((String)"Daylight savings amount not set", (int)1, (int)st.getDSTSavings());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setEndRule", args={int.class, int.class, int.class})
    public void test_setEndRuleIII() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(10, 1, 0);
        st.setEndRule(10, 20, 0);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set1", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set2", (boolean)st.inDaylightTime(new GregorianCalendar(1998, 10, 13).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set3", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        try {
            st.setEndRule(13, 20, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(1, 32, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(1, 30, 10);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setEndRule", args={int.class, int.class, int.class, int.class})
    public void test_setEndRuleIIII() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(10, 1, 1, 0);
        st.setEndRule(10, -1, 1, 0);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set1", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set2", (boolean)st.inDaylightTime(new GregorianCalendar(1998, 10, 13).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set3", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        try {
            st.setEndRule(12, -1, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(10, 10, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(10, -1, 8, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(10, -1, 1, -10);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setEndRule", args={int.class, int.class, int.class, int.class, boolean.class})
    public void test_setEndRuleIIIIZ() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(10, 8, 1, 1, false);
        st.setEndRule(10, 15, 1, 1, true);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set1", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set2", (boolean)st.inDaylightTime(new GregorianCalendar(1999, 10, 7, 12, 0).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set3", (boolean)st.inDaylightTime(new GregorianCalendar(1999, 10, 20, 12, 0).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set4", (!st.inDaylightTime(new GregorianCalendar(1999, 10, 6, 12, 0).getTime()) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set5", (!st.inDaylightTime(new GregorianCalendar(1999, 10, 21, 12, 0).getTime()) ? 1 : 0) != 0);
        try {
            st.setEndRule(20, 15, 1, 1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(10, 35, 1, 1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(10, 15, 12, 1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setEndRule(10, 15, 1, -1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setRawOffset", args={int.class})
    public void test_setRawOffsetI() {
        this.st1 = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        int off = this.st1.getRawOffset();
        this.st1.setRawOffset(1000);
        boolean val = this.st1.getRawOffset() == 1000;
        this.st1.setRawOffset(off);
        SimpleTimeZoneTest.assertTrue((String)"Incorrect offset set", (boolean)val);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setStartRule", args={int.class, int.class, int.class})
    public void test_setStartRuleIII() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(10, 1, 1);
        st.setEndRule(11, 1, 1);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set", (boolean)st.inDaylightTime(new GregorianCalendar(1998, 10, 13).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        try {
            st.setStartRule(13, 20, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(1, 32, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(1, 30, 10);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setStartRule", args={int.class, int.class, int.class, int.class})
    public void test_setStartRuleIIII() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(10, 1, 1, 0);
        st.setEndRule(10, -1, 1, 0);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set1", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set2", (boolean)st.inDaylightTime(new GregorianCalendar(1998, 10, 13).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set3", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        try {
            st.setStartRule(12, -1, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(10, 10, 1, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(10, -1, 8, 0);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(10, -1, 1, -10);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setStartRule", args={int.class, int.class, int.class, int.class, boolean.class})
    public void test_setStartRuleIIIIZ() {
        SimpleTimeZone st = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        st.setStartRule(10, 1, 1, 1, true);
        st.setEndRule(10, 15, 1, 1, false);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set1", (boolean)st.useDaylightTime());
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set2", (boolean)st.inDaylightTime(new GregorianCalendar(1999, 10, 7, 12, 0).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set3", (boolean)st.inDaylightTime(new GregorianCalendar(1999, 10, 13, 12, 0).getTime()));
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set4", (!st.inDaylightTime(new GregorianCalendar(1999, 10, 6, 12, 0).getTime()) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"StartRule improperly set5", (!st.inDaylightTime(new GregorianCalendar(1999, 10, 14, 12, 0).getTime()) ? 1 : 0) != 0);
        try {
            st.setStartRule(20, 15, 1, 1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(10, 35, 1, 1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(10, 15, 12, 1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            st.setStartRule(10, 15, 1, -1, true);
            SimpleTimeZoneTest.fail((String)"IllegalArgumentException is not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setStartYear", args={int.class})
    public void test_setStartYearI() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        st.setStartRule(10, 1, 1, 0);
        st.setEndRule(10, -1, 1, 0);
        st.setStartYear(1999);
        SimpleTimeZoneTest.assertTrue((String)"set year improperly set1", (!st.inDaylightTime(new GregorianCalendar(1999, 6, 12).getTime()) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"set year improperly set2", (!st.inDaylightTime(new GregorianCalendar(1998, 9, 13).getTime()) ? 1 : 0) != 0);
        SimpleTimeZoneTest.assertTrue((String)"set year improperly set3", (boolean)st.inDaylightTime(new GregorianCalendar(1999, 10, 13).getTime()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        String string = TimeZone.getTimeZone("EST").toString();
        SimpleTimeZoneTest.assertNotNull((String)"toString() returned null", (Object)string);
        SimpleTimeZoneTest.assertTrue((String)"toString() is empty", (string.length() != 0 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="useDaylightTime", args={})
    public void test_useDaylightTime() {
        SimpleTimeZone st = new SimpleTimeZone(1000, "Test_TZ");
        SimpleTimeZoneTest.assertTrue((String)"useDaylightTime returned incorrect value", (!st.useDaylightTime() ? 1 : 0) != 0);
        st.setStartRule(10, 1, 1, 0);
        st.setEndRule(10, -1, 1, 0);
        SimpleTimeZoneTest.assertTrue((String)"useDaylightTime returned incorrect value", (boolean)st.useDaylightTime());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getOffset", args={long.class})
    public void test_getOffsetJ() {
        Calendar cal = Calendar.getInstance();
        cal.set(1998, 10, 11, 0, 0);
        this.st1 = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        SimpleTimeZoneTest.assertTrue((String)"Incorrect offset returned", (this.st1.getOffset(cal.getTimeInMillis()) == -18000000 ? 1 : 0) != 0);
        this.st1 = new SimpleTimeZone(TimeZone.getTimeZone("EST").getRawOffset(), "EST");
        cal.set(1998, 5, 11, 0, 0);
        SimpleTimeZoneTest.assertEquals((String)"Incorrect offset returned", (int)-18000000, (int)this.st1.getOffset(cal.getTimeInMillis()));
        this.st1 = new SimpleTimeZone(TimeZone.getDefault().getRawOffset(), TimeZone.getDefault().getID());
        int fourHours = 14400000;
        this.st1.setRawOffset(fourHours);
        cal.set(2099, 1, 1, 0, 0);
        SimpleTimeZoneTest.assertEquals((int)fourHours, (int)this.st1.getOffset(cal.getTimeInMillis()));
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

