/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import tests.support.Support_Locale;
import tests.support.Support_PortManager;

@TestTargetClass(value=Scanner.class)
public class ScannerTest
extends TestCase {
    static final boolean disableRIBugs = false;
    private Scanner s;
    private ServerSocket server;
    private SocketAddress address;
    private SocketChannel client;
    private Socket serverSocket;
    private OutputStream os;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={File.class})
    public void test_ConstructorLjava_io_File() throws IOException {
        File tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        this.s = new Scanner(tmpFile);
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        ScannerTest.assertTrue((boolean)tmpFile.delete());
        try {
            this.s = new Scanner(tmpFile);
            ScannerTest.fail((String)"should throw FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        FileOutputStream fos = new FileOutputStream(tmpFile);
        fos.write("test".getBytes());
        this.s = new Scanner(tmpFile);
        tmpFile.delete();
        try {
            this.s = new Scanner((File)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={File.class, String.class})
    public void test_ConstructorLjava_io_FileLjava_lang_String() throws IOException {
        File tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        this.s = new Scanner(tmpFile, Charset.defaultCharset().name());
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        ScannerTest.assertTrue((boolean)tmpFile.delete());
        try {
            this.s = new Scanner(tmpFile, Charset.defaultCharset().name());
            ScannerTest.fail((String)"should throw FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner(tmpFile, null);
            ScannerTest.fail((String)"should throw FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        try {
            this.s = new Scanner(tmpFile, "invalid charset");
            ScannerTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ScannerTest.assertTrue((boolean)tmpFile.delete());
        try {
            this.s = new Scanner((File)null, null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner((File)null, "UTF-8");
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner((File)null, "invalid");
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            File f = File.createTempFile("test", ".tmp");
            this.s = new Scanner(f, null);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={InputStream.class})
    public void test_ConstructorLjava_io_InputStream() {
        this.s = new Scanner(new PipedInputStream());
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        try {
            this.s = new Scanner((InputStream)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={InputStream.class, String.class})
    public void test_ConstructorLjava_io_InputStreamLjava_lang_String() {
        this.s = new Scanner((InputStream)new PipedInputStream(), Charset.defaultCharset().name());
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        try {
            this.s = new Scanner((InputStream)null, "invalid charset");
            ScannerTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner((InputStream)new PipedInputStream(), null);
            ScannerTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner((InputStream)new PipedInputStream(), "invalid charset");
            ScannerTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={Readable.class})
    public void test_ConstructorLjava_lang_Readable() {
        this.s = new Scanner(new StringReader("test string"));
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        try {
            this.s = new Scanner((Readable)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={ReadableByteChannel.class})
    public void test_ConstructorLjava_nio_channels_ReadableByteChannel() throws IOException {
        File tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        FileChannel fc = new FileOutputStream(tmpFile).getChannel();
        this.s = new Scanner(fc);
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        ScannerTest.assertTrue((boolean)tmpFile.delete());
        try {
            this.s = new Scanner((ReadableByteChannel)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={ReadableByteChannel.class, String.class})
    public void test_ConstructorLjava_nio_channels_ReadableByteChannelLjava_lang_String() throws IOException {
        File tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        FileChannel fc = new FileOutputStream(tmpFile).getChannel();
        this.s = new Scanner((ReadableByteChannel)fc, Charset.defaultCharset().name());
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        fc = new FileOutputStream(tmpFile).getChannel();
        try {
            this.s = new Scanner((ReadableByteChannel)fc, "invalid charset");
            ScannerTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        fc.close();
        ScannerTest.assertTrue((boolean)tmpFile.delete());
        try {
            this.s = new Scanner((ReadableByteChannel)null, null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner((ReadableByteChannel)null, "invalid");
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner((ReadableByteChannel)fc, null);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={String.class})
    public void test_ConstructorLjava_lang_String() {
        this.s = new Scanner("test string");
        ScannerTest.assertNotNull((Object)this.s);
        this.s.close();
        try {
            this.s = new Scanner((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="close", args={})
    public void test_close() throws IOException {
        File tmpFile = File.createTempFile("TestFileForScanner", ".tmp");
        FileOutputStream fos = new FileOutputStream(tmpFile);
        FileChannel fc = fos.getChannel();
        this.s = new Scanner(fc);
        fos.write(12);
        this.s.close();
        ScannerTest.assertFalse((boolean)fc.isOpen());
        try {
            fos.write(12);
            ScannerTest.fail((String)"Should throw IOException");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.s.close();
        ScannerTest.assertTrue((boolean)tmpFile.delete());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ioException", args={})
    public void test_ioException() throws IOException {
        MockCloseable mc = new MockCloseable();
        this.s = new Scanner(mc);
        ScannerTest.assertNull((Object)this.s.ioException());
        this.s.close();
        ScannerTest.assertNotNull((Object)this.s.ioException());
        ScannerTest.assertTrue((boolean)(this.s.ioException() instanceof IOException));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="delimiter", args={})
    public void test_delimiter() {
        this.s = new Scanner("test");
        Pattern pattern = this.s.delimiter();
        ScannerTest.assertEquals((String)"\\p{javaWhitespace}+", (String)pattern.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="useDelimiter", args={Pattern.class})
    public void test_useDelimiter_LPattern() {
        this.s = new Scanner("test");
        this.s.useDelimiter(Pattern.compile("\\w+"));
        ScannerTest.assertEquals((String)"\\w+", (String)this.s.delimiter().toString());
        this.s = new Scanner("test");
        this.s.useDelimiter((Pattern)null);
        ScannerTest.assertNull((Object)this.s.delimiter());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="useDelimiter", args={String.class})
    public void test_useDelimiter_String() {
        this.s = new Scanner("test");
        try {
            this.s.useDelimiter((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.s = new Scanner("test");
        this.s.useDelimiter("\\w+");
        ScannerTest.assertEquals((String)"\\w+", (String)this.s.delimiter().toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="locale", args={})
    public void test_locale() {
        this.s = new Scanner("test");
        ScannerTest.assertEquals((Object)Locale.getDefault(), (Object)this.s.locale());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="useLocale", args={Locale.class})
    public void test_useLocale_LLocale() {
        this.s = new Scanner("test");
        try {
            this.s.useLocale(null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.s.useLocale(new Locale("test", "test"));
        ScannerTest.assertEquals((Object)new Locale("test", "test"), (Object)this.s.locale());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="radix", args={})
    public void test_radix() {
        this.s = new Scanner("test");
        ScannerTest.assertEquals((int)10, (int)this.s.radix());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="useRadix", args={int.class})
    public void test_useRadix_I() {
        this.s = new Scanner("test");
        try {
            this.s.useRadix(1);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.s.useRadix(37);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.s.useRadix(11);
        ScannerTest.assertEquals((int)11, (int)this.s.radix());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={})
    public void test_remove() {
        this.s = new Scanner("aab*b*").useDelimiter("\\*");
        try {
            this.s.remove();
            ScannerTest.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="match", args={})
    public void test_match() {
        this.s = new Scanner("1 2 ");
        try {
            this.s.match();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        MatchResult result = this.s.match();
        ScannerTest.assertEquals((int)2, (int)result.start());
        ScannerTest.assertEquals((int)3, (int)result.end());
        ScannerTest.assertEquals((int)2, (int)result.start(0));
        ScannerTest.assertEquals((int)3, (int)result.end(0));
        ScannerTest.assertEquals((String)"2", (String)result.group());
        ScannerTest.assertEquals((String)"2", (String)result.group(0));
        ScannerTest.assertEquals((int)0, (int)result.groupCount());
        try {
            result.start(1);
            ScannerTest.fail((String)"should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("True faLse");
        try {
            this.s.match();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        result = this.s.match();
        ScannerTest.assertEquals((int)0, (int)result.start());
        ScannerTest.assertEquals((int)4, (int)result.end());
        ScannerTest.assertEquals((int)0, (int)result.start(0));
        ScannerTest.assertEquals((int)4, (int)result.end(0));
        ScannerTest.assertEquals((String)"True", (String)result.group());
        ScannerTest.assertEquals((int)0, (int)result.groupCount());
        ScannerTest.assertFalse((boolean)this.s.nextBoolean());
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("True faLse");
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        result = this.s.match();
        ScannerTest.assertEquals((int)0, (int)result.start());
        ScannerTest.assertEquals((int)4, (int)result.end());
        ScannerTest.assertEquals((int)0, (int)result.start(0));
        ScannerTest.assertEquals((int)4, (int)result.end(0));
        ScannerTest.assertEquals((String)"True", (String)result.group());
        ScannerTest.assertEquals((int)0, (int)result.groupCount());
        this.s.close();
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        result = this.s.match();
        ScannerTest.assertEquals((int)0, (int)result.start());
        ScannerTest.assertEquals((int)4, (int)result.end());
        ScannerTest.assertEquals((int)0, (int)result.start(0));
        ScannerTest.assertEquals((int)4, (int)result.end(0));
        ScannerTest.assertEquals((String)"True", (String)result.group());
        ScannerTest.assertEquals((int)0, (int)result.groupCount());
        this.s = new Scanner("True fase");
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        ScannerTest.assertEquals((int)0, (int)result.groupCount());
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("True fase");
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        try {
            this.s.next((Pattern)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        result = this.s.match();
        ScannerTest.assertEquals((int)0, (int)result.start());
        ScannerTest.assertEquals((int)4, (int)result.end());
        ScannerTest.assertEquals((int)0, (int)result.start(0));
        ScannerTest.assertEquals((int)4, (int)result.end(0));
        ScannerTest.assertEquals((String)"True", (String)result.group());
        ScannerTest.assertEquals((int)0, (int)result.groupCount());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="next", args={})
    public void test_next() throws IOException {
        int i;
        this.s = new Scanner("1**2").useDelimiter("\\*");
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        this.s = new Scanner(" \t 1 \t 2").useDelimiter("\\s*");
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("a").useDelimiter("a?");
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("aa").useDelimiter("a?");
        ScannerTest.assertEquals((String)"", (String)this.s.next());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("word( )test( )").useDelimiter("\\( \\)");
        ScannerTest.assertEquals((String)"word", (String)this.s.next());
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        this.s = new Scanner("? next  ").useDelimiter("( )");
        ScannerTest.assertEquals((String)"?", (String)this.s.next());
        ScannerTest.assertEquals((String)"next", (String)this.s.next());
        ScannerTest.assertEquals((String)"", (String)this.s.next());
        this.s = new Scanner("word1 word2  ");
        ScannerTest.assertEquals((String)"word1", (String)this.s.next());
        ScannerTest.assertEquals((String)"word2", (String)this.s.next());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner(" ");
        try {
            this.s.next();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("");
        try {
            this.s.next();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("test");
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        this.s = new Scanner("  test");
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        this.s = new Scanner("  test  ");
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        StringBuilder longSentence = new StringBuilder(1025);
        for (i = 0; i < 11; ++i) {
            longSentence.append(" ");
        }
        for (i = 11; i < 1026; ++i) {
            longSentence.append("a");
        }
        this.s = new Scanner(longSentence.toString());
        ScannerTest.assertEquals((String)longSentence.toString().trim(), (String)this.s.next());
        this.s = new Scanner(" test test");
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        this.s = new Scanner("test\ntest").useDelimiter(Pattern.compile("^", 8));
        ScannerTest.assertEquals((String)"test\n", (String)this.s.next());
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        this.s = new Scanner("").useDelimiter(Pattern.compile("^", 8));
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("").useDelimiter(Pattern.compile("^*", 8));
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("test\ntest").useDelimiter(Pattern.compile("^*", 8));
        ScannerTest.assertEquals((String)"t", (String)this.s.next());
        ScannerTest.assertEquals((String)"e", (String)this.s.next());
        this.s = new Scanner("\ntest\ntest").useDelimiter(Pattern.compile("$", 8));
        ScannerTest.assertEquals((String)"\ntest", (String)this.s.next());
        ScannerTest.assertEquals((String)"\ntest", (String)this.s.next());
        for (int i2 = 0; i2 < 1024; ++i2) {
            this.os.write(" ".getBytes());
        }
        this.os.write("  1 2 ".getBytes());
        this.s = new Scanner(this.client);
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        this.os.write("  1 2".getBytes());
        this.serverSocket.close();
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.next();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="next", args={Pattern.class})
    public void test_nextLPattern() throws IOException {
        this.s = new Scanner("aab*2*").useDelimiter("\\*");
        Pattern pattern = Pattern.compile("a*b");
        ScannerTest.assertEquals((String)"aab", (String)this.s.next(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word ? ");
        pattern = Pattern.compile("\\w+");
        ScannerTest.assertEquals((String)"word", (String)this.s.next(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 word2  ");
        pattern = Pattern.compile("\\w+");
        ScannerTest.assertEquals((String)"word1", (String)this.s.next(pattern));
        ScannerTest.assertEquals((String)"word2", (String)this.s.next(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.os.write("aab 2".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        pattern = Pattern.compile("a*b");
        ScannerTest.assertEquals((String)"aab", (String)this.s.next(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="next", args={String.class})
    public void test_nextLString() throws IOException {
        this.s = new Scanner("b*a*").useDelimiter("\\*");
        ScannerTest.assertEquals((String)"b", (String)this.s.next("a*b"));
        try {
            this.s.next("a*b");
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word ? ");
        ScannerTest.assertEquals((String)"word", (String)this.s.next("\\w+"));
        try {
            this.s.next("\\w+");
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 next  ");
        ScannerTest.assertEquals((String)"word1", (String)this.s.next("\\w+"));
        ScannerTest.assertEquals((String)"next", (String)this.s.next("\\w+"));
        try {
            this.s.next("\\w+");
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.os.write("aab 2".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        ScannerTest.assertEquals((String)"aab", (String)this.s.next("a*b"));
        try {
            this.s.next("a*b");
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.next("a*b");
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextBoolean", args={})
    public void test_nextBoolean() throws IOException {
        this.s = new Scanner("TRue");
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        this.s = new Scanner("tRue false");
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        ScannerTest.assertFalse((boolean)this.s.nextBoolean());
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("true1");
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        try {
            this.s = new Scanner("");
            this.s.nextBoolean();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.os.write("true false".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        ScannerTest.assertFalse((boolean)this.s.nextBoolean());
        this.s = new Scanner("true**false").useDelimiter("\\*");
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("false( )").useDelimiter("\\( \\)");
        ScannerTest.assertFalse((boolean)this.s.nextBoolean());
        this.s.close();
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextInt", args={int.class})
    public void test_nextIntI() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)123, (int)this.s.nextInt(10));
        ScannerTest.assertEquals((int)456, (int)this.s.nextInt(10));
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)38, (int)this.s.nextInt(5));
        try {
            this.s.nextInt(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((int)102, (int)this.s.nextInt(10));
        try {
            this.s.nextInt(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)162, (int)this.s.nextInt(10));
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt(10));
        this.s = new Scanner("E3456");
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt(16));
        this.s = new Scanner("E3,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt(16));
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt(10));
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt(10));
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt(10));
        if (Support_Locale.areLocalesAvailable(new Locale("ar", "AE"))) {
            this.s = new Scanner("-123 123- -123-");
            this.s.useLocale(new Locale("ar", "AE"));
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
            try {
                this.s.nextInt(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("-123 123- (123)");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
            try {
                this.s.nextInt();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            ScannerTest.assertEquals((String)"123-", (String)this.s.next());
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
            try {
                this.s.nextInt(1);
                ScannerTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.s.nextInt(37);
                ScannerTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.s.close();
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextInt", args={})
    public void test_nextInt() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.CHINESE, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)123, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)456, (int)this.s.nextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertEquals((int)38, (int)this.s.nextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt());
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt());
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((int)102, (int)this.s.nextInt());
        this.s.useRadix(5);
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertEquals((int)162, (int)this.s.nextInt());
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt());
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt());
        this.s = new Scanner("E3456");
        this.s.useRadix(16);
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt());
        this.s = new Scanner("E3,456");
        this.s.useLocale(Locale.ENGLISH);
        this.s.useRadix(16);
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt());
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt());
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt());
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt());
        if (Support_Locale.areLocalesAvailable(new Locale("ar", "AE"))) {
            this.s = new Scanner("-123 123- -123-");
            this.s.useLocale(new Locale("ar", "AE"));
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
            try {
                this.s.nextInt();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("-123 123- (123)");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
            try {
                this.s.nextInt();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            ScannerTest.assertEquals((String)"123-", (String)this.s.next());
            ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        }
        this.s.close();
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextByte", args={int.class})
    public void test_nextByteI() throws IOException {
        this.s = new Scanner("123 126");
        ScannerTest.assertEquals((int)123, (int)this.s.nextByte(10));
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte(10));
        try {
            this.s.nextByte(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 126");
        ScannerTest.assertEquals((int)38, (int)this.s.nextByte(5));
        try {
            this.s.nextByte(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1234");
        try {
            this.s.nextByte(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1\u06602 12\u0666");
        ScannerTest.assertEquals((int)102, (int)this.s.nextByte(10));
        try {
            this.s.nextByte(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte(10));
        this.s = new Scanner("012");
        ScannerTest.assertEquals((int)12, (int)this.s.nextByte(10));
        this.s = new Scanner("E");
        ScannerTest.assertEquals((int)14, (int)this.s.nextByte(16));
        this.s = new Scanner("100");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte(10));
        this.s = new Scanner("1\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte(10));
        this.s = new Scanner("1\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte(10));
        this.s.close();
        try {
            this.s.nextByte(10);
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextByte", args={})
    public void test_nextByte() throws IOException {
        this.s = new Scanner("123 126");
        ScannerTest.assertEquals((int)123, (int)this.s.nextByte());
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte());
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 126");
        this.s.useRadix(5);
        ScannerTest.assertEquals((int)38, (int)this.s.nextByte());
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1234");
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1\u06602 12\u0666");
        ScannerTest.assertEquals((int)102, (int)this.s.nextByte());
        this.s.useRadix(5);
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte());
        this.s = new Scanner("012");
        ScannerTest.assertEquals((int)12, (int)this.s.nextByte());
        this.s = new Scanner("E");
        this.s.useRadix(16);
        ScannerTest.assertEquals((int)14, (int)this.s.nextByte());
        this.s = new Scanner("100");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte());
        this.s = new Scanner("1\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte());
        this.s = new Scanner("1\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte());
        this.s.close();
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextFloat", args={})
    public void test_nextFloat() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.ENGLISH, Locale.GERMANY};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 45\u0666. 123.4 .123 ");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)Float.valueOf(123.0f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(456.0f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(123.4f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(0.123f), (Object)Float.valueOf(this.s.nextFloat()));
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4 -456.7 123,456.789 0.1\u06623,4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)Float.valueOf(123.4f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(-456.7f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(123456.79f), (Object)Float.valueOf(this.s.nextFloat()));
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4E10 -456.7e+12 123,456.789E-10");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)Float.valueOf(1.234E12f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(-4.567E14f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(1.2345679E-5f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("NaN Infinity -Infinity");
        ScannerTest.assertEquals((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(this.s.nextFloat()));
        String str = String.valueOf(Float.POSITIVE_INFINITY);
        this.s = new Scanner(str);
        ScannerTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)Float.valueOf(23456.0f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)Float.valueOf(23.456f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("23.456 23.456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)Float.valueOf(23.456f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)Float.valueOf(23456.0f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("23,456.7 23.456,7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)Float.valueOf(23456.7f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)Float.valueOf(23456.7f), (Object)Float.valueOf(this.s.nextFloat()));
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("(123) 123- -123");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertEquals((Object)Float.valueOf(-123.0f), (Object)Float.valueOf(this.s.nextFloat()));
            try {
                this.s.nextFloat();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            ScannerTest.assertEquals((String)"123-", (String)this.s.next());
            ScannerTest.assertEquals((Object)Float.valueOf(-123.0f), (Object)Float.valueOf(this.s.nextFloat()));
        }
        this.s.close();
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextBigInteger", args={int.class})
    public void test_nextBigIntegerI() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((Object)new BigInteger("123"), (Object)this.s.nextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("456"), (Object)this.s.nextBigInteger(10));
        try {
            this.s.nextBigInteger(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((Object)new BigInteger("38"), (Object)this.s.nextBigInteger(5));
        try {
            this.s.nextBigInteger(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23,456 23,456");
            this.s.useLocale(Locale.GERMANY);
            try {
                this.s.nextBigInteger(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            this.s.useLocale(Locale.ENGLISH);
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23'456 23'456");
            this.s.useLocale(Locale.GERMANY);
            try {
                this.s.nextBigInteger(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(new Locale("de", "CH"))) {
            this.s.useLocale(new Locale("de", "CH"));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
        }
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((Object)new BigInteger("102"), (Object)this.s.nextBigInteger(10));
        try {
            this.s.nextBigInteger(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((Object)new BigInteger("162"), (Object)this.s.nextBigInteger(10));
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("23.45\u0666 23.456");
            this.s.useLocale(Locale.CHINESE);
            try {
                this.s.nextBigInteger(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
        }
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextBigInteger(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger(10));
        this.s = new Scanner("E34");
        ScannerTest.assertEquals((Object)new BigInteger("3636"), (Object)this.s.nextBigInteger(16));
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("12300");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger(10));
            this.s = new Scanner("123\u0966\u0966");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger(10));
            this.s = new Scanner("123\u0e50\u0e50");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger(10));
        }
        if (Support_Locale.areLocalesAvailable(new Locale("ar", "AE"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("ar", "AE"));
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger(10));
        }
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger(10));
        }
        this.s.close();
        try {
            this.s.nextBigInteger(10);
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextBigInteger", args={})
    public void test_nextBigInteger() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((Object)new BigInteger("123"), (Object)this.s.nextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("456"), (Object)this.s.nextBigInteger());
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertEquals((Object)new BigInteger("38"), (Object)this.s.nextBigInteger());
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23,456 23,456");
            this.s.useLocale(Locale.GERMANY);
            try {
                this.s.nextBigInteger();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            this.s.useLocale(Locale.ENGLISH);
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23'456 23'456");
            this.s.useLocale(Locale.GERMANY);
            try {
                this.s.nextBigInteger();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(new Locale("de", "CH"))) {
            this.s.useLocale(new Locale("de", "CH"));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
        }
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((Object)new BigInteger("102"), (Object)this.s.nextBigInteger());
        this.s.useRadix(5);
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertEquals((Object)new BigInteger("162"), (Object)this.s.nextBigInteger());
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("23.45\u0666 23.456");
            this.s.useLocale(Locale.CHINESE);
            try {
                this.s.nextBigInteger();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
        }
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("E34");
        this.s.useRadix(16);
        ScannerTest.assertEquals((Object)new BigInteger("3636"), (Object)this.s.nextBigInteger());
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("12300");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger());
            this.s = new Scanner("123\u0966\u0966");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger());
            this.s = new Scanner("123\u0e50\u0e50");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger());
        }
        if (Support_Locale.areLocalesAvailable(new Locale("ar", "AE"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("ar", "AE"));
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger());
        }
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger());
        }
        this.s.close();
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextShort", args={int.class})
    public void test_nextShortI() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.CHINESE, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)123, (int)this.s.nextShort(10));
        ScannerTest.assertEquals((int)456, (int)this.s.nextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)38, (int)this.s.nextShort(5));
        try {
            this.s.nextShort(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789");
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((int)102, (int)this.s.nextShort(10));
        try {
            this.s.nextShort(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)162, (int)this.s.nextShort(10));
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort(10));
        this.s = new Scanner("E34");
        ScannerTest.assertEquals((int)3636, (int)this.s.nextShort(16));
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort(10));
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort(10));
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort(10));
        this.s.close();
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextShort", args={})
    public void test_nextShort() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.CHINESE, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)123, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)456, (int)this.s.nextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertEquals((int)38, (int)this.s.nextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789");
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((int)102, (int)this.s.nextShort());
        this.s.useRadix(5);
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertEquals((int)162, (int)this.s.nextShort());
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort());
        this.s = new Scanner("E34");
        this.s.useRadix(16);
        ScannerTest.assertEquals((int)3636, (int)this.s.nextShort());
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort());
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort());
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort());
        this.s.close();
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextLong", args={int.class})
    public void test_nextLongI() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.CHINESE, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((long)123L, (long)this.s.nextLong(10));
        ScannerTest.assertEquals((long)456L, (long)this.s.nextLong(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((long)38L, (long)this.s.nextLong(5));
        try {
            this.s.nextLong(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((long)102L, (long)this.s.nextLong(10));
        try {
            this.s.nextLong(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((long)162L, (long)this.s.nextLong(10));
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong(10));
        this.s = new Scanner("E34");
        ScannerTest.assertEquals((long)3636L, (long)this.s.nextLong(16));
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong(10));
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong(10));
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong(10));
        this.s.close();
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextLong", args={})
    public void test_nextLong() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.CHINESE, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((long)123L, (long)this.s.nextLong());
        ScannerTest.assertEquals((long)456L, (long)this.s.nextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertEquals((long)38L, (long)this.s.nextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((long)102L, (long)this.s.nextLong());
        this.s.useRadix(5);
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertEquals((long)162L, (long)this.s.nextLong());
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong());
        this.s = new Scanner("E34");
        this.s.useRadix(16);
        ScannerTest.assertEquals((long)3636L, (long)this.s.nextLong());
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong());
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong());
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong());
        this.s.close();
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNext", args={})
    public void test_hasNext() throws IOException {
        this.s = new Scanner("1##2").useDelimiter("\\#");
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        ScannerTest.assertFalse((boolean)this.s.hasNext());
        this.s.close();
        try {
            this.s.hasNext();
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("1( )2( )").useDelimiter("\\( \\)");
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        this.s = new Scanner("1 2  ").useDelimiter("( )");
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertEquals((String)"", (String)this.s.next());
        this.s = new Scanner("1\n2  ");
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        ScannerTest.assertFalse((boolean)this.s.hasNext());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("1'\n'2  ");
        ScannerTest.assertEquals((String)"1'", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertEquals((String)"'2", (String)this.s.next());
        ScannerTest.assertFalse((boolean)this.s.hasNext());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("  ");
        ScannerTest.assertFalse((boolean)this.s.hasNext());
        this.os.write("1 2".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        ScannerTest.assertEquals((String)"1", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNext());
        ScannerTest.assertEquals((String)"2", (String)this.s.next());
        ScannerTest.assertFalse((boolean)this.s.hasNext());
        try {
            this.s.next();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNext", args={Pattern.class})
    public void test_hasNextLPattern() throws IOException {
        this.s = new Scanner("aab@2@abb@").useDelimiter("\\@");
        Pattern pattern = Pattern.compile("a*b");
        ScannerTest.assertTrue((boolean)this.s.hasNext(pattern));
        ScannerTest.assertEquals((String)"aab", (String)this.s.next(pattern));
        ScannerTest.assertFalse((boolean)this.s.hasNext(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word ? ");
        pattern = Pattern.compile("\\w+");
        ScannerTest.assertTrue((boolean)this.s.hasNext(pattern));
        ScannerTest.assertEquals((String)"word", (String)this.s.next(pattern));
        ScannerTest.assertFalse((boolean)this.s.hasNext(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 WorD2  ");
        pattern = Pattern.compile("\\w+");
        ScannerTest.assertTrue((boolean)this.s.hasNext(pattern));
        ScannerTest.assertEquals((String)"word1", (String)this.s.next(pattern));
        ScannerTest.assertTrue((boolean)this.s.hasNext(pattern));
        ScannerTest.assertEquals((String)"WorD2", (String)this.s.next(pattern));
        ScannerTest.assertFalse((boolean)this.s.hasNext(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 WorD2  ");
        pattern = Pattern.compile("\\w+");
        try {
            this.s.hasNext((Pattern)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.hasNext(pattern);
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.os.write("aab b".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        pattern = Pattern.compile("a+b");
        ScannerTest.assertTrue((boolean)this.s.hasNext(pattern));
        ScannerTest.assertEquals((String)"aab", (String)this.s.next(pattern));
        ScannerTest.assertFalse((boolean)this.s.hasNext(pattern));
        try {
            this.s.next(pattern);
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNext", args={String.class})
    public void test_hasNextLString() throws IOException {
        this.s = new Scanner("aab@2@abb@").useDelimiter("\\@");
        try {
            this.s.hasNext((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.s = new Scanner("aab*b*").useDelimiter("\\*");
        ScannerTest.assertTrue((boolean)this.s.hasNext("a+b"));
        ScannerTest.assertEquals((String)"aab", (String)this.s.next("a+b"));
        ScannerTest.assertFalse((boolean)this.s.hasNext("a+b"));
        try {
            this.s.next("a+b");
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.hasNext("a+b");
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("WORD ? ");
        ScannerTest.assertTrue((boolean)this.s.hasNext("\\w+"));
        ScannerTest.assertEquals((String)"WORD", (String)this.s.next("\\w+"));
        ScannerTest.assertFalse((boolean)this.s.hasNext("\\w+"));
        try {
            this.s.next("\\w+");
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 word2  ");
        ScannerTest.assertEquals((String)"word1", (String)this.s.next("\\w+"));
        ScannerTest.assertEquals((String)"word2", (String)this.s.next("\\w+"));
        try {
            this.s.next("\\w+");
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.os.write("aab 2".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        ScannerTest.assertTrue((boolean)this.s.hasNext("a*b"));
        ScannerTest.assertEquals((String)"aab", (String)this.s.next("a*b"));
        ScannerTest.assertFalse((boolean)this.s.hasNext("a*b"));
        try {
            this.s.next("a*b");
            ScannerTest.fail((String)"should throw InputMismatchException");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextBoolean", args={})
    public void test_hasNextBoolean() throws IOException {
        this.s = new Scanner("TRue");
        ScannerTest.assertTrue((boolean)this.s.hasNextBoolean());
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        this.s = new Scanner("tRue false");
        ScannerTest.assertTrue((boolean)this.s.hasNextBoolean());
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        ScannerTest.assertTrue((boolean)this.s.hasNextBoolean());
        ScannerTest.assertFalse((boolean)this.s.nextBoolean());
        this.s = new Scanner("");
        ScannerTest.assertFalse((boolean)this.s.hasNextBoolean());
        this.os.write("true false ".getBytes());
        this.serverSocket.close();
        this.s = new Scanner(this.client);
        ScannerTest.assertTrue((boolean)this.s.hasNextBoolean());
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        this.s = new Scanner("true**false").useDelimiter("\\*");
        ScannerTest.assertTrue((boolean)this.s.hasNextBoolean());
        ScannerTest.assertTrue((boolean)this.s.nextBoolean());
        ScannerTest.assertFalse((boolean)this.s.hasNextBoolean());
        try {
            this.s.nextBoolean();
            ScannerTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("false( )").useDelimiter("\\( \\)");
        ScannerTest.assertTrue((boolean)this.s.hasNextBoolean());
        ScannerTest.assertFalse((boolean)this.s.nextBoolean());
        ScannerTest.assertFalse((boolean)this.s.hasNextBoolean());
        this.s.close();
        try {
            this.s.hasNextBoolean();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="IllegalStateException checking missed.", method="hasNextByte", args={int.class})
    public void test_hasNextByteI() throws IOException {
        this.s = new Scanner("123 126");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)123, (int)this.s.nextByte(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextByte(10));
        try {
            this.s.nextByte(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 126");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(5));
        ScannerTest.assertEquals((int)38, (int)this.s.nextByte(5));
        ScannerTest.assertFalse((boolean)this.s.hasNextByte(5));
        try {
            this.s.nextByte(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1234");
        ScannerTest.assertFalse((boolean)this.s.hasNextByte(10));
        try {
            this.s.nextByte(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1\u06602 12\u0666");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)102, (int)this.s.nextByte(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextByte(5));
        try {
            this.s.nextByte(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte(10));
        this.s = new Scanner("012");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)12, (int)this.s.nextByte(10));
        this.s = new Scanner("E");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(16));
        ScannerTest.assertEquals((int)14, (int)this.s.nextByte(16));
        this.s = new Scanner("100");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte(10));
        this.s = new Scanner("1\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte(10));
        this.s = new Scanner("1\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte(10));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test.", method="hasNextByte", args={int.class})
    public void test_hasNextByteI_cache() throws IOException {
        this.s = new Scanner("123 45");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(8));
        ScannerTest.assertEquals((int)83, (int)this.s.nextByte());
        ScannerTest.assertEquals((int)45, (int)this.s.nextByte());
        this.s = new Scanner("123 45");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(8));
        ScannerTest.assertEquals((int)83, (int)this.s.nextByte());
        ScannerTest.assertEquals((int)45, (int)this.s.nextByte());
        this.s = new Scanner("-123 -45");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte(8));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)-45, (int)this.s.nextByte());
        this.s = new Scanner("123 45");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        this.s.close();
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextByte", args={})
    public void test_hasNextByte() throws IOException {
        this.s = new Scanner("123 126");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)123, (int)this.s.nextByte());
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte());
        ScannerTest.assertFalse((boolean)this.s.hasNextByte());
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 126");
        this.s.useRadix(5);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)38, (int)this.s.nextByte());
        ScannerTest.assertFalse((boolean)this.s.hasNextByte());
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1234");
        ScannerTest.assertFalse((boolean)this.s.hasNextByte());
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("1\u06602 12\u0666");
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)102, (int)this.s.nextByte());
        this.s.useRadix(5);
        ScannerTest.assertFalse((boolean)this.s.hasNextByte());
        try {
            this.s.nextByte();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)126, (int)this.s.nextByte());
        this.s = new Scanner("012");
        ScannerTest.assertEquals((int)12, (int)this.s.nextByte());
        this.s = new Scanner("E");
        this.s.useRadix(16);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)14, (int)this.s.nextByte());
        this.s = new Scanner("100");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte());
        this.s = new Scanner("1\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte());
        this.s = new Scanner("1\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)100, (int)this.s.nextByte());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte());
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertTrue((boolean)this.s.hasNextByte());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextByte());
        this.s.close();
        try {
            this.s.hasNextByte();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="IllegalStateException checking missed.", method="hasNextBigInteger", args={int.class})
    public void test_hasNextBigIntegerI() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("123"), (Object)this.s.nextBigInteger(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("456"), (Object)this.s.nextBigInteger(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(10));
        try {
            this.s.nextBigInteger(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(5));
        ScannerTest.assertEquals((Object)new BigInteger("38"), (Object)this.s.nextBigInteger(5));
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(5));
        try {
            this.s.nextBigInteger(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23,456 23,456");
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(10));
            try {
                this.s.nextBigInteger(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            this.s.useLocale(Locale.ENGLISH);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23'456 23'456");
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(10));
            try {
                this.s.nextBigInteger(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(new Locale("de", "CH"))) {
            this.s.useLocale(new Locale("de", "CH"));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
        }
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("102"), (Object)this.s.nextBigInteger(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(5));
        try {
            this.s.nextBigInteger(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("162"), (Object)this.s.nextBigInteger(10));
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("23.45\u0666 23.456");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(10));
            try {
                this.s.nextBigInteger(10);
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger(10));
        }
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger(10));
        try {
            this.s.nextBigInteger(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger(10));
        this.s = new Scanner("E34");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(16));
        ScannerTest.assertEquals((Object)new BigInteger("3636"), (Object)this.s.nextBigInteger(16));
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("12300");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger(10));
            this.s = new Scanner("123\u0966\u0966");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger(10));
            this.s = new Scanner("123\u0e50\u0e50");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger(10));
        }
        if (Support_Locale.areLocalesAvailable(new Locale("ar", "AE"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("ar", "AE"));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger(10));
        }
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger(10));
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test.", method="hasNextBigInteger", args={int.class})
    public void test_hasNextBigIntegerI_cache() throws IOException {
        this.s = new Scanner("123 123456789123456789");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(16));
        ScannerTest.assertEquals((Object)new BigInteger("291"), (Object)this.s.nextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("123456789123456789"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("123456789123456789 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(16));
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(10));
        ScannerTest.assertEquals((Object)new BigInteger("123456789123456789"), (Object)this.s.nextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("456"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("-123 -123456789123456789");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger(8));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort());
        ScannerTest.assertEquals((Object)new BigInteger("-123456789123456789"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        this.s.close();
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextBigInteger", args={})
    public void test_hasNextBigInteger() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("123"), (Object)this.s.nextBigInteger());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("456"), (Object)this.s.nextBigInteger());
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("38"), (Object)this.s.nextBigInteger());
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23,456 23,456");
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
            try {
                this.s.nextBigInteger();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
            this.s.useLocale(Locale.ENGLISH);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s = new Scanner("23'456 23'456");
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
            try {
                this.s.nextBigInteger();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(new Locale("de", "CH"))) {
            this.s.useLocale(new Locale("de", "CH"));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
        }
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((Object)new BigInteger("102"), (Object)this.s.nextBigInteger());
        this.s.useRadix(5);
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("162"), (Object)this.s.nextBigInteger());
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("23.45\u0666 23.456");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
            try {
                this.s.nextBigInteger();
                ScannerTest.fail((String)"Should throw InputMismatchException");
            }
            catch (InputMismatchException e) {
                // empty catch block
            }
        }
        if (Support_Locale.areLocalesAvailable(Locale.GERMANY)) {
            this.s.useLocale(Locale.GERMANY);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("23456"), (Object)this.s.nextBigInteger());
        }
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextBigInteger());
        try {
            this.s.nextBigInteger();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("3456"), (Object)this.s.nextBigInteger());
        this.s = new Scanner("E34");
        this.s.useRadix(16);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
        ScannerTest.assertEquals((Object)new BigInteger("3636"), (Object)this.s.nextBigInteger());
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            this.s = new Scanner("12300");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger());
            this.s = new Scanner("123\u0966\u0966");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger());
            this.s = new Scanner("123\u0e50\u0e50");
            this.s.useLocale(Locale.CHINESE);
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("12300"), (Object)this.s.nextBigInteger());
        }
        if (Support_Locale.areLocalesAvailable(new Locale("ar", "AE"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("ar", "AE"));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger());
        }
        if (Support_Locale.areLocalesAvailable(new Locale("mk", "MK"))) {
            this.s = new Scanner("-123");
            this.s.useLocale(new Locale("mk", "MK"));
            ScannerTest.assertTrue((boolean)this.s.hasNextBigInteger());
            ScannerTest.assertEquals((Object)new BigInteger("-123"), (Object)this.s.nextBigInteger());
        }
        this.s.close();
        try {
            this.s.hasNextBigInteger();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="IllegalStateException checking missed.", method="hasNextInt", args={int.class})
    public void test_hasNextIntI() throws IOException {
        Locale mkLocale = new Locale("mk", "MK");
        Locale arLocale = new Locale("ar", "AE");
        Locale deLocale = new Locale("de", "CH");
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE, mkLocale, arLocale, deLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertEquals((int)123, (int)this.s.nextInt(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)456, (int)this.s.nextInt(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(5));
        ScannerTest.assertEquals((int)38, (int)this.s.nextInt(5));
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(5));
        try {
            this.s.nextInt(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        this.s = new Scanner("23,456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        this.s = new Scanner("23'456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        this.s.useLocale(deLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        this.s = new Scanner("1\u06662");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(5));
        this.s = new Scanner("23.45\u0666");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt(10));
        this.s = new Scanner("E3456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(16));
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt(16));
        this.s = new Scanner("E3,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(16));
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt(16));
        try {
            this.s.hasNextInt(1);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt(10));
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt(10));
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt(10));
        this.s = new Scanner("-123 123- -123-");
        this.s.useLocale(arLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        try {
            this.s.nextInt(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("-123 123- (123)");
        this.s.useLocale(mkLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextInt(10));
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"123-", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt(10));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test", method="hasNextInt", args={int.class})
    public void test_hasNextIntI_cache() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(16));
        ScannerTest.assertEquals((int)291, (int)this.s.nextInt(10));
        ScannerTest.assertEquals((int)456, (int)this.s.nextInt());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(16));
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(8));
        ScannerTest.assertEquals((int)83, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)456, (int)this.s.nextInt());
        this.s = new Scanner("-123 -456 -789");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(8));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)-456, (int)this.s.nextInt());
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(16));
        ScannerTest.assertEquals((int)-789, (int)this.s.nextInt());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        this.s.close();
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextInt", args={})
    public void test_hasNextInt() throws IOException {
        Locale mkLocale = new Locale("mk", "MK");
        Locale arLocale = new Locale("ar", "AE");
        Locale deLocale = new Locale("de", "CH");
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE, mkLocale, arLocale, deLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)123, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)456, (int)this.s.nextInt());
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)38, (int)this.s.nextInt());
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        this.s = new Scanner("23,456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        this.s = new Scanner("23'456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        this.s.useLocale(deLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        this.s = new Scanner("1\u06662");
        this.s.useRadix(5);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        this.s = new Scanner("23.45\u0666");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((int)3456, (int)this.s.nextInt());
        this.s = new Scanner("E3456");
        this.s.useRadix(16);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt());
        this.s = new Scanner("E3,456");
        this.s.useLocale(Locale.ENGLISH);
        this.s.useRadix(16);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)930902, (int)this.s.nextInt());
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt());
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt());
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)12300, (int)this.s.nextInt());
        this.s = new Scanner("-123 123- -123-");
        this.s.useLocale(arLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        ScannerTest.assertFalse((boolean)this.s.hasNextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("-123 123- (123)");
        this.s.useLocale(mkLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        try {
            this.s.nextInt();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"123-", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNextInt());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        this.s.close();
        try {
            this.s.hasNextInt();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextFloat", args={})
    public void test_hasNextFloat() throws IOException {
        Locale mkLocale = new Locale("mk", "MK");
        Locale arLocale = new Locale("ar", "AE");
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, mkLocale, arLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 45\u0666. 123.4 .123 ");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(123.0f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(456.0f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(123.4f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(0.123f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertFalse((boolean)this.s.hasNextFloat());
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4 -456.7 123,456.789 0.1\u06623,4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(123.4f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(-456.7f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(123456.79f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertFalse((boolean)this.s.hasNextFloat());
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4E10 -456.7e+12 123,456.789E-10");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(1.234E12f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(-4.567E14f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(1.2345679E-5f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("NaN Infinity -Infinity");
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(this.s.nextFloat()));
        String str = String.valueOf(Float.POSITIVE_INFINITY);
        this.s = new Scanner(str);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(23456.0f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(23.456f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("23.456 23.456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(23.456f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(23456.0f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("23,456.7 23.456,7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(23456.7f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(23456.7f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("-123.4 123.4- -123.4-");
        this.s.useLocale(arLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(-123.4f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(-123.4f), (Object)Float.valueOf(this.s.nextFloat()));
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("(123) 123- -123");
        this.s.useLocale(mkLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(-123.0f), (Object)Float.valueOf(this.s.nextFloat()));
        ScannerTest.assertFalse((boolean)this.s.hasNextFloat());
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"123-", (String)this.s.next());
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        ScannerTest.assertEquals((Object)Float.valueOf(-123.0f), (Object)Float.valueOf(this.s.nextFloat()));
        this.s = new Scanner("+123.4 -456.7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextFloat());
        this.s.close();
        try {
            this.s.nextFloat();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="IllegalStateException checking missed.", method="hasNextShort", args={int.class})
    public void test_hasNextShortI() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)123, (int)this.s.nextShort(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)456, (int)this.s.nextShort(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(5));
        ScannerTest.assertEquals((int)38, (int)this.s.nextShort(5));
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(5));
        try {
            this.s.nextShort(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789");
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextInt(10));
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)102, (int)this.s.nextShort(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(5));
        try {
            this.s.nextShort(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)162, (int)this.s.nextShort(10));
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort(10));
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextShort(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort(10));
        this.s = new Scanner("E34");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(16));
        ScannerTest.assertEquals((int)3636, (int)this.s.nextShort(16));
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort(10));
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort(10));
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(10));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort(10));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextShort", args={})
    public void test_hasNextShort() throws IOException {
        Locale deLocale = new Locale("de", "CH");
        Locale arLocale = new Locale("ar", "AE");
        Locale mkLocale = new Locale("mk", "MK");
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE, deLocale, arLocale, mkLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)123, (int)this.s.nextShort());
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)456, (int)this.s.nextShort());
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)38, (int)this.s.nextShort());
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789");
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(deLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((int)102, (int)this.s.nextShort());
        this.s.useRadix(5);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)162, (int)this.s.nextShort());
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)23456, (int)this.s.nextShort());
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort());
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)3456, (int)this.s.nextShort());
        this.s = new Scanner("E34");
        this.s.useRadix(16);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)3636, (int)this.s.nextShort());
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort());
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort());
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)12300, (int)this.s.nextShort());
        this.s = new Scanner("-123");
        this.s.useLocale(arLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort());
        this.s = new Scanner("-123");
        this.s.useLocale(mkLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        ScannerTest.assertEquals((int)-123, (int)this.s.nextShort());
        this.s.close();
        try {
            this.s.hasNextShort();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test.", method="hasNextShort", args={int.class})
    public void test_hasNextShortI_cache() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(16));
        ScannerTest.assertEquals((int)291, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)456, (int)this.s.nextShort());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(16));
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(8));
        ScannerTest.assertEquals((int)83, (int)this.s.nextShort());
        ScannerTest.assertEquals((int)456, (int)this.s.nextShort());
        this.s = new Scanner("-123 -456 -789");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(8));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        ScannerTest.assertEquals((int)-456, (int)this.s.nextShort());
        ScannerTest.assertTrue((boolean)this.s.hasNextInt(16));
        ScannerTest.assertEquals((int)-789, (int)this.s.nextShort());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextShort());
        this.s.close();
        try {
            this.s.nextShort();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="IllegalStateException checking missed.", method="hasNextLong", args={int.class})
    public void test_hasNextLongI() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)123L, (long)this.s.nextLong(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)456L, (long)this.s.nextLong(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(5));
        ScannerTest.assertEquals((long)38L, (long)this.s.nextLong(5));
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(5));
        try {
            this.s.nextLong(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextShort(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(new Locale("de", "CH"));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)102L, (long)this.s.nextLong(10));
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(5));
        try {
            this.s.nextLong(5);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)162L, (long)this.s.nextLong(10));
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong(10));
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong(10));
        try {
            this.s.nextLong(10);
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong(10));
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong(10));
        this.s = new Scanner("E34");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(16));
        ScannerTest.assertEquals((long)3636L, (long)this.s.nextLong(16));
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong(10));
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong(10));
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("ar", "AE"));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong(10));
        this.s = new Scanner("-123");
        this.s.useLocale(new Locale("mk", "MK"));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(10));
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong(10));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test.", method="hasNextLong", args={int.class})
    public void test_hasNextLongI_cache() throws IOException {
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(16));
        ScannerTest.assertEquals((long)291L, (long)this.s.nextLong());
        ScannerTest.assertEquals((long)456L, (long)this.s.nextLong());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(16));
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(8));
        ScannerTest.assertEquals((long)83L, (long)this.s.nextLong());
        ScannerTest.assertEquals((long)456L, (long)this.s.nextLong());
        this.s = new Scanner("-123 -456 -789");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong(8));
        ScannerTest.assertEquals((int)-123, (int)this.s.nextInt());
        ScannerTest.assertEquals((long)-456L, (long)this.s.nextLong());
        ScannerTest.assertTrue((boolean)this.s.hasNextShort(16));
        ScannerTest.assertEquals((long)-789L, (long)this.s.nextLong());
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        this.s.close();
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextLong", args={})
    public void test_hasNextLong() throws IOException {
        Locale deLocale = new Locale("de", "CH");
        Locale arLocale = new Locale("ar", "AE");
        Locale mkLocale = new Locale("mk", "MK");
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.CHINESE, deLocale, arLocale, mkLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)123L, (long)this.s.nextLong());
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)456L, (long)this.s.nextLong());
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("123 456");
        this.s.useRadix(5);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)38L, (long)this.s.nextLong());
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("123456789123456789123456789123456789");
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        this.s = new Scanner("23'456 23'456");
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(deLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        this.s = new Scanner("1\u06602 1\u06662");
        ScannerTest.assertEquals((long)102L, (long)this.s.nextLong());
        this.s.useRadix(5);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useRadix(10);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)162L, (long)this.s.nextLong());
        this.s = new Scanner("23.45\u0666 23.456");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)23456L, (long)this.s.nextLong());
        this.s = new Scanner("03,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertFalse((boolean)this.s.hasNextLong());
        try {
            this.s.nextLong();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("03456");
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong());
        this.s = new Scanner("\u06603,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)3456L, (long)this.s.nextLong());
        this.s = new Scanner("E34");
        this.s.useRadix(16);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)3636L, (long)this.s.nextLong());
        this.s = new Scanner("12300");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong());
        this.s = new Scanner("123\u0966\u0966");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong());
        this.s = new Scanner("123\u0e50\u0e50");
        this.s.useLocale(Locale.CHINESE);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)12300L, (long)this.s.nextLong());
        this.s = new Scanner("-123");
        this.s.useLocale(arLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong());
        this.s = new Scanner("-123");
        this.s.useLocale(mkLocale);
        ScannerTest.assertTrue((boolean)this.s.hasNextLong());
        ScannerTest.assertEquals((long)-123L, (long)this.s.nextLong());
        this.s.close();
        try {
            this.s.hasNextLong();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextDouble", args={})
    public void test_hasNextDouble() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 45\u0666. 123.4 .123 ");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)123.0, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)456.0, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)123.4, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)0.123, (Object)this.s.nextDouble());
        ScannerTest.assertFalse((boolean)this.s.hasNextDouble());
        try {
            this.s.nextDouble();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4 -456.7 123,456.789 0.1\u06623,4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)123.4, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)-456.7, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)123456.789, (Object)this.s.nextDouble());
        ScannerTest.assertFalse((boolean)this.s.hasNextDouble());
        try {
            this.s.nextDouble();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4E10 -456.7e+12 123,456.789E-10");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)1.234E12, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)-4.567E14, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)1.23456789E-5, (Object)this.s.nextDouble());
        this.s = new Scanner("NaN Infinity -Infinity");
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)Double.NaN, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.s.nextDouble());
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)this.s.nextDouble());
        String str = String.valueOf(Double.POSITIVE_INFINITY);
        this.s = new Scanner(str);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.s.nextDouble());
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)23456.0, (Object)this.s.nextDouble());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)23.456, (Object)this.s.nextDouble());
        this.s = new Scanner("23.456 23.456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)23.456, (Object)this.s.nextDouble());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)23456.0, (Object)this.s.nextDouble());
        this.s = new Scanner("23,456.7 23.456,7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)23456.7, (Object)this.s.nextDouble());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)23456.7, (Object)this.s.nextDouble());
        this.s = new Scanner("-123.4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        ScannerTest.assertEquals((Object)-123.4, (Object)this.s.nextDouble());
        this.s = new Scanner("+123.4 -456.7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextDouble());
        this.s.close();
        try {
            this.s.nextDouble();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextBigDecimal", args={})
    public void test_hasNextBigDecimal() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 45\u0666. 123.4 .123 ");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("123"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("456"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("123.4"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("0.123"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertFalse((boolean)this.s.hasNextBigDecimal());
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4 -456.7 123,456.789 0.1\u06623,4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("123.4"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("-456.7"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("123456.789"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertFalse((boolean)this.s.hasNextBigDecimal());
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4E10 -456.7e+12 123,456.789E-10");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("1.234E12"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("-4.567E14"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("1.23456789E-5"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("NaN");
        ScannerTest.assertFalse((boolean)this.s.hasNextBigDecimal());
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("23456"), (Object)this.s.nextBigDecimal());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("23.456"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("23.456 23.456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("23.456"), (Object)this.s.nextBigDecimal());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("23456"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("23,456.7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("23456.7"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("-123.4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertTrue((boolean)this.s.hasNextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("-123.4"), (Object)this.s.nextBigDecimal());
        this.s.close();
        try {
            this.s.hasNextBigDecimal();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="findWithinHorizon", args={Pattern.class, int.class})
    public void test_findWithinHorizon_LPatternI() {
        int i;
        this.s = new Scanner("123test");
        String result = this.s.findWithinHorizon(Pattern.compile("\\p{Lower}"), 5);
        ScannerTest.assertEquals((String)"t", (String)result);
        MatchResult mresult = this.s.match();
        ScannerTest.assertEquals((int)3, (int)mresult.start());
        ScannerTest.assertEquals((int)4, (int)mresult.end());
        this.s = new Scanner("12345test1234test next");
        result = this.s.findWithinHorizon(Pattern.compile("\\p{Digit}+"), 2);
        ScannerTest.assertEquals((String)"12", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)mresult.start());
        ScannerTest.assertEquals((int)2, (int)mresult.end());
        result = this.s.findWithinHorizon(Pattern.compile("\\p{Digit}+"), 6);
        ScannerTest.assertEquals((String)"345", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)2, (int)mresult.start());
        ScannerTest.assertEquals((int)5, (int)mresult.end());
        result = this.s.findWithinHorizon(Pattern.compile("\\p{Digit}+"), 3);
        ScannerTest.assertNull((Object)result);
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"345", (String)mresult.group());
        ScannerTest.assertEquals((int)2, (int)mresult.start());
        ScannerTest.assertEquals((int)5, (int)mresult.end());
        result = this.s.findWithinHorizon(Pattern.compile("\\p{Digit}+"), 0);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)9, (int)mresult.start());
        ScannerTest.assertEquals((int)13, (int)mresult.end());
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        mresult = this.s.match();
        ScannerTest.assertEquals((int)13, (int)mresult.start());
        ScannerTest.assertEquals((int)17, (int)mresult.end());
        ScannerTest.assertEquals((String)"next", (String)this.s.next());
        mresult = this.s.match();
        ScannerTest.assertEquals((int)18, (int)mresult.start());
        ScannerTest.assertEquals((int)22, (int)mresult.end());
        try {
            this.s.findWithinHorizon((Pattern)null, -1);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s.findWithinHorizon(Pattern.compile("\\p{Digit}+"), -1);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.findWithinHorizon((Pattern)null, -1);
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("test");
        result = this.s.findWithinHorizon(Pattern.compile("\\w+"), 10);
        ScannerTest.assertEquals((String)"test", (String)result);
        this.s = new Scanner("aa\n\rb");
        String patternStr = "^(a)$";
        result = this.s.findWithinHorizon(Pattern.compile("a"), 5);
        ScannerTest.assertEquals((String)"a", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)mresult.start());
        ScannerTest.assertEquals((int)1, (int)mresult.end());
        result = this.s.findWithinHorizon(Pattern.compile(patternStr, 8), 5);
        ScannerTest.assertNull((Object)result);
        try {
            mresult = this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("");
        result = this.s.findWithinHorizon(Pattern.compile("^"), 0);
        ScannerTest.assertEquals((String)"", (String)result);
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        result = this.s.findWithinHorizon(Pattern.compile("$"), 0);
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        this.s = new Scanner("1 fish 2 fish red fish blue fish");
        result = this.s.findWithinHorizon(Pattern.compile("(\\d+) fish (\\d+) fish (\\w+) fish (\\w+)"), 10);
        ScannerTest.assertNull((Object)result);
        try {
            mresult = this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)0, (int)mresult.groupCount());
        result = this.s.findWithinHorizon(Pattern.compile("(\\d+) fish (\\d+) fish (\\w+) fish (\\w+)"), 100);
        ScannerTest.assertEquals((String)"1 fish 2 fish red fish blue", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)4, (int)mresult.groupCount());
        ScannerTest.assertEquals((String)"1", (String)mresult.group(1));
        ScannerTest.assertEquals((String)"2", (String)mresult.group(2));
        ScannerTest.assertEquals((String)"red", (String)mresult.group(3));
        ScannerTest.assertEquals((String)"blue", (String)mresult.group(4));
        this.s = new Scanner("test");
        this.s.close();
        try {
            this.s.findWithinHorizon(Pattern.compile("test"), 1);
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 WorD2  ");
        this.s.close();
        try {
            this.s.findWithinHorizon(Pattern.compile("\\d+"), 10);
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 WorD2 wOrd3 ");
        Pattern pattern = Pattern.compile("\\d+");
        ScannerTest.assertEquals((String)"1", (String)this.s.findWithinHorizon(pattern, 10));
        ScannerTest.assertEquals((String)"WorD2", (String)this.s.next());
        ScannerTest.assertEquals((String)"3", (String)this.s.findWithinHorizon(pattern, 15));
        this.s = new Scanner(new MockStringReader("MockStringReader"));
        pattern = Pattern.compile("test");
        result = this.s.findWithinHorizon(pattern, 10);
        ScannerTest.assertEquals((String)"test", (String)result);
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < 1026; ++i) {
            stringBuilder.append('a');
        }
        this.s = new Scanner(stringBuilder.toString());
        pattern = Pattern.compile("\\p{Lower}+");
        result = this.s.findWithinHorizon(pattern, 1026);
        ScannerTest.assertEquals((String)stringBuilder.toString(), (String)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 1026; ++i) {
            stringBuilder.append('a');
        }
        this.s = new Scanner(stringBuilder.toString());
        pattern = Pattern.compile("\\p{Lower}+");
        result = this.s.findWithinHorizon(pattern, 1022);
        ScannerTest.assertEquals((int)1022, (int)result.length());
        ScannerTest.assertEquals((Object)stringBuilder.subSequence(0, 1022), (Object)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 1022; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("bbc");
        ScannerTest.assertEquals((int)1025, (int)stringBuilder.length());
        this.s = new Scanner(stringBuilder.toString());
        pattern = Pattern.compile("bbc");
        result = this.s.findWithinHorizon(pattern, 1025);
        ScannerTest.assertEquals((int)3, (int)result.length());
        ScannerTest.assertEquals((Object)stringBuilder.subSequence(1022, 1025), (Object)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 1026; ++i) {
            stringBuilder.append('a');
        }
        this.s = new Scanner(stringBuilder.toString());
        pattern = Pattern.compile("\\p{Lower}+");
        result = this.s.findWithinHorizon(pattern, 0);
        ScannerTest.assertEquals((String)stringBuilder.toString(), (String)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 10240; ++i) {
            stringBuilder.append('-');
        }
        stringBuilder.replace(0, 2, "aa");
        this.s = new Scanner(stringBuilder.toString());
        result = this.s.findWithinHorizon(Pattern.compile("aa"), 0);
        ScannerTest.assertEquals((String)"aa", (String)result);
        this.s = new Scanner("aaaa");
        result = this.s.findWithinHorizon(Pattern.compile("a*"), 0);
        ScannerTest.assertEquals((String)"aaaa", (String)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="findWithinHorizon", args={String.class, int.class})
    public void test_findWithinHorizon_Ljava_lang_StringI() {
        int i;
        this.s = new Scanner("123test");
        String result = this.s.findWithinHorizon("\\p{Lower}", 5);
        ScannerTest.assertEquals((String)"t", (String)result);
        MatchResult mresult = this.s.match();
        ScannerTest.assertEquals((int)3, (int)mresult.start());
        ScannerTest.assertEquals((int)4, (int)mresult.end());
        this.s = new Scanner("12345test1234test next");
        result = this.s.findWithinHorizon("\\p{Digit}+", 2);
        ScannerTest.assertEquals((String)"12", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)mresult.start());
        ScannerTest.assertEquals((int)2, (int)mresult.end());
        result = this.s.findWithinHorizon("\\p{Digit}+", 6);
        ScannerTest.assertEquals((String)"345", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)2, (int)mresult.start());
        ScannerTest.assertEquals((int)5, (int)mresult.end());
        result = this.s.findWithinHorizon("\\p{Digit}+", 3);
        ScannerTest.assertNull((Object)result);
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"345", (String)mresult.group());
        ScannerTest.assertEquals((int)2, (int)mresult.start());
        ScannerTest.assertEquals((int)5, (int)mresult.end());
        result = this.s.findWithinHorizon("\\p{Digit}+", 0);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)9, (int)mresult.start());
        ScannerTest.assertEquals((int)13, (int)mresult.end());
        ScannerTest.assertEquals((String)"test", (String)this.s.next());
        mresult = this.s.match();
        ScannerTest.assertEquals((int)13, (int)mresult.start());
        ScannerTest.assertEquals((int)17, (int)mresult.end());
        ScannerTest.assertEquals((String)"next", (String)this.s.next());
        mresult = this.s.match();
        ScannerTest.assertEquals((int)18, (int)mresult.start());
        ScannerTest.assertEquals((int)22, (int)mresult.end());
        try {
            this.s.findWithinHorizon((String)null, 1);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s.findWithinHorizon("\\p{Digit}+", -1);
            ScannerTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.s.close();
        this.s = new Scanner("test");
        result = this.s.findWithinHorizon("\\w+", 10);
        ScannerTest.assertEquals((String)"test", (String)result);
        this.s = new Scanner("aa\n\rb");
        String patternStr = "^(a)$";
        result = this.s.findWithinHorizon("a", 5);
        ScannerTest.assertEquals((String)"a", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)mresult.start());
        ScannerTest.assertEquals((int)1, (int)mresult.end());
        result = this.s.findWithinHorizon(patternStr, 5);
        ScannerTest.assertNull((Object)result);
        try {
            mresult = this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("");
        result = this.s.findWithinHorizon("^", 0);
        ScannerTest.assertEquals((String)"", (String)result);
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        result = this.s.findWithinHorizon("$", 0);
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        this.s = new Scanner("1 fish 2 fish red fish blue fish");
        result = this.s.findWithinHorizon("(\\d+) fish (\\d+) fish (\\w+) fish (\\w+)", 10);
        ScannerTest.assertNull((Object)result);
        try {
            mresult = this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)0, (int)mresult.groupCount());
        result = this.s.findWithinHorizon("(\\d+) fish (\\d+) fish (\\w+) fish (\\w+)", 100);
        ScannerTest.assertEquals((String)"1 fish 2 fish red fish blue", (String)result);
        mresult = this.s.match();
        ScannerTest.assertEquals((int)4, (int)mresult.groupCount());
        ScannerTest.assertEquals((String)"1", (String)mresult.group(1));
        ScannerTest.assertEquals((String)"2", (String)mresult.group(2));
        ScannerTest.assertEquals((String)"red", (String)mresult.group(3));
        ScannerTest.assertEquals((String)"blue", (String)mresult.group(4));
        this.s = new Scanner("test");
        this.s.close();
        try {
            this.s.findWithinHorizon("test", 1);
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 WorD2  ");
        this.s.close();
        try {
            this.s.findWithinHorizon("\\d+", 10);
            ScannerTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("word1 WorD2 wOrd3 ");
        patternStr = "\\d+";
        ScannerTest.assertEquals((String)"1", (String)this.s.findWithinHorizon(patternStr, 10));
        ScannerTest.assertEquals((String)"WorD2", (String)this.s.next());
        ScannerTest.assertEquals((String)"3", (String)this.s.findWithinHorizon(patternStr, 15));
        this.s = new Scanner(new MockStringReader("MockStringReader"));
        patternStr = "test";
        result = this.s.findWithinHorizon(patternStr, 10);
        ScannerTest.assertEquals((String)"test", (String)result);
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < 1026; ++i) {
            stringBuilder.append('a');
        }
        this.s = new Scanner(stringBuilder.toString());
        patternStr = "\\p{Lower}+";
        result = this.s.findWithinHorizon(patternStr, 1026);
        ScannerTest.assertEquals((String)stringBuilder.toString(), (String)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 1026; ++i) {
            stringBuilder.append('a');
        }
        this.s = new Scanner(stringBuilder.toString());
        patternStr = "\\p{Lower}+";
        result = this.s.findWithinHorizon(patternStr, 1022);
        ScannerTest.assertEquals((int)1022, (int)result.length());
        ScannerTest.assertEquals((Object)stringBuilder.subSequence(0, 1022), (Object)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 1022; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("bbc");
        ScannerTest.assertEquals((int)1025, (int)stringBuilder.length());
        this.s = new Scanner(stringBuilder.toString());
        patternStr = "bbc";
        result = this.s.findWithinHorizon(patternStr, 1025);
        ScannerTest.assertEquals((int)3, (int)result.length());
        ScannerTest.assertEquals((Object)stringBuilder.subSequence(1022, 1025), (Object)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 1026; ++i) {
            stringBuilder.append('a');
        }
        this.s = new Scanner(stringBuilder.toString());
        patternStr = "\\p{Lower}+";
        result = this.s.findWithinHorizon(patternStr, 0);
        ScannerTest.assertEquals((String)stringBuilder.toString(), (String)result);
        stringBuilder = new StringBuilder();
        for (i = 0; i < 10240; ++i) {
            stringBuilder.append('-');
        }
        stringBuilder.replace(0, 2, "aa");
        this.s = new Scanner(stringBuilder.toString());
        result = this.s.findWithinHorizon("aa", 0);
        ScannerTest.assertEquals((String)"aa", (String)result);
        this.s = new Scanner("aaaa");
        result = this.s.findWithinHorizon("a*", 0);
        ScannerTest.assertEquals((String)"aaaa", (String)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="findInLine", args={Pattern.class})
    public void test_findInLine_LPattern() {
        Scanner s = new Scanner("");
        try {
            s.findInLine((Pattern)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String result = s.findInLine(Pattern.compile("^"));
        ScannerTest.assertEquals((String)"", (String)result);
        MatchResult matchResult = s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        result = s.findInLine(Pattern.compile("$"));
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        s = new Scanner("aa\nb.b");
        result = s.findInLine(Pattern.compile("a\nb*"));
        ScannerTest.assertNull((Object)result);
        s = new Scanner("aa\nbb.b");
        result = s.findInLine(Pattern.compile("\\."));
        ScannerTest.assertNull((Object)result);
        s = new Scanner("abcd1234test\n");
        result = s.findInLine(Pattern.compile("\\p{Lower}+"));
        ScannerTest.assertEquals((String)"abcd", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        result = s.findInLine(Pattern.compile("\\p{Digit}{5}"));
        ScannerTest.assertNull((Object)result);
        try {
            matchResult = s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        result = s.findInLine(Pattern.compile("\\p{Lower}+"));
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)8, (int)matchResult.start());
        ScannerTest.assertEquals((int)12, (int)matchResult.end());
        char[] chars = new char[2048];
        Arrays.fill(chars, 'a');
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        stringBuilder.append("1234");
        s = new Scanner(stringBuilder.toString());
        result = s.findInLine(Pattern.compile("\\p{Digit}+"));
        ScannerTest.assertEquals((String)"1234", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)2048, (int)matchResult.start());
        ScannerTest.assertEquals((int)2052, (int)matchResult.end());
        s = new Scanner("test");
        s.close();
        try {
            s.findInLine((Pattern)null);
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        s = new Scanner("test1234\n1234 test");
        result = s.findInLine(Pattern.compile("test"));
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        int number = s.nextInt();
        ScannerTest.assertEquals((int)1234, (int)number);
        matchResult = s.match();
        ScannerTest.assertEquals((int)4, (int)matchResult.start());
        ScannerTest.assertEquals((int)8, (int)matchResult.end());
        result = s.next();
        ScannerTest.assertEquals((String)"1234", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)9, (int)matchResult.start());
        ScannerTest.assertEquals((int)13, (int)matchResult.end());
        result = s.findInLine(Pattern.compile("test"));
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = s.match();
        ScannerTest.assertEquals((int)14, (int)matchResult.start());
        ScannerTest.assertEquals((int)18, (int)matchResult.end());
        s = new Scanner("test\u0085\ntest");
        result = s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        result = s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        s = new Scanner("test\ntest");
        result = s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        result = s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        s = new Scanner("test\n123\ntest");
        result = s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        result = s.findInLine("est");
        ScannerTest.assertNull((Object)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="findInLine", args={String.class})
    public void test_findInLine_LString() {
        this.s = new Scanner("test");
        try {
            this.s.findInLine((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.s.close();
        try {
            this.s.findInLine((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.s.findInLine("test");
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("");
        String result = this.s.findInLine("^");
        ScannerTest.assertEquals((String)"", (String)result);
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        result = this.s.findInLine("$");
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)0, (int)matchResult.end());
        this.s = new Scanner("aa\nb.b");
        result = this.s.findInLine("a\nb*");
        ScannerTest.assertNull((Object)result);
        this.s = new Scanner("aa\nbb.b");
        result = this.s.findInLine("\\.");
        ScannerTest.assertNull((Object)result);
        this.s = new Scanner("abcd1234test\n");
        result = this.s.findInLine("\\p{Lower}+");
        ScannerTest.assertEquals((String)"abcd", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        result = this.s.findInLine("\\p{Digit}{5}");
        ScannerTest.assertNull((Object)result);
        try {
            matchResult = this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        result = this.s.findInLine("\\p{Lower}+");
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)8, (int)matchResult.start());
        ScannerTest.assertEquals((int)12, (int)matchResult.end());
        char[] chars = new char[2048];
        Arrays.fill(chars, 'a');
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        stringBuilder.append("1234");
        this.s = new Scanner(stringBuilder.toString());
        result = this.s.findInLine("\\p{Digit}+");
        ScannerTest.assertEquals((String)"1234", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)2048, (int)matchResult.start());
        ScannerTest.assertEquals((int)2052, (int)matchResult.end());
        this.s = new Scanner("test1234\n1234 test");
        result = this.s.findInLine("test");
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        int number = this.s.nextInt();
        ScannerTest.assertEquals((int)1234, (int)number);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)4, (int)matchResult.start());
        ScannerTest.assertEquals((int)8, (int)matchResult.end());
        result = this.s.next();
        ScannerTest.assertEquals((String)"1234", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)9, (int)matchResult.start());
        ScannerTest.assertEquals((int)13, (int)matchResult.end());
        result = this.s.findInLine("test");
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)14, (int)matchResult.start());
        ScannerTest.assertEquals((int)18, (int)matchResult.end());
        this.s = new Scanner("test\u0085\ntest");
        result = this.s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        result = this.s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        this.s = new Scanner("test\ntest");
        result = this.s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        result = this.s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        this.s = new Scanner("test\n123\ntest");
        result = this.s.findInLine("est");
        ScannerTest.assertEquals((String)"est", (String)result);
        result = this.s.findInLine("est");
        ScannerTest.assertNull((Object)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="skip", args={Pattern.class})
    public void test_skip_LPattern() {
        this.s = new Scanner("test");
        try {
            this.s.skip((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.s = new Scanner("1234");
        try {
            this.s.skip(Pattern.compile("\\p{Lower}"));
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s.skip(Pattern.compile("\\p{Digit}"));
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s.skip(Pattern.compile("\\p{Digit}+"));
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)1, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        this.s.close();
        try {
            this.s.skip(Pattern.compile("test"));
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        MockStringReader2Read reader = new MockStringReader2Read("test");
        this.s = new Scanner(reader);
        try {
            this.s.skip(Pattern.compile("\\p{Digit}{4}"));
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s.skip(Pattern.compile("\\p{Digit}{3}\\p{Lower}"));
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        this.s.close();
        try {
            this.s.skip((Pattern)null);
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = new char[1024];
        Arrays.fill(chars, 'a');
        stringBuilder.append(chars);
        stringBuilder.append('3');
        this.s = new Scanner(stringBuilder.toString());
        this.s.skip(Pattern.compile("\\p{Lower}+\\p{Digit}"));
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1025, (int)matchResult.end());
        chars = new char[102400];
        Arrays.fill(chars, 'a');
        stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        this.s = new Scanner(stringBuilder.toString());
        this.s.skip(Pattern.compile(".*"));
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)102400, (int)matchResult.end());
        this.s.skip(Pattern.compile("[ \t]*"));
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)102400, (int)matchResult.start());
        ScannerTest.assertEquals((int)102400, (int)matchResult.end());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="skip", args={String.class})
    public void test_skip_LString() {
        this.s = new Scanner("test");
        try {
            this.s.skip((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.s = new Scanner("1234");
        try {
            this.s.skip("\\p{Lower}");
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s.skip("\\p{Digit}");
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s.skip("\\p{Digit}+");
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)1, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        this.s.close();
        try {
            this.s.skip("test");
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        MockStringReader2Read reader = new MockStringReader2Read("test");
        this.s = new Scanner(reader);
        try {
            this.s.skip("\\p{Digit}{4}");
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s.skip("\\p{Digit}{3}\\p{Lower}");
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)4, (int)matchResult.end());
        this.s.close();
        try {
            this.s.skip("");
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = new char[1024];
        Arrays.fill(chars, 'a');
        stringBuilder.append(chars);
        stringBuilder.append('3');
        this.s = new Scanner(stringBuilder.toString());
        this.s.skip("\\p{Lower}+\\p{Digit}");
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1025, (int)matchResult.end());
        chars = new char[102400];
        Arrays.fill(chars, 'a');
        stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        this.s = new Scanner(stringBuilder.toString());
        this.s.skip(".*");
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)102400, (int)matchResult.end());
        this.s.skip("[ \t]*");
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)102400, (int)matchResult.start());
        ScannerTest.assertEquals((int)102400, (int)matchResult.end());
        this.s = new Scanner("test");
        try {
            this.s.skip((String)null);
            ScannerTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextDouble", args={})
    public void test_nextDouble() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.GERMANY, Locale.ENGLISH};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 45\u0666. 123.4 .123 ");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)123.0, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)456.0, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)123.4, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)0.123, (Object)this.s.nextDouble());
        try {
            this.s.nextDouble();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4 -456.7 123,456.789 0.1\u06623,4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)123.4, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)-456.7, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)123456.789, (Object)this.s.nextDouble());
        try {
            this.s.nextDouble();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4E10 -456.7e+12 123,456.789E-10");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)1.234E12, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)-4.567E14, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)1.23456789E-5, (Object)this.s.nextDouble());
        this.s = new Scanner("NaN Infinity -Infinity");
        ScannerTest.assertEquals((Object)Double.NaN, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.s.nextDouble());
        ScannerTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)this.s.nextDouble());
        this.s = new Scanner("\u221e");
        this.s.useLocale(Locale.ENGLISH);
        String str = String.valueOf(Double.POSITIVE_INFINITY);
        this.s = new Scanner(str);
        ScannerTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.s.nextDouble());
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)23456.0, (Object)this.s.nextDouble());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)23.456, (Object)this.s.nextDouble());
        this.s = new Scanner("23.456 23.456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)23.456, (Object)this.s.nextDouble());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)23456.0, (Object)this.s.nextDouble());
        this.s = new Scanner("23,456.7 23.456,7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)23456.7, (Object)this.s.nextDouble());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)23456.7, (Object)this.s.nextDouble());
        this.s = new Scanner("-123.4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)-123.4, (Object)this.s.nextDouble());
        this.s.close();
        try {
            this.s.nextDouble();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextBigDecimal", args={})
    public void test_nextBigDecimal() throws IOException {
        Locale[] requiredLocales = new Locale[]{Locale.ENGLISH, Locale.GERMANY};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        this.s = new Scanner("123 45\u0666. 123.4 .123 ");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("123"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("456"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("123.4"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("0.123"), (Object)this.s.nextBigDecimal());
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4 -456.7 123,456.789 0.1\u06623,4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("123.4"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("-456.7"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("123456.789"), (Object)this.s.nextBigDecimal());
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("+123.4E10 -456.7e+12 123,456.789E-10");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("1.234E12"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("-4.567E14"), (Object)this.s.nextBigDecimal());
        ScannerTest.assertEquals((Object)new BigDecimal("1.23456789E-5"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("NaN");
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"Should throw InputMismatchException");
        }
        catch (InputMismatchException e) {
            // empty catch block
        }
        this.s = new Scanner("23,456 23,456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("23456"), (Object)this.s.nextBigDecimal());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)new BigDecimal("23.456"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("23.456 23.456");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("23.456"), (Object)this.s.nextBigDecimal());
        this.s.useLocale(Locale.GERMANY);
        ScannerTest.assertEquals((Object)new BigDecimal("23456"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("23,456.7");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("23456.7"), (Object)this.s.nextBigDecimal());
        this.s = new Scanner("-123.4");
        this.s.useLocale(Locale.ENGLISH);
        ScannerTest.assertEquals((Object)new BigDecimal("-123.4"), (Object)this.s.nextBigDecimal());
        this.s.close();
        try {
            this.s.nextBigDecimal();
            ScannerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        this.s = new Scanner("test");
        ScannerTest.assertNotNull((Object)this.s.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextLine", args={})
    public void test_nextLine() {
        this.s = new Scanner("");
        this.s.close();
        try {
            this.s.nextLine();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("test\r\ntest");
        String result = this.s.nextLine();
        ScannerTest.assertEquals((String)"test", (String)result);
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)6, (int)matchResult.end());
        this.s = new Scanner("\u0085");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s = new Scanner("\u2028");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s = new Scanner("\u2029");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s = new Scanner("");
        try {
            result = this.s.nextLine();
            ScannerTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            this.s.match();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("Ttest");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"Ttest", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)5, (int)matchResult.end());
        this.s = new Scanner("\r\n");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)2, (int)matchResult.end());
        char[] chars = new char[1024];
        Arrays.fill(chars, 'a');
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        chars = new char[]{'+', '-'};
        stringBuilder.append(chars);
        stringBuilder.append("\u2028");
        this.s = new Scanner(stringBuilder.toString());
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)stringBuilder.toString().substring(0, 1026), (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1027, (int)matchResult.end());
        chars = new char[1023];
        Arrays.fill(chars, 'a');
        stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        stringBuilder.append("\r\n");
        this.s = new Scanner(stringBuilder.toString());
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)stringBuilder.toString().substring(0, 1023), (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1025, (int)matchResult.end());
        this.s = new Scanner("  ");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"  ", (String)result);
        this.s = new Scanner("test\n\n\n");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"test", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)5, (int)matchResult.end());
        result = this.s.nextLine();
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)5, (int)matchResult.start());
        ScannerTest.assertEquals((int)6, (int)matchResult.end());
        this.s = new Scanner("\n\n\n");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"", (String)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        result = this.s.nextLine();
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)1, (int)matchResult.start());
        ScannerTest.assertEquals((int)2, (int)matchResult.end());
        this.s = new Scanner("123 test\n   ");
        int value = this.s.nextInt();
        ScannerTest.assertEquals((int)123, (int)value);
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)" test", (String)result);
        this.s = new Scanner("test\n ");
        result = this.s.nextLine();
        ScannerTest.assertEquals((String)"test", (String)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNextLine", args={})
    public void test_hasNextLine() {
        this.s = new Scanner("");
        this.s.close();
        try {
            this.s.hasNextLine();
            ScannerTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.s = new Scanner("test\r\ntest");
        boolean result = this.s.hasNextLine();
        ScannerTest.assertTrue((boolean)result);
        MatchResult matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)6, (int)matchResult.end());
        this.s = new Scanner("\u0085");
        result = this.s.hasNextLine();
        ScannerTest.assertTrue((boolean)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s = new Scanner("\u2028");
        result = this.s.hasNextLine();
        ScannerTest.assertTrue((boolean)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s = new Scanner("\u2029");
        result = this.s.hasNextLine();
        ScannerTest.assertTrue((boolean)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        this.s = new Scanner("test\n");
        ScannerTest.assertTrue((boolean)this.s.hasNextLine());
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)5, (int)matchResult.end());
        char[] chars = new char[2048];
        Arrays.fill(chars, 'a');
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(chars);
        this.s = new Scanner(stringBuilder.toString());
        result = this.s.hasNextLine();
        ScannerTest.assertTrue((boolean)result);
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)2048, (int)matchResult.end());
        this.s = new Scanner("\n\n\n");
        ScannerTest.assertTrue((boolean)this.s.hasNextLine());
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
        ScannerTest.assertTrue((boolean)this.s.hasNextLine());
        matchResult = this.s.match();
        ScannerTest.assertEquals((int)0, (int)matchResult.start());
        ScannerTest.assertEquals((int)1, (int)matchResult.end());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.server = new ServerSocket(0);
        this.address = new InetSocketAddress("127.0.0.1", this.server.getLocalPort());
        this.client = SocketChannel.open();
        this.client.connect(this.address);
        this.serverSocket = this.server.accept();
        this.os = this.serverSocket.getOutputStream();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Scanner", args={ReadableByteChannel.class})
    public void test_Constructor_LReadableByteChannel() throws IOException {
        InetSocketAddress localAddr = new InetSocketAddress("127.0.0.1", Support_PortManager.getNextPort());
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(localAddr);
        SocketChannel sc = SocketChannel.open();
        sc.connect(localAddr);
        sc.configureBlocking(false);
        ScannerTest.assertFalse((boolean)sc.isBlocking());
        ssc.accept().close();
        ssc.close();
        ScannerTest.assertFalse((boolean)sc.isBlocking());
        Scanner s = new Scanner(sc);
        while (s.hasNextInt()) {
            s.nextInt();
        }
        sc.close();
    }

    private static class MockStringReader2Read
    extends StringReader {
        private int timesRead = 1;

        public MockStringReader2Read(String param) {
            super(param);
        }

        public int read(CharBuffer target) throws IOException {
            if (this.timesRead == 1) {
                target.append('1');
                target.append('2');
                target.append('3');
                ++this.timesRead;
                return 3;
            }
            if (this.timesRead == 2) {
                target.append('t');
                ++this.timesRead;
                return 1;
            }
            throw new IOException();
        }
    }

    private static class MockStringReader
    extends StringReader {
        public MockStringReader(String param) {
            super(param);
        }

        public int read(CharBuffer target) throws IOException {
            target.append('t');
            target.append('e');
            target.append('s');
            target.append('t');
            throw new IOException();
        }
    }

    private static class MockCloseable
    implements Closeable,
    Readable {
        private MockCloseable() {
        }

        public void close() throws IOException {
            throw new IOException();
        }

        public int read(CharBuffer cb) throws IOException {
            throw new EOFException();
        }
    }
}

