/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.KnownFailure;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.TestCase;
import tests.api.java.util.support.B;

@TestTargetClass(value=ResourceBundle.class)
public class ResourceBundleTest
extends TestCase {
    SecurityManager sm = new SecurityManager(){

        public void checkPermission(Permission perm) {
        }
    };

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getBundle", args={String.class, Locale.class})
    public void test_getBundleLjava_lang_StringLjava_util_Locale() {
        String name = "tests.support.Support_TestResource";
        Locale defLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
        ResourceBundle bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "VAR"));
        ResourceBundleTest.assertEquals((String)"Wrong bundle fr_FR_VAR", (String)"frFRVARValue4", (String)bundle.getString("parent4"));
        bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "v1"));
        ResourceBundleTest.assertEquals((String)"Wrong bundle fr_FR_v1", (String)"frFRValue4", (String)bundle.getString("parent4"));
        bundle = ResourceBundle.getBundle(name, new Locale("fr", "US", "VAR"));
        ResourceBundleTest.assertEquals((String)"Wrong bundle fr_US_var", (String)"frValue4", (String)bundle.getString("parent4"));
        bundle = ResourceBundle.getBundle(name, new Locale("de", "FR", "VAR"));
        ResourceBundleTest.assertEquals((String)"Wrong bundle de_FR_var", (String)"enUSValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("fr", "FR", "VAR"));
        bundle = ResourceBundle.getBundle(name, new Locale("de", "FR", "v1"));
        ResourceBundleTest.assertEquals((String)"Wrong bundle de_FR_var 2", (String)"frFRVARValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("de", "US"));
        bundle = ResourceBundle.getBundle(name, new Locale("de", "FR", "var"));
        ResourceBundleTest.assertEquals((String)"Wrong bundle de_FR_var 2", (String)"parentValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("en", "US"));
        try {
            ResourceBundle.getBundle(null, Locale.getDefault());
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            ResourceBundle.getBundle("", new Locale("xx", "yy"));
            ResourceBundleTest.fail((String)"MissingResourceException expected");
        }
        catch (MissingResourceException ee) {
            // empty catch block
        }
        Locale.setDefault(defLocale);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getBundle", args={String.class, Locale.class, ClassLoader.class})
    @KnownFailure(value="It's not allowed to pass null as parent class loader to a new ClassLoader anymore. Maybe we need to change URLClassLoader to allow this? It's not specified.")
    public void test_getBundleLjava_lang_StringLjava_util_LocaleLjava_lang_ClassLoader() {
        String classPath = System.getProperty("java.class.path");
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        Vector<URL> urlVec = new Vector<URL>();
        String resPackage = "/tests/resources/";
        try {
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                String url = new File(path).isDirectory() ? "file:" + path + resPackage + "subfolder/" : "jar:file:" + path + "!" + resPackage + "subfolder/";
                urlVec.addElement(new URL(url));
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        URL[] urls = new URL[urlVec.size()];
        for (int i = 0; i < urlVec.size(); ++i) {
            urls[i] = (URL)urlVec.elementAt(i);
        }
        URLClassLoader loader = new URLClassLoader(urls, null);
        String name = "tests.resources.hyts_resource";
        ResourceBundle bundle = ResourceBundle.getBundle(name, Locale.getDefault());
        ResourceBundleTest.assertEquals((String)"Wrong value read", (String)"parent", (String)bundle.getString("property"));
        bundle = ResourceBundle.getBundle(name, Locale.getDefault(), loader);
        ResourceBundleTest.assertEquals((String)"Wrong cached value", (String)"resource", (String)bundle.getString("property"));
        try {
            ResourceBundle.getBundle(null, Locale.getDefault(), loader);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            ResourceBundle.getBundle(name, null, loader);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            ResourceBundle.getBundle(name, Locale.getDefault(), (ClassLoader)null);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            ResourceBundle.getBundle("", Locale.getDefault(), loader);
            ResourceBundleTest.fail((String)"MissingResourceException expected");
        }
        catch (MissingResourceException ee) {
            // empty catch block
        }
        B bb = new B();
        String s = bb.find("nonexistent");
        s = bb.find("name");
        ResourceBundleTest.assertEquals((String)"Wrong property got", (String)"Name", (String)s);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getString", args={String.class})
    public void test_getStringLjava_lang_String() {
        String name = "tests.support.Support_TestResource";
        Locale.setDefault(new Locale("en", "US"));
        ResourceBundle bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "VAR"));
        ResourceBundleTest.assertEquals((String)"Wrong value parent4", (String)"frFRVARValue4", (String)bundle.getString("parent4"));
        ResourceBundleTest.assertEquals((String)"Wrong value parent3", (String)"frFRValue3", (String)bundle.getString("parent3"));
        ResourceBundleTest.assertEquals((String)"Wrong value parent2", (String)"frValue2", (String)bundle.getString("parent2"));
        ResourceBundleTest.assertEquals((String)"Wrong value parent1", (String)"parentValue1", (String)bundle.getString("parent1"));
        ResourceBundleTest.assertEquals((String)"Wrong value child3", (String)"frFRVARChildValue3", (String)bundle.getString("child3"));
        ResourceBundleTest.assertEquals((String)"Wrong value child2", (String)"frFRVARChildValue2", (String)bundle.getString("child2"));
        ResourceBundleTest.assertEquals((String)"Wrong value child1", (String)"frFRVARChildValue1", (String)bundle.getString("child1"));
        try {
            bundle.getString(null);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            bundle.getString("");
            ResourceBundleTest.fail((String)"MissingResourceException expected");
        }
        catch (MissingResourceException ee) {
            // empty catch block
        }
        try {
            bundle.getString("IntegerVal");
            ResourceBundleTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test. Doesn't verify NullPointerException.", method="getBundle", args={String.class})
    public void test_getBundle_getClassName() {
        Locale locale = Locale.GERMAN;
        String nonExistentBundle = "Non-ExistentBundle";
        try {
            ResourceBundle.getBundle(nonExistentBundle, locale, ((Object)((Object)this)).getClass().getClassLoader());
            ResourceBundleTest.fail((String)"MissingResourceException expected!");
        }
        catch (MissingResourceException e) {
            ResourceBundleTest.assertEquals((String)(nonExistentBundle + "_" + locale), (String)e.getClassName());
        }
        try {
            ResourceBundle.getBundle(nonExistentBundle, locale);
            ResourceBundleTest.fail((String)"MissingResourceException expected!");
        }
        catch (MissingResourceException e) {
            ResourceBundleTest.assertEquals((String)(nonExistentBundle + "_" + locale), (String)e.getClassName());
        }
        locale = Locale.getDefault();
        try {
            ResourceBundle.getBundle(nonExistentBundle);
            ResourceBundleTest.fail((String)"MissingResourceException expected!");
        }
        catch (MissingResourceException e) {
            ResourceBundleTest.assertEquals((String)(nonExistentBundle + "_" + locale), (String)e.getClassName());
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ResourceBundle", args={})
    public void test_constructor() {
        ResourceBundleTest.assertNotNull((Object)new Mock_ResourceBundle());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getLocale", args={})
    public void test_getLocale() {
        String name = "tests.support.Support_TestResource";
        Locale loc = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
        ResourceBundle bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "VAR"));
        ResourceBundleTest.assertEquals((String)"fr_FR_VAR", (String)bundle.getLocale().toString());
        bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "v1"));
        ResourceBundleTest.assertEquals((String)"fr_FR", (String)bundle.getLocale().toString());
        bundle = ResourceBundle.getBundle(name, new Locale("fr", "US", "VAR"));
        ResourceBundleTest.assertEquals((String)"fr", (String)bundle.getLocale().toString());
        bundle = ResourceBundle.getBundle(name, new Locale("de", "FR", "VAR"));
        ResourceBundleTest.assertEquals((String)"en_US", (String)bundle.getLocale().toString());
        bundle = ResourceBundle.getBundle(name, new Locale("de", "FR", "v1"));
        ResourceBundleTest.assertEquals((String)"en_US", (String)bundle.getLocale().toString());
        bundle = ResourceBundle.getBundle(name, new Locale("de", "FR", "var"));
        ResourceBundleTest.assertEquals((String)"en_US", (String)bundle.getLocale().toString());
        Locale.setDefault(loc);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getObject", args={String.class})
    public void test_getObjectLjava_lang_String() {
        String name = "tests.support.Support_TestResource";
        Locale.setDefault(new Locale("en", "US"));
        ResourceBundle bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "VAR"));
        ResourceBundleTest.assertEquals((String)"Wrong value parent4", (String)"frFRVARValue4", (String)((String)bundle.getObject("parent4")));
        ResourceBundleTest.assertEquals((String)"Wrong value parent3", (String)"frFRValue3", (String)((String)bundle.getObject("parent3")));
        ResourceBundleTest.assertEquals((String)"Wrong value parent2", (String)"frValue2", (String)((String)bundle.getObject("parent2")));
        ResourceBundleTest.assertEquals((String)"Wrong value parent1", (String)"parentValue1", (String)((String)bundle.getObject("parent1")));
        ResourceBundleTest.assertEquals((String)"Wrong value child3", (String)"frFRVARChildValue3", (String)((String)bundle.getObject("child3")));
        ResourceBundleTest.assertEquals((String)"Wrong value child2", (String)"frFRVARChildValue2", (String)((String)bundle.getObject("child2")));
        ResourceBundleTest.assertEquals((String)"Wrong value child1", (String)"frFRVARChildValue1", (String)((String)bundle.getObject("child1")));
        ResourceBundleTest.assertEquals((String)"Wrong value IntegerVal", (Object)1, (Object)bundle.getObject("IntegerVal"));
        try {
            bundle.getObject(null);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            bundle.getObject("");
            ResourceBundleTest.fail((String)"MissingResourceException expected");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getStringArray", args={String.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setParent", args={ResourceBundle.class})})
    public void test_getStringArrayLjava_lang_String() {
        String name = "tests.support.Support_TestResource";
        Locale.setDefault(new Locale("en", "US"));
        ResourceBundle bundle = ResourceBundle.getBundle(name, new Locale("fr", "FR", "VAR"));
        String[] array = bundle.getStringArray("StringArray");
        for (int i = 0; i < array.length; ++i) {
            ResourceBundleTest.assertEquals((String)("Str" + (i + 1)), (String)array[i]);
        }
        try {
            bundle.getStringArray(null);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            bundle.getStringArray("");
            ResourceBundleTest.fail((String)"MissingResourceException expected");
        }
        catch (MissingResourceException ee) {
            // empty catch block
        }
        try {
            bundle.getStringArray("IntegerVal");
            ResourceBundleTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException ee) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getBundle", args={String.class})
    public void test_getBundleLjava_lang_String() {
        String name = "tests.support.Support_TestResource";
        Locale defLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
        ResourceBundle bundle = ResourceBundle.getBundle(name);
        ResourceBundleTest.assertEquals((String)"enUSValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("fr", "FR", "v1"));
        bundle = ResourceBundle.getBundle(name);
        ResourceBundleTest.assertEquals((String)"Wrong bundle fr_FR_v1", (String)"frFRValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("fr", "US", "VAR"));
        bundle = ResourceBundle.getBundle(name);
        ResourceBundleTest.assertEquals((String)"Wrong bundle fr_US_var", (String)"frValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("de", "FR", "VAR"));
        bundle = ResourceBundle.getBundle(name);
        ResourceBundleTest.assertEquals((String)"Wrong bundle de_FR_var", (String)"parentValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("de", "FR", "v1"));
        bundle = ResourceBundle.getBundle(name);
        ResourceBundleTest.assertEquals((String)"Wrong bundle de_FR_var 2", (String)"parentValue4", (String)bundle.getString("parent4"));
        Locale.setDefault(new Locale("de", "FR", "var"));
        bundle = ResourceBundle.getBundle(name);
        ResourceBundleTest.assertEquals((String)"Wrong bundle de_FR_var 2", (String)"parentValue4", (String)bundle.getString("parent4"));
        try {
            ResourceBundle.getBundle(null);
            ResourceBundleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            ResourceBundle.getBundle("");
            ResourceBundleTest.fail((String)"MissingResourceException expected");
        }
        catch (MissingResourceException ee) {
            // empty catch block
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Mock_ResourceBundle
    extends ResourceBundle {
        Mock_ResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    }
}

