/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Random;
import junit.framework.TestCase;

@TestTargetClass(value=Random.class)
public class RandomTest
extends TestCase {
    Random r;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Random", args={})
    public void test_Constructor() {
        RandomTest.assertTrue((String)"Used to test", (boolean)true);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Random", args={long.class})
    public void test_ConstructorJ() {
        Random r = new Random(8409238L);
        Random r2 = new Random(8409238L);
        for (int i = 0; i < 100; ++i) {
            RandomTest.assertTrue((String)"Values from randoms with same seed don't match", (r.nextInt() == r2.nextInt() ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextBoolean", args={})
    public void test_nextBoolean() {
        boolean falseAppeared = false;
        boolean trueAppeared = false;
        for (int counter = 0; counter < 100; ++counter) {
            if (this.r.nextBoolean()) {
                trueAppeared = true;
                continue;
            }
            falseAppeared = true;
        }
        RandomTest.assertTrue((String)"Calling nextBoolean() 100 times resulted in all trues", (boolean)falseAppeared);
        RandomTest.assertTrue((String)"Calling nextBoolean() 100 times resulted in all falses", (boolean)trueAppeared);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextBytes", args={byte[].class})
    public void test_nextBytes$B() {
        boolean someDifferent = false;
        byte[] randomBytes = new byte[100];
        this.r.nextBytes(randomBytes);
        byte firstByte = randomBytes[0];
        for (int counter = 1; counter < randomBytes.length; ++counter) {
            if (randomBytes[counter] == firstByte) continue;
            someDifferent = true;
        }
        RandomTest.assertTrue((String)"nextBytes() returned an array of length 100 of the same byte", (boolean)someDifferent);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextDouble", args={})
    public void test_nextDouble() {
        double lastNum = this.r.nextDouble();
        boolean someDifferent = false;
        boolean inRange = true;
        for (int counter = 0; counter < 100; ++counter) {
            double nextNum = this.r.nextDouble();
            if (nextNum != lastNum) {
                someDifferent = true;
            }
            if (!(0.0 <= nextNum) || !(nextNum < 1.0)) {
                inRange = false;
            }
            lastNum = nextNum;
        }
        RandomTest.assertTrue((String)"Calling nextDouble 100 times resulted in same number", (boolean)someDifferent);
        RandomTest.assertTrue((String)"Calling nextDouble resulted in a number out of range [0,1)", (boolean)inRange);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextFloat", args={})
    public void test_nextFloat() {
        float lastNum = this.r.nextFloat();
        boolean someDifferent = false;
        boolean inRange = true;
        for (int counter = 0; counter < 100; ++counter) {
            float nextNum = this.r.nextFloat();
            if (nextNum != lastNum) {
                someDifferent = true;
            }
            if (!(0.0f <= nextNum) || !((double)nextNum < 1.0)) {
                inRange = false;
            }
            lastNum = nextNum;
        }
        RandomTest.assertTrue((String)"Calling nextFloat 100 times resulted in same number", (boolean)someDifferent);
        RandomTest.assertTrue((String)"Calling nextFloat resulted in a number out of range [0,1)", (boolean)inRange);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextGaussian", args={})
    public void test_nextGaussian() {
        double lastNum = this.r.nextGaussian();
        boolean someDifferent = false;
        boolean someInsideStd = false;
        for (int counter = 0; counter < 100; ++counter) {
            double nextNum = this.r.nextGaussian();
            if (nextNum != lastNum) {
                someDifferent = true;
            }
            if (-1.0 <= nextNum && nextNum <= 1.0) {
                someInsideStd = true;
            }
            lastNum = nextNum;
        }
        RandomTest.assertTrue((String)"Calling nextGaussian 100 times resulted in same number", (boolean)someDifferent);
        RandomTest.assertTrue((String)"Calling nextGaussian 100 times resulted in no number within 1 std. deviation of mean", (boolean)someInsideStd);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextInt", args={})
    public void test_nextInt() {
        int lastNum = this.r.nextInt();
        boolean someDifferent = false;
        for (int counter = 0; counter < 100; ++counter) {
            int nextNum = this.r.nextInt();
            if (nextNum != lastNum) {
                someDifferent = true;
            }
            lastNum = nextNum;
        }
        RandomTest.assertTrue((String)"Calling nextInt 100 times resulted in same number", (boolean)someDifferent);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextInt", args={int.class})
    public void test_nextIntI() {
        int range = 10;
        int lastNum = this.r.nextInt(10);
        boolean someDifferent = false;
        boolean inRange = true;
        for (int counter = 0; counter < 100; ++counter) {
            int nextNum = this.r.nextInt(10);
            if (nextNum != lastNum) {
                someDifferent = true;
            }
            if (0 > nextNum || nextNum >= 10) {
                inRange = false;
            }
            lastNum = nextNum;
        }
        RandomTest.assertTrue((String)"Calling nextInt (range) 100 times resulted in same number", (boolean)someDifferent);
        RandomTest.assertTrue((String)"Calling nextInt (range) resulted in a number outside of [0, range)", (boolean)inRange);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextLong", args={})
    public void test_nextLong() {
        long lastNum = this.r.nextLong();
        boolean someDifferent = false;
        for (int counter = 0; counter < 100; ++counter) {
            long nextNum = this.r.nextLong();
            if (nextNum != lastNum) {
                someDifferent = true;
            }
            lastNum = nextNum;
        }
        RandomTest.assertTrue((String)"Calling nextLong 100 times resulted in same number", (boolean)someDifferent);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setSeed", args={long.class})
    public void test_setSeedJ() {
        int counter;
        long[] randomArray = new long[100];
        boolean someDifferent = false;
        long firstSeed = 1000L;
        Random aRandom = new Random();
        Random anotherRandom = new Random();
        Random yetAnotherRandom = new Random();
        aRandom.setSeed(1000L);
        anotherRandom.setSeed(1000L);
        for (counter = 0; counter < randomArray.length; ++counter) {
            long anotherLong;
            long aLong = aRandom.nextLong();
            RandomTest.assertTrue((String)"Two randoms with same seeds gave differing nextLong values", (aLong == (anotherLong = anotherRandom.nextLong()) ? 1 : 0) != 0);
            long yetAnotherLong = yetAnotherRandom.nextLong();
            randomArray[counter] = aLong;
            if (aLong == yetAnotherLong) continue;
            someDifferent = true;
        }
        RandomTest.assertTrue((String)"Two randoms with the different seeds gave the same chain of values", (boolean)someDifferent);
        aRandom.setSeed(1000L);
        for (counter = 0; counter < randomArray.length; ++counter) {
            RandomTest.assertTrue((String)"Reseting a random to its old seed did not result in the same chain of values as it gave before", (aRandom.nextLong() == randomArray[counter] ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="next", args={int.class})
    public void test_next() {
        Mock_Random mr = new Mock_Random();
        RandomTest.assertFalse((boolean)mr.getFlag());
        mr.nextBoolean();
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextBytes(new byte[10]);
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextDouble();
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextFloat();
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextGaussian();
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextInt();
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextInt(10);
        RandomTest.assertTrue((boolean)mr.getFlag());
        mr.nextLong();
        RandomTest.assertTrue((boolean)mr.getFlag());
    }

    protected void setUp() {
        this.r = new Random();
    }

    protected void tearDown() {
    }

    class Mock_Random
    extends Random {
        boolean nextCalled = false;

        Mock_Random() {
        }

        public boolean getFlag() {
            boolean retVal = this.nextCalled;
            this.nextCalled = false;
            return retVal;
        }

        protected int next(int bits) {
            this.nextCalled = true;
            return super.next(bits);
        }
    }
}

