/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=PropertyResourceBundle.class)
public class PropertyResourceBundleTest
extends TestCase {
    static PropertyResourceBundle prb;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="PropertyResourceBundle", args={InputStream.class})
    public void test_ConstructorLjava_io_InputStream() {
        PropertyResourceBundleTest.assertTrue((String)"Used to test", (boolean)true);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getKeys", args={})
    public void test_getKeys() {
        Enumeration<String> keyEnum = prb.getKeys();
        Vector<String> test = new Vector<String>();
        int keyCount = 0;
        while (keyEnum.hasMoreElements()) {
            test.addElement(keyEnum.nextElement());
            ++keyCount;
        }
        PropertyResourceBundleTest.assertEquals((String)"Returned the wrong number of keys", (int)2, (int)keyCount);
        PropertyResourceBundleTest.assertTrue((String)"Returned the wrong keys", (test.contains("p1") && test.contains("p2") ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="handleGetObject", args={String.class})
    public void test_handleGetObjectLjava_lang_String() {
        try {
            PropertyResourceBundleTest.assertTrue((String)"Returned incorrect objects", (prb.getObject("p1").equals("one") && prb.getObject("p2").equals("two") ? 1 : 0) != 0);
        }
        catch (MissingResourceException e) {
            PropertyResourceBundleTest.fail((String)"Threw MisingResourceException for a key contained in the bundle");
        }
        try {
            prb.getObject("Not in the bundle");
        }
        catch (MissingResourceException e) {
            return;
        }
        PropertyResourceBundleTest.fail((String)"Failed to throw MissingResourceException for object not in the bundle");
    }

    protected void setUp() {
        ByteArrayInputStream propertiesStream = new ByteArrayInputStream("p1=one\np2=two".getBytes());
        try {
            prb = new PropertyResourceBundle(propertiesStream);
        }
        catch (IOException e) {
            PropertyResourceBundleTest.fail((String)"Contruction of PropertyResourceBundle threw IOException");
        }
    }

    protected void tearDown() {
    }
}

