/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.PropertyPermission;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

@TestTargetClass(value=PropertyPermission.class)
public class PropertyPermissionTest
extends TestCase {
    static PropertyPermission javaPP = new PropertyPermission("java.*", "read");
    static PropertyPermission userPP = new PropertyPermission("user.name", "read,write");
    private static final SerializationTest.SerializableAssert comparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            PropertyPermission initialPP = (PropertyPermission)initial;
            PropertyPermission deseriaPP = (PropertyPermission)deserialized;
            Assert.assertEquals((String)"should be equal", (Object)initialPP, (Object)deseriaPP);
        }
    };

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="PropertyPermission", args={String.class, String.class})
    public void test_ConstructorLjava_lang_StringLjava_lang_String() {
        PropertyPermissionTest.assertTrue((String)"Used to test", (boolean)true);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        PropertyPermission equalToJavaPP = new PropertyPermission("java.*", "read");
        PropertyPermission notEqualToJavaPP = new PropertyPermission("java.*", "read, write");
        PropertyPermission alsoNotEqualToJavaPP = new PropertyPermission("java.home", "read");
        PropertyPermissionTest.assertTrue((String)"Equal returned false for equal objects", (boolean)javaPP.equals(equalToJavaPP));
        PropertyPermissionTest.assertTrue((String)"Equal returned true for objects with different names", (!javaPP.equals(notEqualToJavaPP) ? 1 : 0) != 0);
        PropertyPermissionTest.assertTrue((String)"Equal returned true for objects with different permissions", (!javaPP.equals(alsoNotEqualToJavaPP) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getActions", args={})
    public void test_getActions() {
        PropertyPermissionTest.assertEquals((String)"getActions did not return proper action", (String)"read", (String)javaPP.getActions());
        PropertyPermissionTest.assertEquals((String)"getActions did not return proper canonical representation of actions", (String)"read,write", (String)userPP.getActions());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        PropertyPermissionTest.assertTrue((String)"javaPP returned wrong hashCode", (javaPP.hashCode() == javaPP.getName().hashCode() ? 1 : 0) != 0);
        PropertyPermissionTest.assertTrue((String)"userPP returned wrong hashCode", (userPP.hashCode() == userPP.getName().hashCode() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="implies", args={Permission.class})
    public void test_impliesLjava_security_Permission() {
        PropertyPermission impliedByJavaPP = new PropertyPermission("java.home", "read");
        PropertyPermission notImpliedByJavaPP = new PropertyPermission("java.home", "read,write");
        PropertyPermission impliedByUserPP = new PropertyPermission("user.name", "read,write");
        PropertyPermission alsoImpliedByUserPP = new PropertyPermission("user.name", "write");
        PropertyPermissionTest.assertTrue((String)"Returned false for implied permission (subset of .*)", (boolean)javaPP.implies(impliedByJavaPP));
        PropertyPermissionTest.assertTrue((String)"Returned true for unimplied permission", (!javaPP.implies(notImpliedByJavaPP) ? 1 : 0) != 0);
        PropertyPermissionTest.assertTrue((String)"Returned false for implied permission (equal)", (boolean)userPP.implies(impliedByUserPP));
        PropertyPermissionTest.assertTrue((String)"Returned false for implied permission (subset of actions)", (boolean)userPP.implies(alsoImpliedByUserPP));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="newPermissionCollection", args={})
    public void test_newPermissionCollection() {
        PermissionCollection pc = javaPP.newPermissionCollection();
        pc.add(javaPP);
        Enumeration<Permission> elementEnum = pc.elements();
        PropertyPermissionTest.assertTrue((String)"Invalid PermissionCollection returned", (boolean)((Object)elementEnum.nextElement()).equals(javaPP));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization.", method="!SerializationSelf", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization.", method="!SerializationGolden", args={})})
    public void test_serialization() throws Exception {
        PropertyPermission pp = new PropertyPermission("test", "read");
        SerializationTest.verifySelf(pp, comparator);
        SerializationTest.verifyGolden((TestCase)this, pp, comparator);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

