/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=Observable.class)
public class ObservableTest
extends TestCase {
    Observer observer;
    TestObservable observable;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Observable", args={})
    public void test_Constructor() {
        try {
            Observable ov = new Observable();
            ObservableTest.assertTrue((String)"Wrong initial values.", (!ov.hasChanged() ? 1 : 0) != 0);
            ObservableTest.assertEquals((String)"Wrong initial values.", (int)0, (int)ov.countObservers());
        }
        catch (Exception e) {
            ObservableTest.fail((String)("Exception during test : " + e.getMessage()));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addObserver", args={Observer.class})
    public void test_addObserverLjava_util_Observer() {
        TestObserver test = new TestObserver();
        this.observable.addObserver(test);
        ObservableTest.assertEquals((String)"Failed to add observer", (int)1, (int)this.observable.countObservers());
        this.observable.addObserver(test);
        ObservableTest.assertEquals((String)"Duplicate observer", (int)1, (int)this.observable.countObservers());
        Observable o = new Observable();
        try {
            o.addObserver(null);
            ObservableTest.fail((String)"Expected adding a null observer to throw a NPE.");
        }
        catch (NullPointerException ex) {
        }
        catch (Throwable ex) {
            ObservableTest.fail((String)("Did not expect adding a new observer to throw a " + ex.getClass().getName()));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="countObservers", args={})
    public void test_countObservers() {
        ObservableTest.assertEquals((String)"New observable had > 0 observers", (int)0, (int)this.observable.countObservers());
        this.observable.addObserver(new TestObserver());
        ObservableTest.assertEquals((String)"Observable with observer returned other than 1", (int)1, (int)this.observable.countObservers());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="deleteObserver", args={Observer.class})
    public void test_deleteObserverLjava_util_Observer() {
        this.observer = new TestObserver();
        this.observable.addObserver(this.observer);
        this.observable.deleteObserver(this.observer);
        ObservableTest.assertEquals((String)"Failed to delete observer", (int)0, (int)this.observable.countObservers());
        this.observable.deleteObserver(this.observer);
        this.observable.deleteObserver(null);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="deleteObservers", args={})
    public void test_deleteObservers() {
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.addObserver(new TestObserver());
        this.observable.deleteObservers();
        ObservableTest.assertEquals((String)"Failed to delete observers", (int)0, (int)this.observable.countObservers());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasChanged", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setChanged", args={})})
    public void test_hasChanged() {
        ObservableTest.assertFalse((boolean)this.observable.hasChanged());
        this.observer = new TestObserver();
        this.observable.addObserver(this.observer);
        this.observable.doChange();
        ObservableTest.assertTrue((boolean)this.observable.hasChanged());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setChanged", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clearChanged", args={})})
    public void test_clearChanged() {
        ObservableTest.assertFalse((boolean)this.observable.hasChanged());
        this.observer = new TestObserver();
        this.observable.addObserver(this.observer);
        this.observable.doChange();
        ObservableTest.assertTrue((boolean)this.observable.hasChanged());
        this.observable.clearChange();
        ObservableTest.assertFalse((boolean)this.observable.hasChanged());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="notifyObservers", args={})
    public void test_notifyObservers() {
        this.observer = new TestObserver();
        this.observable.addObserver(this.observer);
        this.observable.notifyObservers();
        ObservableTest.assertEquals((String)"Notified when unchnaged", (int)0, (int)((TestObserver)this.observer).updateCount());
        this.observable.doChange();
        this.observable.notifyObservers();
        ObservableTest.assertEquals((String)"Failed to notify", (int)1, (int)((TestObserver)this.observer).updateCount());
        this.observable.deleteObservers();
        DeleteTestObserver observer1 = new DeleteTestObserver(false);
        this.observable.addObserver(observer1);
        DeleteTestObserver observer2 = new DeleteTestObserver(false);
        this.observable.addObserver(observer2);
        this.observable.doChange();
        this.observable.notifyObservers();
        ObservableTest.assertTrue((String)"Failed to notify all", (observer1.updateCount() == 1 && observer2.updateCount() == 1 ? 1 : 0) != 0);
        ObservableTest.assertEquals((String)"Failed to delete all", (int)0, (int)this.observable.countObservers());
        observer1 = new DeleteTestObserver(false);
        this.observable.addObserver(observer1);
        observer2 = new DeleteTestObserver(false);
        this.observable.addObserver(observer2);
        this.observable.doChange();
        this.observable.notifyObservers();
        ObservableTest.assertTrue((String)"Failed to notify all 2", (observer1.updateCount() == 1 && observer2.updateCount() == 1 ? 1 : 0) != 0);
        ObservableTest.assertEquals((String)"Failed to delete all 2", (int)0, (int)this.observable.countObservers());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="notifyObservers", args={Object.class})
    public void test_notifyObserversLjava_lang_Object() {
        this.observer = new TestObserver();
        this.observable.addObserver(this.observer);
        this.observable.notifyObservers();
        ObservableTest.assertEquals((String)"Notified when unchanged", (int)0, (int)((TestObserver)this.observer).updateCount());
        this.observable.doChange();
        Object obj = new Object();
        this.observable.notifyObservers(obj);
        ObservableTest.assertEquals((String)"Failed to notify", (int)1, (int)((TestObserver)this.observer).updateCount());
        ObservableTest.assertTrue((String)"Failed to pass Object arg", (boolean)((TestObserver)this.observer).objv.elementAt(0).equals(obj));
    }

    protected void setUp() {
        this.observable = new TestObservable();
    }

    protected void tearDown() {
    }

    static class TestObservable
    extends Observable {
        TestObservable() {
        }

        public void doChange() {
            this.setChanged();
        }

        public void clearChange() {
            this.clearChanged();
        }
    }

    static class DeleteTestObserver
    implements Observer {
        int updateCount = 0;
        boolean deleteAll = false;

        public DeleteTestObserver(boolean all) {
            this.deleteAll = all;
        }

        public void update(Observable observed, Object arg) {
            ++this.updateCount;
            if (this.deleteAll) {
                observed.deleteObservers();
            } else {
                observed.deleteObserver(this);
            }
        }

        public int updateCount() {
            return this.updateCount;
        }
    }

    static class TestObserver
    implements Observer {
        public Vector objv = new Vector();
        int updateCount = 0;

        TestObserver() {
        }

        public void update(Observable observed, Object arg) {
            ++this.updateCount;
            this.objv.add(arg);
        }

        public int updateCount() {
            return this.updateCount;
        }
    }
}

