/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import junit.framework.TestCase;

@TestTargetClass(value=MissingResourceException.class)
public class MissingResourceExceptionTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="MissingResourceException", args={String.class, String.class, String.class})
    public void test_ConstructorLjava_lang_StringLjava_lang_StringLjava_lang_String() {
        MissingResourceExceptionTest.assertNotNull((Object)new MissingResourceException("Detail string", "Class name string", "Key string"));
        MissingResourceExceptionTest.assertNotNull((Object)new MissingResourceException(null, "Class name string", "Key string"));
        MissingResourceExceptionTest.assertNotNull((Object)new MissingResourceException("Detail string", null, "Key string"));
        MissingResourceExceptionTest.assertNotNull((Object)new MissingResourceException("Detail string", "Class name string", null));
        try {
            ResourceBundle.getBundle("Non-ExistentBundle");
        }
        catch (MissingResourceException e) {
            return;
        }
        MissingResourceExceptionTest.fail((String)"Failed to generate expected exception");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getClassName", args={})
    public void test_getClassName() {
        try {
            ResourceBundle.getBundle("Non-ExistentBundle");
        }
        catch (MissingResourceException e) {
            MissingResourceExceptionTest.assertEquals((String)"Returned incorrect class name", (String)("Non-ExistentBundle_" + Locale.getDefault()), (String)e.getClassName());
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getKey", args={})
    public void test_getKey() {
        try {
            ResourceBundle.getBundle("Non-ExistentBundle");
        }
        catch (MissingResourceException e) {
            MissingResourceExceptionTest.assertTrue((String)"Returned incorrect class name", (boolean)e.getKey().equals(""));
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

