/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.AndroidOnly;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import junit.framework.TestCase;
import tests.support.Support_Locale;

@TestTargetClass(value=Locale.class)
public class LocaleTest
extends TestCase {
    Locale testLocale;
    Locale l;
    Locale defaultLocale;
    SecurityManager sm = new SecurityManager(){
        final String forbidenPermissionName = "user.language";

        public void checkPermission(Permission perm) {
            if (perm.getName().equals("user.language")) {
                throw new SecurityException();
            }
        }
    };

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Locale", args={String.class})
    public void test_ConstructorLjava_lang_String() {
        Locale x = new Locale("xx");
        LocaleTest.assertTrue((String)"Failed to create Locale", (boolean)x.getVariant().equals(""));
        try {
            new Locale(null);
            LocaleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Locale", args={String.class, String.class})
    public void test_ConstructorLjava_lang_StringLjava_lang_String() {
        Locale x = new Locale("xx", "CV");
        LocaleTest.assertTrue((String)"Failed to create Locale", (x.getCountry().equals("CV") && x.getVariant().equals("") ? 1 : 0) != 0);
        try {
            new Locale("xx", null);
            LocaleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new Locale(null, "CV");
            LocaleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Locale", args={String.class, String.class, String.class})
    public void test_ConstructorLjava_lang_StringLjava_lang_StringLjava_lang_String() {
        Locale x = new Locale("xx", "CV", "ZZ");
        LocaleTest.assertTrue((String)"Failed to create Locale", (x.getLanguage().equals("xx") && x.getCountry().equals("CV") && x.getVariant().equals("ZZ") ? 1 : 0) != 0);
        try {
            new Locale(null, "CV", "ZZ");
            LocaleTest.fail((String)"expected NullPointerException with 1st parameter == null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new Locale("xx", null, "ZZ");
            LocaleTest.fail((String)"expected NullPointerException with 2nd parameter == null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new Locale("xx", "CV", null);
            LocaleTest.fail((String)"expected NullPointerException with 3rd parameter == null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        LocaleTest.assertTrue((String)"Clone failed", (boolean)this.l.clone().equals(this.l));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        Locale l2 = new Locale("en", "CA", "WIN32");
        LocaleTest.assertTrue((String)"Same object returned false", (boolean)this.testLocale.equals(this.testLocale));
        LocaleTest.assertTrue((String)"Same values returned false", (boolean)this.testLocale.equals(l2));
        LocaleTest.assertTrue((String)"Different locales returned true", (!this.testLocale.equals(this.l) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getAvailableLocales", args={})
    public void test_getAvailableLocales() {
        try {
            Locale[] locales = Locale.getAvailableLocales();
            LocaleTest.assertTrue((String)("Wrong number of locales: " + locales.length), (locales.length > 10 ? 1 : 0) != 0);
            HashSet<Locale> localesSet = new HashSet<Locale>(Arrays.asList(locales));
            LocaleTest.assertEquals((int)localesSet.size(), (int)locales.length);
        }
        catch (Exception e) {
            LocaleTest.fail((String)("Exception during test : " + e.getMessage()));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getCountry", args={})
    public void test_getCountry() {
        LocaleTest.assertTrue((String)("Returned incorrect country: " + this.testLocale.getCountry()), (boolean)this.testLocale.getCountry().equals("CA"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDefault", args={})
    public void test_getDefault() {
        LocaleTest.assertTrue((String)"returns copy", (Locale.getDefault() == Locale.getDefault() ? 1 : 0) != 0);
        Locale org = Locale.getDefault();
        Locale.setDefault(this.l);
        Locale x = Locale.getDefault();
        Locale.setDefault(org);
        LocaleTest.assertEquals((String)"Failed to get locale", (String)"fr_CA_WIN32", (String)x.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayCountry", args={})
    @AndroidOnly(value="ICU has different display name for countries")
    public void test_getDisplayCountry() {
        LocaleTest.assertTrue((String)("Returned incorrect country: " + this.testLocale.getDisplayCountry()), (boolean)this.testLocale.getDisplayCountry().equals("Canada"));
        Locale l_countryCD = new Locale("", "CD");
        LocaleTest.assertEquals((String)"Congo - Kinshasa", (String)l_countryCD.getDisplayCountry());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayCountry", args={Locale.class})
    public void test_getDisplayCountryLjava_util_Locale() {
        Locale[] requiredLocales = new Locale[]{Locale.ITALY};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        LocaleTest.assertEquals((String)"Returned incorrect country", (String)"Italie", (String)Locale.ITALY.getDisplayCountry(this.l));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayLanguage", args={})
    public void test_getDisplayLanguage() {
        LocaleTest.assertTrue((String)("Returned incorrect language: " + this.testLocale.getDisplayLanguage()), (boolean)this.testLocale.getDisplayLanguage().equals("English"));
        Locale l_languageAE = new Locale("ae", "");
        LocaleTest.assertEquals((String)"Avestan", (String)l_languageAE.getDisplayLanguage());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayLanguage", args={Locale.class})
    public void test_getDisplayLanguageLjava_util_Locale() {
        Locale[] requiredLocales = new Locale[]{this.testLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        LocaleTest.assertTrue((String)("Returned incorrect language: " + this.testLocale.getDisplayLanguage(this.l)), (boolean)this.testLocale.getDisplayLanguage(this.l).equals("anglais"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayName", args={})
    public void test_getDisplayName() {
        LocaleTest.assertTrue((String)("Returned incorrect name: " + this.testLocale.getDisplayName()), (boolean)this.testLocale.getDisplayName().equals("English (Canada,WIN32)"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayName", args={Locale.class})
    public void test_getDisplayNameLjava_util_Locale() {
        Locale[] requiredLocales = new Locale[]{this.testLocale};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        LocaleTest.assertTrue((String)("Returned incorrect name: " + this.testLocale.getDisplayName(this.l)), (boolean)this.testLocale.getDisplayName(this.l).equals("anglais (Canada,WIN32)"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayVariant", args={})
    public void test_getDisplayVariant() {
        LocaleTest.assertTrue((String)("Returned incorrect variant: " + this.testLocale.getDisplayVariant()), (boolean)this.testLocale.getDisplayVariant().equals("WIN32"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDisplayVariant", args={Locale.class})
    public void test_getDisplayVariantLjava_util_Locale() {
        LocaleTest.assertTrue((String)("Returned incorrect variant: " + this.testLocale.getDisplayVariant(this.l)), (boolean)this.testLocale.getDisplayVariant(this.l).equals("WIN32"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getISO3Country", args={})
    public void test_getISO3Country() {
        LocaleTest.assertTrue((String)("Returned incorrect ISO3 country: " + this.testLocale.getISO3Country()), (boolean)this.testLocale.getISO3Country().equals("CAN"));
        Locale l = new Locale("", "CD");
        LocaleTest.assertEquals((String)"COD", (String)l.getISO3Country());
        Locale x = new Locale("xx", "C");
        try {
            x.getISO3Country();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getISO3Language", args={})
    public void test_getISO3Language() {
        LocaleTest.assertTrue((String)("Returned incorrect ISO3 language: " + this.testLocale.getISO3Language()), (boolean)this.testLocale.getISO3Language().equals("eng"));
        Locale l = new Locale("ae");
        LocaleTest.assertEquals((String)"ave", (String)l.getISO3Language());
        Locale l_CountryCS = new Locale("", "CS");
        LocaleTest.assertEquals((String)"SCG", (String)l_CountryCS.getISO3Country());
        l = new Locale("ak", "");
        LocaleTest.assertEquals((String)"aka", (String)l.getISO3Language());
        Locale x = new Locale("xx", "C");
        try {
            x.getISO3Language();
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getISOCountries", args={})
    public void test_getISOCountries() {
        String[] isoCountries = Locale.getISOCountries();
        int length = isoCountries.length;
        int familiarCount = 0;
        for (int i = 0; i < length; ++i) {
            if (isoCountries[i].length() != 2) {
                LocaleTest.fail((String)"Wrong format for ISOCountries.");
            }
            if (!isoCountries[i].equals("CA") && !isoCountries[i].equals("BB") && !isoCountries[i].equals("US") && !isoCountries[i].equals("KR")) continue;
            ++familiarCount;
        }
        LocaleTest.assertTrue((String)"ISOCountries missing.", (familiarCount == 4 && length > 230 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getISOLanguages", args={})
    public void test_getISOLanguages() {
        int length;
        String[] isoLang = Locale.getISOLanguages();
        LocaleTest.assertTrue((String)"Random element in wrong format.", ((isoLang[(length = isoLang.length) / 2].length() == 2 || isoLang[length / 2].length() == 3) && isoLang[length / 2].toLowerCase().equals(isoLang[length / 2]) ? 1 : 0) != 0);
        LocaleTest.assertTrue((String)"Wrong number of ISOLanguages.", (length > 130 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getLanguage", args={})
    public void test_getLanguage() {
        LocaleTest.assertTrue((String)("Returned incorrect language: " + this.testLocale.getLanguage()), (boolean)this.testLocale.getLanguage().equals("en"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getVariant", args={})
    public void test_getVariant() {
        LocaleTest.assertTrue((String)("Returned incorrect variant: " + this.testLocale.getVariant()), (boolean)this.testLocale.getVariant().equals("WIN32"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setDefault", args={Locale.class})
    public void test_setDefaultLjava_util_Locale() {
        Locale org = Locale.getDefault();
        Locale.setDefault(this.l);
        Locale x = Locale.getDefault();
        Locale.setDefault(org);
        LocaleTest.assertEquals((String)"Failed to set locale", (String)"fr_CA_WIN32", (String)x.toString());
        Locale.setDefault(new Locale("tr", ""));
        String res1 = "i".toUpperCase();
        String res2 = "I".toLowerCase();
        Locale.setDefault(org);
        LocaleTest.assertEquals((String)"Wrong toUppercase conversion", (String)"\u0130", (String)res1);
        LocaleTest.assertEquals((String)"Wrong toLowercase conversion", (String)"\u0131", (String)res2);
        try {
            Locale.setDefault(null);
            LocaleTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        LocaleTest.assertEquals((String)"Returned incorrect string representation", (String)"en_CA_WIN32", (String)this.testLocale.toString());
        Locale l = new Locale("en", "");
        LocaleTest.assertEquals((String)"Wrong representation 1", (String)"en", (String)l.toString());
        l = new Locale("", "CA");
        LocaleTest.assertEquals((String)"Wrong representation 2", (String)"_CA", (String)l.toString());
        l = new Locale("", "CA", "var");
        LocaleTest.assertEquals((String)"Wrong representation 2.5", (String)"_CA_var", (String)l.toString());
        l = new Locale("en", "", "WIN");
        LocaleTest.assertEquals((String)"Wrong representation 4", (String)"en__WIN", (String)l.toString());
        l = new Locale("en", "CA");
        LocaleTest.assertEquals((String)"Wrong representation 6", (String)"en_CA", (String)l.toString());
        l = new Locale("en", "CA", "VAR");
        LocaleTest.assertEquals((String)"Wrong representation 7", (String)"en_CA_VAR", (String)l.toString());
        l = new Locale("", "", "var");
        LocaleTest.assertEquals((String)"Wrong representation 8", (String)"", (String)l.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        Locale l1 = new Locale("en", "US");
        Locale l2 = new Locale("fr", "CA");
        LocaleTest.assertTrue((l1.hashCode() != l2.hashCode() ? 1 : 0) != 0);
    }

    protected void setUp() {
        this.defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        this.testLocale = new Locale("en", "CA", "WIN32");
        this.l = new Locale("fr", "CA", "WIN32");
    }

    protected void tearDown() {
        Locale.setDefault(this.defaultLocale);
    }
}

