/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import tests.support.Support_ListTest;

@TestTargetClass(value=LinkedList.class)
public class LinkedListTest
extends TestCase {
    LinkedList ll;
    Object[] objArray;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedList", args={})
    public void test_Constructor() {
        new Support_ListTest("", this.ll).runTest();
        LinkedList<Integer> subList = new LinkedList<Integer>();
        for (int i = -50; i < 150; ++i) {
            subList.add(new Integer(i));
        }
        new Support_ListTest("", subList.subList(50, 150)).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedList", args={Collection.class})
    public void test_ConstructorLjava_util_Collection() {
        LinkedListTest.assertTrue((String)"Incorrect LinkedList constructed", (boolean)new LinkedList(this.ll).equals(this.ll));
        try {
            new LinkedList(null);
            LinkedListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={int.class, Object.class})
    public void test_addILjava_lang_Object() {
        String o = "Test";
        this.ll.add(50, "Test");
        LinkedListTest.assertTrue((String)("Failed to add Object>: " + this.ll.get(50).toString()), (this.ll.get(50) == o ? 1 : 0) != 0);
        LinkedListTest.assertTrue((String)"Failed to fix up list after insert", (this.ll.get(51) == this.objArray[50] && this.ll.get(52) == this.objArray[51] ? 1 : 0) != 0);
        this.ll.add(50, null);
        LinkedListTest.assertNull((String)"Did not add null correctly", this.ll.get(50));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void test_addLjava_lang_Object() {
        Object o = new Object();
        this.ll.add(o);
        LinkedListTest.assertTrue((String)"Failed to add Object", (this.ll.getLast() == o ? 1 : 0) != 0);
        this.ll.add(null);
        LinkedListTest.assertNull((String)"Did not add null correctly", this.ll.get(this.ll.size() - 1));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={int.class, Collection.class})
    public void test_addAllILjava_util_Collection() {
        int i;
        this.ll.addAll(50, (Collection)this.ll.clone());
        LinkedListTest.assertEquals((String)"Returned incorrect size after adding to existing list", (int)200, (int)this.ll.size());
        for (i = 0; i < 50; ++i) {
            LinkedListTest.assertTrue((String)"Manipulated elements < index", (this.ll.get(i) == this.objArray[i] ? 1 : 0) != 0);
        }
        for (i = 0; i >= 50 && i < 150; ++i) {
            LinkedListTest.assertTrue((String)"Failed to ad elements properly", (this.ll.get(i) == this.objArray[i - 50] ? 1 : 0) != 0);
        }
        for (i = 0; i >= 150 && i < 200; ++i) {
            LinkedListTest.assertTrue((String)"Failed to ad elements properly", (this.ll.get(i) == this.objArray[i - 100] ? 1 : 0) != 0);
        }
        LinkedList<String> myList = new LinkedList<String>();
        myList.add(null);
        myList.add("Blah");
        myList.add(null);
        myList.add("Booga");
        myList.add(null);
        this.ll.addAll(50, myList);
        LinkedListTest.assertNull((String)"a) List w/nulls not added correctly", this.ll.get(50));
        LinkedListTest.assertEquals((String)"b) List w/nulls not added correctly", (Object)"Blah", this.ll.get(51));
        LinkedListTest.assertNull((String)"c) List w/nulls not added correctly", this.ll.get(52));
        LinkedListTest.assertEquals((String)"d) List w/nulls not added correctly", (Object)"Booga", this.ll.get(53));
        LinkedListTest.assertNull((String)"e) List w/nulls not added correctly", this.ll.get(54));
        try {
            this.ll.addAll(-1, null);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.ll.addAll(this.ll.size() + 1, null);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.ll.addAll(0, null);
            LinkedListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies IndexOutOfBoundsException.", method="addAll", args={int.class, Collection.class})
    public void test_addAllILjava_util_Collection_2() {
        LinkedList obj = new LinkedList();
        try {
            obj.addAll(-1, null);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={Collection.class})
    public void test_addAllLjava_util_Collection() {
        int i;
        ArrayList l = new ArrayList();
        l.addAll((Collection)this.ll.clone());
        for (i = 0; i < this.ll.size(); ++i) {
            LinkedListTest.assertTrue((String)"Failed to add elements properly", (boolean)l.get(i).equals(this.ll.get(i)));
        }
        this.ll.addAll((Collection)this.ll.clone());
        LinkedListTest.assertEquals((String)"Returned incorrect siZe after adding to existing list", (int)200, (int)this.ll.size());
        for (i = 0; i < 100; ++i) {
            LinkedListTest.assertTrue((String)"Added to list in incorrect order", (boolean)this.ll.get(i).equals(l.get(i)));
            LinkedListTest.assertTrue((String)"Failed to add to existing list", (boolean)this.ll.get(i + 100).equals(l.get(i)));
        }
        LinkedList<String> myList = new LinkedList<String>();
        myList.add(null);
        myList.add("Blah");
        myList.add(null);
        myList.add("Booga");
        myList.add(null);
        this.ll.addAll(myList);
        LinkedListTest.assertNull((String)"a) List w/nulls not added correctly", this.ll.get(200));
        LinkedListTest.assertEquals((String)"b) List w/nulls not added correctly", (Object)"Blah", this.ll.get(201));
        LinkedListTest.assertNull((String)"c) List w/nulls not added correctly", this.ll.get(202));
        LinkedListTest.assertEquals((String)"d) List w/nulls not added correctly", (Object)"Booga", this.ll.get(203));
        LinkedListTest.assertNull((String)"e) List w/nulls not added correctly", this.ll.get(204));
        try {
            this.ll.addAll(null);
            LinkedListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addFirst", args={Object.class})
    public void test_addFirstLjava_lang_Object() {
        Object o = new Object();
        this.ll.addFirst(o);
        LinkedListTest.assertTrue((String)"Failed to add Object", (this.ll.getFirst() == o ? 1 : 0) != 0);
        this.ll.addFirst(null);
        LinkedListTest.assertNull((String)"Failed to add null", this.ll.getFirst());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addLast", args={Object.class})
    public void test_addLastLjava_lang_Object() {
        Object o = new Object();
        this.ll.addLast(o);
        LinkedListTest.assertTrue((String)"Failed to add Object", (this.ll.getLast() == o ? 1 : 0) != 0);
        this.ll.addLast(null);
        LinkedListTest.assertNull((String)"Failed to add null", this.ll.getLast());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        this.ll.clear();
        for (int i = 0; i < this.ll.size(); ++i) {
            LinkedListTest.assertNull((String)"Failed to clear list", this.ll.get(i));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        Object x = this.ll.clone();
        LinkedListTest.assertTrue((String)"Cloned list was inequal to cloned", (boolean)x.equals(this.ll));
        for (int i = 0; i < this.ll.size(); ++i) {
            LinkedListTest.assertTrue((String)"Cloned list contains incorrect elements", (boolean)this.ll.get(i).equals(((LinkedList)x).get(i)));
        }
        this.ll.addFirst(null);
        x = this.ll.clone();
        LinkedListTest.assertTrue((String)"List with a null did not clone properly", (boolean)this.ll.equals(x));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="contains", args={Object.class})
    public void test_containsLjava_lang_Object() {
        LinkedListTest.assertTrue((String)"Returned false for valid element", (boolean)this.ll.contains(this.objArray[99]));
        LinkedListTest.assertTrue((String)"Returned false for equal element", (boolean)this.ll.contains(new Integer(8)));
        LinkedListTest.assertTrue((String)"Returned true for invalid element", (!this.ll.contains(new Object()) ? 1 : 0) != 0);
        LinkedListTest.assertTrue((String)"Should not contain null", (!this.ll.contains(null) ? 1 : 0) != 0);
        this.ll.add(25, null);
        LinkedListTest.assertTrue((String)"Should contain null", (boolean)this.ll.contains(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={int.class})
    public void test_getI() {
        LinkedListTest.assertTrue((String)"Returned incorrect element", (this.ll.get(22) == this.objArray[22] ? 1 : 0) != 0);
        try {
            this.ll.get(8765);
            LinkedListTest.fail((String)"Failed to throw expected exception for index > size");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getFirst", args={})
    public void test_getFirst() {
        LinkedListTest.assertTrue((String)"Returned incorrect first element", (boolean)this.ll.getFirst().equals(this.objArray[0]));
        this.ll.clear();
        try {
            this.ll.getFirst();
            LinkedListTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getLast", args={})
    public void test_getLast() {
        LinkedListTest.assertTrue((String)"Returned incorrect first element", (boolean)this.ll.getLast().equals(this.objArray[this.objArray.length - 1]));
        this.ll.clear();
        try {
            this.ll.getLast();
            LinkedListTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="indexOf", args={Object.class})
    public void test_indexOfLjava_lang_Object() {
        LinkedListTest.assertEquals((String)"Returned incorrect index", (int)87, (int)this.ll.indexOf(this.objArray[87]));
        LinkedListTest.assertEquals((String)"Returned index for invalid Object", (int)-1, (int)this.ll.indexOf(new Object()));
        this.ll.add(20, null);
        this.ll.add(24, null);
        LinkedListTest.assertTrue((String)("Index of null should be 20, but got: " + this.ll.indexOf(null)), (this.ll.indexOf(null) == 20 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastIndexOf", args={Object.class})
    public void test_lastIndexOfLjava_lang_Object() {
        this.ll.add(new Integer(99));
        LinkedListTest.assertEquals((String)"Returned incorrect index", (int)100, (int)this.ll.lastIndexOf(this.objArray[99]));
        LinkedListTest.assertEquals((String)"Returned index for invalid Object", (int)-1, (int)this.ll.lastIndexOf(new Object()));
        this.ll.add(20, null);
        this.ll.add(24, null);
        LinkedListTest.assertTrue((String)("Last index of null should be 20, but got: " + this.ll.lastIndexOf(null)), (this.ll.lastIndexOf(null) == 24 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="listIterator", args={int.class})
    public void test_listIteratorI() {
        ListIterator i1 = this.ll.listIterator();
        ListIterator i2 = this.ll.listIterator(0);
        int n = 0;
        while (i2.hasNext()) {
            Object elm;
            if (n == 0 || n == this.objArray.length - 1) {
                if (n == 0) {
                    LinkedListTest.assertTrue((String)"First element claimed to have a previous", (!i2.hasPrevious() ? 1 : 0) != 0);
                }
                if (n == this.objArray.length) {
                    LinkedListTest.assertTrue((String)"Last element claimed to have next", (!i2.hasNext() ? 1 : 0) != 0);
                }
            }
            LinkedListTest.assertTrue((String)"Iterator returned elements in wrong order", ((elm = i2.next()) == this.objArray[n] ? 1 : 0) != 0);
            if (n > 0 && n < this.objArray.length - 1) {
                LinkedListTest.assertTrue((String)"Next index returned incorrect value", (i2.nextIndex() == n + 1 ? 1 : 0) != 0);
                LinkedListTest.assertTrue((String)("previousIndex returned incorrect value : " + i2.previousIndex() + ", n val: " + n), (i2.previousIndex() == n ? 1 : 0) != 0);
            }
            LinkedListTest.assertTrue((String)"Iterator returned elements in wrong order", ((elm = i1.next()) == this.objArray[n] ? 1 : 0) != 0);
            ++n;
        }
        i2 = this.ll.listIterator(this.ll.size() / 2);
        LinkedListTest.assertTrue(((Integer)i2.next() == this.ll.size() / 2 ? 1 : 0) != 0);
        LinkedList<String> myList = new LinkedList<String>();
        myList.add(null);
        myList.add("Blah");
        myList.add(null);
        myList.add("Booga");
        myList.add(null);
        ListIterator li = myList.listIterator();
        LinkedListTest.assertTrue((String)"li.hasPrevious() should be false", (!li.hasPrevious() ? 1 : 0) != 0);
        LinkedListTest.assertNull((String)"li.next() should be null", li.next());
        LinkedListTest.assertTrue((String)"li.hasPrevious() should be true", (boolean)li.hasPrevious());
        LinkedListTest.assertNull((String)"li.prev() should be null", li.previous());
        LinkedListTest.assertNull((String)"li.next() should be null", li.next());
        LinkedListTest.assertEquals((String)"li.next() should be Blah", (Object)"Blah", li.next());
        LinkedListTest.assertNull((String)"li.next() should be null", li.next());
        LinkedListTest.assertEquals((String)"li.next() should be Booga", (Object)"Booga", li.next());
        LinkedListTest.assertTrue((String)"li.hasNext() should be true", (boolean)li.hasNext());
        LinkedListTest.assertNull((String)"li.next() should be null", li.next());
        LinkedListTest.assertTrue((String)"li.hasNext() should be false", (!li.hasNext() ? 1 : 0) != 0);
        try {
            this.ll.listIterator(-1);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.ll.listIterator(this.ll.size() + 1);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={int.class})
    public void test_removeI() {
        this.ll.remove(10);
        LinkedListTest.assertEquals((String)"Failed to remove element", (int)-1, (int)this.ll.indexOf(this.objArray[10]));
        try {
            this.ll.remove(999);
            LinkedListTest.fail((String)"Failed to throw expected exception when index out of range");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.ll.add(20, null);
        this.ll.remove(20);
        LinkedListTest.assertNotNull((String)"Should have removed null", this.ll.get(20));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        LinkedListTest.assertTrue((String)"Failed to remove valid Object", (boolean)this.ll.remove(this.objArray[87]));
        LinkedListTest.assertTrue((String)"Removed invalid object", (!this.ll.remove(new Object()) ? 1 : 0) != 0);
        LinkedListTest.assertEquals((String)"Found Object after removal", (int)-1, (int)this.ll.indexOf(this.objArray[87]));
        this.ll.add(null);
        this.ll.remove(null);
        LinkedListTest.assertTrue((String)"Should not contain null afrer removal", (!this.ll.contains(null) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeFirst", args={})
    public void test_removeFirst() {
        this.ll.removeFirst();
        LinkedListTest.assertTrue((String)"Failed to remove first element", (this.ll.getFirst() != this.objArray[0] ? 1 : 0) != 0);
        this.ll.clear();
        try {
            this.ll.removeFirst();
            LinkedListTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeLast", args={})
    public void test_removeLast() {
        this.ll.removeLast();
        LinkedListTest.assertTrue((String)"Failed to remove last element", (this.ll.getLast() != this.objArray[this.objArray.length - 1] ? 1 : 0) != 0);
        this.ll.clear();
        try {
            this.ll.removeLast();
            LinkedListTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, Object.class})
    public void test_setILjava_lang_Object() {
        Object obj = new Object();
        this.ll.set(65, obj);
        LinkedListTest.assertTrue((String)"Failed to set object", (this.ll.get(65) == obj ? 1 : 0) != 0);
        try {
            obj = new Object();
            this.ll.set(-1, obj);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            obj = new Object();
            this.ll.set(this.ll.size() + 1, obj);
            LinkedListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        LinkedListTest.assertTrue((String)"Returned incorrect size", (this.ll.size() == this.objArray.length ? 1 : 0) != 0);
        this.ll.removeFirst();
        LinkedListTest.assertTrue((String)"Returned incorrect size", (this.ll.size() == this.objArray.length - 1 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={})
    public void test_toArray() {
        this.ll.add(null);
        Object[] obj = this.ll.toArray();
        LinkedListTest.assertEquals((String)"Returned array of incorrect size", (int)(this.objArray.length + 1), (int)obj.length);
        for (int i = 0; i < obj.length - 1; ++i) {
            LinkedListTest.assertTrue((String)("Returned incorrect array: " + i), (obj[i] == this.objArray[i] ? 1 : 0) != 0);
        }
        LinkedListTest.assertNull((String)"Returned incorrect array--end isn't null", (Object)obj[obj.length - 1]);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={Object[].class})
    public void test_toArray$Ljava_lang_Object() {
        Integer[] argArray = new Integer[100];
        Integer[] retArray = this.ll.toArray(argArray);
        LinkedListTest.assertTrue((String)"Returned different array than passed", (retArray == argArray ? 1 : 0) != 0);
        LinkedList<Integer> retList = new LinkedList<Integer>(Arrays.asList(retArray));
        Iterator li = this.ll.iterator();
        Iterator ri = retList.iterator();
        while (li.hasNext()) {
            LinkedListTest.assertTrue((String)"Lists are not equal", (li.next() == ri.next() ? 1 : 0) != 0);
        }
        argArray = new Integer[1000];
        retArray = this.ll.toArray(argArray);
        LinkedListTest.assertNull((String)"Failed to set first extra element to null", (Object)argArray[this.ll.size()]);
        for (int i = 0; i < this.ll.size(); ++i) {
            LinkedListTest.assertTrue((String)("Returned incorrect array: " + i), (retArray[i] == this.objArray[i] ? 1 : 0) != 0);
        }
        this.ll.add(50, null);
        argArray = new Integer[101];
        retArray = this.ll.toArray(argArray);
        LinkedListTest.assertTrue((String)"Returned different array than passed", (retArray == argArray ? 1 : 0) != 0);
        retArray = this.ll.toArray(argArray);
        LinkedListTest.assertTrue((String)"Returned different array than passed", (retArray == argArray ? 1 : 0) != 0);
        retList = new LinkedList<Integer>(Arrays.asList(retArray));
        li = this.ll.iterator();
        ri = retList.iterator();
        while (li.hasNext()) {
            LinkedListTest.assertTrue((String)"Lists are not equal", (li.next() == ri.next() ? 1 : 0) != 0);
        }
        try {
            this.ll.toArray((T[])null);
            LinkedListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LinkedList<String> lls = new LinkedList<String>();
        lls.add("First");
        lls.add("Second");
        try {
            lls.toArray(argArray);
            LinkedListTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="offer", args={Object.class})
    public void test_offer() {
        int origSize = this.ll.size();
        LinkedListTest.assertTrue((String)"offer() should return true'", (boolean)this.ll.offer(this.objArray[0]));
        LinkedListTest.assertEquals((String)"offer() should add an element as the last one", (int)origSize, (int)this.ll.lastIndexOf(this.objArray[0]));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="poll", args={})
    public void test_poll() {
        for (int i = 0; i < this.objArray.length; ++i) {
            LinkedListTest.assertEquals((String)"should remove the head", (Object)this.objArray[i], this.ll.poll());
        }
        LinkedListTest.assertEquals((String)"should be empty", (int)0, (int)this.ll.size());
        LinkedListTest.assertNull((String)"should return 'null' if list is empty", this.ll.poll());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={})
    public void test_remove() {
        for (int i = 0; i < this.objArray.length; ++i) {
            LinkedListTest.assertEquals((String)"should remove the head", (Object)this.objArray[i], this.ll.remove());
        }
        LinkedListTest.assertEquals((String)"should be empty", (int)0, (int)this.ll.size());
        try {
            this.ll.remove();
            LinkedListTest.fail((String)"NoSuchElementException is expected when removing from the empty list");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="element", args={})
    public void test_element() {
        LinkedListTest.assertEquals((String)"should return the head", (Object)this.objArray[0], this.ll.element());
        LinkedListTest.assertEquals((String)"element() should remove nothing", (int)this.objArray.length, (int)this.ll.size());
        try {
            new LinkedList().remove();
            LinkedListTest.fail((String)"NoSuchElementException is expected when the list is empty");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="peek", args={})
    public void test_peek() {
        LinkedListTest.assertEquals((String)"should remove the head", (Object)this.objArray[0], this.ll.peek());
        LinkedListTest.assertEquals((String)"should remove the head", (Object)this.objArray[0], this.ll.peek());
        this.ll.clear();
        LinkedListTest.assertNull((String)"should return 'null' if list is empty", this.ll.peek());
    }

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        this.objArray = new Object[100];
        for (i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
        }
        this.ll = new LinkedList();
        for (i = 0; i < this.objArray.length; ++i) {
            this.ll.add(this.objArray[i]);
        }
    }

    protected void tearDown() throws Exception {
        this.objArray = null;
        this.ll = null;
        super.tearDown();
    }
}

