/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=LinkedHashSet.class)
public class LinkedHashSetTest
extends TestCase {
    LinkedHashSet hs;
    Object[] objArray;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashSet", args={})
    public void test_Constructor() {
        LinkedHashSet hs2 = new LinkedHashSet();
        LinkedHashSetTest.assertEquals((String)"Created incorrect LinkedHashSet", (int)0, (int)hs2.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashSet", args={int.class})
    public void test_ConstructorI() {
        LinkedHashSet hs2 = new LinkedHashSet(5);
        LinkedHashSetTest.assertEquals((String)"Created incorrect LinkedHashSet", (int)0, (int)hs2.size());
        try {
            new LinkedHashSet(-1);
            LinkedHashSetTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashSet", args={int.class, float.class})
    public void test_ConstructorIF() {
        LinkedHashSet hs2 = new LinkedHashSet(5, 0.5f);
        LinkedHashSetTest.assertEquals((String)"Created incorrect LinkedHashSet", (int)0, (int)hs2.size());
        try {
            new LinkedHashSet(-1, 0.5f);
            LinkedHashSetTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new LinkedHashSet(1, -0.5f);
            LinkedHashSetTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new LinkedHashSet(1, 0.0f);
            LinkedHashSetTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashSet", args={Collection.class})
    public void test_ConstructorLjava_util_Collection() {
        LinkedHashSet<Object> hs2 = new LinkedHashSet<Object>(Arrays.asList(this.objArray));
        for (int counter = 0; counter < this.objArray.length; ++counter) {
            LinkedHashSetTest.assertTrue((String)"LinkedHashSet does not contain correct elements", (boolean)this.hs.contains(this.objArray[counter]));
        }
        LinkedHashSetTest.assertTrue((String)"LinkedHashSet created from collection incorrect size", (hs2.size() == this.objArray.length ? 1 : 0) != 0);
        try {
            new LinkedHashSet(null);
            LinkedHashSetTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void test_addLjava_lang_Object() {
        int size = this.hs.size();
        this.hs.add(new Integer(8));
        LinkedHashSetTest.assertTrue((String)"Added element already contained by set", (this.hs.size() == size ? 1 : 0) != 0);
        this.hs.add(new Integer(-9));
        LinkedHashSetTest.assertTrue((String)"Failed to increment set size after add", (this.hs.size() == size + 1 ? 1 : 0) != 0);
        LinkedHashSetTest.assertTrue((String)"Failed to add element to set", (boolean)this.hs.contains(new Integer(-9)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        Set orgSet = (Set)this.hs.clone();
        this.hs.clear();
        Iterator i = orgSet.iterator();
        LinkedHashSetTest.assertEquals((String)"Returned non-zero size after clear", (int)0, (int)this.hs.size());
        while (i.hasNext()) {
            LinkedHashSetTest.assertTrue((String)"Failed to clear set", (!this.hs.contains(i.next()) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        LinkedHashSet hs2 = (LinkedHashSet)this.hs.clone();
        LinkedHashSetTest.assertTrue((String)"clone returned an equivalent LinkedHashSet", (this.hs != hs2 ? 1 : 0) != 0);
        LinkedHashSetTest.assertTrue((String)"clone did not return an equal LinkedHashSet", (boolean)this.hs.equals(hs2));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies null as a parameter.", method="contains", args={Object.class})
    public void test_containsLjava_lang_Object() {
        LinkedHashSetTest.assertTrue((String)"Returned false for valid object", (boolean)this.hs.contains(this.objArray[90]));
        LinkedHashSetTest.assertTrue((String)"Returned true for invalid Object", (!this.hs.contains(new Object()) ? 1 : 0) != 0);
        LinkedHashSet s = new LinkedHashSet();
        s.add(null);
        LinkedHashSetTest.assertTrue((String)"Cannot handle null", (boolean)s.contains(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        LinkedHashSetTest.assertTrue((String)"Empty set returned false", (boolean)new LinkedHashSet().isEmpty());
        LinkedHashSetTest.assertTrue((String)"Non-empty set returned true", (!this.hs.isEmpty() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="iterator", args={})
    public void test_iterator() {
        Iterator i = this.hs.iterator();
        int x = 0;
        int j = 0;
        while (i.hasNext()) {
            Object oo = i.next();
            if (oo != null) {
                Integer ii = (Integer)oo;
                LinkedHashSetTest.assertTrue((String)"Incorrect element found", (ii == j ? 1 : 0) != 0);
            } else {
                LinkedHashSetTest.assertTrue((String)"Cannot find null", (boolean)this.hs.contains(oo));
            }
            ++x;
            ++j;
        }
        LinkedHashSetTest.assertTrue((String)"Returned iteration of incorrect size", (this.hs.size() == x ? 1 : 0) != 0);
        LinkedHashSet s = new LinkedHashSet();
        s.add(null);
        LinkedHashSetTest.assertNull((String)"Cannot handle null", s.iterator().next());
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify ClassCastException, NullPointerException, UnsupportedOperationException.", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        int size = this.hs.size();
        this.hs.remove(new Integer(98));
        LinkedHashSetTest.assertTrue((String)"Failed to remove element", (!this.hs.contains(new Integer(98)) ? 1 : 0) != 0);
        LinkedHashSetTest.assertTrue((String)"Failed to decrement set size", (this.hs.size() == size - 1 ? 1 : 0) != 0);
        LinkedHashSet s = new LinkedHashSet();
        s.add(null);
        LinkedHashSetTest.assertTrue((String)"Cannot handle null", (boolean)s.remove(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        LinkedHashSetTest.assertTrue((String)"Returned incorrect size", (this.hs.size() == this.objArray.length + 1 ? 1 : 0) != 0);
        this.hs.clear();
        LinkedHashSetTest.assertEquals((String)"Cleared set returned non-zero size", (int)0, (int)this.hs.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="retainAll", args={Collection.class})
    public void test_retainAllLjava_util_Collection() {
        Mock_LinkedHashSet lhs = new LinkedHashSet();
        Vector<Number> v = new Vector<Number>();
        v.add(new Float(3.14));
        lhs.add(new Integer(1));
        LinkedHashSetTest.assertEquals((int)1, (int)lhs.size());
        ((AbstractCollection)lhs).retainAll(v);
        LinkedHashSetTest.assertEquals((int)0, (int)lhs.size());
        v = new Vector();
        v.add(new Integer(1));
        v.add(new Integer(2));
        v.add(new Integer(3));
        v.add(new Integer(4));
        v.add(new Integer(5));
        v.add(new Integer(6));
        lhs.add(new Integer(1));
        lhs.add(new Integer(6));
        lhs.add(new Integer(7));
        lhs.add(new Integer(8));
        lhs.add(new Integer(9));
        lhs.add(new Integer(10));
        lhs.add(new Integer(11));
        lhs.add(new Integer(12));
        lhs.add(new Integer(13));
        LinkedHashSetTest.assertEquals((int)9, (int)lhs.size());
        ((AbstractCollection)lhs).retainAll(v);
        LinkedHashSetTest.assertEquals((int)2, (int)lhs.size());
        try {
            ((AbstractCollection)lhs).retainAll(null);
            LinkedHashSetTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        lhs = new Mock_LinkedHashSet();
        try {
            ((AbstractCollection)lhs).retainAll(v);
            LinkedHashSetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={})
    public void test_toArray() {
        LinkedHashSet<Integer> lhs = new LinkedHashSet<Integer>();
        lhs.add(new Integer(1));
        lhs.add(new Integer(6));
        lhs.add(new Integer(7));
        lhs.add(new Integer(8));
        lhs.add(new Integer(9));
        lhs.add(new Integer(10));
        lhs.add(new Integer(11));
        lhs.add(new Integer(12));
        lhs.add(new Integer(13));
        Object[] o = lhs.toArray();
        for (int i = 0; i < o.length; ++i) {
            LinkedHashSetTest.assertTrue((boolean)lhs.contains(o[i]));
        }
        LinkedHashSetTest.assertEquals((int)lhs.size(), (int)o.length);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={Object[].class})
    public void test_toArray$Ljava_lang_Object() {
        LinkedHashSet<Integer> lhs = new LinkedHashSet<Integer>();
        lhs.add(new Integer(1));
        lhs.add(new Integer(6));
        lhs.add(new Integer(7));
        lhs.add(new Integer(8));
        lhs.add(new Integer(9));
        lhs.add(new Integer(10));
        lhs.add(new Integer(11));
        lhs.add(new Integer(12));
        lhs.add(new Integer(13));
        Object[] o1 = new Object[lhs.size()];
        Double[] o2 = new Double[lhs.size()];
        lhs.toArray(o1);
        for (int i = 0; i < o1.length; ++i) {
            LinkedHashSetTest.assertTrue((boolean)lhs.contains(o1[i]));
        }
        try {
            lhs.toArray((T[])null);
            LinkedHashSetTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            lhs.toArray(o2);
            LinkedHashSetTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
    }

    protected void setUp() {
        int i;
        this.objArray = new Object[1000];
        for (i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
        }
        this.hs = new LinkedHashSet();
        for (i = 0; i < this.objArray.length; ++i) {
            this.hs.add(this.objArray[i]);
        }
        this.hs.add(null);
    }

    protected void tearDown() {
        this.objArray = null;
        this.hs = null;
    }

    class Mock_LinkedHashSet
    extends LinkedHashSet {
        Mock_LinkedHashSet() {
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }
}

