/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;
import tests.support.Support_MapTest2;

@TestTargetClass(value=IdentityHashMap.class)
public class IdentityHashMapTest
extends TestCase {
    private static final String ID = "hello";
    IdentityHashMap hm;
    static final int hmSize = 1000;
    Object[] objArray;
    Object[] objArray2;
    private static final SerializationTest.SerializableAssert comparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            IdentityHashMap initialMap = (IdentityHashMap)initial;
            IdentityHashMap deseriaMap = (IdentityHashMap)deserialized;
            Assert.assertEquals((String)"should be equal", (int)initialMap.size(), (int)deseriaMap.size());
        }
    };

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="IdentityHashMap", args={})
    public void test_Constructor() {
        new Support_MapTest2(new IdentityHashMap<String, String>()).runTest();
        IdentityHashMap hm2 = new IdentityHashMap();
        IdentityHashMapTest.assertEquals((String)"Created incorrect IdentityHashMap", (int)0, (int)hm2.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="IdentityHashMap", args={int.class})
    public void test_ConstructorI() {
        IdentityHashMap hm2 = new IdentityHashMap(5);
        IdentityHashMapTest.assertEquals((String)"Created incorrect IdentityHashMap", (int)0, (int)hm2.size());
        try {
            new IdentityHashMap(-1);
            IdentityHashMapTest.fail((String)"Failed to throw IllegalArgumentException for initial capacity < 0");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        IdentityHashMap<String, String> empty = new IdentityHashMap<String, String>(0);
        IdentityHashMapTest.assertNull((String)"Empty IdentityHashMap access", empty.get("nothing"));
        empty.put("something", "here");
        IdentityHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="IdentityHashMap", args={Map.class})
    public void test_ConstructorLjava_util_Map() {
        TreeMap<Object, Object> myMap = new TreeMap<Object, Object>();
        for (int counter = 0; counter < 1000; ++counter) {
            myMap.put(this.objArray2[counter], this.objArray[counter]);
        }
        IdentityHashMap hm2 = new IdentityHashMap(myMap);
        for (int counter = 0; counter < 1000; ++counter) {
            IdentityHashMapTest.assertTrue((String)"Failed to construct correct IdentityHashMap", (this.hm.get(this.objArray2[counter]) == hm2.get(this.objArray2[counter]) ? 1 : 0) != 0);
        }
        MockMap mockMap = new MockMap();
        hm2 = new IdentityHashMap(mockMap);
        IdentityHashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)hm2.size());
        try {
            new IdentityHashMap(null);
            IdentityHashMapTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        this.hm.clear();
        IdentityHashMapTest.assertEquals((String)"Clear failed to reset size", (int)0, (int)this.hm.size());
        for (int i = 0; i < 1000; ++i) {
            IdentityHashMapTest.assertNull((String)"Failed to clear all elements", this.hm.get(this.objArray2[i]));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        IdentityHashMap hm2 = (IdentityHashMap)this.hm.clone();
        IdentityHashMapTest.assertTrue((String)"Clone answered equivalent IdentityHashMap", (hm2 != this.hm ? 1 : 0) != 0);
        for (int counter = 0; counter < 1000; ++counter) {
            IdentityHashMapTest.assertTrue((String)"Clone answered unequal IdentityHashMap", (this.hm.get(this.objArray2[counter]) == hm2.get(this.objArray2[counter]) ? 1 : 0) != 0);
        }
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        map.put("key", "value");
        Set keys = map.keySet();
        Collection values = map.values();
        IdentityHashMapTest.assertEquals((String)"values() does not work", (Object)"value", values.iterator().next());
        IdentityHashMapTest.assertEquals((String)"keySet() does not work", (Object)"key", keys.iterator().next());
        AbstractMap map2 = (AbstractMap)map.clone();
        map2.put("key", "value2");
        Collection values2 = map2.values();
        IdentityHashMapTest.assertTrue((String)"values() is identical", (values2 != values ? 1 : 0) != 0);
        IdentityHashMapTest.assertEquals((String)"values() was not cloned", (Object)"value2", values2.iterator().next());
        map2.clear();
        map2.put("key2", "value3");
        Set key2 = map2.keySet();
        IdentityHashMapTest.assertTrue((String)"keySet() is identical", (key2 != keys ? 1 : 0) != 0);
        IdentityHashMapTest.assertEquals((String)"keySet() was not cloned", (Object)"key2", key2.iterator().next());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsKey", args={Object.class})
    public void test_containsKeyLjava_lang_Object() {
        IdentityHashMapTest.assertTrue((String)"Returned false for valid key", (boolean)this.hm.containsKey(this.objArray2[23]));
        IdentityHashMapTest.assertTrue((String)"Returned true for copy of valid key", (!this.hm.containsKey(new Integer(23).toString()) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"Returned true for invalid key", (!this.hm.containsKey("KKDKDKD") ? 1 : 0) != 0);
        IdentityHashMap m = new IdentityHashMap();
        m.put(null, "test");
        IdentityHashMapTest.assertTrue((String)"Failed with null key", (boolean)m.containsKey(null));
        IdentityHashMapTest.assertTrue((String)"Failed with missing key matching null hash", (!m.containsKey(new Integer(0)) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsValue", args={Object.class})
    public void test_containsValueLjava_lang_Object() {
        IdentityHashMapTest.assertTrue((String)"Returned false for valid value", (boolean)this.hm.containsValue(this.objArray[19]));
        IdentityHashMapTest.assertTrue((String)"Returned true for invalid valie", (!this.hm.containsValue(new Integer(-9)) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="entrySet", args={})
    public void test_entrySet() {
        Set s = this.hm.entrySet();
        Iterator i = s.iterator();
        IdentityHashMapTest.assertTrue((String)"Returned set of incorrect size", (this.hm.size() == s.size() ? 1 : 0) != 0);
        while (i.hasNext()) {
            Map.Entry m = i.next();
            IdentityHashMapTest.assertTrue((String)"Returned incorrect entry set", (this.hm.containsKey(m.getKey()) && this.hm.containsValue(m.getValue()) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})
    public void test_getLjava_lang_Object() {
        IdentityHashMapTest.assertNull((String)"Get returned non-null for non existent key", this.hm.get("T"));
        this.hm.put("T", "HELLO");
        IdentityHashMapTest.assertEquals((String)"Get returned incorecct value for existing key", (Object)"HELLO", this.hm.get("T"));
        IdentityHashMap m = new IdentityHashMap();
        m.put(null, "test");
        IdentityHashMapTest.assertEquals((String)"Failed with null key", (Object)"test", m.get(null));
        IdentityHashMapTest.assertNull((String)"Failed with missing key matching null hash", m.get(new Integer(0)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        IdentityHashMapTest.assertTrue((String)"Returned false for new map", (boolean)new IdentityHashMap().isEmpty());
        IdentityHashMapTest.assertTrue((String)"Returned true for non-empty", (!this.hm.isEmpty() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keySet", args={})
    public void test_keySet() {
        Set s = this.hm.keySet();
        IdentityHashMapTest.assertTrue((String)"Returned set of incorrect size()", (s.size() == this.hm.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.objArray.length; ++i) {
            IdentityHashMapTest.assertTrue((String)"Returned set does not contain all keys", (boolean)s.contains(this.objArray2[i]));
        }
        IdentityHashMap m = new IdentityHashMap();
        m.put(null, "test");
        IdentityHashMapTest.assertTrue((String)"Failed with null key", (boolean)m.keySet().contains(null));
        IdentityHashMapTest.assertNull((String)"Failed with null key", m.keySet().iterator().next());
        IdentityHashMap<Integer, String> map = new IdentityHashMap<Integer, String>(101);
        map.put(new Integer(1), "1");
        map.put(new Integer(102), "102");
        map.put(new Integer(203), "203");
        Iterator it = map.keySet().iterator();
        Integer remove1 = (Integer)it.next();
        it.hasNext();
        it.remove();
        Integer remove2 = (Integer)it.next();
        it.remove();
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(new Integer(1), new Integer(102), new Integer(203)));
        list.remove(remove1);
        list.remove(remove2);
        IdentityHashMapTest.assertTrue((String)"Wrong result", (boolean)it.next().equals(list.get(0)));
        IdentityHashMapTest.assertEquals((String)"Wrong size", (int)1, (int)map.size());
        IdentityHashMapTest.assertTrue((String)"Wrong contents", (boolean)map.keySet().iterator().next().equals(list.get(0)));
        IdentityHashMap<Integer, String> map2 = new IdentityHashMap<Integer, String>(101);
        map2.put(new Integer(1), "1");
        map2.put(new Integer(4), "4");
        Iterator it2 = map2.keySet().iterator();
        Integer remove3 = (Integer)it2.next();
        Integer next = remove3 == 1 ? new Integer(4) : new Integer(1);
        it2.hasNext();
        it2.remove();
        IdentityHashMapTest.assertTrue((String)"Wrong result 2", (boolean)it2.next().equals(next));
        IdentityHashMapTest.assertEquals((String)"Wrong size 2", (int)1, (int)map2.size());
        IdentityHashMapTest.assertTrue((String)"Wrong contents 2", (boolean)map2.keySet().iterator().next().equals(next));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="put", args={Object.class, Object.class})
    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        this.hm.put("KEY", "VALUE");
        IdentityHashMapTest.assertEquals((String)"Failed to install key/value pair", (Object)"VALUE", this.hm.get("KEY"));
        IdentityHashMap<Number, String> m = new IdentityHashMap<Number, String>();
        Short s0 = new Short(0);
        m.put(s0, "short");
        m.put(null, "test");
        Integer i0 = new Integer(0);
        m.put(i0, "int");
        IdentityHashMapTest.assertEquals((String)"Failed adding to bucket containing null", (Object)"short", m.get(s0));
        IdentityHashMapTest.assertEquals((String)"Failed adding to bucket containing null2", (Object)"int", m.get(i0));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="putAll", args={Map.class})
    public void test_putAllLjava_util_Map() {
        IdentityHashMap hm2 = new IdentityHashMap();
        hm2.putAll(this.hm);
        for (int i = 0; i < 1000; ++i) {
            IdentityHashMapTest.assertTrue((String)"Failed to clear all elements", (boolean)hm2.get(this.objArray2[i]).equals(new Integer(i)));
        }
        hm2 = new IdentityHashMap();
        MockMap mockMap = new MockMap();
        hm2.putAll(mockMap);
        IdentityHashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)hm2.size());
        try {
            hm2.putAll(null);
            IdentityHashMapTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        int size = this.hm.size();
        Integer x = (Integer)this.hm.remove(this.objArray2[9]);
        IdentityHashMapTest.assertTrue((String)"Remove returned incorrect value", (boolean)x.equals(new Integer(9)));
        IdentityHashMapTest.assertNull((String)"Failed to remove given key", this.hm.get(this.objArray2[9]));
        IdentityHashMapTest.assertTrue((String)"Failed to decrement size", (this.hm.size() == size - 1 ? 1 : 0) != 0);
        IdentityHashMapTest.assertNull((String)"Remove of non-existent key returned non-null", this.hm.remove("LCLCLC"));
        IdentityHashMap m = new IdentityHashMap();
        m.put(null, "test");
        IdentityHashMapTest.assertNull((String)"Failed with same hash as null", m.remove(this.objArray[0]));
        IdentityHashMapTest.assertEquals((String)"Failed with null key", (Object)"test", m.remove(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        IdentityHashMapTest.assertEquals((String)"Returned incorrect size, ", (int)(this.objArray.length + 2), (int)this.hm.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        IdentityHashMap<String, String> mapOne = new IdentityHashMap<String, String>();
        IdentityHashMap<String, String> mapTwo = new IdentityHashMap<String, String>();
        IdentityHashMap<String, String> mapThree = new IdentityHashMap<String, String>();
        IdentityHashMap<String, String> mapFour = new IdentityHashMap<String, String>();
        String one = "one";
        String alsoOne = new String(one);
        String two = "two";
        String alsoTwo = new String(two);
        mapOne.put(one, two);
        mapFour.put(one, two);
        mapTwo.put(alsoOne, two);
        mapThree.put(one, alsoTwo);
        IdentityHashMapTest.assertEquals((String)"failure of equality of IdentityHashMaps", mapOne, mapFour);
        IdentityHashMapTest.assertTrue((String)"failure of non-equality of IdentityHashMaps one and two", (!mapOne.equals(mapTwo) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"failure of non-equality of IdentityHashMaps one and three", (!mapOne.equals(mapThree) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"failure of non-equality of IdentityHashMaps two and three", (!mapTwo.equals(mapThree) ? 1 : 0) != 0);
        HashMap<String, String> hashMapTwo = new HashMap<String, String>();
        HashMap<String, String> hashMapThree = new HashMap<String, String>();
        hashMapTwo.put(alsoOne, two);
        hashMapThree.put(one, alsoTwo);
        IdentityHashMapTest.assertTrue((String)"failure of non-equality of IdentityHashMaps one and Hashmap two", (!mapOne.equals(hashMapTwo) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"failure of non-equality of IdentityHashMaps one and Hashmap three", (!mapOne.equals(hashMapThree) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="values", args={})
    public void test_values() {
        Collection c = this.hm.values();
        IdentityHashMapTest.assertTrue((String)"Returned collection of incorrect size()", (c.size() == this.hm.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.objArray.length; ++i) {
            IdentityHashMapTest.assertTrue((String)"Returned collection does not contain all keys", (boolean)c.contains(this.objArray[i]));
        }
        IdentityHashMap<Object, Object> myIdentityHashMap = new IdentityHashMap<Object, Object>();
        for (int i = 0; i < 100; ++i) {
            myIdentityHashMap.put(this.objArray2[i], this.objArray[i]);
        }
        Collection values = myIdentityHashMap.values();
        values.remove(this.objArray[0]);
        IdentityHashMapTest.assertTrue((String)"Removing from the values collection should remove from the original map", (!myIdentityHashMap.containsValue(this.objArray2[0]) ? 1 : 0) != 0);
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationSelf", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationGolden", args={})})
    public void test_Serialization() throws Exception {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        map.put(ID, "world");
        map.put(null, "null");
        SerializationTest.verifySelf(map, comparator);
        SerializationTest.verifyGolden((TestCase)this, map, comparator);
    }

    protected void setUp() {
        int i;
        this.objArray = new Object[1000];
        this.objArray2 = new Object[1000];
        for (i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
            this.objArray2[i] = new String(this.objArray[i].toString());
        }
        this.hm = new IdentityHashMap();
        for (i = 0; i < this.objArray.length; ++i) {
            this.hm.put(this.objArray2[i], this.objArray[i]);
        }
        this.hm.put("test", null);
        this.hm.put(null, "test");
    }

    protected void tearDown() {
        this.objArray = null;
        this.objArray2 = null;
        this.hm = null;
    }

    class MockMap
    extends AbstractMap {
        MockMap() {
        }

        public Set entrySet() {
            return null;
        }

        public int size() {
            return 0;
        }
    }
}

