/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import junit.framework.TestCase;
import tests.support.Support_MapTest2;
import tests.support.Support_UnmodifiableCollectionTest;

@TestTargetClass(value=Hashtable.class)
public class HashtableTest
extends TestCase {
    private Hashtable ht10;
    private Hashtable ht100;
    private Hashtable htfull;
    private Vector keyVector;
    private Vector elmVector;
    private String h10sVal;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Hashtable", args={})
    public void test_Constructor() {
        new Support_MapTest2(new Hashtable<String, String>()).runTest();
        Hashtable h = new Hashtable();
        HashtableTest.assertEquals((String)"Created incorrect hashtable", (int)0, (int)h.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Hashtable", args={int.class})
    public void test_ConstructorI() {
        Hashtable h = new Hashtable(9);
        HashtableTest.assertEquals((String)"Created incorrect hashtable", (int)0, (int)h.size());
        Hashtable<String, String> empty = new Hashtable<String, String>(0);
        HashtableTest.assertNull((String)"Empty hashtable access", empty.get("nothing"));
        empty.put("something", "here");
        HashtableTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
        try {
            new Hashtable(-1);
            HashtableTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Hashtable", args={int.class, float.class})
    public void test_ConstructorIF() {
        Hashtable h = new Hashtable(10, 0.5f);
        HashtableTest.assertEquals((String)"Created incorrect hashtable", (int)0, (int)h.size());
        Hashtable<String, String> empty = new Hashtable<String, String>(0, 0.75f);
        HashtableTest.assertNull((String)"Empty hashtable access", empty.get("nothing"));
        empty.put("something", "here");
        HashtableTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
        try {
            new Hashtable(-1, 0.75f);
            HashtableTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Hashtable(0, -0.75f);
            HashtableTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Hashtable", args={Map.class})
    public void test_ConstructorLjava_util_Map() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String firstVal = "Gabba";
        Integer secondVal = new Integer(5);
        map.put("Gah", firstVal);
        map.put("Ooga", secondVal);
        Hashtable ht = new Hashtable(map);
        HashtableTest.assertTrue((String)"a) Incorrect Hashtable constructed", (ht.get("Gah") == firstVal ? 1 : 0) != 0);
        HashtableTest.assertTrue((String)"b) Incorrect Hashtable constructed", (ht.get("Ooga") == secondVal ? 1 : 0) != 0);
        try {
            new Hashtable(null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Hashtable", args={Map.class})
    public void test_ConversionConstructorNullValue() {
        Map<String, Object> map = Collections.singletonMap("Dog", null);
        try {
            new Hashtable<String, Object>(map);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        Hashtable h = this.hashtableClone(this.htfull);
        h.clear();
        HashtableTest.assertEquals((String)"Hashtable was not cleared", (int)0, (int)h.size());
        Enumeration el = h.elements();
        Enumeration keys = h.keys();
        HashtableTest.assertTrue((String)"Hashtable improperly cleared", (!el.hasMoreElements() && !keys.hasMoreElements() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        Hashtable h = (Hashtable)this.htfull.clone();
        HashtableTest.assertTrue((String)"Clone different size than original", (h.size() == this.htfull.size() ? 1 : 0) != 0);
        Enumeration org = this.htfull.keys();
        Enumeration cpy = h.keys();
        while (org.hasMoreElements()) {
            String okey = (String)org.nextElement();
            String ckey = (String)cpy.nextElement();
            HashtableTest.assertTrue((String)"Key comparison failed", (boolean)okey.equals(ckey));
            HashtableTest.assertTrue((String)"Value comparison failed", (boolean)((String)this.htfull.get(okey)).equals((String)h.get(ckey)));
        }
        HashtableTest.assertTrue((String)"Copy has more keys than original", (!cpy.hasMoreElements() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="contains", args={Object.class})
    public void test_containsLjava_lang_Object() {
        HashtableTest.assertTrue((String)"Element not found", (boolean)this.ht10.contains("Val 7"));
        HashtableTest.assertTrue((String)"Invalid element found", (!this.ht10.contains("ZZZZZZZZZZZZZZZZ") ? 1 : 0) != 0);
        try {
            this.ht10.contains(null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsKey", args={Object.class})
    public void test_containsKeyLjava_lang_Object() {
        HashtableTest.assertTrue((String)"Failed to find key", (boolean)this.htfull.containsKey("FKey 4"));
        HashtableTest.assertTrue((String)"Failed to find key", (!this.htfull.containsKey("FKey 99") ? 1 : 0) != 0);
        try {
            this.htfull.containsKey(null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsValue", args={Object.class})
    public void test_containsValueLjava_lang_Object() {
        Enumeration e = this.elmVector.elements();
        while (e.hasMoreElements()) {
            HashtableTest.assertTrue((String)"Returned false for valid value", (boolean)this.ht10.containsValue(e.nextElement()));
        }
        HashtableTest.assertTrue((String)"Returned true for invalid value", (!this.ht10.containsValue(new Object()) ? 1 : 0) != 0);
        try {
            this.ht10.containsValue(null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="elements", args={})
    public void test_elements() {
        Enumeration elms = this.ht10.elements();
        int i = 0;
        while (elms.hasMoreElements()) {
            String s = (String)elms.nextElement();
            HashtableTest.assertTrue((String)"Missing key from enumeration", (boolean)this.elmVector.contains(s));
            ++i;
        }
        HashtableTest.assertEquals((String)"All keys not retrieved", (int)10, (int)this.ht10.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="entrySet", args={})
    public void test_entrySet() {
        Set s = this.ht10.entrySet();
        HashSet s2 = new HashSet();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            s2.add(i.next().getValue());
        }
        Enumeration e = this.elmVector.elements();
        while (e.hasMoreElements()) {
            HashtableTest.assertTrue((String)"Returned incorrect entry set", (boolean)s2.contains(e.nextElement()));
        }
        boolean exception = false;
        try {
            this.ht10.entrySet().iterator().next().setValue(null);
        }
        catch (NullPointerException e1) {
            exception = true;
        }
        HashtableTest.assertTrue((String)"Should not be able to assign null to a Hashtable entrySet() Map.Entry", (boolean)exception);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        Hashtable h = this.hashtableClone(this.ht10);
        HashtableTest.assertTrue((String)"Returned false for equal tables", (boolean)this.ht10.equals(h));
        HashtableTest.assertTrue((String)"Returned true for unequal tables", (!this.ht10.equals(this.htfull) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})
    public void test_getLjava_lang_Object() {
        Hashtable h = this.hashtableClone(this.htfull);
        HashtableTest.assertEquals((String)"Could not retrieve element", (String)"FVal 2", (String)((String)h.get("FKey 2")));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        Set entrySet = this.ht10.entrySet();
        Iterator iterator = entrySet.iterator();
        int expectedHash = 0;
        while (iterator.hasNext()) {
            expectedHash += ((Object)iterator.next()).hashCode();
        }
        HashtableTest.assertTrue((String)("Incorrect hashCode returned.  Wanted: " + expectedHash + " got: " + this.ht10.hashCode()), (expectedHash == this.ht10.hashCode() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        HashtableTest.assertTrue((String)"isEmpty returned incorrect value", (!this.ht10.isEmpty() ? 1 : 0) != 0);
        HashtableTest.assertTrue((String)"isEmpty returned incorrect value", (boolean)new Hashtable().isEmpty());
        final Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("0", "");
        Thread t1 = new Thread(){

            public void run() {
                while (!ht.isEmpty()) {
                }
                ht.put("final", "");
            }
        };
        t1.start();
        for (int i = 1; i < 10000; ++i) {
            Hashtable<String, String> hashtable = ht;
            synchronized (hashtable) {
                ht.remove(String.valueOf(i - 1));
                ht.put(String.valueOf(i), "");
            }
            int size = ht.size();
            if (size == 1) continue;
            String result = "Size is not 1: " + size + " " + ht;
            ht.clear();
            HashtableTest.fail((String)result);
        }
        ht.clear();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keys", args={})
    public void test_keys() {
        Enumeration keys = this.ht10.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String s = (String)keys.nextElement();
            HashtableTest.assertTrue((String)"Missing key from enumeration", (boolean)this.keyVector.contains(s));
            ++i;
        }
        HashtableTest.assertEquals((String)"All keys not retrieved", (int)10, (int)this.ht10.size());
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="keys", args={})
    public void test_keys_subtest0() {
        Hashtable<String, String> ht = new Hashtable<String, String>(3);
        ht.put("initial", "");
        Enumeration en = ht.keys();
        en.hasMoreElements();
        ht.remove("initial");
        boolean exception = false;
        try {
            Object result = en.nextElement();
            HashtableTest.assertTrue((String)("unexpected: " + result), (boolean)"initial".equals(result));
        }
        catch (NoSuchElementException e) {
            exception = true;
        }
        HashtableTest.assertTrue((String)"unexpected NoSuchElementException", (!exception ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keySet", args={})
    public void test_keySet() {
        Set s = this.ht10.keySet();
        Enumeration e = this.keyVector.elements();
        while (e.hasMoreElements()) {
            HashtableTest.assertTrue((String)"Returned incorrect key set", (boolean)s.contains(e.nextElement()));
        }
        Hashtable<Integer, String> map = new Hashtable<Integer, String>(101);
        map.put(new Integer(1), "1");
        map.put(new Integer(102), "102");
        map.put(new Integer(203), "203");
        Iterator it = map.keySet().iterator();
        Integer remove1 = (Integer)it.next();
        it.remove();
        Integer remove2 = (Integer)it.next();
        it.remove();
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(new Integer(1), new Integer(102), new Integer(203)));
        list.remove(remove1);
        list.remove(remove2);
        HashtableTest.assertTrue((String)"Wrong result", (boolean)it.next().equals(list.get(0)));
        HashtableTest.assertEquals((String)"Wrong size", (int)1, (int)map.size());
        HashtableTest.assertTrue((String)"Wrong contents", (boolean)map.keySet().iterator().next().equals(list.get(0)));
        Hashtable<Integer, String> map2 = new Hashtable<Integer, String>(101);
        map2.put(new Integer(1), "1");
        map2.put(new Integer(4), "4");
        Iterator it2 = map2.keySet().iterator();
        Integer remove3 = (Integer)it2.next();
        Integer next = remove3 == 1 ? new Integer(4) : new Integer(1);
        it2.hasNext();
        it2.remove();
        HashtableTest.assertTrue((String)"Wrong result 2", (boolean)it2.next().equals(next));
        HashtableTest.assertEquals((String)"Wrong size 2", (int)1, (int)map2.size());
        HashtableTest.assertTrue((String)"Wrong contents 2", (boolean)map2.keySet().iterator().next().equals(next));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="keySet", args={})
    public void test_keySet_subtest0() {
        Set s1 = this.ht10.keySet();
        HashtableTest.assertTrue((String)"should contain key", (boolean)s1.remove("Key 0"));
        HashtableTest.assertTrue((String)"should not contain key", (!s1.remove("Key 0") ? 1 : 0) != 0);
        int iterations = 10000;
        final Hashtable ht = new Hashtable();
        Thread t1 = new Thread(){

            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    ht.put(String.valueOf(i), "");
                    ht.remove(String.valueOf(i));
                }
            }
        };
        t1.start();
        Set set = ht.keySet();
        for (int i = 0; i < 10000; ++i) {
            Iterator it = set.iterator();
            try {
                it.next();
                it.remove();
                int size = ht.size();
                if (size >= 0) continue;
                HashtableTest.fail((String)("invalid size: " + size));
                continue;
            }
            catch (NoSuchElementException e) {
                continue;
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="put", args={Object.class, Object.class})
    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        Hashtable h = this.hashtableClone(this.ht100);
        Integer key = new Integer(100);
        h.put("Value 100", key);
        HashtableTest.assertTrue((String)"Key/Value not inserted", (h.size() == 1 && h.contains(key) ? 1 : 0) != 0);
        h = this.hashtableClone(this.htfull);
        h.put("Value 100", key);
        HashtableTest.assertTrue((String)"Key/Value not inserted into full table", (h.size() == 8 && h.contains(key) ? 1 : 0) != 0);
        try {
            h.put(null, key);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            h.put("Value 100", null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="putAll", args={Map.class})
    public void test_putAllLjava_util_Map() {
        Hashtable h = new Hashtable();
        h.putAll(this.ht10);
        Enumeration e = this.keyVector.elements();
        while (e.hasMoreElements()) {
            Object x = e.nextElement();
            HashtableTest.assertTrue((String)"Failed to put all elements", (boolean)h.get(x).equals(this.ht10.get(x)));
        }
        try {
            h.putAll(null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        Hashtable h = this.hashtableClone(this.htfull);
        Object k = h.remove("FKey 0");
        HashtableTest.assertTrue((String)"Remove failed", (!h.containsKey("FKey 0") || k == null ? 1 : 0) != 0);
        HashtableTest.assertNull(h.remove("FKey 0"));
        try {
            h.remove(null);
            HashtableTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        HashtableTest.assertTrue((String)"Returned invalid size", (this.ht10.size() == 10 && this.ht100.size() == 0 ? 1 : 0) != 0);
        final Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("0", "");
        Thread t1 = new Thread(){

            public void run() {
                while (ht.size() > 0) {
                }
                ht.put("final", "");
            }
        };
        t1.start();
        for (int i = 1; i < 10000; ++i) {
            Hashtable<String, String> hashtable = ht;
            synchronized (hashtable) {
                ht.remove(String.valueOf(i - 1));
                ht.put(String.valueOf(i), "");
            }
            int size = ht.size();
            if (size == 1) continue;
            String result = "Size is not 1: " + size + " " + ht;
            ht.clear();
            HashtableTest.fail((String)result);
        }
        ht.clear();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        Hashtable<Object, Object> h = new Hashtable<Object, Object>();
        HashtableTest.assertEquals((String)"Incorrect toString for Empty table", (String)"{}", (String)h.toString());
        h.put("one", "1");
        h.put("two", h);
        h.put(h, "3");
        h.put(h, h);
        String result = h.toString();
        HashtableTest.assertTrue((String)"should contain self ref", (result.indexOf("(this") > -1 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="values", args={})
    public void test_values() {
        Collection c = this.ht10.values();
        Enumeration e = this.elmVector.elements();
        while (e.hasMoreElements()) {
            HashtableTest.assertTrue((String)"Returned incorrect values", (boolean)c.contains(e.nextElement()));
        }
        Hashtable<Integer, Integer> myHashtable = new Hashtable<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            myHashtable.put(new Integer(i), new Integer(i));
        }
        Collection<Integer> values = myHashtable.values();
        new Support_UnmodifiableCollectionTest("Test Returned Collection From Hashtable.values()", values).runTest();
        values.remove(new Integer(0));
        HashtableTest.assertTrue((String)"Removing from the values collection should remove from the original map", (!myHashtable.containsValue(new Integer(0)) ? 1 : 0) != 0);
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="entrySet", args={}), @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="remove", args={Object.class})})
    public void test_entrySet_remove() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("my.nonexistent.prop", "AAA");
        hashtable.put("parse.error", "BBB");
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (!value.equals("AAA")) continue;
            iterator.remove();
        }
        HashtableTest.assertFalse((boolean)hashtable.containsKey("my.nonexistent.prop"));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="rehash", args={})
    public void test_rehash() {
        Mock_Hashtable mht = new Mock_Hashtable(5);
        HashtableTest.assertFalse((boolean)mht.isRehashed());
        for (int i = 0; i < 10; ++i) {
            mht.put(i, "New value");
        }
        HashtableTest.assertTrue((boolean)mht.isRehashed());
    }

    protected Hashtable hashtableClone(Hashtable s) {
        return (Hashtable)s.clone();
    }

    protected void setUp() {
        int i;
        this.ht10 = new Hashtable(10);
        this.ht100 = new Hashtable(100);
        this.htfull = new Hashtable(10);
        this.keyVector = new Vector(10);
        this.elmVector = new Vector(10);
        for (i = 0; i < 10; ++i) {
            this.ht10.put("Key " + i, "Val " + i);
            this.keyVector.addElement("Key " + i);
            this.elmVector.addElement("Val " + i);
        }
        for (i = 0; i < 7; ++i) {
            this.htfull.put("FKey " + i, "FVal " + i);
        }
    }

    protected void tearDown() {
        this.ht10 = null;
        this.ht100 = null;
        this.htfull = null;
        this.keyVector = null;
        this.elmVector = null;
    }

    class Mock_Hashtable
    extends Hashtable {
        boolean flag;

        public Mock_Hashtable(int i) {
            super(i);
            this.flag = false;
        }

        protected void rehash() {
            this.flag = true;
            super.rehash();
        }

        public boolean isRehashed() {
            return this.flag;
        }
    }
}

