/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

@TestTargetClass(value=HashSet.class)
public class HashSetTest
extends TestCase {
    HashSet hs;
    Object[] objArray;
    private static final SerializationTest.SerializableAssert comparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            HashSet initialHs = (HashSet)initial;
            HashSet deseriaHs = (HashSet)deserialized;
            Assert.assertEquals((String)"should be equal", (int)initialHs.size(), (int)deseriaHs.size());
            Assert.assertEquals((String)"should be equal", (Object)initialHs, (Object)deseriaHs);
        }
    };

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="HashSet", args={})
    public void test_Constructor() {
        HashSet hs2 = new HashSet();
        HashSetTest.assertEquals((String)"Created incorrect HashSet", (int)0, (int)hs2.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="HashSet", args={int.class})
    public void test_ConstructorI() {
        HashSet hs2 = new HashSet(5);
        HashSetTest.assertEquals((String)"Created incorrect HashSet", (int)0, (int)hs2.size());
        try {
            new HashSet(-1);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        HashSetTest.fail((String)"Failed to throw IllegalArgumentException for capacity < 0");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="HashSet", args={int.class, float.class})
    public void test_ConstructorIF() {
        HashSet hs2 = new HashSet(5, 0.5f);
        HashSetTest.assertEquals((String)"Created incorrect HashSet", (int)0, (int)hs2.size());
        try {
            new HashSet(0, 0.0f);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        HashSetTest.fail((String)"Failed to throw IllegalArgumentException for initial load factor <= 0");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="HashSet", args={Collection.class})
    public void test_ConstructorLjava_util_Collection() {
        HashSet<Object> hs2 = new HashSet<Object>(Arrays.asList(this.objArray));
        for (int counter = 0; counter < this.objArray.length; ++counter) {
            HashSetTest.assertTrue((String)"HashSet does not contain correct elements", (boolean)this.hs.contains(this.objArray[counter]));
        }
        HashSetTest.assertTrue((String)"HashSet created from collection incorrect size", (hs2.size() == this.objArray.length ? 1 : 0) != 0);
        try {
            new HashSet(null);
            HashSetTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void test_addLjava_lang_Object() {
        int size = this.hs.size();
        this.hs.add(new Integer(8));
        HashSetTest.assertTrue((String)"Added element already contained by set", (this.hs.size() == size ? 1 : 0) != 0);
        this.hs.add(new Integer(-9));
        HashSetTest.assertTrue((String)"Failed to increment set size after add", (this.hs.size() == size + 1 ? 1 : 0) != 0);
        HashSetTest.assertTrue((String)"Failed to add element to set", (boolean)this.hs.contains(new Integer(-9)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        Set orgSet = (Set)this.hs.clone();
        this.hs.clear();
        Iterator i = orgSet.iterator();
        HashSetTest.assertEquals((String)"Returned non-zero size after clear", (int)0, (int)this.hs.size());
        while (i.hasNext()) {
            HashSetTest.assertTrue((String)"Failed to clear set", (!this.hs.contains(i.next()) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        HashSet hs2 = (HashSet)this.hs.clone();
        HashSetTest.assertTrue((String)"clone returned an equivalent HashSet", (this.hs != hs2 ? 1 : 0) != 0);
        HashSetTest.assertTrue((String)"clone did not return an equal HashSet", (boolean)this.hs.equals(hs2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="contains", args={Object.class})
    public void test_containsLjava_lang_Object() {
        HashSetTest.assertTrue((String)"Returned false for valid object", (boolean)this.hs.contains(this.objArray[90]));
        HashSetTest.assertTrue((String)"Returned true for invalid Object", (!this.hs.contains(new Object()) ? 1 : 0) != 0);
        HashSet s = new HashSet();
        s.add(null);
        HashSetTest.assertTrue((String)"Cannot handle null", (boolean)s.contains(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        HashSetTest.assertTrue((String)"Empty set returned false", (boolean)new HashSet().isEmpty());
        HashSetTest.assertTrue((String)"Non-empty set returned true", (!this.hs.isEmpty() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="iterator", args={})
    public void test_iterator() {
        Iterator i = this.hs.iterator();
        int x = 0;
        while (i.hasNext()) {
            HashSetTest.assertTrue((String)"Failed to iterate over all elements", (boolean)this.hs.contains(i.next()));
            ++x;
        }
        HashSetTest.assertTrue((String)"Returned iteration of incorrect size", (this.hs.size() == x ? 1 : 0) != 0);
        HashSet s = new HashSet();
        s.add(null);
        HashSetTest.assertNull((String)"Cannot handle null", s.iterator().next());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        int size = this.hs.size();
        this.hs.remove(new Integer(98));
        HashSetTest.assertTrue((String)"Failed to remove element", (!this.hs.contains(new Integer(98)) ? 1 : 0) != 0);
        HashSetTest.assertTrue((String)"Failed to decrement set size", (this.hs.size() == size - 1 ? 1 : 0) != 0);
        HashSet s = new HashSet();
        s.add(null);
        HashSetTest.assertTrue((String)"Cannot handle null", (boolean)s.remove(null));
        HashSetTest.assertFalse((boolean)this.hs.remove(new Integer(-98)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        HashSetTest.assertTrue((String)"Returned incorrect size", (this.hs.size() == this.objArray.length + 1 ? 1 : 0) != 0);
        this.hs.clear();
        HashSetTest.assertEquals((String)"Cleared set returned non-zero size", (int)0, (int)this.hs.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationSelf", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationGolden", args={})})
    public void test_Serialization() throws Exception {
        HashSet<String> hs = new HashSet<String>();
        hs.add("hello");
        hs.add("world");
        SerializationTest.verifySelf(hs, comparator);
        SerializationTest.verifyGolden((TestCase)this, hs, comparator);
    }

    protected void setUp() {
        int i;
        this.objArray = new Object[1000];
        for (i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
        }
        this.hs = new HashSet();
        for (i = 0; i < this.objArray.length; ++i) {
            this.hs.add(this.objArray[i]);
        }
        this.hs.add(null);
    }

    protected void tearDown() {
        this.hs = null;
        this.objArray = null;
    }
}

