/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.AndroidOnly;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.TestCase;
import tests.support.Support_Locale;

@TestTargetClass(value=GregorianCalendar.class)
public class GregorianCalendarTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={})
    public void test_Constructor() {
        GregorianCalendarTest.assertTrue((String)"Constructed incorrect calendar", (boolean)new GregorianCalendar().isLenient());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={int.class, int.class, int.class})
    public void test_ConstructorIII() {
        GregorianCalendar gc = new GregorianCalendar(1972, 9, 13);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed 1", (int)1972, (int)gc.get(1));
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar constructed 2", (gc.get(2) == 9 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed 3", (int)13, (int)gc.get(5));
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar constructed 4", (boolean)gc.getTimeZone().equals(TimeZone.getDefault()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorIIIII() {
        GregorianCalendar gc = new GregorianCalendar(1972, 9, 13, 19, 9);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)1972, (int)gc.get(1));
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar constructed", (gc.get(2) == 9 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)13, (int)gc.get(5));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)7, (int)gc.get(10));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)1, (int)gc.get(9));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)9, (int)gc.get(12));
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar constructed", (boolean)gc.getTimeZone().equals(TimeZone.getDefault()));
        gc = new GregorianCalendar(1900, 0, 0, 0, Integer.MAX_VALUE);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)5983, (int)gc.get(1));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorIIIIII() {
        GregorianCalendar gc = new GregorianCalendar(1972, 9, 13, 19, 9, 59);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)1972, (int)gc.get(1));
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar constructed", (gc.get(2) == 9 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)13, (int)gc.get(5));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)7, (int)gc.get(10));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)1, (int)gc.get(9));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)9, (int)gc.get(12));
        GregorianCalendarTest.assertEquals((String)"Incorrect calendar constructed", (int)59, (int)gc.get(13));
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar constructed", (boolean)gc.getTimeZone().equals(TimeZone.getDefault()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={Locale.class})
    public void test_ConstructorLjava_util_Locale() {
        Locale[] requiredLocales = new Locale[]{Locale.US, Locale.FRANCE};
        if (!Support_Locale.areLocalesAvailable(requiredLocales)) {
            return;
        }
        Date date = new Date();
        GregorianCalendar gcUS = new GregorianCalendar(Locale.US);
        gcUS.setTime(date);
        GregorianCalendar gcUS2 = new GregorianCalendar(Locale.US);
        gcUS2.setTime(date);
        GregorianCalendar gcFrance = new GregorianCalendar(Locale.FRANCE);
        gcFrance.setTime(date);
        GregorianCalendarTest.assertTrue((String)"Locales not created correctly", (boolean)gcUS.equals(gcUS2));
        GregorianCalendarTest.assertFalse((String)"Locales not created correctly", (boolean)gcUS.equals(gcFrance));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={TimeZone.class})
    public void test_ConstructorLjava_util_TimeZone() {
        Date date = new Date();
        TimeZone.getDefault();
        GregorianCalendar gc1 = new GregorianCalendar(TimeZone.getTimeZone("EST"));
        gc1.setTime(date);
        GregorianCalendar gc2 = new GregorianCalendar(TimeZone.getTimeZone("CST"));
        gc2.setTime(date);
        GregorianCalendarTest.assertFalse((boolean)gc1.equals(gc2));
        gc1 = new GregorianCalendar(TimeZone.getTimeZone("GMT+2"));
        gc1.setTime(date);
        gc2 = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        gc2.setTime(date);
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar returned", (gc1.get(10) == (gc2.get(10) + 1) % 12 ? 1 : 0) != 0);
        SimpleTimeZone timezone = new SimpleTimeZone(-172800000, "GMT");
        GregorianCalendar gc = new GregorianCalendar(timezone);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="GregorianCalendar", args={TimeZone.class, Locale.class})
    public void test_ConstructorLjava_util_TimeZoneLjava_util_Locale() {
        Date date = new Date();
        TimeZone.getDefault();
        GregorianCalendar gc1 = new GregorianCalendar(TimeZone.getTimeZone("EST"), Locale.US);
        gc1.setTime(date);
        GregorianCalendar gc2 = new GregorianCalendar(TimeZone.getTimeZone("EST"), Locale.US);
        gc2.setTime(date);
        GregorianCalendar gc3 = new GregorianCalendar(TimeZone.getTimeZone("CST"), Locale.FRANCE);
        gc3.setTime(date);
        GregorianCalendarTest.assertTrue((boolean)gc1.equals(gc2));
        GregorianCalendarTest.assertFalse((boolean)gc2.equals(gc3));
        GregorianCalendarTest.assertFalse((boolean)gc3.equals(gc1));
        gc1 = new GregorianCalendar(TimeZone.getTimeZone("GMT+2"), Locale.US);
        gc1.setTime(date);
        gc3 = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"), Locale.FRANCE);
        gc3.setTime(date);
        GregorianCalendarTest.assertTrue((String)"Incorrect calendar returned", (gc1.get(10) == (gc3.get(10) + 1) % 12 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={int.class, int.class})
    @AndroidOnly(value="This test fails on the RI with version 1.5 but succeedson the RI with version 1.6")
    public void test_addII() {
        GregorianCalendar gc1 = new GregorianCalendar(1998, 11, 6);
        gc1.add(1, 1);
        GregorianCalendarTest.assertEquals((String)"Add failed to Increment", (int)1999, (int)gc1.get(1));
        gc1 = new GregorianCalendar(1999, 6, 31);
        gc1.add(2, 7);
        GregorianCalendarTest.assertEquals((String)"Wrong result year 1", (int)2000, (int)gc1.get(1));
        GregorianCalendarTest.assertTrue((String)"Wrong result month 1", (gc1.get(2) == 1 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong result date 1", (int)29, (int)gc1.get(5));
        gc1.add(1, -1);
        GregorianCalendarTest.assertEquals((String)"Wrong result year 2", (int)1999, (int)gc1.get(1));
        GregorianCalendarTest.assertTrue((String)"Wrong result month 2", (gc1.get(2) == 1 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong result date 2", (int)28, (int)gc1.get(5));
        gc1 = new GregorianCalendar(TimeZone.getTimeZone("EST"));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(14, 86400000);
        GregorianCalendarTest.assertEquals((String)"Wrong time after MILLISECOND change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(13, 86400);
        GregorianCalendarTest.assertEquals((String)"Wrong time after SECOND change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(12, 1440);
        GregorianCalendarTest.assertEquals((String)"Wrong time after MINUTE change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(10, 24);
        GregorianCalendarTest.assertEquals((String)"Wrong time after HOUR change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(11, 24);
        GregorianCalendarTest.assertEquals((String)"Wrong time after HOUR_OF_DAY change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(9, 2);
        GregorianCalendarTest.assertEquals((String)"Wrong time after AM_PM change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(5, 1);
        GregorianCalendarTest.assertEquals((String)"Wrong time after DATE change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(6, 1);
        GregorianCalendarTest.assertEquals((String)"Wrong time after DAY_OF_YEAR change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(7, 1);
        GregorianCalendarTest.assertEquals((String)"Wrong time after DAY_OF_WEEK change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(3, 1);
        GregorianCalendarTest.assertEquals((String)"Wrong time after WEEK_OF_YEAR change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(4, 1);
        GregorianCalendarTest.assertEquals((String)"Wrong time after WEEK_OF_MONTH change", (int)16, (int)gc1.get(11));
        gc1.set(1999, 3, 3, 16, 0);
        gc1.add(8, 1);
        GregorianCalendarTest.assertEquals((String)"Wrong time after DAY_OF_WEEK_IN_MONTH change", (int)16, (int)gc1.get(11));
        gc1.clear();
        gc1.set(2000, 3, 1, 23, 0);
        gc1.add(5, 1);
        GregorianCalendarTest.assertTrue((String)"Wrong time after DATE change near DST boundary", (gc1.get(2) == 3 && gc1.get(5) == 2 && gc1.get(11) == 23 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        GregorianCalendar gc1 = new GregorianCalendar(1998, 11, 6);
        GregorianCalendar gc2 = new GregorianCalendar(2000, 11, 6);
        GregorianCalendar gc3 = new GregorianCalendar(1998, 11, 6);
        GregorianCalendarTest.assertTrue((String)"Equality check failed", (boolean)gc1.equals(gc3));
        GregorianCalendarTest.assertTrue((String)"Equality check failed", (!gc1.equals(gc2) ? 1 : 0) != 0);
        gc3.setGregorianChange(new Date());
        GregorianCalendarTest.assertTrue((String)"Different gregorian change", (!gc1.equals(gc3) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getActualMaximum", args={int.class})
    public void test_getActualMaximumI() {
        GregorianCalendar gc1 = new GregorianCalendar(1900, 1, 1);
        GregorianCalendar gc2 = new GregorianCalendar(1996, 1, 1);
        GregorianCalendar gc3 = new GregorianCalendar(1997, 1, 1);
        GregorianCalendar gc4 = new GregorianCalendar(2000, 1, 1);
        GregorianCalendar gc5 = new GregorianCalendar(2000, 9, 9);
        GregorianCalendar gc6 = new GregorianCalendar(2000, 3, 3);
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_MONTH for Feb 1900", (int)28, (int)gc1.getActualMaximum(5));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_MONTH for Feb 1996", (int)29, (int)gc2.getActualMaximum(5));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_MONTH for Feb 1998", (int)28, (int)gc3.getActualMaximum(5));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_MONTH for Feb 2000", (int)29, (int)gc4.getActualMaximum(5));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_MONTH for Oct 2000", (int)31, (int)gc5.getActualMaximum(5));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_MONTH for Apr 2000", (int)30, (int)gc6.getActualMaximum(5));
        GregorianCalendarTest.assertTrue((String)"Wrong actual maximum value for MONTH", (gc1.getActualMaximum(2) == 11 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for HOUR_OF_DAY", (int)23, (int)gc1.getActualMaximum(11));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for HOUR", (int)11, (int)gc1.getActualMaximum(10));
        GregorianCalendarTest.assertEquals((String)"Wrong actual maximum value for DAY_OF_WEEK_IN_MONTH", (int)4, (int)gc6.getActualMaximum(8));
        Date date = new Date(Date.parse("Jan 15 00:00:01 GMT 2000"));
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(Date.parse("Dec 15 00:00:01 GMT 1582"));
        GregorianCalendarTest.assertEquals((int)355, (int)gc.getActualMaximum(6));
        gc.setGregorianChange(date);
        gc.setTimeInMillis(Date.parse("Jan 16 00:00:01 GMT 2000"));
        GregorianCalendarTest.assertEquals((int)353, (int)gc.getActualMaximum(6));
        gc = new GregorianCalendar(1900, 7, 1);
        String[] ids = TimeZone.getAvailableIDs();
        for (int i = 0; i < ids.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(ids[i]);
            gc.setTimeZone(tz);
            for (int j = 1900; j < 2000; ++j) {
                gc.set(1, j);
                GregorianCalendarTest.assertEquals((int)0x6DDD00, (int)gc.getActualMaximum(16));
            }
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getActualMinimum", args={int.class})
    public void test_getActualMinimumI() {
        GregorianCalendar gc1 = new GregorianCalendar(1900, 1, 1);
        new GregorianCalendar(1996, 1, 1);
        new GregorianCalendar(1997, 1, 1);
        new GregorianCalendar(2000, 1, 1);
        new GregorianCalendar(2000, 9, 9);
        GregorianCalendar gc6 = new GregorianCalendar(2000, 3, 3);
        GregorianCalendarTest.assertEquals((String)"Wrong actual minimum value for DAY_OF_MONTH for Feb 1900", (int)1, (int)gc1.getActualMinimum(5));
        GregorianCalendarTest.assertTrue((String)"Wrong actual minimum value for MONTH", (gc1.getActualMinimum(2) == 0 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong actual minimum value for HOUR_OF_DAY", (int)0, (int)gc1.getActualMinimum(11));
        GregorianCalendarTest.assertEquals((String)"Wrong actual minimum value for HOUR", (int)0, (int)gc1.getActualMinimum(10));
        GregorianCalendarTest.assertEquals((String)"Wrong actual minimum value for DAY_OF_WEEK_IN_MONTH", (int)1, (int)gc6.getActualMinimum(8));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getGreatestMinimum", args={int.class})
    public void test_getGreatestMinimumI() {
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendarTest.assertEquals((String)"Wrong greatest minimum value for DAY_OF_MONTH", (int)1, (int)gc.getGreatestMinimum(5));
        GregorianCalendarTest.assertTrue((String)"Wrong greatest minimum value for MONTH", (gc.getGreatestMinimum(2) == 0 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong greatest minimum value for HOUR_OF_DAY", (int)0, (int)gc.getGreatestMinimum(11));
        GregorianCalendarTest.assertEquals((String)"Wrong greatest minimum value for HOUR", (int)0, (int)gc.getGreatestMinimum(10));
        BitSet result = new BitSet();
        int[] min = new int[]{0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
        for (int i = 0; i < min.length; ++i) {
            if (gc.getGreatestMinimum(i) == min[i]) continue;
            result.set(i);
        }
        GregorianCalendarTest.assertTrue((String)("Wrong greatest min for " + result), (result.length() == 0 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getGregorianChange", args={})
    public void test_getGregorianChange() {
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendar returnedChange = new GregorianCalendar(TimeZone.getTimeZone("EST"));
        returnedChange.setTime(gc.getGregorianChange());
        GregorianCalendarTest.assertEquals((String)"Returned incorrect year", (int)1582, (int)returnedChange.get(1));
        GregorianCalendarTest.assertTrue((String)"Returned incorrect month", (returnedChange.get(2) == 9 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Returned incorrect day of month", (int)4, (int)returnedChange.get(5));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getLeastMaximum", args={int.class})
    public void test_getLeastMaximumI() {
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendarTest.assertEquals((String)"Wrong least maximum value for DAY_OF_MONTH", (int)28, (int)gc.getLeastMaximum(5));
        GregorianCalendarTest.assertTrue((String)"Wrong least maximum value for MONTH", (gc.getLeastMaximum(2) == 11 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong least maximum value for HOUR_OF_DAY", (int)23, (int)gc.getLeastMaximum(11));
        GregorianCalendarTest.assertEquals((String)"Wrong least maximum value for HOUR", (int)11, (int)gc.getLeastMaximum(10));
        BitSet result = new BitSet();
        Vector<Integer> values = new Vector<Integer>();
        int[] max = new int[]{1, 292269054, 11, 50, 3, 28, 355, 7, 3, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
        for (int i = 0; i < max.length; ++i) {
            if (gc.getLeastMaximum(i) == max[i]) continue;
            result.set(i);
            values.add(new Integer(gc.getLeastMaximum(i)));
        }
        GregorianCalendarTest.assertTrue((String)("Wrong least max for " + result + " = " + values), (result.length() == 0 ? 1 : 0) != 0);
        Date date = new Date(Date.parse("Jan 1 00:00:01 GMT 2000"));
        gc = new GregorianCalendar();
        gc.setGregorianChange(date);
        gc.setTime(date);
        GregorianCalendarTest.assertEquals((int)gc.getActualMaximum(3), (int)gc.getLeastMaximum(3));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getMaximum", args={int.class})
    public void test_getMaximumI() {
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendarTest.assertEquals((String)"Wrong maximum value for DAY_OF_MONTH", (int)31, (int)gc.getMaximum(5));
        GregorianCalendarTest.assertTrue((String)"Wrong maximum value for MONTH", (gc.getMaximum(2) == 11 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong maximum value for HOUR_OF_DAY", (int)23, (int)gc.getMaximum(11));
        GregorianCalendarTest.assertEquals((String)"Wrong maximum value for HOUR", (int)11, (int)gc.getMaximum(10));
        BitSet result = new BitSet();
        Vector<Integer> values = new Vector<Integer>();
        int[] max = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
        for (int i = 0; i < max.length; ++i) {
            if (gc.getMaximum(i) == max[i]) continue;
            result.set(i);
            values.add(new Integer(gc.getMaximum(i)));
        }
        GregorianCalendarTest.assertTrue((String)("Wrong max for " + result + " = " + values), (result.length() == 0 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getMinimum", args={int.class})
    public void test_getMinimumI() {
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendarTest.assertEquals((String)"Wrong minimum value for DAY_OF_MONTH", (int)1, (int)gc.getMinimum(5));
        GregorianCalendarTest.assertTrue((String)"Wrong minimum value for MONTH", (gc.getMinimum(2) == 0 ? 1 : 0) != 0);
        GregorianCalendarTest.assertEquals((String)"Wrong minimum value for HOUR_OF_DAY", (int)0, (int)gc.getMinimum(11));
        GregorianCalendarTest.assertEquals((String)"Wrong minimum value for HOUR", (int)0, (int)gc.getMinimum(10));
        BitSet result = new BitSet();
        int[] min = new int[]{0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
        for (int i = 0; i < min.length; ++i) {
            if (gc.getMinimum(i) == min[i]) continue;
            result.set(i);
        }
        GregorianCalendarTest.assertTrue((String)("Wrong min for " + result), (result.length() == 0 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isLeapYear", args={int.class})
    public void test_isLeapYearI() {
        GregorianCalendar gc = new GregorianCalendar(1998, 11, 6);
        GregorianCalendarTest.assertTrue((String)"Returned incorrect value for leap year", (!gc.isLeapYear(1998) ? 1 : 0) != 0);
        GregorianCalendarTest.assertTrue((String)"Returned incorrect value for leap year", (boolean)gc.isLeapYear(2000));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="roll", args={int.class, int.class})
    public void test_rollII() {
        GregorianCalendar gc = new GregorianCalendar(1972, 9, 8, 2, 5, 0);
        gc.roll(5, -1);
        GregorianCalendarTest.assertTrue((String)"Failed to roll DAY_OF_MONTH down by 1", (boolean)gc.equals(new GregorianCalendar(1972, 9, 7, 2, 5, 0)));
        gc = new GregorianCalendar(1972, 9, 8, 2, 5, 0);
        gc.roll(5, 25);
        GregorianCalendarTest.assertTrue((String)"Failed to roll DAY_OF_MONTH up by 25", (boolean)gc.equals(new GregorianCalendar(1972, 9, 2, 2, 5, 0)));
        gc = new GregorianCalendar(1972, 9, 8, 2, 5, 0);
        gc.roll(5, -10);
        GregorianCalendarTest.assertTrue((String)"Failed to roll DAY_OF_MONTH down by 10", (boolean)gc.equals(new GregorianCalendar(1972, 9, 29, 2, 5, 0)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="roll", args={int.class, boolean.class})
    public void test_rollIZ() {
        int result;
        GregorianCalendar gc = new GregorianCalendar(1972, 9, 13, 19, 9, 59);
        gc.roll(5, false);
        GregorianCalendarTest.assertTrue((String)"Failed to roll day_of_month down", (boolean)gc.equals(new GregorianCalendar(1972, 9, 12, 19, 9, 59)));
        gc = new GregorianCalendar(1972, 9, 13, 19, 9, 59);
        gc.roll(5, true);
        GregorianCalendarTest.assertTrue((String)"Failed to roll day_of_month up", (boolean)gc.equals(new GregorianCalendar(1972, 9, 14, 19, 9, 59)));
        gc = new GregorianCalendar(1972, 9, 31, 19, 9, 59);
        gc.roll(5, true);
        GregorianCalendarTest.assertTrue((String)"Failed to roll day_of_month up", (boolean)gc.equals(new GregorianCalendar(1972, 9, 1, 19, 9, 59)));
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.roll(15, true);
            result = 0;
        }
        catch (IllegalArgumentException e) {
            result = 1;
        }
        GregorianCalendarTest.assertEquals((String)"ZONE_OFFSET roll", (int)1, (int)result);
        try {
            cal.roll(16, true);
            result = 0;
        }
        catch (IllegalArgumentException e) {
            result = 1;
        }
        GregorianCalendarTest.assertEquals((String)"ZONE_OFFSET roll", (int)1, (int)result);
        cal.set(2004, 11, 31, 5, 0, 0);
        cal.roll(3, true);
        GregorianCalendarTest.assertTrue((String)("Wrong year: " + cal.getTime()), (cal.get(1) == 2004 ? 1 : 0) != 0);
        GregorianCalendarTest.assertTrue((String)("Wrong month: " + cal.getTime()), (cal.get(2) == 0 ? 1 : 0) != 0);
        GregorianCalendarTest.assertTrue((String)("Wrong date: " + cal.getTime()), (cal.get(5) == 9 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setGregorianChange", args={Date.class})
    public void test_setGregorianChangeLjava_util_Date() {
        GregorianCalendar gc1 = new GregorianCalendar(1582, 9, 4, 0, 0);
        GregorianCalendar gc2 = new GregorianCalendar(1972, 9, 13, 0, 0);
        gc1.setGregorianChange(gc2.getTime());
        GregorianCalendarTest.assertTrue((String)"Returned incorrect value", (boolean)gc2.getTime().equals(gc1.getGregorianChange()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        GregorianCalendar gCalend = new GregorianCalendar();
        gCalend.set(14, 0);
        int dayOfMonth = gCalend.get(5);
        GregorianCalendar gCalendClone = (GregorianCalendar)gCalend.clone();
        gCalendClone.add(5, 1);
        GregorianCalendarTest.assertEquals((String)"Before", (int)dayOfMonth, (int)gCalend.get(5));
        gCalend.set(14, 0);
        GregorianCalendarTest.assertEquals((String)"After", (int)dayOfMonth, (int)gCalend.get(5));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getMinimalDaysInFirstWeek", args={})
    public void test_getMinimalDaysInFirstWeek() {
        GregorianCalendar g = new GregorianCalendar(TimeZone.getTimeZone("Paris/France"), new Locale("en", "GB"));
        int minimalDaysInFirstWeek = g.getMinimalDaysInFirstWeek();
        GregorianCalendarTest.assertEquals((int)4, (int)minimalDaysInFirstWeek);
        g = new GregorianCalendar(TimeZone.getTimeZone("Paris/France"), new Locale("fr", "FR"));
        minimalDaysInFirstWeek = g.getMinimalDaysInFirstWeek();
        GregorianCalendarTest.assertEquals((int)4, (int)minimalDaysInFirstWeek);
        g = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"), new Locale("fr", "CA"));
        minimalDaysInFirstWeek = g.getMinimalDaysInFirstWeek();
        GregorianCalendarTest.assertTrue((minimalDaysInFirstWeek == 4 || minimalDaysInFirstWeek == 1 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Checks computeTime indirectly.", method="computeTime", args={})
    public void test_computeTime() {
        GregorianCalendar g = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"), new Locale("en", "GB"));
        g.clear();
        g.set(2006, 2, 26, 1, 50, 0);
        GregorianCalendarTest.assertEquals((long)1143337800000L, (long)g.getTimeInMillis());
        GregorianCalendar g1 = new GregorianCalendar(TimeZone.getTimeZone("Europe/Moscow"));
        g1.clear();
        g1.set(2006, 2, 26, 2, 20, 0);
        GregorianCalendarTest.assertEquals((long)1143328800000L, (long)g1.getTimeInMillis());
        GregorianCalendarTest.assertEquals((int)3, (int)g1.get(11));
        g1.clear();
        g1.set(2006, 9, 29, 2, 50, 0);
        GregorianCalendarTest.assertEquals((long)1162079400000L, (long)g1.getTimeInMillis());
        GregorianCalendarTest.assertEquals((int)2, (int)g1.get(11));
        g1.set(2006, -9, 29, 2, 50, 0);
        g1.setLenient(false);
        try {
            g1.getTimeInMillis();
            GregorianCalendarTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Checks computeFields indirectly.", method="computeFields", args={})
    public void test_computeFields() {
        GregorianCalendar g = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"), new Locale("en", "GB"));
        g.clear();
        g.setTimeInMillis(1222185600225L);
        GregorianCalendarTest.assertEquals((int)1, (int)g.get(0));
        GregorianCalendarTest.assertEquals((int)2008, (int)g.get(1));
        GregorianCalendarTest.assertEquals((int)8, (int)g.get(2));
        GregorianCalendarTest.assertEquals((int)23, (int)g.get(5));
        GregorianCalendarTest.assertEquals((int)17, (int)g.get(11));
        GregorianCalendarTest.assertEquals((int)0, (int)g.get(12));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify ArrayIndexOutOfBoundsException.", method="get", args={int.class})
    public void test_getI() {
        Date date = new Date(Date.parse("Jan 15 00:00:01 GMT 2000"));
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gc.setGregorianChange(date);
        gc.setTimeInMillis(Date.parse("Dec 24 00:00:01 GMT 2000"));
        GregorianCalendarTest.assertEquals((int)346, (int)gc.get(6));
        date = new Date(Date.parse("Feb 28 00:00:01 GMT 2000"));
        gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gc.setGregorianChange(date);
        gc.setTimeInMillis(Date.parse("Dec 1 00:00:01 GMT 2000"));
        GregorianCalendarTest.assertEquals((int)1, (int)gc.get(5));
        GregorianCalendarTest.assertEquals((int)11, (int)gc.get(2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        GregorianCalendar g = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"), new Locale("en", "GB"));
        g.clear();
        g.setTimeInMillis(1222185600225L);
        GregorianCalendar g1 = new GregorianCalendar(TimeZone.getTimeZone("Europe/Moscow"));
        g1.clear();
        g1.set(2008, 8, 23, 18, 0, 0);
        GregorianCalendarTest.assertNotSame((Object)g.hashCode(), (Object)g1.hashCode());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setFirstDayOfWeek", args={int.class})
    public void test_setFirstDayOfWeekI() {
        GregorianCalendar g = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"), new Locale("en", "GB"));
        for (int i = 0; i < 10; ++i) {
            g.setFirstDayOfWeek(i);
            GregorianCalendarTest.assertEquals((int)i, (int)g.getFirstDayOfWeek());
        }
        g.setLenient(false);
        g.setFirstDayOfWeek(10);
        g.setFirstDayOfWeek(-10);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setMinimalDaysInFirstWeek", args={int.class})
    public void test_setMinimalDaysInFirstWeekI() {
        GregorianCalendar g = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"), new Locale("en", "GB"));
        for (int i = 0; i < 10; ++i) {
            g.setMinimalDaysInFirstWeek(i);
            GregorianCalendarTest.assertEquals((int)i, (int)g.getMinimalDaysInFirstWeek());
        }
        g.setLenient(false);
        g.setMinimalDaysInFirstWeek(10);
        g.setMinimalDaysInFirstWeek(-10);
    }

    protected void setUp() {
        Locale.setDefault(Locale.US);
    }

    protected void tearDown() {
    }
}

