/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

@TestTargetClass(value=EnumSet.class)
public class EnumSetTest
extends TestCase {
    static final boolean disableRIBugs = true;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="noneOf", args={Class.class})
    public void test_NoneOf_LClass() {
        try {
            EnumSet.noneOf(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.noneOf(Enum.class);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        Class<?> c = ((Object)((Object)EnumWithAllInnerClass.a)).getClass();
        try {
            EnumSet.noneOf(c);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<EnumWithAllInnerClass> setWithInnerClass = EnumSet.noneOf(EnumWithAllInnerClass.class);
        EnumSetTest.assertNotNull(setWithInnerClass);
        Class<?> hc = ((Object)((Object)HugeEnumWithInnerClass.a)).getClass();
        try {
            EnumSet.noneOf(hc);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeSetWithInnerClass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        EnumSetTest.assertNotNull(hugeSetWithInnerClass);
    }

    public void test_iterator_HugeEnumSet() {
        EnumSet<HugeEnumCount> set = EnumSet.range(HugeEnumCount.NO1, HugeEnumCount.NO65);
        Object[] array = set.toArray();
        for (HugeEnumCount count : set) {
            EnumSetTest.assertEquals((Object)((Object)count), (Object)((Object)((HugeEnumCount)((Object)array[count.ordinal()]))));
        }
        set = EnumSet.range(HugeEnumCount.NO1, HugeEnumCount.NO130);
        array = set.toArray();
        for (HugeEnumCount count : set) {
            EnumSetTest.assertEquals((Object)((Object)count), (Object)((Object)((HugeEnumCount)((Object)array[count.ordinal()]))));
        }
    }

    public void testRemoveIteratorRemoveFromHugeEnumSet() {
        EnumSet<HugeEnumCount> set = EnumSet.noneOf(HugeEnumCount.class);
        set.add(HugeEnumCount.NO64);
        set.add(HugeEnumCount.NO65);
        set.add(HugeEnumCount.NO128);
        Iterator iterator = set.iterator();
        EnumSetTest.assertTrue((boolean)iterator.hasNext());
        EnumSetTest.assertEquals((Object)((Object)HugeEnumCount.NO64), iterator.next());
        EnumSetTest.assertTrue((boolean)iterator.hasNext());
        iterator.remove();
        EnumSetTest.assertEquals((Object)((Object)HugeEnumCount.NO65), iterator.next());
        EnumSetTest.assertTrue((boolean)iterator.hasNext());
        EnumSetTest.assertEquals((Object)((Object)HugeEnumCount.NO128), iterator.next());
        EnumSetTest.assertFalse((boolean)iterator.hasNext());
        EnumSetTest.assertEquals(EnumSet.of(HugeEnumCount.NO65, HugeEnumCount.NO128), set);
        iterator.remove();
        EnumSetTest.assertEquals(EnumSet.of(HugeEnumCount.NO65), set);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="allOf", args={Class.class})
    public void test_AllOf_LClass() {
        try {
            EnumSet.allOf(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.allOf(Enum.class);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        EnumSet<EnumFoo> enumSet = EnumSet.allOf(EnumFoo.class);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 64", (int)64, (int)enumSet.size());
        EnumSetTest.assertFalse((String)"enumSet should not contain null value", (boolean)enumSet.contains(null));
        EnumSetTest.assertTrue((String)"enumSet should contain EnumFoo.a", (boolean)enumSet.contains((Object)EnumFoo.a));
        EnumSetTest.assertTrue((String)"enumSet should contain EnumFoo.b", (boolean)enumSet.contains((Object)EnumFoo.b));
        enumSet.add(EnumFoo.a);
        EnumSetTest.assertEquals((String)"Should be equal", (int)64, (int)enumSet.size());
        EnumSet<EnumFoo> anotherSet = EnumSet.allOf(EnumFoo.class);
        EnumSetTest.assertEquals((String)"Should be equal", enumSet, anotherSet);
        EnumSetTest.assertNotSame((String)"Should not be identical", enumSet, anotherSet);
        EnumSet<HugeEnum> hugeEnumSet = EnumSet.allOf(HugeEnum.class);
        EnumSetTest.assertEquals((int)65, (int)hugeEnumSet.size());
        EnumSetTest.assertFalse((boolean)hugeEnumSet.contains(null));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnum.a));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnum.b));
        hugeEnumSet.add(HugeEnum.a);
        EnumSetTest.assertEquals((int)65, (int)hugeEnumSet.size());
        EnumSet<HugeEnum> anotherHugeSet = EnumSet.allOf(HugeEnum.class);
        EnumSetTest.assertEquals(hugeEnumSet, anotherHugeSet);
        EnumSetTest.assertNotSame(hugeEnumSet, anotherHugeSet);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void test_add_E() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        set.add(EnumFoo.a);
        set.add(EnumFoo.b);
        try {
            set.add(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumSet<Enum> rawSet = set;
        try {
            rawSet.add((EnumFoo)((Object)HugeEnumWithInnerClass.b));
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        set.clear();
        try {
            set.add(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean result = set.add(EnumFoo.a);
        EnumSetTest.assertEquals((String)"Size should be 1:", (int)1, (int)set.size());
        EnumSetTest.assertTrue((String)"Return value should be true", (boolean)result);
        result = set.add(EnumFoo.a);
        EnumSetTest.assertEquals((String)"Size should be 1:", (int)1, (int)set.size());
        EnumSetTest.assertFalse((String)"Return value should be false", (boolean)result);
        set.add(EnumFoo.b);
        EnumSetTest.assertEquals((String)"Size should be 2:", (int)2, (int)set.size());
        rawSet = set;
        try {
            rawSet.add((EnumFoo)((Object)EnumWithAllInnerClass.a));
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            rawSet.add((EnumFoo)((Object)EnumWithInnerClass.a));
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            rawSet.add((EnumFoo)((Object)new Object()));
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        result = hugeSet.add(HugeEnum.a);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.add(HugeEnum.a);
        EnumSetTest.assertFalse((boolean)result);
        try {
            hugeSet.add(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        rawSet = hugeSet;
        try {
            rawSet.add((EnumFoo)((Object)HugeEnumWithInnerClass.b));
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            rawSet.add((Enum)new Object());
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        result = hugeSet.add(HugeEnum.mm);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.add(HugeEnum.mm);
        EnumSetTest.assertFalse((boolean)result);
        EnumSetTest.assertEquals((int)2, (int)hugeSet.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={Collection.class})
    public void test_addAll_LCollection() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        EnumSetTest.assertEquals((String)"Size should be 0:", (int)0, (int)set.size());
        try {
            set.addAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumSet<EmptyEnum> emptySet = EnumSet.noneOf(EmptyEnum.class);
        Enum[] elements = (Enum[])EmptyEnum.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            emptySet.add((EmptyEnum)elements[i]);
        }
        boolean result = set.addAll(emptySet);
        EnumSetTest.assertFalse((boolean)result);
        ArrayList<EnumFoo> collection = new ArrayList<EnumFoo>();
        collection.add(EnumFoo.a);
        collection.add(EnumFoo.b);
        result = set.addAll(collection);
        EnumSetTest.assertTrue((String)"addAll should be successful", (boolean)result);
        EnumSetTest.assertEquals((String)"Size should be 2:", (int)2, (int)set.size());
        set = EnumSet.noneOf(EnumFoo.class);
        ArrayList<Integer> rawCollection = new ArrayList<Integer>();
        result = set.addAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        rawCollection.add(1);
        try {
            set.addAll(rawCollection);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<EnumFoo> fullSet = EnumSet.noneOf(EnumFoo.class);
        fullSet.add(EnumFoo.a);
        fullSet.add(EnumFoo.b);
        result = set.addAll(fullSet);
        EnumSetTest.assertTrue((String)"addAll should be successful", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 2", (int)2, (int)set.size());
        try {
            fullSet.addAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumSet<EnumWithInnerClass> fullSetWithSubclass = EnumSet.noneOf(EnumWithInnerClass.class);
        elements = (Enum[])EnumWithInnerClass.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            fullSetWithSubclass.add((EnumWithInnerClass)elements[i]);
        }
        try {
            set.addAll(fullSetWithSubclass);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<EnumWithInnerClass> setWithSubclass = fullSetWithSubclass;
        result = setWithSubclass.addAll(setWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumWithInnerClass> anotherSetWithSubclass = EnumSet.noneOf(EnumWithInnerClass.class);
        elements = (Enum[])EnumWithInnerClass.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            anotherSetWithSubclass.add((EnumWithInnerClass)elements[i]);
        }
        result = setWithSubclass.addAll(anotherSetWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        anotherSetWithSubclass.remove((Object)EnumWithInnerClass.a);
        result = setWithSubclass.addAll(anotherSetWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        try {
            hugeSet.addAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        hugeSet = EnumSet.allOf(HugeEnum.class);
        result = hugeSet.addAll(hugeSet);
        EnumSetTest.assertFalse((boolean)result);
        hugeSet = EnumSet.noneOf(HugeEnum.class);
        ArrayList<HugeEnum> hugeCollection = new ArrayList<HugeEnum>();
        hugeCollection.add(HugeEnum.a);
        hugeCollection.add(HugeEnum.b);
        result = hugeSet.addAll(hugeCollection);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)2, (int)set.size());
        hugeSet = EnumSet.noneOf(HugeEnum.class);
        rawCollection = new ArrayList();
        result = hugeSet.addAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        rawCollection.add(1);
        try {
            hugeSet.addAll(rawCollection);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<HugeEnum> aHugeSet = EnumSet.noneOf(HugeEnum.class);
        aHugeSet.add(HugeEnum.a);
        aHugeSet.add(HugeEnum.b);
        result = hugeSet.addAll(aHugeSet);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)2, (int)hugeSet.size());
        try {
            aHugeSet.addAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeSetWithSubclass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        try {
            hugeSet.addAll(hugeSetWithSubclass);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeSetWithInnerSubclass = hugeSetWithSubclass;
        result = hugeSetWithInnerSubclass.addAll(hugeSetWithInnerSubclass);
        EnumSetTest.assertFalse((boolean)result);
        EnumSet<HugeEnumWithInnerClass> anotherHugeSetWithSubclass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        result = hugeSetWithSubclass.addAll(anotherHugeSetWithSubclass);
        EnumSetTest.assertFalse((boolean)result);
        anotherHugeSetWithSubclass.remove((Object)HugeEnumWithInnerClass.a);
        result = setWithSubclass.addAll(anotherSetWithSubclass);
        EnumSetTest.assertFalse((boolean)result);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify exceptions.", method="remove", args={Object.class})
    public void test_remove_LOject() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        Enum[] elements = (Enum[])EnumFoo.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            set.add((EnumFoo)elements[i]);
        }
        boolean result = set.remove(null);
        EnumSetTest.assertFalse((String)"'set' does not contain null", (boolean)result);
        result = set.remove((Object)EnumFoo.a);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        result = set.remove((Object)EnumFoo.a);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 63:", (int)63, (int)set.size());
        result = set.remove((Object)EnumWithInnerClass.a);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        result = set.remove((Object)EnumWithInnerClass.f);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<HugeEnum> hugeSet = EnumSet.allOf(HugeEnum.class);
        result = hugeSet.remove(null);
        EnumSetTest.assertFalse((String)"'set' does not contain null", (boolean)result);
        result = hugeSet.remove((Object)HugeEnum.a);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        result = hugeSet.remove((Object)HugeEnum.a);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 64:", (int)64, (int)hugeSet.size());
        result = hugeSet.remove((Object)HugeEnumWithInnerClass.a);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        result = hugeSet.remove((Object)HugeEnumWithInnerClass.f);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equals_LObject() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        Enum[] elements = (Enum[])EnumFoo.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            set.add((EnumFoo)elements[i]);
        }
        EnumSetTest.assertFalse((String)"Should return false", (boolean)((Object)set).equals(null));
        EnumSetTest.assertFalse((String)"Should return false", (boolean)((Object)set).equals(new Object()));
        EnumSet<EnumFoo> anotherSet = EnumSet.noneOf(EnumFoo.class);
        elements = (Enum[])EnumFoo.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            anotherSet.add((EnumFoo)elements[i]);
        }
        EnumSetTest.assertTrue((String)"Should return true", (boolean)((Object)set).equals(anotherSet));
        anotherSet.remove((Object)EnumFoo.a);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)((Object)set).equals(anotherSet));
        EnumSet<EnumWithInnerClass> setWithInnerClass = EnumSet.noneOf(EnumWithInnerClass.class);
        elements = (Enum[])EnumWithInnerClass.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            setWithInnerClass.add((EnumWithInnerClass)elements[i]);
        }
        EnumSetTest.assertFalse((String)"Should return false", (boolean)((Object)set).equals(setWithInnerClass));
        setWithInnerClass.clear();
        set.clear();
        EnumSetTest.assertTrue((String)"Should be equal", (boolean)((Object)set).equals(setWithInnerClass));
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        EnumSetTest.assertTrue((boolean)((Object)hugeSet).equals(set));
        hugeSet = EnumSet.allOf(HugeEnum.class);
        EnumSetTest.assertFalse((boolean)((Object)hugeSet).equals(null));
        EnumSetTest.assertFalse((boolean)((Object)hugeSet).equals(new Object()));
        EnumSet<HugeEnum> anotherHugeSet = EnumSet.allOf(HugeEnum.class);
        anotherHugeSet.remove((Object)HugeEnum.a);
        EnumSetTest.assertFalse((boolean)((Object)hugeSet).equals(anotherHugeSet));
        EnumSet<HugeEnumWithInnerClass> hugeSetWithInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        EnumSetTest.assertFalse((boolean)((Object)hugeSet).equals(hugeSetWithInnerClass));
        hugeSetWithInnerClass.clear();
        hugeSet.clear();
        EnumSetTest.assertTrue((boolean)((Object)hugeSet).equals(hugeSetWithInnerClass));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        set.add(EnumFoo.a);
        set.add(EnumFoo.b);
        EnumSetTest.assertEquals((String)"Size should be 2", (int)2, (int)set.size());
        set.clear();
        EnumSetTest.assertEquals((String)"Size should be 0", (int)0, (int)set.size());
        EnumSet<HugeEnum> hugeSet = EnumSet.allOf(HugeEnum.class);
        EnumSetTest.assertEquals((int)65, (int)hugeSet.size());
        boolean result = hugeSet.contains((Object)HugeEnum.aa);
        EnumSetTest.assertTrue((boolean)result);
        hugeSet.clear();
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        result = hugeSet.contains((Object)HugeEnum.aa);
        EnumSetTest.assertFalse((boolean)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        set.add(EnumFoo.a);
        set.add(EnumFoo.b);
        EnumSetTest.assertEquals((String)"Size should be 2", (int)2, (int)set.size());
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        hugeSet.add(HugeEnum.a);
        hugeSet.add(HugeEnum.bb);
        EnumSetTest.assertEquals((String)"Size should be 2", (int)2, (int)hugeSet.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="complementOf", args={EnumSet.class})
    public void test_ComplementOf_LEnumSet() {
        try {
            EnumSet.complementOf(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EnumSet<EnumWithInnerClass> set = EnumSet.noneOf(EnumWithInnerClass.class);
        set.add(EnumWithInnerClass.d);
        set.add(EnumWithInnerClass.e);
        set.add(EnumWithInnerClass.f);
        EnumSetTest.assertEquals((String)"Size should be 3:", (int)3, (int)set.size());
        EnumSet<EnumWithInnerClass> complementOfE = EnumSet.complementOf(set);
        EnumSetTest.assertTrue((boolean)set.contains((Object)EnumWithInnerClass.d));
        EnumSetTest.assertEquals((String)"complementOfE should have size 3", (int)3, (int)complementOfE.size());
        EnumSetTest.assertTrue((String)"complementOfE should contain EnumWithSubclass.a:", (boolean)complementOfE.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"complementOfE should contain EnumWithSubclass.b:", (boolean)complementOfE.contains((Object)EnumWithInnerClass.b));
        EnumSetTest.assertTrue((String)"complementOfE should contain EnumWithSubclass.c:", (boolean)complementOfE.contains((Object)EnumWithInnerClass.c));
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        EnumSet<HugeEnum> complementHugeSet = EnumSet.complementOf(hugeSet);
        EnumSetTest.assertEquals((int)65, (int)complementHugeSet.size());
        hugeSet.add(HugeEnum.A);
        hugeSet.add(HugeEnum.mm);
        complementHugeSet = EnumSet.complementOf(hugeSet);
        EnumSetTest.assertEquals((int)63, (int)complementHugeSet.size());
        try {
            EnumSet.complementOf(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify ClassCastException, and NullPointerException.", method="contains", args={Object.class})
    public void test_contains_LObject() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        Enum[] elements = (Enum[])EnumFoo.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            set.add((EnumFoo)elements[i]);
        }
        boolean result = set.contains(null);
        EnumSetTest.assertFalse((String)"Should not contain null:", (boolean)result);
        result = set.contains((Object)EnumFoo.a);
        EnumSetTest.assertTrue((String)"Should contain EnumFoo.a", (boolean)result);
        result = set.contains((Object)EnumFoo.ll);
        EnumSetTest.assertTrue((String)"Should contain EnumFoo.ll", (boolean)result);
        result = set.contains((Object)EnumFoo.b);
        EnumSetTest.assertTrue((String)"Should contain EnumFoo.b", (boolean)result);
        result = set.contains(new Object());
        EnumSetTest.assertFalse((String)"Should not contain Object instance", (boolean)result);
        result = set.contains((Object)EnumWithInnerClass.a);
        EnumSetTest.assertFalse((String)"Should not contain EnumWithSubclass.a", (boolean)result);
        set = EnumSet.noneOf(EnumFoo.class);
        set.add(EnumFoo.aa);
        set.add(EnumFoo.bb);
        set.add(EnumFoo.cc);
        EnumSetTest.assertEquals((String)"Size of set should be 3", (int)3, (int)set.size());
        EnumSetTest.assertTrue((String)"set should contain EnumFoo.aa", (boolean)set.contains((Object)EnumFoo.aa));
        EnumSet<EnumWithInnerClass> setWithSubclass = EnumSet.noneOf(EnumWithInnerClass.class);
        setWithSubclass.add(EnumWithInnerClass.a);
        setWithSubclass.add(EnumWithInnerClass.b);
        setWithSubclass.add(EnumWithInnerClass.c);
        setWithSubclass.add(EnumWithInnerClass.d);
        setWithSubclass.add(EnumWithInnerClass.e);
        setWithSubclass.add(EnumWithInnerClass.f);
        result = setWithSubclass.contains((Object)EnumWithInnerClass.f);
        EnumSetTest.assertTrue((String)"Should contain EnumWithSubclass.f", (boolean)result);
        EnumSet<HugeEnum> hugeSet = EnumSet.allOf(HugeEnum.class);
        hugeSet.add(HugeEnum.a);
        result = hugeSet.contains((Object)HugeEnum.a);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.contains((Object)HugeEnum.b);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.contains(null);
        EnumSetTest.assertFalse((boolean)result);
        result = hugeSet.contains((Object)HugeEnum.a);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.contains((Object)HugeEnum.ll);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.contains(new Object());
        EnumSetTest.assertFalse((boolean)result);
        result = hugeSet.contains(Enum.class);
        EnumSetTest.assertFalse((boolean)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsAll", args={Collection.class})
    public void test_containsAll_LCollection() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        Enum[] elements = (Enum[])EnumFoo.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            set.add((EnumFoo)elements[i]);
        }
        try {
            set.containsAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumSet<EmptyEnum> emptySet = EnumSet.noneOf(EmptyEnum.class);
        elements = (Enum[])EmptyEnum.class.getEnumConstants();
        for (int i = 0; i < elements.length; ++i) {
            emptySet.add((EmptyEnum)elements[i]);
        }
        boolean result = set.containsAll(emptySet);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        ArrayList<Object> rawCollection = new ArrayList<Object>();
        result = set.containsAll(rawCollection);
        EnumSetTest.assertTrue((String)"Should contain empty collection:", (boolean)result);
        rawCollection.add(1);
        result = set.containsAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        rawCollection.add((Object)EnumWithInnerClass.a);
        result = set.containsAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<Enum> rawSet = EnumSet.noneOf(EnumFoo.class);
        result = set.containsAll(rawSet);
        EnumSetTest.assertTrue((String)"Should contain empty set", (boolean)result);
        emptySet = EnumSet.noneOf(EmptyEnum.class);
        result = set.containsAll(emptySet);
        EnumSetTest.assertTrue((String)"No class cast should be performed on empty set", (boolean)result);
        ArrayList<EnumFoo> collection = new ArrayList<EnumFoo>();
        collection.add(EnumFoo.a);
        result = set.containsAll(collection);
        EnumSetTest.assertTrue((String)"Should contain all elements in collection", (boolean)result);
        EnumSet<EnumFoo> fooSet = EnumSet.noneOf(EnumFoo.class);
        fooSet.add(EnumFoo.a);
        result = set.containsAll(fooSet);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        set.clear();
        try {
            set.containsAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArrayList<EnumWithInnerClass> collectionWithSubclass = new ArrayList<EnumWithInnerClass>();
        collectionWithSubclass.add(EnumWithInnerClass.a);
        result = set.containsAll(collectionWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumWithInnerClass> setWithSubclass = EnumSet.noneOf(EnumWithInnerClass.class);
        setWithSubclass.add(EnumWithInnerClass.a);
        result = set.containsAll(setWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        hugeSet.add(HugeEnum.a);
        hugeSet.add(HugeEnum.b);
        hugeSet.add(HugeEnum.aa);
        hugeSet.add(HugeEnum.bb);
        hugeSet.add(HugeEnum.cc);
        hugeSet.add(HugeEnum.dd);
        EnumSet<HugeEnum> anotherHugeSet = EnumSet.noneOf(HugeEnum.class);
        hugeSet.add(HugeEnum.b);
        hugeSet.add(HugeEnum.cc);
        result = hugeSet.containsAll(anotherHugeSet);
        EnumSetTest.assertTrue((boolean)result);
        try {
            hugeSet.containsAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeSetWithInnerClass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        hugeSetWithInnerClass.add(HugeEnumWithInnerClass.a);
        hugeSetWithInnerClass.add(HugeEnumWithInnerClass.b);
        result = hugeSetWithInnerClass.containsAll(hugeSetWithInnerClass);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSet.containsAll(hugeSetWithInnerClass);
        EnumSetTest.assertFalse((boolean)result);
        rawCollection = new ArrayList();
        result = hugeSet.containsAll(rawCollection);
        EnumSetTest.assertTrue((String)"Should contain empty collection:", (boolean)result);
        rawCollection.add(1);
        result = hugeSet.containsAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        rawCollection.add((Object)EnumWithInnerClass.a);
        result = set.containsAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        rawSet = EnumSet.noneOf(HugeEnum.class);
        result = hugeSet.containsAll(rawSet);
        EnumSetTest.assertTrue((String)"Should contain empty set", (boolean)result);
        EnumSet<HugeEnumWithInnerClass> emptyHugeSet = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        result = hugeSet.containsAll(emptyHugeSet);
        EnumSetTest.assertTrue((String)"No class cast should be performed on empty set", (boolean)result);
        ArrayList<HugeEnum> hugeCollection = new ArrayList<HugeEnum>();
        hugeCollection.add(HugeEnum.a);
        result = hugeSet.containsAll(hugeCollection);
        EnumSetTest.assertTrue((String)"Should contain all elements in collection", (boolean)result);
        hugeSet.clear();
        try {
            hugeSet.containsAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArrayList<HugeEnumWithInnerClass> hugeCollectionWithSubclass = new ArrayList<HugeEnumWithInnerClass>();
        hugeCollectionWithSubclass.add(HugeEnumWithInnerClass.a);
        result = hugeSet.containsAll(hugeCollectionWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<HugeEnumWithInnerClass> hugeSetWithSubclass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        hugeSetWithSubclass.add(HugeEnumWithInnerClass.a);
        result = hugeSet.containsAll(hugeSetWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="copyOf", args={Collection.class})
    public void test_CopyOf_LCollection() {
        try {
            EnumSet.copyOf((Collection)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        ArrayList<Object> collection = new ArrayList<Object>();
        try {
            EnumSet.copyOf(collection);
            EnumSetTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        collection.add(new Object());
        try {
            EnumSet.copyOf(collection);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        ArrayList<EnumFoo> enumCollection = new ArrayList<EnumFoo>();
        enumCollection.add(EnumFoo.b);
        EnumSet copyOfEnumCollection = EnumSet.copyOf(enumCollection);
        EnumSetTest.assertEquals((String)"Size of copyOfEnumCollection should be 1:", (int)1, (int)copyOfEnumCollection.size());
        EnumSetTest.assertTrue((String)"copyOfEnumCollection should contain EnumFoo.b:", (boolean)copyOfEnumCollection.contains((Object)EnumFoo.b));
        enumCollection.add(null);
        EnumSetTest.assertEquals((String)"Size of enumCollection should be 2:", (int)2, (int)enumCollection.size());
        try {
            copyOfEnumCollection = EnumSet.copyOf(enumCollection);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        ArrayList<Enum> rawEnumCollection = new ArrayList<Enum>();
        rawEnumCollection.add(EnumFoo.a);
        rawEnumCollection.add(EnumWithInnerClass.a);
        try {
            EnumSet.copyOf(rawEnumCollection);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        ArrayList<HugeEnum> hugeEnumCollection = new ArrayList<HugeEnum>();
        hugeEnumCollection.add(HugeEnum.b);
        EnumSet copyOfHugeEnumCollection = EnumSet.copyOf(hugeEnumCollection);
        EnumSetTest.assertEquals((int)1, (int)copyOfHugeEnumCollection.size());
        EnumSetTest.assertTrue((boolean)copyOfHugeEnumCollection.contains((Object)HugeEnum.b));
        hugeEnumCollection.add(null);
        EnumSetTest.assertEquals((int)2, (int)hugeEnumCollection.size());
        try {
            copyOfHugeEnumCollection = EnumSet.copyOf(hugeEnumCollection);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        rawEnumCollection = new ArrayList();
        rawEnumCollection.add(HugeEnum.a);
        rawEnumCollection.add(HugeEnumWithInnerClass.a);
        try {
            EnumSet.copyOf(rawEnumCollection);
            EnumSetTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="copyOf", args={EnumSet.class})
    public void test_CopyOf_LEnumSet() {
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.noneOf(EnumWithInnerClass.class);
        enumSet.add(EnumWithInnerClass.a);
        enumSet.add(EnumWithInnerClass.f);
        EnumSet<EnumWithInnerClass> copyOfE = EnumSet.copyOf(enumSet);
        EnumSetTest.assertEquals((String)"Size of enumSet and copyOfE should be equal", (int)enumSet.size(), (int)copyOfE.size());
        EnumSetTest.assertTrue((String)"EnumWithSubclass.a should be contained in copyOfE", (boolean)copyOfE.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"EnumWithSubclass.f should be contained in copyOfE", (boolean)copyOfE.contains((Object)EnumWithInnerClass.f));
        Object[] enumValue = copyOfE.toArray();
        EnumSetTest.assertSame((String)"enumValue[0] should be identical with EnumWithSubclass.a", (Object)enumValue[0], (Object)((Object)EnumWithInnerClass.a));
        EnumSetTest.assertSame((String)"enumValue[1] should be identical with EnumWithSubclass.f", (Object)enumValue[1], (Object)((Object)EnumWithInnerClass.f));
        try {
            EnumSet.copyOf((EnumSet)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        hugeEnumSet.add(HugeEnumWithInnerClass.a);
        hugeEnumSet.add(HugeEnumWithInnerClass.f);
        EnumSet<HugeEnumWithInnerClass> copyOfHugeEnum = EnumSet.copyOf(hugeEnumSet);
        EnumSetTest.assertEquals((int)enumSet.size(), (int)copyOfE.size());
        EnumSetTest.assertTrue((boolean)copyOfHugeEnum.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)copyOfHugeEnum.contains((Object)HugeEnumWithInnerClass.f));
        Object[] hugeEnumValue = copyOfHugeEnum.toArray();
        EnumSetTest.assertSame((Object)hugeEnumValue[0], (Object)((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertSame((Object)hugeEnumValue[1], (Object)((Object)HugeEnumWithInnerClass.f));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify UnsupportedOperationException, ClassCastException.", method="removeAll", args={Collection.class})
    public void test_removeAll_LCollection() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        try {
            set.removeAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        set = EnumSet.allOf(EnumFoo.class);
        EnumSetTest.assertEquals((String)"Size of set should be 64:", (int)64, (int)set.size());
        try {
            set.removeAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArrayList<EnumFoo> collection = new ArrayList<EnumFoo>();
        collection.add(EnumFoo.a);
        boolean result = set.removeAll(collection);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 63", (int)63, (int)set.size());
        collection = new ArrayList();
        result = set.removeAll(collection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EmptyEnum> emptySet = EnumSet.noneOf(EmptyEnum.class);
        result = set.removeAll(emptySet);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumFoo> emptyFooSet = EnumSet.noneOf(EnumFoo.class);
        result = set.removeAll(emptyFooSet);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        emptyFooSet.add(EnumFoo.a);
        result = set.removeAll(emptyFooSet);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumWithInnerClass> setWithSubclass = EnumSet.noneOf(EnumWithInnerClass.class);
        result = set.removeAll(setWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        setWithSubclass.add(EnumWithInnerClass.a);
        result = set.removeAll(setWithSubclass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumFoo> anotherSet = EnumSet.noneOf(EnumFoo.class);
        anotherSet.add(EnumFoo.a);
        set = EnumSet.allOf(EnumFoo.class);
        result = set.removeAll(anotherSet);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 63:", (int)63, (int)set.size());
        EnumSet<EnumWithInnerClass> setWithInnerClass = EnumSet.noneOf(EnumWithInnerClass.class);
        setWithInnerClass.add(EnumWithInnerClass.a);
        setWithInnerClass.add(EnumWithInnerClass.b);
        EnumSet<EnumWithInnerClass> anotherSetWithInnerClass = EnumSet.noneOf(EnumWithInnerClass.class);
        anotherSetWithInnerClass.add(EnumWithInnerClass.c);
        anotherSetWithInnerClass.add(EnumWithInnerClass.d);
        result = anotherSetWithInnerClass.removeAll(setWithInnerClass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        anotherSetWithInnerClass.add(EnumWithInnerClass.a);
        result = anotherSetWithInnerClass.removeAll(setWithInnerClass);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of anotherSetWithInnerClass should remain 2", (int)2, (int)anotherSetWithInnerClass.size());
        anotherSetWithInnerClass.remove((Object)EnumWithInnerClass.c);
        anotherSetWithInnerClass.remove((Object)EnumWithInnerClass.d);
        result = anotherSetWithInnerClass.remove(setWithInnerClass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<Enum> rawSet = EnumSet.allOf(EnumWithAllInnerClass.class);
        result = rawSet.removeAll(EnumSet.allOf(EnumFoo.class));
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        setWithInnerClass = EnumSet.allOf(EnumWithInnerClass.class);
        anotherSetWithInnerClass = EnumSet.allOf(EnumWithInnerClass.class);
        setWithInnerClass.remove((Object)EnumWithInnerClass.a);
        anotherSetWithInnerClass.remove((Object)EnumWithInnerClass.f);
        result = setWithInnerClass.removeAll(anotherSetWithInnerClass);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of setWithInnerClass should be 1", (int)1, (int)setWithInnerClass.size());
        result = setWithInnerClass.contains((Object)EnumWithInnerClass.f);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSet<HugeEnum> hugeSet = EnumSet.allOf(HugeEnum.class);
        ArrayList<HugeEnum> hugeCollection = new ArrayList<HugeEnum>();
        hugeCollection.add(HugeEnum.a);
        result = hugeSet.removeAll(hugeCollection);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)64, (int)hugeSet.size());
        collection = new ArrayList();
        result = hugeSet.removeAll(collection);
        EnumSetTest.assertFalse((boolean)result);
        EnumSet<HugeEnum> emptyHugeSet = EnumSet.noneOf(HugeEnum.class);
        result = hugeSet.removeAll(emptyHugeSet);
        EnumSetTest.assertFalse((boolean)result);
        EnumSet<HugeEnumWithInnerClass> hugeSetWithSubclass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        result = hugeSet.removeAll(hugeSetWithSubclass);
        EnumSetTest.assertFalse((boolean)result);
        hugeSetWithSubclass.add(HugeEnumWithInnerClass.a);
        result = hugeSet.removeAll(hugeSetWithSubclass);
        EnumSetTest.assertFalse((boolean)result);
        EnumSet<HugeEnum> anotherHugeSet = EnumSet.noneOf(HugeEnum.class);
        anotherHugeSet.add(HugeEnum.a);
        hugeSet = EnumSet.allOf(HugeEnum.class);
        result = hugeSet.removeAll(anotherHugeSet);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)63, (int)set.size());
        EnumSet<HugeEnumWithInnerClass> hugeSetWithInnerClass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        hugeSetWithInnerClass.add(HugeEnumWithInnerClass.a);
        hugeSetWithInnerClass.add(HugeEnumWithInnerClass.b);
        EnumSet<HugeEnumWithInnerClass> anotherHugeSetWithInnerClass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        anotherHugeSetWithInnerClass.add(HugeEnumWithInnerClass.c);
        anotherHugeSetWithInnerClass.add(HugeEnumWithInnerClass.d);
        result = anotherHugeSetWithInnerClass.removeAll(setWithInnerClass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        anotherHugeSetWithInnerClass.add(HugeEnumWithInnerClass.a);
        result = anotherHugeSetWithInnerClass.removeAll(hugeSetWithInnerClass);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)2, (int)anotherHugeSetWithInnerClass.size());
        anotherHugeSetWithInnerClass.remove((Object)HugeEnumWithInnerClass.c);
        anotherHugeSetWithInnerClass.remove((Object)HugeEnumWithInnerClass.d);
        result = anotherHugeSetWithInnerClass.remove(hugeSetWithInnerClass);
        EnumSetTest.assertFalse((boolean)result);
        rawSet = EnumSet.allOf(HugeEnumWithInnerClass.class);
        result = rawSet.removeAll(EnumSet.allOf(HugeEnum.class));
        EnumSetTest.assertFalse((boolean)result);
        hugeSetWithInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        anotherHugeSetWithInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        hugeSetWithInnerClass.remove((Object)HugeEnumWithInnerClass.a);
        anotherHugeSetWithInnerClass.remove((Object)HugeEnumWithInnerClass.f);
        result = hugeSetWithInnerClass.removeAll(anotherHugeSetWithInnerClass);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)1, (int)hugeSetWithInnerClass.size());
        result = hugeSetWithInnerClass.contains((Object)HugeEnumWithInnerClass.f);
        EnumSetTest.assertTrue((boolean)result);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify UnsupportedOperationException, ClassCastException.", method="retainAll", args={Collection.class})
    public void test_retainAll_LCollection() {
        EnumSet<EnumFoo> set = EnumSet.allOf(EnumFoo.class);
        try {
            set.retainAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        set.clear();
        boolean result = set.retainAll(null);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        ArrayList<Enum> rawCollection = new ArrayList<Enum>();
        result = set.retainAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        rawCollection.add(EnumFoo.a);
        result = set.retainAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        rawCollection.add(EnumWithInnerClass.a);
        result = set.retainAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 0:", (int)0, (int)set.size());
        rawCollection.remove((Object)EnumFoo.a);
        result = set.retainAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumFoo> anotherSet = EnumSet.allOf(EnumFoo.class);
        result = set.retainAll(anotherSet);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 0", (int)0, (int)set.size());
        EnumSet<EnumWithInnerClass> setWithInnerClass = EnumSet.allOf(EnumWithInnerClass.class);
        result = set.retainAll(setWithInnerClass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 0", (int)0, (int)set.size());
        setWithInnerClass = EnumSet.noneOf(EnumWithInnerClass.class);
        result = set.retainAll(setWithInnerClass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EmptyEnum> emptySet = EnumSet.allOf(EmptyEnum.class);
        result = set.retainAll(emptySet);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        EnumSet<EnumWithAllInnerClass> setWithAllInnerClass = EnumSet.allOf(EnumWithAllInnerClass.class);
        result = set.retainAll(setWithAllInnerClass);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        set.add(EnumFoo.a);
        result = set.retainAll(setWithInnerClass);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 0", (int)0, (int)set.size());
        setWithInnerClass = EnumSet.allOf(EnumWithInnerClass.class);
        setWithInnerClass.remove((Object)EnumWithInnerClass.f);
        EnumSet<EnumWithInnerClass> anotherSetWithInnerClass = EnumSet.noneOf(EnumWithInnerClass.class);
        anotherSetWithInnerClass.add(EnumWithInnerClass.e);
        anotherSetWithInnerClass.add(EnumWithInnerClass.f);
        result = setWithInnerClass.retainAll(anotherSetWithInnerClass);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        result = setWithInnerClass.contains((Object)EnumWithInnerClass.e);
        EnumSetTest.assertTrue((String)"Should contain EnumWithInnerClass.e", (boolean)result);
        result = setWithInnerClass.contains((Object)EnumWithInnerClass.b);
        EnumSetTest.assertFalse((String)"Should not contain EnumWithInnerClass.b", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of set should be 1:", (int)1, (int)setWithInnerClass.size());
        anotherSetWithInnerClass = EnumSet.allOf(EnumWithInnerClass.class);
        result = setWithInnerClass.retainAll(anotherSetWithInnerClass);
        EnumSetTest.assertFalse((String)"Return value should be false", (boolean)result);
        rawCollection = new ArrayList();
        rawCollection.add(EnumWithInnerClass.e);
        rawCollection.add(EnumWithInnerClass.f);
        result = setWithInnerClass.retainAll(rawCollection);
        EnumSetTest.assertFalse((String)"Should return false", (boolean)result);
        set = EnumSet.allOf(EnumFoo.class);
        set.remove((Object)EnumFoo.a);
        anotherSet = EnumSet.noneOf(EnumFoo.class);
        anotherSet.add(EnumFoo.a);
        result = set.retainAll(anotherSet);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)result);
        EnumSetTest.assertEquals((String)"size should be 0", (int)0, (int)set.size());
        EnumSet<HugeEnum> hugeSet = EnumSet.allOf(HugeEnum.class);
        try {
            hugeSet.retainAll(null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        hugeSet.clear();
        result = hugeSet.retainAll(null);
        EnumSetTest.assertFalse((boolean)result);
        rawCollection = new ArrayList();
        result = hugeSet.retainAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        rawCollection.add(HugeEnum.a);
        result = hugeSet.retainAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        rawCollection.add(HugeEnumWithInnerClass.a);
        result = hugeSet.retainAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        EnumSetTest.assertEquals((int)0, (int)set.size());
        rawCollection.remove((Object)HugeEnum.a);
        result = set.retainAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        EnumSet<HugeEnum> anotherHugeSet = EnumSet.allOf(HugeEnum.class);
        result = hugeSet.retainAll(anotherHugeSet);
        EnumSetTest.assertFalse((boolean)result);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        EnumSet<HugeEnumWithInnerClass> hugeSetWithInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        result = hugeSet.retainAll(hugeSetWithInnerClass);
        EnumSetTest.assertFalse((boolean)result);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        hugeSetWithInnerClass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        result = hugeSet.retainAll(hugeSetWithInnerClass);
        EnumSetTest.assertFalse((boolean)result);
        EnumSet<HugeEnumWithInnerClass> hugeSetWithAllInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        result = hugeSet.retainAll(hugeSetWithAllInnerClass);
        EnumSetTest.assertFalse((boolean)result);
        hugeSet.add(HugeEnum.a);
        result = hugeSet.retainAll(hugeSetWithInnerClass);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        hugeSetWithInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        hugeSetWithInnerClass.remove((Object)HugeEnumWithInnerClass.f);
        EnumSet<HugeEnumWithInnerClass> anotherHugeSetWithInnerClass = EnumSet.noneOf(HugeEnumWithInnerClass.class);
        anotherHugeSetWithInnerClass.add(HugeEnumWithInnerClass.e);
        anotherHugeSetWithInnerClass.add(HugeEnumWithInnerClass.f);
        result = hugeSetWithInnerClass.retainAll(anotherHugeSetWithInnerClass);
        EnumSetTest.assertTrue((boolean)result);
        result = hugeSetWithInnerClass.contains((Object)HugeEnumWithInnerClass.e);
        EnumSetTest.assertTrue((String)"Should contain HugeEnumWithInnerClass.e", (boolean)result);
        result = hugeSetWithInnerClass.contains((Object)HugeEnumWithInnerClass.b);
        EnumSetTest.assertFalse((String)"Should not contain HugeEnumWithInnerClass.b", (boolean)result);
        EnumSetTest.assertEquals((String)"Size of hugeSet should be 1:", (int)1, (int)hugeSetWithInnerClass.size());
        anotherHugeSetWithInnerClass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        result = hugeSetWithInnerClass.retainAll(anotherHugeSetWithInnerClass);
        EnumSetTest.assertFalse((String)"Return value should be false", (boolean)result);
        rawCollection = new ArrayList();
        rawCollection.add(HugeEnumWithInnerClass.e);
        rawCollection.add(HugeEnumWithInnerClass.f);
        result = hugeSetWithInnerClass.retainAll(rawCollection);
        EnumSetTest.assertFalse((boolean)result);
        hugeSet = EnumSet.allOf(HugeEnum.class);
        hugeSet.remove((Object)HugeEnum.a);
        anotherHugeSet = EnumSet.noneOf(HugeEnum.class);
        anotherHugeSet.add(HugeEnum.a);
        result = hugeSet.retainAll(anotherHugeSet);
        EnumSetTest.assertTrue((boolean)result);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="iterator", args={})
    public void test_iterator() {
        EnumSet<EnumFoo> set = EnumSet.noneOf(EnumFoo.class);
        set.add(EnumFoo.a);
        set.add(EnumFoo.b);
        Iterator iterator = set.iterator();
        Iterator anotherIterator = set.iterator();
        EnumSetTest.assertNotSame((String)"Should not be same", iterator, anotherIterator);
        try {
            iterator.remove();
            EnumSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumSetTest.assertTrue((String)"Should has next element:", (boolean)iterator.hasNext());
        EnumSetTest.assertSame((String)"Should be identical", (Object)((Object)EnumFoo.a), iterator.next());
        iterator.remove();
        EnumSetTest.assertTrue((String)"Should has next element:", (boolean)iterator.hasNext());
        EnumSetTest.assertSame((String)"Should be identical", (Object)((Object)EnumFoo.b), iterator.next());
        EnumSetTest.assertFalse((String)"Should not has next element:", (boolean)iterator.hasNext());
        EnumSetTest.assertFalse((String)"Should not has next element:", (boolean)iterator.hasNext());
        EnumSetTest.assertEquals((String)"Size should be 1:", (int)1, (int)set.size());
        try {
            iterator.next();
            EnumSetTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        set = EnumSet.noneOf(EnumFoo.class);
        set.add(EnumFoo.a);
        iterator = set.iterator();
        EnumSetTest.assertEquals((String)"Should be equal", (Object)((Object)EnumFoo.a), iterator.next());
        iterator.remove();
        try {
            iterator.remove();
            EnumSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumSet<EmptyEnum> emptySet = EnumSet.allOf(EmptyEnum.class);
        Iterator emptyIterator = emptySet.iterator();
        try {
            emptyIterator.next();
            EnumSetTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        EnumSet<EnumWithInnerClass> setWithSubclass = EnumSet.allOf(EnumWithInnerClass.class);
        setWithSubclass.remove((Object)EnumWithInnerClass.e);
        Iterator iteratorWithSubclass = setWithSubclass.iterator();
        EnumSetTest.assertSame((String)"Should be same", (Object)((Object)EnumWithInnerClass.a), iteratorWithSubclass.next());
        EnumSetTest.assertTrue((String)"Should return true", (boolean)iteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((String)"Should be same", (Object)((Object)EnumWithInnerClass.b), iteratorWithSubclass.next());
        setWithSubclass.remove((Object)EnumWithInnerClass.c);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)iteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((String)"Should be same", (Object)((Object)EnumWithInnerClass.c), iteratorWithSubclass.next());
        EnumSetTest.assertTrue((String)"Should return true", (boolean)iteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((String)"Should be same", (Object)((Object)EnumWithInnerClass.d), iteratorWithSubclass.next());
        setWithSubclass.add(EnumWithInnerClass.e);
        EnumSetTest.assertTrue((String)"Should return true", (boolean)iteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((String)"Should be same", (Object)((Object)EnumWithInnerClass.f), iteratorWithSubclass.next());
        set = EnumSet.noneOf(EnumFoo.class);
        iterator = set.iterator();
        try {
            iterator.next();
            EnumSetTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        set.add(EnumFoo.a);
        iterator = set.iterator();
        EnumSetTest.assertEquals((String)"Should return EnumFoo.a", (Object)((Object)EnumFoo.a), iterator.next());
        EnumSetTest.assertEquals((String)"Size of set should be 1", (int)1, (int)set.size());
        iterator.remove();
        EnumSetTest.assertEquals((String)"Size of set should be 0", (int)0, (int)set.size());
        EnumSetTest.assertFalse((String)"Should return false", (boolean)set.contains((Object)EnumFoo.a));
        set.add(EnumFoo.a);
        set.add(EnumFoo.b);
        iterator = set.iterator();
        EnumSetTest.assertEquals((String)"Should be equals", (Object)((Object)EnumFoo.a), iterator.next());
        iterator.remove();
        try {
            iterator.remove();
            EnumSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumSetTest.assertTrue((String)"Should have next element", (boolean)iterator.hasNext());
        try {
            iterator.remove();
            EnumSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumSetTest.assertEquals((String)"Size of set should be 1", (int)1, (int)set.size());
        EnumSetTest.assertTrue((String)"Should have next element", (boolean)iterator.hasNext());
        EnumSetTest.assertEquals((String)"Should return EnumFoo.b", (Object)((Object)EnumFoo.b), iterator.next());
        set.remove((Object)EnumFoo.b);
        EnumSetTest.assertEquals((String)"Size of set should be 0", (int)0, (int)set.size());
        iterator.remove();
        EnumSetTest.assertFalse((String)"Should return false", (boolean)set.contains((Object)EnumFoo.a));
        EnumSet<HugeEnum> hugeSet = EnumSet.noneOf(HugeEnum.class);
        hugeSet.add(HugeEnum.a);
        hugeSet.add(HugeEnum.b);
        Iterator hIterator = hugeSet.iterator();
        Iterator anotherHugeIterator = hugeSet.iterator();
        EnumSetTest.assertNotSame(hIterator, anotherHugeIterator);
        try {
            hIterator.remove();
            EnumSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumSetTest.assertTrue((boolean)hIterator.hasNext());
        EnumSetTest.assertSame((Object)((Object)HugeEnum.a), hIterator.next());
        hIterator.remove();
        EnumSetTest.assertTrue((boolean)hIterator.hasNext());
        EnumSetTest.assertSame((Object)((Object)HugeEnum.b), hIterator.next());
        EnumSetTest.assertFalse((boolean)hIterator.hasNext());
        EnumSetTest.assertFalse((boolean)hIterator.hasNext());
        EnumSetTest.assertEquals((int)1, (int)hugeSet.size());
        try {
            hIterator.next();
            EnumSetTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeSetWithSubclass = EnumSet.allOf(HugeEnumWithInnerClass.class);
        hugeSetWithSubclass.remove((Object)HugeEnumWithInnerClass.e);
        Iterator hugeIteratorWithSubclass = hugeSetWithSubclass.iterator();
        EnumSetTest.assertSame((Object)((Object)HugeEnumWithInnerClass.a), hugeIteratorWithSubclass.next());
        EnumSetTest.assertTrue((boolean)hugeIteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((Object)((Object)HugeEnumWithInnerClass.b), hugeIteratorWithSubclass.next());
        setWithSubclass.remove((Object)HugeEnumWithInnerClass.c);
        EnumSetTest.assertTrue((boolean)hugeIteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((Object)((Object)HugeEnumWithInnerClass.c), hugeIteratorWithSubclass.next());
        EnumSetTest.assertTrue((boolean)hugeIteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((Object)((Object)HugeEnumWithInnerClass.d), hugeIteratorWithSubclass.next());
        hugeSetWithSubclass.add(HugeEnumWithInnerClass.e);
        EnumSetTest.assertTrue((boolean)hugeIteratorWithSubclass.hasNext());
        EnumSetTest.assertSame((Object)((Object)HugeEnumWithInnerClass.f), hugeIteratorWithSubclass.next());
        hugeSet = EnumSet.noneOf(HugeEnum.class);
        hIterator = hugeSet.iterator();
        try {
            hIterator.next();
            EnumSetTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        hugeSet.add(HugeEnum.a);
        hIterator = hugeSet.iterator();
        EnumSetTest.assertEquals((Object)((Object)HugeEnum.a), hIterator.next());
        EnumSetTest.assertEquals((int)1, (int)hugeSet.size());
        hIterator.remove();
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        EnumSetTest.assertFalse((boolean)hugeSet.contains((Object)HugeEnum.a));
        hugeSet.add(HugeEnum.a);
        hugeSet.add(HugeEnum.b);
        hIterator = hugeSet.iterator();
        hIterator.next();
        hIterator.remove();
        EnumSetTest.assertTrue((boolean)hIterator.hasNext());
        try {
            hIterator.remove();
            EnumSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumSetTest.assertEquals((int)1, (int)hugeSet.size());
        EnumSetTest.assertTrue((boolean)hIterator.hasNext());
        EnumSetTest.assertEquals((Object)((Object)HugeEnum.b), hIterator.next());
        hugeSet.remove((Object)HugeEnum.b);
        EnumSetTest.assertEquals((int)0, (int)hugeSet.size());
        hIterator.remove();
        EnumSetTest.assertFalse((boolean)hugeSet.contains((Object)HugeEnum.a));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="of", args={Enum.class})
    public void test_Of_E() {
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.of(EnumWithInnerClass.a);
        EnumSetTest.assertEquals((String)"enumSet should have length 1:", (int)1, (int)enumSet.size());
        EnumSetTest.assertTrue((String)"enumSet should contain EnumWithSubclass.a:", (boolean)enumSet.contains((Object)EnumWithInnerClass.a));
        try {
            EnumSet.of((EnumWithInnerClass)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a);
        EnumSetTest.assertEquals((int)1, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.a));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="of", args={Enum.class, Enum.class})
    public void test_Of_EE() {
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.of(EnumWithInnerClass.a, EnumWithInnerClass.b);
        EnumSetTest.assertEquals((String)"enumSet should have length 2:", (int)2, (int)enumSet.size());
        EnumSetTest.assertTrue((String)"enumSet should contain EnumWithSubclass.a:", (boolean)enumSet.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"enumSet should contain EnumWithSubclass.b:", (boolean)enumSet.contains((Object)EnumWithInnerClass.b));
        try {
            EnumSet.of((EnumWithInnerClass)null, EnumWithInnerClass.a);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            EnumSet.of(EnumWithInnerClass.a, (EnumWithInnerClass)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            EnumSet.of((EnumWithInnerClass)null, (EnumWithInnerClass)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        enumSet = EnumSet.of(EnumWithInnerClass.a, EnumWithInnerClass.a);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 1", (int)1, (int)enumSet.size());
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.b);
        EnumSetTest.assertEquals((int)2, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.b));
        try {
            EnumSet.of((HugeEnumWithInnerClass)null, HugeEnumWithInnerClass.a);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            EnumSet.of(HugeEnumWithInnerClass.a, (HugeEnumWithInnerClass)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            EnumSet.of((HugeEnumWithInnerClass)null, (HugeEnumWithInnerClass)null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.a);
        EnumSetTest.assertEquals((int)1, (int)hugeEnumSet.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="of", args={Enum.class, Enum.class, Enum.class})
    public void test_Of_EEE() {
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.of(EnumWithInnerClass.a, EnumWithInnerClass.b, EnumWithInnerClass.c);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 3:", (int)3, (int)enumSet.size());
        EnumSetTest.assertTrue((String)"enumSet should contain EnumWithSubclass.a:", (boolean)enumSet.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"Should return true", (boolean)enumSet.contains((Object)EnumWithInnerClass.c));
        try {
            EnumSet.of((EnumWithInnerClass)null, null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        enumSet = EnumSet.of(EnumWithInnerClass.a, EnumWithInnerClass.b, EnumWithInnerClass.b);
        EnumSetTest.assertEquals((String)"enumSet should contain 2 elements:", (int)2, (int)enumSet.size());
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.c);
        EnumSetTest.assertEquals((int)3, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.c));
        try {
            EnumSet.of((HugeEnumWithInnerClass)null, null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.b);
        EnumSetTest.assertEquals((int)2, (int)hugeEnumSet.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="of", args={Enum.class, Enum.class, Enum.class, Enum.class})
    public void test_Of_EEEE() {
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.of(EnumWithInnerClass.a, EnumWithInnerClass.b, EnumWithInnerClass.c, EnumWithInnerClass.d);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 4", (int)4, (int)enumSet.size());
        EnumSetTest.assertTrue((String)"enumSet should contain EnumWithSubclass.a:", (boolean)enumSet.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"enumSet should contain EnumWithSubclass.d:", (boolean)enumSet.contains((Object)EnumWithInnerClass.d));
        try {
            EnumSet.of((EnumWithInnerClass)null, null, null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.c, HugeEnumWithInnerClass.d);
        EnumSetTest.assertEquals((int)4, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.d));
        try {
            EnumSet.of((HugeEnumWithInnerClass)null, null, null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="of", args={Enum.class, Enum.class, Enum.class, Enum.class, Enum.class})
    public void test_Of_EEEEE() {
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.of(EnumWithInnerClass.a, EnumWithInnerClass.b, EnumWithInnerClass.c, EnumWithInnerClass.d, EnumWithInnerClass.e);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 5:", (int)5, (int)enumSet.size());
        EnumSetTest.assertTrue((String)"Should return true", (boolean)enumSet.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"Should return true", (boolean)enumSet.contains((Object)EnumWithInnerClass.e));
        try {
            EnumSet.of((EnumWithInnerClass)null, null, null, null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.c, HugeEnumWithInnerClass.d, HugeEnumWithInnerClass.e);
        EnumSetTest.assertEquals((int)5, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.e));
        try {
            EnumSet.of((HugeEnumWithInnerClass)null, null, null, null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="of", args={Enum.class, Enum[].class})
    public void test_Of_EEArray() {
        EnumWithInnerClass[] enumArray = new EnumWithInnerClass[]{EnumWithInnerClass.b, EnumWithInnerClass.c};
        EnumSet<EnumWithInnerClass[]> enumSet = EnumSet.of(EnumWithInnerClass.a, enumArray);
        EnumSetTest.assertEquals((String)"Should be equal", (int)3, (int)enumSet.size());
        EnumSetTest.assertTrue((String)"Should return true", (boolean)enumSet.contains((Object)EnumWithInnerClass.a));
        EnumSetTest.assertTrue((String)"Should return true", (boolean)enumSet.contains((Object)EnumWithInnerClass.c));
        try {
            EnumSet.of(EnumWithInnerClass.a, (EnumWithInnerClass[])null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EnumFoo[] foos = new EnumFoo[]{EnumFoo.a, EnumFoo.c, EnumFoo.d};
        EnumSet<EnumFoo[]> set = EnumSet.of(EnumFoo.c, foos);
        EnumSetTest.assertEquals((String)"size of set should be 1", (int)3, (int)set.size());
        EnumSetTest.assertTrue((String)"Should contain EnumFoo.a", (boolean)set.contains((Object)EnumFoo.a));
        EnumSetTest.assertTrue((String)"Should contain EnumFoo.c", (boolean)set.contains((Object)EnumFoo.c));
        EnumSetTest.assertTrue((String)"Should contain EnumFoo.d", (boolean)set.contains((Object)EnumFoo.d));
        HugeEnumWithInnerClass[] hugeEnumArray = new HugeEnumWithInnerClass[]{HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.c};
        EnumSet<HugeEnumWithInnerClass[]> hugeEnumSet = EnumSet.of(HugeEnumWithInnerClass.a, hugeEnumArray);
        EnumSetTest.assertEquals((int)3, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnumWithInnerClass.c));
        try {
            EnumSet.of(HugeEnumWithInnerClass.a, (HugeEnumWithInnerClass[])null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        HugeEnumWithInnerClass[] huges = new HugeEnumWithInnerClass[]{HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.c, HugeEnumWithInnerClass.d};
        EnumSet<HugeEnumWithInnerClass[]> hugeSet = EnumSet.of(HugeEnumWithInnerClass.c, huges);
        EnumSetTest.assertEquals((int)3, (int)hugeSet.size());
        EnumSetTest.assertTrue((boolean)hugeSet.contains((Object)HugeEnumWithInnerClass.a));
        EnumSetTest.assertTrue((boolean)hugeSet.contains((Object)HugeEnumWithInnerClass.c));
        EnumSetTest.assertTrue((boolean)hugeSet.contains((Object)HugeEnumWithInnerClass.d));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="range", args={Enum.class, Enum.class})
    public void test_Range_EE() {
        try {
            EnumSet.range(EnumWithInnerClass.c, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.range(null, EnumWithInnerClass.c);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.range(null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.range(EnumWithInnerClass.b, EnumWithInnerClass.a);
            EnumSetTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        EnumSet<EnumWithInnerClass> enumSet = EnumSet.range(EnumWithInnerClass.a, EnumWithInnerClass.a);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 1", (int)1, (int)enumSet.size());
        enumSet = EnumSet.range(EnumWithInnerClass.a, EnumWithInnerClass.c);
        EnumSetTest.assertEquals((String)"Size of enumSet should be 3", (int)3, (int)enumSet.size());
        try {
            EnumSet.range(HugeEnumWithInnerClass.c, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.range(null, HugeEnumWithInnerClass.c);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.range(null, null);
            EnumSetTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            EnumSet.range(HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.a);
            EnumSetTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        EnumSet<HugeEnumWithInnerClass> hugeEnumSet = EnumSet.range(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.a);
        EnumSetTest.assertEquals((int)1, (int)hugeEnumSet.size());
        hugeEnumSet = EnumSet.range(HugeEnumWithInnerClass.c, HugeEnumWithInnerClass.aa);
        EnumSetTest.assertEquals((int)51, (int)hugeEnumSet.size());
        hugeEnumSet = EnumSet.range(HugeEnumWithInnerClass.a, HugeEnumWithInnerClass.mm);
        EnumSetTest.assertEquals((int)65, (int)hugeEnumSet.size());
        hugeEnumSet = EnumSet.range(HugeEnumWithInnerClass.b, HugeEnumWithInnerClass.mm);
        EnumSetTest.assertEquals((int)64, (int)hugeEnumSet.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_Clone() {
        EnumSet<EnumFoo> enumSet = EnumSet.allOf(EnumFoo.class);
        Object clonedEnumSet = enumSet.clone();
        EnumSetTest.assertEquals(enumSet, (Object)clonedEnumSet);
        EnumSetTest.assertNotSame(enumSet, (Object)clonedEnumSet);
        EnumSetTest.assertTrue((boolean)((AbstractCollection)clonedEnumSet).contains((Object)EnumFoo.a));
        EnumSetTest.assertTrue((boolean)((AbstractCollection)clonedEnumSet).contains((Object)EnumFoo.b));
        EnumSetTest.assertEquals((int)64, (int)((AbstractCollection)clonedEnumSet).size());
        EnumSet<HugeEnum> hugeEnumSet = EnumSet.allOf(HugeEnum.class);
        Object hugeClonedEnumSet = hugeEnumSet.clone();
        EnumSetTest.assertEquals(hugeEnumSet, (Object)hugeClonedEnumSet);
        EnumSetTest.assertNotSame(hugeEnumSet, (Object)hugeClonedEnumSet);
        EnumSetTest.assertTrue((boolean)((AbstractCollection)hugeClonedEnumSet).contains((Object)HugeEnum.a));
        EnumSetTest.assertTrue((boolean)((AbstractCollection)hugeClonedEnumSet).contains((Object)HugeEnum.b));
        EnumSetTest.assertEquals((int)65, (int)((AbstractCollection)hugeClonedEnumSet).size());
        ((AbstractCollection)hugeClonedEnumSet).remove((Object)HugeEnum.a);
        EnumSetTest.assertEquals((int)64, (int)((AbstractCollection)hugeClonedEnumSet).size());
        EnumSetTest.assertFalse((boolean)((AbstractCollection)hugeClonedEnumSet).contains((Object)HugeEnum.a));
        EnumSetTest.assertEquals((int)65, (int)hugeEnumSet.size());
        EnumSetTest.assertTrue((boolean)hugeEnumSet.contains((Object)HugeEnum.a));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationSelf", args={})
    public void test_serialization() throws Exception {
        EnumSet<EnumFoo> set = EnumSet.allOf(EnumFoo.class);
        SerializationTest.verifySelf(set);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationGolden", args={})
    public void testSerializationCompatibility() throws Exception {
        EnumSet<EnumFoo> set = EnumSet.allOf(EnumFoo.class);
        SerializationTest.verifyGolden((TestCase)this, set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HugeEnumCount {
        NO1,
        NO2,
        NO3,
        NO4,
        NO5,
        NO6,
        NO7,
        NO8,
        NO9,
        NO10,
        NO11,
        NO12,
        NO13,
        NO14,
        NO15,
        NO16,
        NO17,
        NO18,
        NO19,
        NO20,
        NO21,
        NO22,
        NO23,
        NO24,
        NO25,
        NO26,
        NO27,
        NO28,
        NO29,
        NO30,
        NO31,
        NO32,
        NO33,
        NO34,
        NO35,
        NO36,
        NO37,
        NO38,
        NO39,
        NO40,
        NO41,
        NO42,
        NO43,
        NO44,
        NO45,
        NO46,
        NO47,
        NO48,
        NO49,
        NO50,
        NO51,
        NO52,
        NO53,
        NO54,
        NO55,
        NO56,
        NO57,
        NO58,
        NO59,
        NO60,
        NO61,
        NO62,
        NO63,
        NO64,
        NO65,
        NO66,
        NO67,
        NO68,
        NO69,
        NO70,
        NO71,
        NO72,
        NO73,
        NO74,
        NO75,
        NO76,
        NO77,
        NO78,
        NO79,
        NO80,
        NO81,
        NO82,
        NO83,
        NO84,
        NO85,
        NO86,
        NO87,
        NO88,
        NO89,
        NO90,
        NO91,
        NO92,
        NO93,
        NO94,
        NO95,
        NO96,
        NO97,
        NO98,
        NO99,
        NO100,
        NO101,
        NO102,
        NO103,
        NO104,
        NO105,
        NO106,
        NO107,
        NO108,
        NO109,
        NO110,
        NO111,
        NO112,
        NO113,
        NO114,
        NO115,
        NO116,
        NO117,
        NO118,
        NO119,
        NO120,
        NO121,
        NO122,
        NO123,
        NO124,
        NO125,
        NO126,
        NO127,
        NO128,
        NO129,
        NO130;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HugeEnum {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        x,
        y,
        z,
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z,
        aa,
        bb,
        cc,
        dd,
        ee,
        ff,
        gg,
        hh,
        ii,
        jj,
        kk,
        ll,
        mm;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HugeEnumWithInnerClass {
        a{}
        ,
        b{}
        ,
        c{}
        ,
        d{}
        ,
        e{}
        ,
        f{}
        ,
        g{}
        ,
        h{}
        ,
        i{}
        ,
        j{}
        ,
        k{}
        ,
        l{}
        ,
        m{}
        ,
        n{}
        ,
        o{}
        ,
        p{}
        ,
        q{}
        ,
        r{}
        ,
        s{}
        ,
        t{}
        ,
        u{}
        ,
        v{}
        ,
        w{}
        ,
        x{}
        ,
        y{}
        ,
        z{}
        ,
        A{}
        ,
        B{}
        ,
        C{}
        ,
        D{}
        ,
        E{}
        ,
        F{}
        ,
        G{}
        ,
        H{}
        ,
        I{}
        ,
        J{}
        ,
        K{}
        ,
        L{}
        ,
        M{}
        ,
        N{}
        ,
        O{}
        ,
        P{}
        ,
        Q{}
        ,
        R{}
        ,
        S{}
        ,
        T{}
        ,
        U{}
        ,
        V{}
        ,
        W{}
        ,
        X{}
        ,
        Y{}
        ,
        Z{}
        ,
        aa{}
        ,
        bb{}
        ,
        cc{}
        ,
        dd{}
        ,
        ee{}
        ,
        ff{}
        ,
        gg{}
        ,
        hh{}
        ,
        ii{}
        ,
        jj{}
        ,
        kk{}
        ,
        ll{}
        ,
        mm{};

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EmptyEnum {

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EnumFoo {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        x,
        y,
        z,
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z,
        aa,
        bb,
        cc,
        dd,
        ee,
        ff,
        gg,
        hh,
        ii,
        jj,
        kk,
        ll;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EnumWithAllInnerClass {
        a{}
        ,
        b{};

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EnumWithInnerClass {
        a,
        b,
        c,
        d,
        e,
        f{};

    }
}

