/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.AndroidOnly;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

@TestTargetClass(value=EnumMap.class)
public class EnumMapTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="EnumMap", args={Class.class})
    public void test_ConstructorLjava_lang_Class() {
        try {
            new EnumMap((Class)null);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new EnumMap(((Object)((Object)Size.Big)).getClass());
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new EnumMap(Integer.class);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumMap<Color, Integer> enumColorMap = new EnumMap<Color, Integer>(Color.class);
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumColorMap.put(Color.Green, 2));
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)2, enumColorMap.get((Object)Color.Green));
        EnumMap<Empty, Integer> enumEmptyMap = new EnumMap<Empty, Integer>(Empty.class);
        try {
            enumEmptyMap.put((Empty)((Object)Color.Red), 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumSizeMap.put(Size.Big, 2));
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)2, enumSizeMap.get((Object)Size.Big));
        try {
            enumSizeMap.put((Size)((Object)Color.Red), 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        enumSizeMap = new EnumMap(((Object)((Object)Size.Middle)).getClass());
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumSizeMap.put(Size.Small, 1));
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)1, enumSizeMap.get((Object)Size.Small));
        try {
            enumSizeMap.put((Size)((Object)Color.Red), 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="EnumMap", args={EnumMap.class})
    public void test_ConstructorLjava_util_EnumMap() {
        EnumMap<Object, Integer> enumMap;
        EnumMap<Color, Number> enumColorMap = null;
        try {
            enumMap = new EnumMap(enumColorMap);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        enumColorMap = new EnumMap<Color, Number>(Color.class);
        Double double1 = new Double(1.0);
        enumColorMap.put(Color.Green, 2);
        enumColorMap.put(Color.Blue, double1);
        enumMap = new EnumMap(enumColorMap);
        EnumMapTest.assertEquals((String)"Constructor fails", (Object)2, enumMap.get((Object)Color.Green));
        EnumMapTest.assertSame((String)"Constructor fails", (Object)double1, enumMap.get((Object)Color.Blue));
        EnumMapTest.assertNull((String)"Constructor fails", enumMap.get((Object)Color.Red));
        enumMap.put((Object)Color.Red, 1);
        EnumMapTest.assertEquals((String)"Wrong value", (Object)1, enumMap.get((Object)Color.Red));
        try {
            enumMap.put((Object)Size.Middle, 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="EnumMap", args={Map.class})
    public void test_ConstructorLjava_util_Map() {
        EnumMap enumMap;
        EnumMap<Color, Integer> enumColorMap = null;
        try {
            enumMap = new EnumMap(enumColorMap);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        enumColorMap = new EnumMap<Color, Integer>(Color.class);
        enumMap = new EnumMap(enumColorMap);
        enumColorMap.put(Color.Blue, 3);
        enumMap = new EnumMap(enumColorMap);
        HashMap<Object, Integer> hashColorMap = null;
        try {
            enumMap = new EnumMap(hashColorMap);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        hashColorMap = new HashMap<Object, Integer>();
        try {
            enumMap = new EnumMap(hashColorMap);
            EnumMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        hashColorMap.put((Object)Color.Green, 2);
        enumMap = new EnumMap(hashColorMap);
        EnumMapTest.assertEquals((String)"Constructor fails", (Object)2, enumMap.get((Object)Color.Green));
        EnumMapTest.assertNull((String)"Constructor fails", enumMap.get((Object)Color.Red));
        enumMap.put((Object)((Object)Color.Red), 1);
        EnumMapTest.assertEquals((String)"Wrong value", (Object)1, enumMap.get((Object)Color.Red));
        hashColorMap.put((Object)Size.Big, 3);
        try {
            enumMap = new EnumMap(hashColorMap);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        hashColorMap = new HashMap();
        hashColorMap.put(new Integer(1), 1);
        try {
            enumMap = new EnumMap(hashColorMap);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        enumSizeMap.put(Size.Small, 1);
        enumSizeMap.clear();
        EnumMapTest.assertNull((String)"Failed to clear all elements", enumSizeMap.get((Object)Size.Small));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsKey", args={Object.class})
    public void test_containsKeyLjava_lang_Object() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        EnumMapTest.assertFalse((String)"Returned true for uncontained key", (boolean)enumSizeMap.containsKey((Object)Size.Small));
        enumSizeMap.put(Size.Small, 1);
        EnumMapTest.assertTrue((String)"Returned false for contained key", (boolean)enumSizeMap.containsKey((Object)Size.Small));
        enumSizeMap.put(Size.Big, null);
        EnumMapTest.assertTrue((String)"Returned false for contained key", (boolean)enumSizeMap.containsKey((Object)Size.Big));
        EnumMapTest.assertFalse((String)"Returned true for uncontained key", (boolean)enumSizeMap.containsKey((Object)Color.Red));
        EnumMapTest.assertFalse((String)"Returned true for uncontained key", (boolean)enumSizeMap.containsKey(new Integer("3")));
        EnumMapTest.assertFalse((String)"Returned true for uncontained key", (boolean)enumSizeMap.containsKey(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        Integer integer = new Integer("3");
        enumSizeMap.put(Size.Small, integer);
        Object enumSizeMapClone = enumSizeMap.clone();
        EnumMapTest.assertNotSame((String)"Should not be same", enumSizeMap, (Object)enumSizeMapClone);
        EnumMapTest.assertEquals((String)"Clone answered unequal EnumMap", enumSizeMap, (Object)enumSizeMapClone);
        EnumMapTest.assertSame((String)"Should be same", enumSizeMap.get((Object)Size.Small), ((EnumMap)enumSizeMapClone).get((Object)Size.Small));
        EnumMapTest.assertSame((String)"Clone is not shallow clone", (Object)integer, ((EnumMap)enumSizeMapClone).get((Object)Size.Small));
        enumSizeMap.remove((Object)Size.Small);
        EnumMapTest.assertSame((String)"Clone is not shallow clone", (Object)integer, ((EnumMap)enumSizeMapClone).get((Object)Size.Small));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsValue", args={Object.class})
    public void test_containsValueLjava_lang_Object() {
        EnumMap<Size, Number> enumSizeMap = new EnumMap<Size, Number>(Size.class);
        Double double1 = new Double(3.0);
        Double double2 = new Double(3.0);
        EnumMapTest.assertFalse((String)"Returned true for uncontained value", (boolean)enumSizeMap.containsValue(double1));
        enumSizeMap.put(Size.Middle, 2);
        enumSizeMap.put(Size.Small, double1);
        EnumMapTest.assertTrue((String)"Returned false for contained value", (boolean)enumSizeMap.containsValue(double1));
        EnumMapTest.assertTrue((String)"Returned false for contained value", (boolean)enumSizeMap.containsValue(double2));
        EnumMapTest.assertTrue((String)"Returned false for contained value", (boolean)enumSizeMap.containsValue(2));
        EnumMapTest.assertFalse((String)"Returned true for uncontained value", (boolean)enumSizeMap.containsValue(1));
        EnumMapTest.assertFalse((String)"Returned true for uncontained value", (boolean)enumSizeMap.containsValue(null));
        enumSizeMap.put(Size.Big, null);
        EnumMapTest.assertTrue((String)"Returned false for contained value", (boolean)enumSizeMap.containsValue(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="entrySet", args={})
    @AndroidOnly(value="Map.Entry is indirectly modified on RI when Iterator.next() is invoked")
    public void test_entrySet() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        MockEntry<Object, Integer> mockEntry = new MockEntry<Size, Integer>(Size.Middle, 1);
        Set set = enumSizeMap.entrySet();
        Set set1 = enumSizeMap.entrySet();
        EnumMapTest.assertSame((String)"Should be same", set1, set);
        try {
            set.add(mockEntry);
            EnumMapTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(mockEntry));
        mockEntry = new MockEntry<Size, Object>(Size.Middle, null);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains((Object)Size.Small));
        mockEntry = new MockEntry<Integer, Integer>(new Integer(1), 1);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(new Integer(1)));
        mockEntry = new MockEntry<Size, Object>(Size.Big, null);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(mockEntry));
        EnumMapTest.assertTrue((String)"Returned false when the object can be removed", (boolean)set.remove(mockEntry));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)set.remove(mockEntry));
        mockEntry = new MockEntry<Integer, Integer>(new Integer(1), 1);
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)set.remove(mockEntry));
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)set.remove(new Integer(1)));
        enumSizeMap.put(Size.Big, 3);
        mockEntry = new MockEntry<Size, Integer>(Size.Big, 3);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(mockEntry));
        enumSizeMap.remove((Object)Size.Big);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        set.clear();
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)set.size());
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.entrySet();
        ArrayList<MockEntry<Size, Integer>> c = new ArrayList<MockEntry<Size, Integer>>();
        c.add(new MockEntry<Size, Integer>(Size.Middle, 1));
        EnumMapTest.assertTrue((String)"Return wrong value", (boolean)set.containsAll(c));
        EnumMapTest.assertTrue((String)"Remove does not success", (boolean)set.removeAll(c));
        enumSizeMap.put(Size.Middle, 1);
        c.add(new MockEntry<Size, Integer>(Size.Big, 3));
        EnumMapTest.assertTrue((String)"Remove does not success", (boolean)set.removeAll(c));
        EnumMapTest.assertFalse((String)"Should return false", (boolean)set.removeAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.entrySet();
        c = new ArrayList();
        c.add(new MockEntry<Size, Integer>(Size.Middle, 1));
        c.add(new MockEntry<Size, Integer>(Size.Big, 3));
        EnumMapTest.assertTrue((String)"Retain does not success", (boolean)set.retainAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        EnumMapTest.assertFalse((String)"Should return false", (boolean)set.retainAll(c));
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.entrySet();
        Object[] array = set.toArray();
        EnumMapTest.assertEquals((String)"Wrong length", (int)2, (int)array.length);
        Map.Entry<Size, Integer> entry = (Map.Entry<Size, Integer>)array[0];
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Middle), entry.getKey());
        EnumMapTest.assertEquals((String)"Wrong value", (Object)1, entry.getValue());
        Object[] array1 = new Object[10];
        array1 = set.toArray();
        EnumMapTest.assertEquals((String)"Wrong length", (int)2, (int)array1.length);
        entry = (Map.Entry)array[0];
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Middle), entry.getKey());
        EnumMapTest.assertEquals((String)"Wrong value", (Object)1, entry.getValue());
        array1 = new Object[10];
        array1 = set.toArray(array1);
        EnumMapTest.assertEquals((String)"Wrong length", (int)10, (int)array1.length);
        entry = (Map.Entry)array[1];
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Big), entry.getKey());
        EnumMapTest.assertNull((String)"Should be null", (Object)array1[2]);
        set = enumSizeMap.entrySet();
        Integer integer = new Integer("1");
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)set.remove(integer));
        EnumMapTest.assertTrue((String)"Returned false when the object can be removed", (boolean)set.remove(entry));
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.entrySet();
        Iterator iter = set.iterator();
        entry = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(entry));
        mockEntry = new MockEntry<Size, Integer>(Size.Middle, 2);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        mockEntry = new MockEntry<Integer, Integer>(new Integer(2), 2);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        entry = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(entry));
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.remove((Object)Size.Big);
        mockEntry = new MockEntry<Size, Object>(Size.Big, null);
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(mockEntry));
        enumSizeMap.put(Size.Big, 2);
        mockEntry = new MockEntry<Size, Integer>(Size.Big, 2);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(mockEntry));
        iter.remove();
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            entry.setValue(2);
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            set.contains(entry);
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.entrySet();
        iter = set.iterator();
        entry = iter.next();
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Middle), (Object)((Object)entry.getKey()));
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(entry));
        enumSizeMap.put(Size.Middle, 3);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(entry));
        entry.setValue(2);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(entry));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.remove(new Integer(1)));
        iter.next();
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Middle), (Object)((Object)entry.getKey()));
        set.clear();
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)set.size());
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.entrySet();
        iter = set.iterator();
        mockEntry = new MockEntry<Size, Integer>(Size.Middle, 1);
        EnumMapTest.assertFalse((String)"Wrong result", (boolean)((Object)entry).equals(mockEntry));
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        entry = iter.next();
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Middle), (Object)((Object)entry.getKey()));
        EnumMapTest.assertTrue((String)"Should return true", (boolean)((Object)entry).equals(mockEntry));
        EnumMapTest.assertEquals((String)"Should be equal", (int)mockEntry.hashCode(), (int)((Object)entry).hashCode());
        mockEntry = new MockEntry<Size, Integer>(Size.Big, 1);
        EnumMapTest.assertFalse((String)"Wrong result", (boolean)((Object)entry).equals(mockEntry));
        entry = iter.next();
        EnumMapTest.assertFalse((String)"Wrong result", (boolean)((Object)entry).equals(mockEntry));
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Big), (Object)((Object)entry.getKey()));
        iter.remove();
        EnumMapTest.assertFalse((String)"Wrong result", (boolean)((Object)entry).equals(mockEntry));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            iter.next();
            EnumMapTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        EnumMap<Size, Integer> enumMap = new EnumMap<Size, Integer>(Size.class);
        enumMap.put(Size.Small, 1);
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        EnumMapTest.assertFalse((String)"Returned true for unequal EnumMap", (boolean)enumSizeMap.equals((Object)enumMap));
        enumSizeMap.put(Size.Small, 1);
        EnumMapTest.assertTrue((String)"Returned false for equal EnumMap", (boolean)enumSizeMap.equals((Object)enumMap));
        enumSizeMap.put(Size.Big, null);
        EnumMapTest.assertFalse((String)"Returned true for unequal EnumMap", (boolean)enumSizeMap.equals((Object)enumMap));
        enumMap.put(Size.Middle, null);
        EnumMapTest.assertFalse((String)"Returned true for unequal EnumMap", (boolean)enumSizeMap.equals((Object)enumMap));
        enumMap.remove((Object)Size.Middle);
        enumMap.put(Size.Big, 3);
        EnumMapTest.assertFalse((String)"Returned true for unequal EnumMap", (boolean)enumSizeMap.equals((Object)enumMap));
        enumMap.put(Size.Big, null);
        EnumMapTest.assertTrue((String)"Returned false for equal EnumMap", (boolean)enumSizeMap.equals((Object)enumMap));
        HashMap<Size, Integer> hashMap = new HashMap<Size, Integer>();
        hashMap.put(Size.Small, 1);
        EnumMapTest.assertFalse((String)"Returned true for unequal EnumMap", (boolean)hashMap.equals(enumMap));
        hashMap.put(Size.Big, null);
        EnumMapTest.assertTrue((String)"Returned false for equal EnumMap", (boolean)enumMap.equals(hashMap));
        EnumMapTest.assertFalse((String)"Should return false", (boolean)enumSizeMap.equals(new Integer(1)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keySet", args={})
    public void test_keySet() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        enumSizeMap.put(Size.Middle, 2);
        enumSizeMap.put(Size.Big, null);
        Set<Size> set = enumSizeMap.keySet();
        Set<Size> set1 = enumSizeMap.keySet();
        EnumMapTest.assertSame((String)"Should be same", set1, set);
        try {
            set.add(Size.Big);
            EnumMapTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains((Object)Size.Middle));
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains((Object)Size.Big));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains((Object)Size.Small));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(new Integer(1)));
        EnumMapTest.assertTrue((String)"Returned false when the object can be removed", (boolean)set.remove((Object)Size.Big));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains((Object)Size.Big));
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)set.remove((Object)Size.Big));
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)set.remove(new Integer(1)));
        enumSizeMap.put(Size.Big, 3);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains((Object)Size.Big));
        enumSizeMap.remove((Object)Size.Big);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains((Object)Size.Big));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        set.clear();
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)set.size());
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.keySet();
        ArrayList<Enum> c = new ArrayList<Enum>();
        c.add(Size.Big);
        EnumMapTest.assertTrue((String)"Should return true", (boolean)set.containsAll(c));
        c.add(Size.Small);
        EnumMapTest.assertFalse((String)"Should return false", (boolean)set.containsAll(c));
        EnumMapTest.assertTrue((String)"Should return true", (boolean)set.removeAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        EnumMapTest.assertFalse((String)"Should return false", (boolean)set.removeAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        try {
            set.addAll(c);
            EnumMapTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        enumSizeMap.put(Size.Big, null);
        EnumMapTest.assertEquals((String)"Wrong size", (int)2, (int)set.size());
        EnumMapTest.assertTrue((String)"Should return true", (boolean)set.retainAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        EnumMapTest.assertFalse((String)"Should return false", (boolean)set.retainAll(c));
        EnumMapTest.assertEquals((int)1, (int)set.size());
        Object[] array = set.toArray();
        EnumMapTest.assertEquals((String)"Wrong length", (int)1, (int)array.length);
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Big), (Object)array[0]);
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.keySet();
        c = new ArrayList();
        c.add(Color.Blue);
        EnumMapTest.assertFalse((String)"Should return false", (boolean)set.remove(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)2, (int)set.size());
        EnumMapTest.assertTrue((String)"Should return true", (boolean)set.retainAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)set.size());
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.keySet();
        Iterator<Size> iter = set.iterator();
        Enum enumKey = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(enumKey));
        enumKey = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(enumKey));
        enumSizeMap.remove((Object)Size.Big);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(enumKey));
        iter.remove();
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(enumKey));
        iter = set.iterator();
        enumKey = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(enumKey));
        enumSizeMap.put(Size.Middle, 3);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)set.contains(enumKey));
        enumSizeMap = new EnumMap(Size.class);
        enumSizeMap.put(Size.Middle, 1);
        enumSizeMap.put(Size.Big, null);
        set = enumSizeMap.keySet();
        iter = set.iterator();
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        enumKey = iter.next();
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Middle), (Object)enumKey);
        EnumMapTest.assertSame((String)"Wrong key", (Object)((Object)Size.Middle), (Object)enumKey);
        EnumMapTest.assertFalse((String)"Returned true for unequal object", (boolean)iter.equals(enumKey));
        iter.remove();
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)set.contains(enumKey));
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)set.size());
        enumKey = iter.next();
        EnumMapTest.assertEquals((String)"Wrong key", (Object)((Object)Size.Big), (Object)enumKey);
        iter.remove();
        try {
            iter.next();
            EnumMapTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})
    public void test_getLjava_lang_Object() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumSizeMap.get((Object)Size.Big));
        enumSizeMap.put(Size.Big, 1);
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)1, enumSizeMap.get((Object)Size.Big));
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumSizeMap.get((Object)Size.Small));
        EnumMapTest.assertNull((String)"Get returned non-null for non existent key", enumSizeMap.get((Object)Color.Red));
        EnumMapTest.assertNull((String)"Get returned non-null for non existent key", enumSizeMap.get(new Integer(1)));
        EnumMapTest.assertNull((String)"Get returned non-null for non existent key", enumSizeMap.get(null));
        EnumMap<Color, Number> enumColorMap = new EnumMap<Color, Number>(Color.class);
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumColorMap.get((Object)Color.Green));
        enumColorMap.put(Color.Green, 2);
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)2, enumColorMap.get((Object)Color.Green));
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumColorMap.get((Object)Color.Blue));
        enumColorMap.put(Color.Green, new Double(4.0));
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)new Double(4.0), enumColorMap.get((Object)Color.Green));
        enumColorMap.put(Color.Green, new Integer("3"));
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)new Integer("3"), enumColorMap.get((Object)Color.Green));
        enumColorMap.put(Color.Green, null);
        EnumMapTest.assertNull((String)"Can not handle null value", enumColorMap.get((Object)Color.Green));
        Float f = new Float("3.4");
        enumColorMap.put(Color.Green, f);
        EnumMapTest.assertSame((String)"Get returned incorrect value for given key", (Object)f, enumColorMap.get((Object)Color.Green));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="put", args={Enum.class, Object.class})
    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        try {
            enumSizeMap.put((Size)((Object)Color.Red), 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumSizeMap.put(Size.Small, 1));
        EnumMap<Color, Number> enumColorMap = new EnumMap<Color, Number>(Color.class);
        try {
            enumColorMap.put((Color)((Object)Size.Big), 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            enumColorMap.put(null, 2);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumColorMap.put(Color.Green, 2));
        EnumMapTest.assertEquals((String)"Return wrong value", (Object)2, (Object)enumColorMap.put(Color.Green, new Double(4.0)));
        EnumMapTest.assertEquals((String)"Return wrong value", (Object)new Double(4.0), (Object)enumColorMap.put(Color.Green, new Integer("3")));
        EnumMapTest.assertEquals((String)"Return wrong value", (Object)new Integer("3"), enumColorMap.put(Color.Green, null));
        Float f = new Float("3.4");
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumColorMap.put(Color.Green, f));
        EnumMapTest.assertNull((String)"Return non-null for non mapped key", (Object)enumColorMap.put(Color.Blue, 2));
        EnumMapTest.assertEquals((String)"Return wrong value", (Object)2, (Object)enumColorMap.put(Color.Blue, new Double(4.0)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="putAll", args={Map.class})
    public void test_putAllLjava_util_Map() {
        EnumMap<Color, Integer> enumColorMap = new EnumMap<Color, Integer>(Color.class);
        enumColorMap.put(Color.Green, 2);
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        enumColorMap.putAll(enumSizeMap);
        enumSizeMap.put(Size.Big, 1);
        try {
            enumColorMap.putAll(enumSizeMap);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumMap<Color, Integer> enumColorMap1 = new EnumMap<Color, Integer>(Color.class);
        enumColorMap1.put(Color.Blue, 3);
        enumColorMap.putAll(enumColorMap1);
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)3, enumColorMap.get((Object)Color.Blue));
        EnumMapTest.assertEquals((String)"Wrong Size", (int)2, (int)enumColorMap.size());
        enumColorMap = new EnumMap(Color.class);
        HashMap<Object, Integer> hashColorMap = null;
        try {
            enumColorMap.putAll(hashColorMap);
            EnumMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        hashColorMap = new HashMap<Object, Integer>();
        enumColorMap.putAll(hashColorMap);
        hashColorMap.put((Object)Color.Green, 2);
        enumColorMap.putAll(hashColorMap);
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)2, enumColorMap.get((Object)Color.Green));
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumColorMap.get((Object)Color.Red));
        hashColorMap.put((Object)Color.Red, new Integer(1));
        enumColorMap.putAll(hashColorMap);
        EnumMapTest.assertEquals((String)"Get returned incorrect value for given key", (Object)new Integer(2), enumColorMap.get((Object)Color.Green));
        hashColorMap.put((Object)Size.Big, 3);
        try {
            enumColorMap.putAll(hashColorMap);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        hashColorMap = new HashMap();
        hashColorMap.put(new Integer(1), 1);
        try {
            enumColorMap.putAll(hashColorMap);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        EnumMapTest.assertNull((String)"Remove of non-mapped key returned non-null", enumSizeMap.remove((Object)Size.Big));
        enumSizeMap.put(Size.Big, 3);
        enumSizeMap.put(Size.Middle, 2);
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumSizeMap.get((Object)Size.Small));
        EnumMapTest.assertEquals((String)"Remove returned incorrect value", (Object)3, enumSizeMap.remove((Object)Size.Big));
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumSizeMap.get((Object)Size.Big));
        EnumMapTest.assertNull((String)"Remove of non-mapped key returned non-null", enumSizeMap.remove((Object)Size.Big));
        EnumMapTest.assertNull((String)"Remove of non-existent key returned non-null", enumSizeMap.remove((Object)Color.Red));
        EnumMapTest.assertNull((String)"Remove of non-existent key returned non-null", enumSizeMap.remove(new Double(4.0)));
        EnumMapTest.assertNull((String)"Remove of non-existent key returned non-null", enumSizeMap.remove(null));
        EnumMap<Color, Double> enumColorMap = new EnumMap<Color, Double>(Color.class);
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumColorMap.get((Object)Color.Green));
        enumColorMap.put(Color.Green, new Double(4.0));
        EnumMapTest.assertEquals((String)"Remove returned incorrect value", (Object)new Double(4.0), enumColorMap.remove((Object)Color.Green));
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumColorMap.get((Object)Color.Green));
        enumColorMap.put(Color.Green, null);
        EnumMapTest.assertNull((String)"Can not handle null value", enumColorMap.remove((Object)Color.Green));
        EnumMapTest.assertNull((String)"Get returned non-null for non mapped key", enumColorMap.get((Object)Color.Green));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        EnumMap<Size, Integer> enumSizeMap = new EnumMap<Size, Integer>(Size.class);
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)enumSizeMap.size());
        enumSizeMap.put(Size.Small, 1);
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)enumSizeMap.size());
        enumSizeMap.put(Size.Small, 0);
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)enumSizeMap.size());
        try {
            enumSizeMap.put((Size)((Object)Color.Red), 2);
            EnumMapTest.fail((String)"Expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)enumSizeMap.size());
        enumSizeMap.put(Size.Middle, null);
        EnumMapTest.assertEquals((String)"Wrong size", (int)2, (int)enumSizeMap.size());
        enumSizeMap.remove((Object)Size.Big);
        EnumMapTest.assertEquals((String)"Wrong size", (int)2, (int)enumSizeMap.size());
        enumSizeMap.remove((Object)Size.Middle);
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)enumSizeMap.size());
        enumSizeMap.remove((Object)Color.Green);
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)enumSizeMap.size());
        EnumMap<Color, Integer> enumColorMap = new EnumMap<Color, Integer>(Color.class);
        enumColorMap.put(Color.Green, 2);
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)enumColorMap.size());
        enumColorMap.remove((Object)Color.Green);
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)enumColorMap.size());
        EnumMap enumEmptyMap = new EnumMap(Empty.class);
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)enumEmptyMap.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="values", args={})
    public void test_values() {
        EnumMap<Color, Integer> enumColorMap = new EnumMap<Color, Integer>(Color.class);
        enumColorMap.put(Color.Red, 1);
        enumColorMap.put(Color.Blue, null);
        Collection collection = enumColorMap.values();
        Collection collection1 = enumColorMap.values();
        EnumMapTest.assertSame((String)"Should be same", collection1, collection);
        try {
            collection.add(new Integer(1));
            EnumMapTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(1));
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(null));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)collection.contains(2));
        EnumMapTest.assertTrue((String)"Returned false when the object can be removed", (boolean)collection.remove(null));
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)collection.contains(null));
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)collection.remove(null));
        enumColorMap.put(Color.Blue, 3);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(3));
        enumColorMap.remove((Object)Color.Blue);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)collection.contains(3));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)collection.size());
        collection.clear();
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)collection.size());
        enumColorMap = new EnumMap(Color.class);
        enumColorMap.put(Color.Red, 1);
        enumColorMap.put(Color.Blue, null);
        collection = enumColorMap.values();
        ArrayList<Number> c = new ArrayList<Number>();
        c.add(new Integer(1));
        EnumMapTest.assertTrue((String)"Should return true", (boolean)collection.containsAll(c));
        c.add(new Double(3.4));
        EnumMapTest.assertFalse((String)"Should return false", (boolean)collection.containsAll(c));
        EnumMapTest.assertTrue((String)"Should return true", (boolean)collection.removeAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)collection.size());
        EnumMapTest.assertFalse((String)"Should return false", (boolean)collection.removeAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)collection.size());
        try {
            collection.addAll(c);
            EnumMapTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        enumColorMap.put(Color.Red, 1);
        EnumMapTest.assertEquals((String)"Wrong size", (int)2, (int)collection.size());
        EnumMapTest.assertTrue((String)"Should return true", (boolean)collection.retainAll(c));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)collection.size());
        EnumMapTest.assertFalse((String)"Should return false", (boolean)collection.retainAll(c));
        EnumMapTest.assertEquals((int)1, (int)collection.size());
        Object[] array = collection.toArray();
        EnumMapTest.assertEquals((String)"Wrong length", (int)1, (int)array.length);
        EnumMapTest.assertEquals((String)"Wrong key", (Object)1, (Object)array[0]);
        enumColorMap = new EnumMap(Color.class);
        enumColorMap.put(Color.Red, 1);
        enumColorMap.put(Color.Blue, null);
        collection = enumColorMap.values();
        EnumMapTest.assertEquals((String)"Wrong size", (int)2, (int)collection.size());
        EnumMapTest.assertFalse((String)"Returned true when the object can not be removed", (boolean)collection.remove(new Integer("10")));
        Iterator iter = enumColorMap.values().iterator();
        Object value = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(value));
        value = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(value));
        enumColorMap.put(Color.Green, 1);
        enumColorMap.remove((Object)Color.Blue);
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)collection.contains(value));
        iter.remove();
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumMapTest.assertFalse((String)"Returned true for uncontained object", (boolean)collection.contains(value));
        iter = enumColorMap.values().iterator();
        value = iter.next();
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(value));
        enumColorMap.put(Color.Green, 3);
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.contains(value));
        EnumMapTest.assertTrue((String)"Returned false for contained object", (boolean)collection.remove(new Integer("1")));
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)collection.size());
        collection.clear();
        EnumMapTest.assertEquals((String)"Wrong size", (int)0, (int)collection.size());
        enumColorMap = new EnumMap(Color.class);
        Integer integer1 = new Integer(1);
        enumColorMap.put(Color.Green, integer1);
        enumColorMap.put(Color.Blue, null);
        collection = enumColorMap.values();
        iter = enumColorMap.values().iterator();
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        value = iter.next();
        EnumMapTest.assertEquals((String)"Wrong value", (Object)integer1, value);
        EnumMapTest.assertSame((String)"Wrong value", (Object)integer1, value);
        EnumMapTest.assertFalse((String)"Returned true for unequal object", (boolean)iter.equals(value));
        iter.remove();
        EnumMapTest.assertFalse((String)"Returned true for unequal object", (boolean)iter.equals(value));
        try {
            iter.remove();
            EnumMapTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EnumMapTest.assertEquals((String)"Wrong size", (int)1, (int)collection.size());
        value = iter.next();
        EnumMapTest.assertFalse((String)"Returned true for unequal object", (boolean)iter.equals(value));
        iter.remove();
        try {
            iter.next();
            EnumMapTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationSelf", args={})
    public void testSerializationSelf() throws Exception {
        EnumMap<Color, Integer> enumColorMap = new EnumMap<Color, Integer>(Color.class);
        enumColorMap.put(Color.Blue, 3);
        SerializationTest.verifySelf(enumColorMap);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies serialization/deserialization compatibility.", method="!SerializationGolden", args={})
    public void testSerializationCompatibility() throws Exception {
        EnumMap<Color, Integer> enumColorMap = new EnumMap<Color, Integer>(Color.class);
        enumColorMap.put(Color.Red, 1);
        enumColorMap.put(Color.Blue, 3);
        SerializationTest.verifyGolden((TestCase)this, enumColorMap);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public MockEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V object) {
            V oldValue = this.value;
            this.value = object;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Empty {

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Color {
        Red,
        Green,
        Blue{};

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Size {
        Small,
        Middle,
        Big{};

    }
}

