/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;

@TestTargetClass(value=Date.class)
public class DateTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Date", args={})
    public void test_Constructor() {
        GregorianCalendar gc = new GregorianCalendar(1998, 9, 13, 19, 9);
        long oldTime = gc.getTime().getTime();
        long now = new Date().getTime();
        DateTest.assertTrue((String)("Created incorrect date: " + oldTime + " now: " + now), (oldTime < now ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Date", args={int.class, int.class, int.class})
    public void test_ConstructorIII() {
        Date d1 = new Date(70, 0, 1);
        Date d2 = new Date(0 + d1.getTimezoneOffset() * 60 * 1000);
        DateTest.assertTrue((String)"Created incorrect date", (boolean)d1.equals(d2));
        Date date = new Date(99, 5, 22);
        GregorianCalendar cal = new GregorianCalendar(1999, 5, 22);
        DateTest.assertTrue((String)"Wrong time zone", (boolean)date.equals(cal.getTime()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Date", args={int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorIIIII() {
        Date d1 = new Date(70, 0, 1, 1, 1);
        Date d2 = new Date(0 + d1.getTimezoneOffset() * 60 * 1000 + 3600000 + 60000);
        DateTest.assertTrue((String)"Created incorrect date", (boolean)d1.equals(d2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Date", args={int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_ConstructorIIIIII() {
        Date d1 = new Date(70, 0, 1, 1, 1, 1);
        Date d2 = new Date(0 + d1.getTimezoneOffset() * 60 * 1000 + 3600000 + 60000 + 1000);
        DateTest.assertTrue((String)"Created incorrect date", (boolean)d1.equals(d2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Date", args={long.class})
    public void test_ConstructorJ() {
        DateTest.assertTrue((String)"Used to test", (boolean)true);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="Date", args={String.class})
    public void test_ConstructorLjava_lang_String() {
        Date d1 = new Date("January 1, 1970, 00:00:00 GMT");
        Date d2 = new Date(0L);
        DateTest.assertTrue((String)"Created incorrect date", (boolean)d1.equals(d2));
        try {
            new Date(null);
            DateTest.fail((String)"Constructor Date((String)null) should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="after", args={Date.class})
    public void test_afterLjava_util_Date() {
        Date d1 = new Date(0L);
        Date d2 = new Date(1900000L);
        DateTest.assertTrue((String)"Older was returned as newer", (boolean)d2.after(d1));
        DateTest.assertTrue((String)"Newer was returned as older", (!d1.after(d2) ? 1 : 0) != 0);
        try {
            d1.after(null);
            DateTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="before", args={Date.class})
    public void test_beforeLjava_util_Date() {
        Date d2 = new Date(1900000L);
        Date d1 = new Date(0L);
        DateTest.assertTrue((String)"Older was returned as newer", (!d2.before(d1) ? 1 : 0) != 0);
        DateTest.assertTrue((String)"Newer was returned as older", (boolean)d1.before(d2));
        try {
            d1.before(null);
            DateTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        Date d1 = new Date(100000L);
        Date d2 = (Date)d1.clone();
        DateTest.assertTrue((String)"Cloning date results in same reference--new date is equivalent", (d1 != d2 ? 1 : 0) != 0);
        DateTest.assertTrue((String)"Cloning date results unequal date", (boolean)d1.equals(d2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="compareTo", args={Date.class})
    public void test_compareToLjava_util_Date() {
        int someNumber = 10000;
        Date d1 = new Date(10000L);
        Date d2 = new Date(10000L);
        Date d3 = new Date(10001L);
        Date d4 = new Date(9999L);
        DateTest.assertEquals((String)"Comparing a date to itself did not answer zero", (int)0, (int)d1.compareTo(d1));
        DateTest.assertEquals((String)"Comparing equal dates did not answer zero", (int)0, (int)d1.compareTo(d2));
        DateTest.assertEquals((String)"date1.compareTo(date2), where date1 > date2, did not result in 1", (int)1, (int)d1.compareTo(d4));
        DateTest.assertEquals((String)"date1.compareTo(date2), where date1 < date2, did not result in -1", (int)-1, (int)d1.compareTo(d3));
        try {
            d1.compareTo(null);
            DateTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        Date d1 = new Date(0L);
        Date d2 = new Date(1900000L);
        Date d3 = new Date(1900000L);
        DateTest.assertTrue((String)"Equality test failed", (boolean)d2.equals(d3));
        DateTest.assertTrue((String)"Equality test failed", (!d1.equals(d2) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDate", args={})
    public void test_getDate() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect date", (int)13, (int)d.getDate());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDay", args={})
    public void test_getDay() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect day", (int)2, (int)d.getDay());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getHours", args={})
    public void test_getHours() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect hours", (int)19, (int)d.getHours());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getMinutes", args={})
    public void test_getMinutes() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect minutes", (int)9, (int)d.getMinutes());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getMonth", args={})
    public void test_getMonth() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect month", (int)9, (int)d.getMonth());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getSeconds", args={})
    public void test_getSeconds() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect seconds", (int)0, (int)d.getSeconds());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getTime", args={})
    public void test_getTime() {
        Date d1 = new Date(0L);
        Date d2 = new Date(1900000L);
        DateTest.assertEquals((String)"Returned incorrect time", (long)1900000L, (long)d2.getTime());
        DateTest.assertEquals((String)"Returned incorrect time", (long)0L, (long)d1.getTime());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getTimezoneOffset", args={})
    public void test_getTimezoneOffset() {
        DateTest.assertTrue((String)"Used to test", (boolean)true);
        int offset = new Date(96, 1, 14).getTimezoneOffset();
        DateTest.assertTrue((offset > -720 && offset < 720 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getYear", args={})
    public void test_getYear() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        DateTest.assertEquals((String)"Returned incorrect year", (int)98, (int)d.getYear());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        Date d1 = new Date(0L);
        Date d2 = new Date(1900000L);
        DateTest.assertEquals((String)"Returned incorrect hash", (int)1900000, (int)d2.hashCode());
        DateTest.assertEquals((String)"Returned incorrect hash", (int)0, (int)d1.hashCode());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="parse", args={String.class})
    public void test_parseLjava_lang_String() {
        Date d = new Date(Date.parse("13 October 1998"));
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        DateTest.assertEquals((String)"Parsed incorrect month", (int)9, (int)cal.get(2));
        DateTest.assertEquals((String)"Parsed incorrect year", (int)1998, (int)cal.get(1));
        DateTest.assertEquals((String)"Parsed incorrect date", (int)13, (int)cal.get(5));
        d = new Date(Date.parse("Jan-12 1999"));
        DateTest.assertTrue((String)"Wrong parsed date 1", (boolean)d.equals(new GregorianCalendar(1999, 0, 12).getTime()));
        d = new Date(Date.parse("Jan12-1999"));
        DateTest.assertTrue((String)"Wrong parsed date 2", (boolean)d.equals(new GregorianCalendar(1999, 0, 12).getTime()));
        d = new Date(Date.parse("Jan12 69-1"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1969, 0, 12, 1, 0);
        DateTest.assertTrue((String)"Wrong parsed date 3", (boolean)d.equals(cal.getTime()));
        d = new Date(Date.parse("6:45:13 3/2/1200 MST"));
        cal.setTimeZone(TimeZone.getTimeZone("MST"));
        cal.clear();
        cal.set(1200, 2, 2, 6, 45, 13);
        DateTest.assertTrue((String)"Wrong parsed date 4", (boolean)d.equals(cal.getTime()));
        d = new Date(Date.parse("Mon, 22 Nov 1999 12:52:06 GMT"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1999, 10, 22, 12, 52, 6);
        DateTest.assertTrue((String)"Wrong parsed date 5", (boolean)d.equals(cal.getTime()));
        try {
            Date.parse(null);
            DateTest.fail((String)"Date.parse(null) should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setDate", args={int.class})
    public void test_setDateI() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        d.setDate(23);
        DateTest.assertEquals((String)"Set incorrect date", (int)23, (int)d.getDate());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setHours", args={int.class})
    public void test_setHoursI() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        d.setHours(23);
        DateTest.assertEquals((String)"Set incorrect hours", (int)23, (int)d.getHours());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setMinutes", args={int.class})
    public void test_setMinutesI() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        d.setMinutes(45);
        DateTest.assertEquals((String)"Set incorrect mins", (int)45, (int)d.getMinutes());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setMonth", args={int.class})
    public void test_setMonthI() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        d.setMonth(0);
        DateTest.assertEquals((String)"Set incorrect month", (int)0, (int)d.getMonth());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setSeconds", args={int.class})
    public void test_setSecondsI() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        d.setSeconds(13);
        DateTest.assertEquals((String)"Set incorrect seconds", (int)13, (int)d.getSeconds());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setTime", args={long.class})
    public void test_setTimeJ() {
        Date d1 = new Date(0L);
        Date d2 = new Date(1900000L);
        d1.setTime(900L);
        d2.setTime(890000L);
        DateTest.assertEquals((String)"Returned incorrect time", (long)890000L, (long)d2.getTime());
        DateTest.assertEquals((String)"Returned incorrect time", (long)900L, (long)d1.getTime());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="setYear", args={int.class})
    public void test_setYearI() {
        Date d = new GregorianCalendar(1998, 9, 13, 19, 9).getTime();
        d.setYear(8);
        DateTest.assertEquals((String)"Set incorrect year", (int)8, (int)d.getYear());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toGMTString", args={})
    public void test_toGMTString() {
        DateTest.assertEquals((String)"Did not convert epoch to GMT string correctly", (String)"1 Jan 1970 00:00:00 GMT", (String)new Date(0L).toGMTString());
        DateTest.assertEquals((String)"Did not convert epoch + 1yr to GMT string correctly", (String)"1 Jan 1971 00:00:00 GMT", (String)new Date(31536000000L).toGMTString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, 1970);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date d = cal.getTime();
        String result = d.toString();
        DateTest.assertTrue((String)("Incorrect result: " + d), (result.startsWith("Thu Jan 01 00:00:00") && result.endsWith("1970") ? 1 : 0) != 0);
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-5"));
        try {
            Date d1 = new Date(0L);
            DateTest.assertTrue((String)("Returned incorrect string: " + d1), (boolean)d1.toString().equals("Wed Dec 31 19:00:00 GMT-05:00 1969"));
        }
        finally {
            TimeZone.setDefault(tz);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="UTC", args={int.class, int.class, int.class, int.class, int.class, int.class})
    public void test_UTCIIIIII() {
        DateTest.assertTrue((String)"Returned incorrect UTC value for epoch", (Date.UTC(70, 0, 1, 0, 0, 0) == 0L ? 1 : 0) != 0);
        DateTest.assertTrue((String)"Returned incorrect UTC value for epoch +1yr", (Date.UTC(71, 0, 1, 0, 0, 0) == 31536000000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toLocaleString", args={})
    public void test_toLocaleString() {
        Locale loc = Locale.getDefault();
        Locale.setDefault(Locale.US);
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        try {
            DateTest.assertEquals((String)"Did not convert epoch to GMT string correctly", (String)"Jan 1, 1970 12:00:00 AM", (String)new Date(0L).toLocaleString());
            DateTest.assertEquals((String)"Did not convert epoch + 1yr to GMT string correctly", (String)"Jan 1, 1971 12:00:00 AM", (String)new Date(31536000000L).toLocaleString());
        }
        finally {
            Locale.setDefault(loc);
            TimeZone.setDefault(tz);
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

