/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.AndroidOnly;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Arrays;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import tests.support.Support_Locale;

@TestTargetClass(value=Currency.class)
public class CurrencyTest
extends TestCase {
    private static Locale defaultLocale = Locale.getDefault();

    @TestTargetNew(level=TestLevel.COMPLETE, notes="getInstance(String) method is tested in test_getInstanceLjava_util_Locale() test.", method="getInstance", args={String.class})
    public void test_getInstanceLjava_lang_String() {
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getInstance", args={Locale.class})
    public void test_getInstanceLjava_util_Locale() {
        Currency curr;
        Currency c0 = Currency.getInstance("CAD");
        Currency c1 = Currency.getInstance(new Locale("en", "CA"));
        CurrencyTest.assertTrue((String)"Currency.getInstance(new Locale(\"en\",\"CA\")) isn't equal to Currency.getInstance(\"CAD\")", (c1 == c0 ? 1 : 0) != 0);
        Currency c2 = Currency.getInstance(new Locale("fr", "CA"));
        CurrencyTest.assertTrue((String)"Currency.getInstance(new Locale(\"fr\",\"CA\")) isn't equal to Currency.getInstance(\"CAD\")", (c2 == c0 ? 1 : 0) != 0);
        Currency c3 = Currency.getInstance(new Locale("", "CA"));
        CurrencyTest.assertTrue((String)"Currency.getInstance(new Locale(\"\",\"CA\")) isn't equal to Currency.getInstance(\"CAD\")", (c3 == c0 ? 1 : 0) != 0);
        c0 = Currency.getInstance("JPY");
        c1 = Currency.getInstance(new Locale("ja", "JP"));
        CurrencyTest.assertTrue((String)"Currency.getInstance(new Locale(\"ja\",\"JP\")) isn't equal to Currency.getInstance(\"JPY\")", (c1 == c0 ? 1 : 0) != 0);
        c2 = Currency.getInstance(new Locale("", "JP"));
        CurrencyTest.assertTrue((String)"Currency.getInstance(new Locale(\"\",\"JP\")) isn't equal to Currency.getInstance(\"JPY\")", (c2 == c0 ? 1 : 0) != 0);
        c3 = Currency.getInstance(new Locale("bogus", "JP"));
        CurrencyTest.assertTrue((String)"Currency.getInstance(new Locale(\"bogus\",\"JP\")) isn't equal to Currency.getInstance(\"JPY\")", (c3 == c0 ? 1 : 0) != 0);
        Locale localeGu = new Locale("gu", "IN");
        Currency cGu = Currency.getInstance(localeGu);
        Locale localeKn = new Locale("kn", "IN");
        Currency cKn = Currency.getInstance(localeKn);
        CurrencyTest.assertTrue((String)("Currency.getInstance(Locale_" + localeGu.toString() + "))" + "isn't equal to " + "Currency.getInstance(Locale_" + localeKn.toString() + "))"), (cGu == cKn ? 1 : 0) != 0);
        Locale loc = new Locale("", "AQ");
        try {
            curr = Currency.getInstance(loc);
            CurrencyTest.assertNull((String)"Currency.getInstance(new Locale(\"\", \"AQ\")) did not return null", (Object)curr);
        }
        catch (IllegalArgumentException e) {
            CurrencyTest.fail((String)("Unexpected IllegalArgumentException " + e));
        }
        loc = new Locale("", "ZR");
        try {
            curr = Currency.getInstance(loc);
            CurrencyTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        loc = new Locale("", "ZAR");
        try {
            curr = Currency.getInstance(loc);
            CurrencyTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        loc = new Locale("", "FX");
        try {
            curr = Currency.getInstance(loc);
            CurrencyTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        loc = new Locale("", "FXX");
        try {
            curr = Currency.getInstance(loc);
            CurrencyTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getSymbol", args={})
    @AndroidOnly(value="icu and the RI have different data. Because Androidonly defines a few locales as a must have, it was not possibleto find a set of combinations where no differences betweenthe RI and Android exist.")
    public void test_getSymbol() {
        Currency currK = Currency.getInstance("KRW");
        Currency currI = Currency.getInstance("IEP");
        Currency currUS = Currency.getInstance("USD");
        Locale.setDefault(Locale.US);
        CurrencyTest.assertEquals((String)"currK.getSymbol()", (String)"\u20a9", (String)currK.getSymbol());
        CurrencyTest.assertEquals((String)"currI.getSymbol()", (String)"IR\u00a3", (String)currI.getSymbol());
        CurrencyTest.assertEquals((String)"currUS.getSymbol()", (String)"$", (String)currUS.getSymbol());
        Locale.setDefault(new Locale("en", "IE"));
        CurrencyTest.assertEquals((String)"currK.getSymbol()", (String)"\u20a9", (String)currK.getSymbol());
        CurrencyTest.assertEquals((String)"currI.getSymbol()", (String)"IR\u00a3", (String)currI.getSymbol());
        CurrencyTest.assertEquals((String)"currUS.getSymbol()", (String)"$", (String)currUS.getSymbol());
        Locale.setDefault(new Locale("kr", "KR"));
        CurrencyTest.assertEquals((String)"currK.getSymbol()", (String)"\u20a9", (String)currK.getSymbol());
        CurrencyTest.assertEquals((String)"currI.getSymbol()", (String)"IR\u00a3", (String)currI.getSymbol());
        CurrencyTest.assertEquals((String)"currUS.getSymbol()", (String)"$", (String)currUS.getSymbol());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getSymbol", args={Locale.class})
    @AndroidOnly(value="specification doesn't include strong requirements for returnig symbol. On android platform used wrong character for yen sign: \u00a5 instead of \uffe5. Both of them give correct image though")
    public void test_getSymbolLjava_util_Locale() {
        Locale[] loc1 = new Locale[]{Locale.JAPAN, Locale.JAPANESE, Locale.FRANCE, Locale.FRENCH, Locale.US, Locale.UK, Locale.CANADA, Locale.CANADA_FRENCH, Locale.ENGLISH, new Locale("ja", "JP"), new Locale("", "JP"), new Locale("fr", "FR"), new Locale("", "FR"), new Locale("en", "US"), new Locale("", "US"), new Locale("es", "US"), new Locale("ar", "US"), new Locale("ja", "US"), new Locale("en", "CA"), new Locale("fr", "CA"), new Locale("", "CA"), new Locale("ar", "CA"), new Locale("ja", "JP"), new Locale("", "JP"), new Locale("ar", "JP"), new Locale("ja", "AE"), new Locale("en", "AE"), new Locale("ar", "AE"), new Locale("da", "DK"), new Locale("", "DK"), new Locale("da", ""), new Locale("ja", ""), new Locale("en", "")};
        if (!Support_Locale.areLocalesAvailable(loc1)) {
            return;
        }
        Object[] euro = new String[]{"EUR", "\u20ac"};
        Object[] yen = new String[]{"JPY", "\u00a5", "\u00a5JP", "JP\u00a5", "\uffe5", "\uffe5JP", "JP\uffe5"};
        Object[] dollar = new String[]{"USD", "$", "US$", "$US"};
        Object[] cDollar = new String[]{"CA$", "CAD", "$", "Can$", "$CA"};
        Currency currE = Currency.getInstance("EUR");
        Currency currJ = Currency.getInstance("JPY");
        Currency currUS = Currency.getInstance("USD");
        Currency currCA = Currency.getInstance("CAD");
        for (int k = 0; k < loc1.length; ++k) {
            int j;
            boolean flag;
            int i;
            Locale.setDefault(loc1[k]);
            for (i = 0; i < loc1.length; ++i) {
                flag = false;
                for (j = 0; j < euro.length; ++j) {
                    if (!currE.getSymbol(loc1[i]).equals(euro[j])) continue;
                    flag = true;
                    break;
                }
                CurrencyTest.assertTrue((String)("Default Locale is: " + Locale.getDefault() + ". For locale " + loc1[i] + " the Euro currency returned " + currE.getSymbol(loc1[i]) + ". Expected was one of these: " + Arrays.toString(euro)), (boolean)flag);
            }
            for (i = 0; i < loc1.length; ++i) {
                flag = false;
                for (j = 0; j < yen.length; ++j) {
                    Object b1 = null;
                    Object b2 = null;
                    if (!currJ.getSymbol(loc1[i]).equals(yen[j])) continue;
                    flag = true;
                    break;
                }
                CurrencyTest.assertTrue((String)("Default Locale is: " + Locale.getDefault() + ". For locale " + loc1[i] + " the Yen currency returned " + currJ.getSymbol(loc1[i]) + ". Expected was one of these: " + Arrays.toString(yen)), (boolean)flag);
            }
            for (i = 0; i < loc1.length; ++i) {
                flag = false;
                for (j = 0; j < dollar.length; ++j) {
                    if (!currUS.getSymbol(loc1[i]).equals(dollar[j])) continue;
                    flag = true;
                    break;
                }
                CurrencyTest.assertTrue((String)("Default Locale is: " + Locale.getDefault() + ". For locale " + loc1[i] + " the Dollar currency returned " + currUS.getSymbol(loc1[i]) + ". Expected was one of these: " + Arrays.toString(dollar)), (boolean)flag);
            }
            for (i = 0; i < loc1.length; ++i) {
                flag = false;
                for (j = 0; j < cDollar.length; ++j) {
                    if (!currCA.getSymbol(loc1[i]).equals(cDollar[j])) continue;
                    flag = true;
                    break;
                }
                CurrencyTest.assertTrue((String)("Default Locale is: " + Locale.getDefault() + ". For locale " + loc1[i] + " the Canadian Dollar currency returned " + currCA.getSymbol(loc1[i]) + ". Expected was one of these: " + Arrays.toString(cDollar)), (boolean)flag);
            }
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getDefaultFractionDigits", args={})
    public void test_getDefaultFractionDigits() {
        Currency c1 = Currency.getInstance("TND");
        c1.getDefaultFractionDigits();
        CurrencyTest.assertEquals((String)(" Currency.getInstance(\"" + c1 + "\") returned incorrect number of digits. "), (int)3, (int)c1.getDefaultFractionDigits());
        Currency c2 = Currency.getInstance("EUR");
        c2.getDefaultFractionDigits();
        CurrencyTest.assertEquals((String)(" Currency.getInstance(\"" + c2 + "\") returned incorrect number of digits. "), (int)2, (int)c2.getDefaultFractionDigits());
        Currency c3 = Currency.getInstance("JPY");
        c3.getDefaultFractionDigits();
        CurrencyTest.assertEquals((String)(" Currency.getInstance(\"" + c3 + "\") returned incorrect number of digits. "), (int)0, (int)c3.getDefaultFractionDigits());
        Currency c4 = Currency.getInstance("XXX");
        c4.getDefaultFractionDigits();
        CurrencyTest.assertEquals((String)(" Currency.getInstance(\"" + c4 + "\") returned incorrect number of digits. "), (int)-1, (int)c4.getDefaultFractionDigits());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getCurrencyCode", args={})
    public void test_getCurrencyCode() {
        List<Locale> locVal = Arrays.asList(Locale.CANADA, Locale.CANADA_FRENCH, Locale.CHINA, Locale.FRANCE, Locale.GERMANY, Locale.ITALY, Locale.JAPAN, Locale.KOREA, Locale.PRC, Locale.SIMPLIFIED_CHINESE, Locale.TAIWAN, Locale.TRADITIONAL_CHINESE, Locale.UK, Locale.US);
        List<String> locDat = Arrays.asList("CAD", "CAD", "CNY", "EUR", "EUR", "EUR", "JPY", "KRW", "CNY", "CNY", "TWD", "TWD", "GBP", "USD");
        Iterator dat = locDat.iterator();
        for (Locale l : locVal) {
            String d = ((String)dat.next()).trim();
            CurrencyTest.assertEquals((String)("For locale " + l + " currency code wrong"), (String)Currency.getInstance(l).getCurrencyCode(), (String)d);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        List<Locale> locVal = Arrays.asList(Locale.CANADA, Locale.CANADA_FRENCH, Locale.CHINA, Locale.FRANCE, Locale.GERMANY, Locale.ITALY, Locale.JAPAN, Locale.KOREA, Locale.PRC, Locale.SIMPLIFIED_CHINESE, Locale.TAIWAN, Locale.TRADITIONAL_CHINESE, Locale.UK, Locale.US);
        List<String> locDat = Arrays.asList("CAD", "CAD", "CNY", "EUR", "EUR", "EUR", "JPY", "KRW", "CNY", "CNY", "TWD", "TWD", "GBP", "USD");
        Iterator dat = locDat.iterator();
        for (Locale l : locVal) {
            String d = ((String)dat.next()).trim();
            CurrencyTest.assertEquals((String)("For locale " + l + " Currency.toString method returns wrong value"), (String)Currency.getInstance(l).toString(), (String)d);
        }
    }

    protected void setUp() {
        Locale.setDefault(defaultLocale);
    }

    protected void tearDown() {
    }

    private void printCurrency(Currency c) {
        System.out.println();
        System.out.println(c.getCurrencyCode());
        System.out.println(c.getSymbol());
        System.out.println(c.getDefaultFractionDigits());
    }

    private static void printLocale(Locale loc) {
        System.out.println();
        System.out.println(loc.getDisplayName());
        System.out.println(loc.getCountry());
        System.out.println(loc.getLanguage());
        System.out.println(loc.getDisplayCountry());
        System.out.println(loc.getDisplayLanguage());
        System.out.println(loc.getDisplayName());
        System.out.println(loc.getISO3Country());
        System.out.println(loc.getISO3Language());
    }
}

