/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;

@TestTargetClass(value=ConcurrentModificationException.class)
public class ConcurrentModificationExceptionTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ConcurrentModificationException", args={})
    public void test_Constructor() {
        LinkedList<Integer> myCollection = new LinkedList<Integer>();
        Iterator myIterator = myCollection.iterator();
        for (int counter = 0; counter < 50; ++counter) {
            myCollection.add(new Integer(counter));
        }
        CollectionModifier cm = new CollectionModifier(myCollection);
        Thread collectionSlapper = new Thread(cm);
        try {
            collectionSlapper.start();
            while (myIterator.hasNext()) {
                myIterator.next();
            }
        }
        catch (ConcurrentModificationException e) {
            cm.stopNow();
            return;
        }
        cm.stopNow();
        ConcurrentModificationExceptionTest.fail((String)"Failed to throw expected ConcurrentModificationException");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ConcurrentModificationException", args={String.class})
    public void test_ConstructorLjava_lang_String() {
        String errorMessage = "This is an error message";
        try {
            throw new ConcurrentModificationException(errorMessage);
        }
        catch (ConcurrentModificationException e) {
            ConcurrentModificationExceptionTest.assertTrue((String)"Exception thrown without error message", (boolean)e.getMessage().equals(errorMessage));
            return;
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static class CollectionModifier
    implements Runnable {
        Collection col;
        boolean keepGoing = true;

        public CollectionModifier(Collection c) {
            this.col = c;
        }

        public void stopNow() {
            this.keepGoing = false;
        }

        public void run() {
            Integer someItem = new Integer(-1);
            while (this.keepGoing) {
                this.col.add(someItem);
                this.col.remove(someItem);
            }
        }
    }
}

