/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=AbstractList.class)
public class ConcurrentModTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="Doesn't verify IndexOutOfBoundsException.", method="get", args={int.class})
    public void testGet() {
        ArrayList<Double> al = new ArrayList<Double>();
        Double one = new Double(1.0);
        Double two = new Double(2.0);
        Double three = new Double(3.0);
        Double four = new Double(4.0);
        ((AbstractList)al).add(one);
        ((AbstractList)al).add(two);
        ((AbstractList)al).add(three);
        ((AbstractList)al).add(four);
        List sub = ((AbstractList)al).subList(1, 3);
        ConcurrentModTest.assertEquals((int)2, (int)sub.size());
        ConcurrentModTest.assertTrue(((Double)sub.get(1) <= 3.0 ? 1 : 0) != 0);
        ConcurrentModTest.assertTrue(((Double)sub.get(1) > 2.0 ? 1 : 0) != 0);
        ((AbstractList)al).remove(1);
        try {
            sub.get(1);
            ConcurrentModTest.fail((String)"It should throws ConcurrentModificationException.");
        }
        catch (ConcurrentModificationException e) {
            return;
        }
        try {
            ((AbstractList)al).get(-1);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        try {
            ((AbstractList)al).get(((AbstractCollection)al).size() + 1);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify UnsupportedOperationException, ClassCastException, IllegalArgumentException, IndexOutOfBoundsException.", method="set", args={int.class, Object.class})
    public void testSet() {
        ArrayList<Double> al = new ArrayList<Double>();
        Double one = new Double(1.0);
        Double two = new Double(2.0);
        Double three = new Double(3.0);
        Double four = new Double(4.0);
        ((AbstractList)al).add(one);
        ((AbstractList)al).add(two);
        ((AbstractList)al).add(three);
        ((AbstractList)al).add(four);
        List<Double> sub = ((AbstractList)al).subList(1, 3);
        ConcurrentModTest.assertEquals((int)2, (int)sub.size());
        ConcurrentModTest.assertTrue(((Double)sub.get(1) <= 3.0 ? 1 : 0) != 0);
        ConcurrentModTest.assertTrue(((Double)sub.get(1) > 2.0 ? 1 : 0) != 0);
        ((AbstractList)al).remove(1);
        try {
            sub.set(1, two);
            ConcurrentModTest.fail((String)"It should throws ConcurrentModificationException.");
        }
        catch (ConcurrentModificationException e) {
            return;
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify UnsupportedOperationException, ClassCastException, IllegalArgumentException, IndexOutOfBoundsException.", method="add", args={Object.class})
    public void testAdd() {
        ArrayList<Double> al = new ArrayList<Double>();
        Double one = new Double(1.0);
        Double two = new Double(2.0);
        Double three = new Double(3.0);
        Double four = new Double(4.0);
        ((AbstractList)al).add(one);
        ((AbstractList)al).add(two);
        ((AbstractList)al).add(three);
        ((AbstractList)al).add(four);
        List<Double> sub = ((AbstractList)al).subList(1, 3);
        ConcurrentModTest.assertEquals((int)2, (int)sub.size());
        ConcurrentModTest.assertTrue(((Double)sub.get(1) <= 3.0 ? 1 : 0) != 0);
        ConcurrentModTest.assertTrue(((Double)sub.get(1) > 2.0 ? 1 : 0) != 0);
        ((AbstractList)al).remove(1);
        try {
            sub.add(1, two);
            ConcurrentModTest.fail((String)"It should throws ConcurrentModificationException.");
        }
        catch (ConcurrentModificationException e) {
            return;
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={int.class})
    public void testRemove() {
        AbstractList al = new ArrayList<Double>();
        Double one = new Double(1.0);
        Double two = new Double(2.0);
        Double three = new Double(3.0);
        Double four = new Double(4.0);
        al.add(one);
        al.add(two);
        al.add(three);
        al.add(four);
        List sub = al.subList(1, 3);
        ConcurrentModTest.assertEquals((int)2, (int)sub.size());
        ConcurrentModTest.assertTrue(((Double)sub.get(1) <= 3.0 ? 1 : 0) != 0);
        ConcurrentModTest.assertTrue(((Double)sub.get(1) > 2.0 ? 1 : 0) != 0);
        al.remove(1);
        try {
            sub.remove(1);
            ConcurrentModTest.fail((String)"It should throws ConcurrentModificationException.");
        }
        catch (ConcurrentModificationException e) {
            return;
        }
        try {
            sub.remove(-1);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        try {
            sub.remove(sub.size() + 1);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        al = new AbstractList(){

            public Object get(int index) {
                return null;
            }

            public int size() {
                return 0;
            }
        };
        try {
            al.remove(1);
            ConcurrentModTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException ee) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify UnsupportedOperationException, ClassCastException, IllegalArgumentException,  NullPointerException.", method="addAll", args={int.class, Collection.class})
    public void testAddAll() {
        ArrayList<Double> al = new ArrayList<Double>();
        Double one = new Double(1.0);
        Double two = new Double(2.0);
        Double three = new Double(3.0);
        Double four = new Double(4.0);
        ((AbstractList)al).add(one);
        ((AbstractList)al).add(two);
        ((AbstractList)al).add(three);
        ((AbstractList)al).add(four);
        List sub = ((AbstractList)al).subList(1, 3);
        ConcurrentModTest.assertEquals((int)2, (int)sub.size());
        ConcurrentModTest.assertTrue(((Double)sub.get(1) <= 3.0 ? 1 : 0) != 0);
        ConcurrentModTest.assertTrue(((Double)sub.get(1) > 2.0 ? 1 : 0) != 0);
        ((AbstractList)al).remove(1);
        try {
            Vector<Double> c = new Vector<Double>();
            Double five = new Double(5.0);
            c.add(five);
            sub.addAll(1, c);
            ConcurrentModTest.fail((String)"It should throws ConcurrentModificationException.");
        }
        catch (ConcurrentModificationException e) {
            return;
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract - test testing simplest implementation.", method="add", args={Object.class})
    public void test_addLjava_lang_Object() {
        AbstractList abstr = new AbstractList(){

            public Object get(int arg0) {
                return null;
            }

            public int size() {
                return 0;
            }
        };
        try {
            abstr.add(null);
            ConcurrentModTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        abstr = new AbstractList<Double>(){

            @Override
            public boolean add(Double value) {
                return true;
            }

            @Override
            public Double get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        try {
            abstr.add(1);
            ConcurrentModTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException ee) {
            // empty catch block
        }
        abstr = new AbstractList<Integer>(){
            final int forbiddenValue = 33;

            @Override
            public boolean add(Integer value) {
                if (value == 33) {
                    throw new IllegalArgumentException();
                }
                return true;
            }

            @Override
            public Integer get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        abstr.add(1);
        try {
            abstr.add(33);
            ConcurrentModTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={int.class, Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="AbstractList", args={})})
    public void test_addILjava_lang_Object() {
        AbstractList abstr = new AbstractList(){

            public Object get(int arg0) {
                return null;
            }

            public int size() {
                return 0;
            }
        };
        try {
            abstr.add(1, null);
            ConcurrentModTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        abstr = new AbstractList<Double>(){

            @Override
            public void add(int index, Double value) {
            }

            @Override
            public Double get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        try {
            abstr.add(1, 1);
            ConcurrentModTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException ee) {
            // empty catch block
        }
        abstr = new AbstractList<Integer>(){
            final int forbiddenValue = 33;

            @Override
            public void add(int index, Integer value) {
                if (value == 33) {
                    throw new IllegalArgumentException();
                }
            }

            @Override
            public Integer get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        abstr.add(1, 1);
        try {
            abstr.add(1, 33);
            ConcurrentModTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ee) {
            // empty catch block
        }
        abstr = new ArrayList();
        abstr.add(0, "element");
        abstr.add(1, null);
        abstr.add(2, 1);
        abstr.add(3, new Double(33.0));
        try {
            abstr.add(-3, new Double(33.0));
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        try {
            abstr.add(abstr.size() + 1, new Double(33.0));
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={int.class, Collection.class})
    public void test_addAllILjava_util_Collection() {
        Vector<Object> c = new Vector<Object>();
        c.add(new Double(33.0));
        c.add(10);
        c.add("String");
        AbstractList abstr = new AbstractList(){

            public Object get(int arg0) {
                return null;
            }

            public int size() {
                return 0;
            }
        };
        try {
            abstr.addAll(0, null);
            ConcurrentModTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        try {
            abstr.addAll(0, c);
            ConcurrentModTest.fail((String)"UnsuportedOperationException expected");
        }
        catch (UnsupportedOperationException ee) {
            // empty catch block
        }
        abstr = new AbstractList<Double>(){

            @Override
            public void add(int index, Double value) {
            }

            @Override
            public Double get(int arg0) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        try {
            abstr.addAll(0, c);
            ConcurrentModTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException ee) {
            // empty catch block
        }
        abstr = new AbstractList<Integer>(){
            final int forbiddenValue = 33;

            @Override
            public void add(int index, Integer value) {
                if (value == 33) {
                    throw new IllegalArgumentException();
                }
            }

            @Override
            public Integer get(int arg0) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        c.clear();
        c.add(new Integer(1));
        c.add(new Integer(2));
        c.add(new Integer(3));
        c.add(new Integer(4));
        c.add(new Integer(5));
        abstr.addAll(0, c);
        c.add(new Integer(33));
        try {
            abstr.addAll(0, c);
            ConcurrentModTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ee) {
            // empty catch block
        }
        abstr = new ArrayList();
        abstr.addAll(0, c);
        try {
            abstr.addAll(-1, c);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        try {
            abstr.addAll(abstr.size() + 1, c);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        ArrayList<Object> abstr = new ArrayList<Object>();
        ConcurrentModTest.assertEquals((int)0, (int)((AbstractCollection)abstr).size());
        ((AbstractList)abstr).add("String");
        ((AbstractList)abstr).add("1");
        ((AbstractList)abstr).add(2);
        ((AbstractList)abstr).add(new Double(3.0));
        ConcurrentModTest.assertEquals((int)4, (int)((AbstractCollection)abstr).size());
        ((AbstractList)abstr).clear();
        ConcurrentModTest.assertEquals((int)0, (int)((AbstractCollection)abstr).size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        Vector<Object> c = new Vector<Object>();
        c.add(new Double(33.0));
        c.add(10);
        c.add("String");
        ArrayList<Object> abstr = new ArrayList<Object>();
        ArrayList<Object> abstr1 = new ArrayList<Object>();
        ConcurrentModTest.assertFalse((boolean)((AbstractList)abstr).equals((Object)this));
        ((AbstractList)abstr).add(new Double(33.0));
        ((AbstractList)abstr).add(10);
        ((AbstractList)abstr).add("String");
        ConcurrentModTest.assertTrue((boolean)((AbstractList)abstr).equals(c));
        ((AbstractCollection)abstr1).addAll(c);
        ConcurrentModTest.assertTrue((boolean)((AbstractList)abstr).equals(abstr1));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, Object.class})
    public void test_setILjava_lang_Object() {
        Vector<Object> c = new Vector<Object>();
        c.add(new Double(33.0));
        c.add(10);
        c.add("String");
        ArrayList<Object> abstr1 = new ArrayList<Object>();
        ArrayList<Object> abstr2 = new ArrayList<Object>();
        ((AbstractCollection)abstr1).addAll(c);
        ((AbstractCollection)abstr2).addAll(c);
        ConcurrentModTest.assertTrue((boolean)((AbstractList)abstr1).equals(abstr2));
        ((AbstractList)abstr1).set(1, 1);
        ConcurrentModTest.assertFalse((boolean)((AbstractList)abstr1).equals(abstr2));
        try {
            ((AbstractList)abstr1).set(((AbstractCollection)abstr1).size() + 1, 1);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        try {
            ((AbstractList)abstr1).set(-1, 1);
            ConcurrentModTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        AbstractList abstr = new AbstractList(){

            public Object get(int index) {
                return null;
            }

            public int size() {
                return 0;
            }
        };
        try {
            abstr.set(0, null);
            ConcurrentModTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException ee) {
            // empty catch block
        }
        abstr = new AbstractList<Double>(){

            @Override
            public Double set(int index, Double value) {
                return value;
            }

            @Override
            public Double get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        try {
            abstr.set(0, 1);
            ConcurrentModTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException ee) {
            // empty catch block
        }
        abstr = new AbstractList<Integer>(){
            final int forbiddenValue = 33;

            @Override
            public Integer set(int index, Integer value) {
                if (value == 33) {
                    throw new IllegalArgumentException();
                }
                return value;
            }

            @Override
            public Integer get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
        try {
            abstr.set(0, 33);
            ConcurrentModTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ee) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeRange", args={int.class, int.class})
    public void test_removeRangeII() {
        Mock_ArrayList al1 = new Mock_ArrayList();
        al1.add(1);
        al1.add(2);
        al1.add(3);
        al1.add(4);
        al1.add(5);
        Mock_ArrayList al2 = new Mock_ArrayList();
        al2.add(1);
        al2.add(5);
        ConcurrentModTest.assertNotSame((Object)al1, (Object)al2);
        al1.removeRange(1, 4);
        ConcurrentModTest.assertEquals((Object)al1, (Object)al2);
    }

    class Mock_ArrayList
    extends ArrayList {
        Mock_ArrayList() {
        }

        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

