/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.TestCase;
import tests.support.Support_CollectionTest;
import tests.support.Support_ListTest;
import tests.support.Support_SetTest;
import tests.support.Support_UnmodifiableCollectionTest;
import tests.support.Support_UnmodifiableMapTest;

@TestTargetClass(value=Collections.class)
public class CollectionsTest
extends TestCase {
    private LinkedList ll;
    private LinkedList myll;
    private LinkedList reversedLinkedList;
    private LinkedList myReversedLinkedList;
    private Set s;
    private Set mys;
    private HashMap hm;
    private Object[] objArray;
    private Object[] myobjArray;

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify ClassCastException.", method="binarySearch", args={List.class, Object.class})
    public void test_binarySearchLjava_util_ListLjava_lang_Object() {
        int llSize = this.ll.size();
        try {
            Collections.binarySearch(null, new Object());
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int counter = 0; counter < llSize; ++counter) {
            CollectionsTest.assertTrue((String)"Returned incorrect binary search item position", (this.ll.get(Collections.binarySearch(this.ll, this.ll.get(counter))) == this.ll.get(counter) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify ClassCastException.", method="binarySearch", args={List.class, Object.class, Comparator.class})
    public void test_binarySearchLjava_util_ListLjava_lang_ObjectLjava_util_Comparator() {
        int rSize = this.myReversedLinkedList.size();
        ReversedMyIntComparator comp = new ReversedMyIntComparator();
        try {
            Collections.binarySearch(null, new Object(), comp);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int counter = 0; counter < rSize; ++counter) {
            CollectionsTest.assertTrue((String)"Returned incorrect binary search item position using custom comparator", (this.myReversedLinkedList.get(Collections.binarySearch(this.myReversedLinkedList, this.myReversedLinkedList.get(counter), comp)) == this.myReversedLinkedList.get(counter) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="copy", args={List.class, List.class})
    public void test_copyLjava_util_ListLjava_util_List() {
        int i;
        try {
            Collections.copy(null, this.ll);
            CollectionsTest.fail((String)"Expected NullPointerException for null list first parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Collections.copy(this.ll, null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list second parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        int llSize = this.ll.size();
        this.ll.set(25, null);
        ArrayList<Integer> al = new ArrayList<Integer>();
        Integer extraElement = new Integer(1);
        Integer extraElement2 = new Integer(2);
        al.addAll(this.myReversedLinkedList);
        al.add(extraElement);
        al.add(extraElement2);
        Collections.copy(al, this.ll);
        for (int counter = 0; counter < llSize; ++counter) {
            CollectionsTest.assertTrue((String)"Elements do not match after copying collection", (al.get(counter) == this.ll.get(counter) ? 1 : 0) != 0);
        }
        CollectionsTest.assertTrue((String)"Elements after copied elements affected by copy", (extraElement == al.get(llSize) && extraElement2 == al.get(llSize + 1) ? 1 : 0) != 0);
        ArrayList<Integer> ar1 = new ArrayList<Integer>();
        ArrayList<Integer> ar2 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            ar2.add(new Integer(i));
        }
        for (i = 0; i < 10; ++i) {
            ar1.add(new Integer(i));
        }
        try {
            Collections.copy(ar2, ar1);
            CollectionsTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        Mock_ArrayList mal1 = new Mock_ArrayList();
        Mock_ArrayList mal2 = new Mock_ArrayList();
        for (i = 0; i < 10; ++i) {
            mal1.add(new Integer(i));
            mal2.add(new Integer(10 - i));
        }
        try {
            Collections.copy(mal1, mal2);
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies IndexOutOfBoundsException. Doesn't verify UnsupportedOperationException.", method="copy", args={List.class, List.class})
    public void test_copy_check_index() {
        ArrayList<String> a1 = new ArrayList<String>();
        a1.add("one");
        a1.add("two");
        ArrayList<String> a2 = new ArrayList<String>();
        a2.add("aa");
        try {
            Collections.copy(a2, a1);
            CollectionsTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        CollectionsTest.assertEquals((Object)"aa", a2.get(0));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="enumeration", args={Collection.class})
    public void test_enumerationLjava_util_Collection() {
        TreeSet ts = new TreeSet();
        ts.addAll(this.s);
        Enumeration e = Collections.enumeration(ts);
        int count = 0;
        while (e.hasMoreElements()) {
            CollectionsTest.assertTrue((String)"Returned incorrect enumeration", (e.nextElement() == this.objArray[count++] ? 1 : 0) != 0);
        }
        CollectionsTest.assertTrue((String)("Enumeration missing elements: " + count), (count == this.objArray.length ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={List.class, Object.class})
    public void test_fillLjava_util_ListLjava_lang_Object() {
        try {
            Collections.fill(null, new Object());
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        int size = this.ll.size();
        Collections.fill(this.ll, "k");
        CollectionsTest.assertTrue((String)"Fill modified list size", (size == this.ll.size() ? 1 : 0) != 0);
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            CollectionsTest.assertEquals((String)"Failed to fill elements", (Object)"k", i.next());
        }
        Collections.fill(this.ll, null);
        CollectionsTest.assertTrue((String)"Fill with nulls modified list size", (size == this.ll.size() ? 1 : 0) != 0);
        i = this.ll.iterator();
        while (i.hasNext()) {
            CollectionsTest.assertNull((String)"Failed to fill with nulls", i.next());
        }
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add("one");
        mal.add("two");
        try {
            Collections.fill(mal, "value");
            CollectionsTest.fail((String)"UnsupportedOperationException ecpected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="max", args={Collection.class})
    public void test_maxLjava_util_Collection() {
        CollectionsTest.assertTrue((String)"Returned incorrect max element", (Collections.max(this.s) == this.objArray[this.objArray.length - 1] ? 1 : 0) != 0);
        ArrayList<Object> al = new ArrayList<Object>();
        try {
            Collections.max(al);
            CollectionsTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        al.add("String");
        al.add(new Integer(1));
        al.add(new Double(3.14));
        try {
            Collections.max(al);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="max", args={Collection.class, Comparator.class})
    public void test_maxLjava_util_CollectionLjava_util_Comparator() {
        ReversedMyIntComparator rmic = new ReversedMyIntComparator();
        CollectionsTest.assertTrue((String)"Returned incorrect max element using custom comparator", (Collections.max(this.mys, rmic) == this.myobjArray[0] ? 1 : 0) != 0);
        ArrayList<Object> al = new ArrayList<Object>();
        try {
            Collections.max(al, rmic);
            CollectionsTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        al.add("String");
        al.add(new Integer(1));
        al.add(new Double(3.14));
        try {
            Collections.max(al, rmic);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="min", args={Collection.class})
    public void test_minLjava_util_Collection() {
        CollectionsTest.assertTrue((String)"Returned incorrect min element", (Collections.min(this.s) == this.objArray[0] ? 1 : 0) != 0);
        ArrayList<Object> al = new ArrayList<Object>();
        try {
            Collections.min(al);
            CollectionsTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        al.add("String");
        al.add(new Integer(1));
        al.add(new Double(3.14));
        try {
            Collections.min(al);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="min", args={Collection.class, Comparator.class})
    public void test_minLjava_util_CollectionLjava_util_Comparator() {
        ReversedMyIntComparator rmic = new ReversedMyIntComparator();
        CollectionsTest.assertTrue((String)"Returned incorrect min element using custom comparator", (Collections.min(this.mys, rmic) == this.myobjArray[this.objArray.length - 1] ? 1 : 0) != 0);
        ArrayList<Object> al = new ArrayList<Object>();
        try {
            Collections.min(al, rmic);
            CollectionsTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        al.add("String");
        al.add(new Integer(1));
        al.add(new Double(3.14));
        try {
            Collections.min(al, rmic);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nCopies", args={int.class, Object.class})
    public void test_nCopiesILjava_lang_Object() {
        Object o = new Object();
        List<Object> l = Collections.nCopies(100, o);
        Iterator<Object> i = l.iterator();
        Object first = i.next();
        CollectionsTest.assertTrue((String)"Returned list consists of copies not refs", (first == o ? 1 : 0) != 0);
        CollectionsTest.assertEquals((String)"Returned list of incorrect size", (int)100, (int)l.size());
        CollectionsTest.assertTrue((String)"Contains", (boolean)l.contains(o));
        CollectionsTest.assertTrue((String)"Contains null", (!l.contains(null) ? 1 : 0) != 0);
        CollectionsTest.assertTrue((String)"null nCopies contains", (!Collections.nCopies(2, null).contains(o) ? 1 : 0) != 0);
        CollectionsTest.assertTrue((String)"null nCopies contains null", (boolean)Collections.nCopies(2, null).contains(null));
        l = Collections.nCopies(20, null);
        i = l.iterator();
        int counter = 0;
        while (i.hasNext()) {
            CollectionsTest.assertTrue((String)"List is too large", (counter < 20 ? 1 : 0) != 0);
            CollectionsTest.assertNull((String)("Element should be null: " + counter), (Object)i.next());
            ++counter;
        }
        try {
            l.add(o);
            CollectionsTest.fail((String)"Returned list is not immutable");
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            Collections.nCopies(-2, new HashSet());
            CollectionsTest.fail((String)"nCopies with negative arg didn't throw IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="reverse", args={List.class})
    public void test_reverseLjava_util_List() {
        try {
            Collections.reverse(null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Collections.reverse(this.ll);
        Iterator i = this.ll.iterator();
        int count = this.objArray.length - 1;
        while (i.hasNext()) {
            CollectionsTest.assertTrue((String)"Failed to reverse collection", (i.next() == this.objArray[count] ? 1 : 0) != 0);
            --count;
        }
        ArrayList<Integer> myList = new ArrayList<Integer>();
        myList.add(null);
        myList.add(new Integer(20));
        Collections.reverse(myList);
        CollectionsTest.assertTrue((String)("Did not reverse correctly--first element is: " + myList.get(0)), (boolean)myList.get(0).equals(new Integer(20)));
        CollectionsTest.assertNull((String)("Did not reverse correctly--second element is: " + myList.get(1)), myList.get(1));
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add("First");
        mal.add("Second");
        try {
            Collections.reverse(mal);
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="reverseOrder", args={})
    public void test_reverseOrder() {
        Comparator comp = Collections.reverseOrder();
        LinkedList list2 = new LinkedList(this.ll);
        Collections.sort(list2, comp);
        int llSize = this.ll.size();
        for (int counter = 0; counter < llSize; ++counter) {
            CollectionsTest.assertTrue((String)"New comparator does not reverse sorting order", (this.ll.get(counter) == list2.get(llSize - counter - 1) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="shuffle", args={List.class})
    public void test_shuffleLjava_util_List() {
        try {
            Collections.shuffle(null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArrayList al = new ArrayList();
        al.addAll(this.ll);
        this.testShuffle(al, "Sequential Access", false);
        LinkedList ll2 = new LinkedList();
        ll2.addAll(this.ll);
        this.testShuffle(ll2, "Random Access", false);
    }

    public void testShuffleRandomAccessWithSeededRandom() {
        List<String> list = Arrays.asList("A", "B", "C", "D", "E", "F", "G");
        Collections.shuffle(list, new Random(0L));
        CollectionsTest.assertEquals(Arrays.asList("B", "A", "D", "C", "G", "E", "F"), list);
    }

    public void testShuffleWithSeededRandom() {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("A", "B", "C", "D", "E", "F", "G"));
        Collections.shuffle(list, new Random(0L));
        CollectionsTest.assertEquals(Arrays.asList("B", "A", "D", "C", "G", "E", "F"), list);
    }

    private void testShuffle(List list, String type, boolean random) {
        int counter;
        boolean sorted = true;
        boolean allMatch = true;
        int index = 0;
        int size = list.size();
        if (random) {
            Collections.shuffle(list);
        } else {
            Collections.shuffle(list, new Random(200L));
        }
        for (counter = 0; counter < size - 1; ++counter) {
            if (((Integer)list.get(counter)).compareTo((Integer)list.get(counter + 1)) <= 0) continue;
            sorted = false;
        }
        CollectionsTest.assertFalse((String)("Shuffling sorted " + type + " list resulted in sorted list (should be unlikely)"), (boolean)sorted);
        for (counter = 0; counter < 20; ++counter) {
            index = 30031 * counter % (size + 1);
            if (list.get(index) == this.ll.get(index)) continue;
            allMatch = false;
        }
        CollectionsTest.assertFalse((String)("Too many element positions match in shuffled " + type + " list"), (boolean)allMatch);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="shuffle", args={List.class, Random.class})
    public void test_shuffleLjava_util_ListLjava_util_Random() {
        try {
            Collections.shuffle(null, new Random(200L));
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArrayList al = new ArrayList();
        al.addAll(this.ll);
        this.testShuffle(al, "Sequential Access", true);
        LinkedList ll2 = new LinkedList();
        ll2.addAll(this.ll);
        this.testShuffle(ll2, "Random Access", true);
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add("First");
        mal.add("Second");
        try {
            Collections.shuffle(mal, new Random(200L));
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="singleton", args={Object.class})
    public void test_singletonLjava_lang_Object() {
        Object o = new Object();
        Set<Object> single = Collections.singleton(o);
        CollectionsTest.assertEquals((String)"Wrong size", (int)1, (int)single.size());
        CollectionsTest.assertTrue((String)"Contains", (boolean)single.contains(o));
        CollectionsTest.assertTrue((String)"Contains null", (!single.contains(null) ? 1 : 0) != 0);
        CollectionsTest.assertTrue((String)"null nCopies contains", (!Collections.singleton(null).contains(o) ? 1 : 0) != 0);
        CollectionsTest.assertTrue((String)"null nCopies contains null", (boolean)Collections.singleton(null).contains(null));
        try {
            single.add("l");
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        CollectionsTest.fail((String)"Allowed modification of singleton");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={List.class})
    public void test_sortLjava_util_List() {
        int counter;
        int llSize = this.ll.size();
        int rllSize = this.reversedLinkedList.size();
        try {
            Collections.sort(null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Collections.shuffle(this.ll);
        Collections.sort(this.ll);
        Collections.sort(this.reversedLinkedList);
        for (counter = 0; counter < llSize - 1; ++counter) {
            CollectionsTest.assertTrue((String)"Sorting shuffled list resulted in unsorted list", (((Integer)this.ll.get(counter)).compareTo((Integer)this.ll.get(counter + 1)) < 0 ? 1 : 0) != 0);
        }
        for (counter = 0; counter < rllSize - 1; ++counter) {
            CollectionsTest.assertTrue((String)"Sorting reversed list resulted in unsorted list", (((Integer)this.reversedLinkedList.get(counter)).compareTo((Integer)this.reversedLinkedList.get(counter + 1)) < 0 ? 1 : 0) != 0);
        }
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("String");
        al.add(new Integer(1));
        al.add(new Double(3.14));
        try {
            Collections.sort(al);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add("First");
        mal.add("Second");
        try {
            Collections.sort(mal);
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={List.class, Comparator.class})
    public void test_sortLjava_util_ListLjava_util_Comparator() {
        ReversedMyIntComparator comp = new ReversedMyIntComparator();
        try {
            Collections.sort(null, comp);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Collections.shuffle(this.myll);
        Collections.sort(this.myll, comp);
        int llSize = this.myll.size();
        for (int counter = 0; counter < llSize - 1; ++counter) {
            CollectionsTest.assertTrue((String)"Sorting shuffled list with custom comparator resulted in unsorted list", (((MyInt)this.myll.get(counter)).compareTo((MyInt)this.myll.get(counter + 1)) >= 0 ? 1 : 0) != 0);
        }
        ArrayList<Object> al = new ArrayList<Object>();
        al.add("String");
        al.add(new Integer(1));
        al.add(new Double(3.14));
        try {
            Collections.sort(al, comp);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add(new MyInt(1));
        mal.add(new MyInt(2));
        try {
            Collections.sort(mal, comp);
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="swap", args={List.class, int.class, int.class})
    public void test_swapLjava_util_ListII() {
        LinkedList<Object> smallList = new LinkedList<Object>();
        for (int i = 0; i < 10; ++i) {
            smallList.add(this.objArray[i]);
        }
        try {
            Collections.swap(smallList, -1, 6);
            CollectionsTest.fail((String)"Expected IndexOutOfBoundsException for -1");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Collections.swap(smallList, 6, -1);
            CollectionsTest.fail((String)"Expected IndexOutOfBoundsException for -1");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Collections.swap(smallList, 6, 11);
            CollectionsTest.fail((String)"Expected IndexOutOfBoundsException for 11");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Collections.swap(smallList, 11, 6);
            CollectionsTest.fail((String)"Expected IndexOutOfBoundsException for 11");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Collections.swap(null, 1, 1);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Collections.swap(smallList, 4, 7);
        CollectionsTest.assertEquals((String)"Didn't Swap the element at position 4 ", (Object)new Integer(7), smallList.get(4));
        CollectionsTest.assertEquals((String)"Didn't Swap the element at position 7 ", (Object)new Integer(4), smallList.get(7));
        for (int i = 0; i < 10; ++i) {
            if (i == 4 || i == 7) continue;
            CollectionsTest.assertEquals((String)("shouldn't have swapped the element at position " + i), (Object)new Integer(i), smallList.get(i));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="replaceAll", args={List.class, Object.class, Object.class})
    public void test_replaceAllLjava_util_ListLjava_lang_ObjectLjava_lang_Object() {
        int i;
        String string1 = "A-B-C-D-E-S-JF-SUB-G-H-I-J-SUBL-K-L-LIST-M-N--S-S-O-SUBLIS-P-Q-R-SUBLIST-S-T-U-V-W-X-Y-Z";
        char[] chars = string1.toCharArray();
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            list.add(new Character(chars[i2]));
        }
        try {
            Collections.replaceAll(null, new Object(), new Object());
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean result = Collections.replaceAll(list, new Character('1'), new Character('Z'));
        CollectionsTest.assertFalse((String)"Test1: Collections.replaceAll() returned wrong result", (boolean)result);
        CollectionsTest.assertEquals((String)"Test2 : ReplaceAll modified the list incorrectly", (String)string1, (String)this.getString(list));
        result = Collections.replaceAll(list, new Character('S'), new Character('K'));
        CollectionsTest.assertTrue((String)"Test3: Collections.replaceAll() returned wrong result", (boolean)result);
        string1 = string1.replace('S', 'K');
        CollectionsTest.assertEquals((String)"Test4: ReplaceAll modified the list incorrectly", (String)string1, (String)this.getString(list));
        result = Collections.replaceAll(list, new Character('Z'), new Character('N'));
        CollectionsTest.assertTrue((String)"Test5: Collections.replaceAll() returned wrong result", (boolean)result);
        string1 = string1.replace('Z', 'N');
        CollectionsTest.assertEquals((String)"Test6: ReplaceAll modified the list incorrectly", (String)string1, (String)this.getString(list));
        result = Collections.replaceAll(list, new Character('A'), new Character('B'));
        CollectionsTest.assertTrue((String)"Test7: Collections.replaceAll() returned wrong result", (boolean)result);
        string1 = string1.replace('A', 'B');
        CollectionsTest.assertEquals((String)"Test8: ReplaceAll modified the list incorrectly", (String)string1, (String)this.getString(list));
        LinkedList<Object> smallList = new LinkedList<Object>();
        for (i = 0; i < 10; ++i) {
            smallList.add(this.objArray[i]);
        }
        smallList.set(4, new Integer(5));
        result = Collections.replaceAll(smallList, new Integer(5), null);
        CollectionsTest.assertTrue((String)"Test9: Collections.replaceAll() returned wrong result", (boolean)result);
        for (i = 0; i < smallList.size(); ++i) {
            if (i == 4 || i == 5) {
                CollectionsTest.assertSame((String)("Test9: ReplaceAll didn't replace element at " + i), null, smallList.get(i));
                continue;
            }
            CollectionsTest.assertEquals((String)("Test9: ReplaceAll shouldn't have replaced element at " + i), (Object)new Integer(i), smallList.get(i));
        }
        result = Collections.replaceAll(smallList, null, new Integer(99));
        CollectionsTest.assertTrue((String)"Test10: Collections.replaceAll() returned wrong result", (boolean)result);
        for (i = 0; i < smallList.size(); ++i) {
            if (i == 4 || i == 5) {
                CollectionsTest.assertEquals((String)("Test10: ReplaceAll didn't replace element at " + i), (Object)new Integer(99), smallList.get(i));
                continue;
            }
            CollectionsTest.assertEquals((String)("Test10: ReplaceAll shouldn't have replaced element at " + i), (Object)new Integer(i), smallList.get(i));
        }
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add("First");
        mal.add("Second");
        try {
            Collections.replaceAll(mal, "Second", null);
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies functionality, and UnsupportedOperationException.", method="rotate", args={List.class, int.class})
    public void test_rotateLjava_util_ListI() {
        try {
            Collections.rotate(null, 0);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LinkedList<Object> list1 = new LinkedList<Object>();
        for (int i = 0; i < 10; ++i) {
            list1.add(this.objArray[i]);
        }
        this.testRotate(list1, "Sequential Access");
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (int i = 0; i < 10; ++i) {
            list2.add(this.objArray[i]);
        }
        this.testRotate(list2, "Random Access");
    }

    private void testRotate(List list, String type) {
        Collections.rotate(list, 7);
        CollectionsTest.assertEquals((String)("Test1: rotate modified the " + type + " list incorrectly,"), (String)"3456789012", (String)this.getString(list));
        Collections.rotate(list, -2);
        CollectionsTest.assertEquals((String)("Test2: rotate modified the " + type + " list incorrectly,"), (String)"5678901234", (String)this.getString(list));
        List subList = list.subList(1, 5);
        Collections.rotate(subList, -1);
        CollectionsTest.assertEquals((String)("Test3: rotate modified the " + type + " list incorrectly,"), (String)"5789601234", (String)this.getString(list));
        Collections.rotate(subList, 2);
        CollectionsTest.assertEquals((String)("Test4: rotate modified the " + type + " list incorrectly,"), (String)"5967801234", (String)this.getString(list));
        Collections.rotate(list, 23);
        CollectionsTest.assertEquals((String)("Test5: rotate modified the " + type + " list incorrectly,"), (String)"2345967801", (String)this.getString(list));
        Collections.rotate(list, -23);
        CollectionsTest.assertEquals((String)("Test6: rotate modified the " + type + " list incorrectly,"), (String)"5967801234", (String)this.getString(list));
        Collections.rotate(list, 0);
        CollectionsTest.assertEquals((String)("Test7: rotate modified the " + type + " list incorrectly,"), (String)"5967801234", (String)this.getString(list));
        Collections.rotate(list, -30);
        CollectionsTest.assertEquals((String)("Test8: rotate modified the " + type + " list incorrectly,"), (String)"5967801234", (String)this.getString(list));
        Collections.rotate(list, 30);
        CollectionsTest.assertEquals((String)("Test9: rotate modified the " + type + " list incorrectly,"), (String)"5967801234", (String)this.getString(list));
    }

    private String getString(List list) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(list.get(i));
        }
        return buffer.toString();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="rotate", args={List.class, int.class})
    public void test_rotate2() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Collections.rotate(list, 5);
        }
        catch (UnsupportedOperationException e) {
            CollectionsTest.fail((String)("Unexpected UnsupportedOperationException for empty list, " + e));
        }
        list.add(0, "zero");
        list.add(1, "one");
        list.add(2, "two");
        list.add(3, "three");
        list.add(4, "four");
        Collections.rotate(list, Integer.MIN_VALUE);
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 0, ", (String)"three", (String)((String)list.get(0)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 1, ", (String)"four", (String)((String)list.get(1)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 2, ", (String)"zero", (String)((String)list.get(2)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 3, ", (String)"one", (String)((String)list.get(3)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 4, ", (String)"two", (String)((String)list.get(4)));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies boundary conditions, and NullPointerException.", method="indexOfSubList", args={List.class, List.class})
    public void test_indexOfSubListLjava_util_ListLjava_util_List() {
        ArrayList list = new ArrayList();
        try {
            Collections.indexOfSubList(null, list);
            CollectionsTest.fail((String)"Expected NullPointerException for null list first parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Collections.indexOfSubList(list, null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list second parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String string1 = "A-B-C-D-E-S-JF-SUB-G-H-I-J-SUBL-K-L-LIST-M-N--S-S-O-SUBLIS-P-Q-R-SUBLIST-S-T-U-V-W-X-Y-Z";
        this.testwithCharList(1, string1, "B", true);
        this.testwithCharList(2, string1, "LIST", true);
        this.testwithCharList(3, string1, "SUBLIST", true);
        this.testwithCharList(4, string1, "NONE", true);
        this.testwithCharList(5, string1, "END", true);
        this.testwithCharList(6, "", "", true);
        this.testwithCharList(7, "LIST", "", true);
        this.testwithCharList(8, "", "SUBLIST", true);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="indexOfSubList", args={List.class, List.class})
    public void test_indexOfSubList2() {
        ArrayList<Integer> sub = new ArrayList<Integer>();
        sub.add(new Integer(1));
        sub.add(new Integer(2));
        sub.add(new Integer(3));
        ArrayList<Integer> sub2 = new ArrayList<Integer>();
        sub2.add(new Integer(7));
        sub2.add(new Integer(8));
        ArrayList<Integer> src = new ArrayList<Integer>();
        src.addAll(sub);
        src.addAll(sub);
        src.addAll(sub);
        src.add(new Integer(5));
        src.add(new Integer(6));
        sub = new ArrayList(src.subList(3, 11));
        CollectionsTest.assertEquals((String)"TestA : Returned wrong indexOfSubList, ", (int)3, (int)Collections.indexOfSubList(src, sub));
        sub = new ArrayList(src.subList(6, 11));
        CollectionsTest.assertEquals((String)"TestB : Returned wrong indexOfSubList, ", (int)6, (int)Collections.indexOfSubList(src, sub));
        sub = new ArrayList(src.subList(0, 3));
        CollectionsTest.assertEquals((String)"TestCC : Returned wrong indexOfSubList, ", (int)0, (int)Collections.indexOfSubList(src, sub));
        sub = new ArrayList(src.subList(9, 11));
        CollectionsTest.assertEquals((String)"TestD : Returned wrong indexOfSubList, ", (int)9, (int)Collections.indexOfSubList(src, sub));
        sub = new ArrayList(src.subList(10, 11));
        CollectionsTest.assertEquals((String)"TestE : Returned wrong indexOfSubList, ", (int)10, (int)Collections.indexOfSubList(src, sub));
        sub = new ArrayList(src.subList(0, 11));
        CollectionsTest.assertEquals((String)"TestH : Returned wrong indexIndexOfSubList, ", (int)0, (int)Collections.indexOfSubList(src, sub));
        CollectionsTest.assertEquals((String)"TestI : Returned wrong indexOfSubList, ", (int)-1, (int)Collections.indexOfSubList(src, sub2));
    }

    private void testwithCharList(int count, String string1, String string2, boolean first) {
        char[] chars = string1.toCharArray();
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < chars.length; ++i) {
            list.add(new Character(chars[i]));
        }
        chars = string2.toCharArray();
        ArrayList<Character> sublist = new ArrayList<Character>();
        for (int i = 0; i < chars.length; ++i) {
            sublist.add(new Character(chars[i]));
        }
        if (first) {
            CollectionsTest.assertEquals((String)("Test " + count + ": Returned wrong index:"), (int)string1.indexOf(string2), (int)Collections.indexOfSubList(list, sublist));
        } else {
            CollectionsTest.assertEquals((String)("Test " + count + ": Returned wrong index:"), (int)string1.lastIndexOf(string2), (int)Collections.lastIndexOfSubList(list, sublist));
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException, and boundary conditions.", method="lastIndexOfSubList", args={List.class, List.class})
    public void test_lastIndexOfSubListLjava_util_ListLjava_util_List() {
        String string1 = "A-B-C-D-E-S-JF-SUB-G-H-I-J-SUBL-K-L-LIST-M-N--S-S-O-SUBLIS-P-Q-R-SUBLIST-S-T-U-V-W-X-Y-Z-END";
        ArrayList list = new ArrayList();
        try {
            Collections.lastIndexOfSubList(null, list);
            CollectionsTest.fail((String)"Expected NullPointerException for null list first parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Collections.lastIndexOfSubList(list, null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list second parameter");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.testwithCharList(1, string1, "B", false);
        this.testwithCharList(2, string1, "LIST", false);
        this.testwithCharList(3, string1, "SUBLIST", false);
        this.testwithCharList(4, string1, "END", false);
        this.testwithCharList(5, string1, "NONE", false);
        this.testwithCharList(6, "", "", false);
        this.testwithCharList(7, "LIST", "", false);
        this.testwithCharList(8, "", "SUBLIST", false);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastIndexOfSubList", args={List.class, List.class})
    public void test_lastIndexOfSubList2() {
        ArrayList<Integer> sub = new ArrayList<Integer>();
        sub.add(new Integer(1));
        sub.add(new Integer(2));
        sub.add(new Integer(3));
        ArrayList<Integer> sub2 = new ArrayList<Integer>();
        sub2.add(new Integer(7));
        sub2.add(new Integer(8));
        ArrayList<Integer> src = new ArrayList<Integer>();
        src.addAll(sub);
        src.addAll(sub);
        src.addAll(sub);
        src.add(new Integer(5));
        src.add(new Integer(6));
        Collections.reverse(src);
        sub = new ArrayList(src.subList(0, 8));
        CollectionsTest.assertEquals((String)"TestA : Returned wrong lastIndexOfSubList, ", (int)0, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(0, 5));
        CollectionsTest.assertEquals((String)"TestB : Returned wrong lastIndexOfSubList, ", (int)0, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(2, 5));
        CollectionsTest.assertEquals((String)"TestC : Returned wrong lastIndexOfSubList, ", (int)8, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(9, 11));
        CollectionsTest.assertEquals((String)"TestD : Returned wrong lastIndexOfSubList, ", (int)9, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(10, 11));
        CollectionsTest.assertEquals((String)"TestE : Returned wrong lastIndexOfSubList, ", (int)10, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(0, 2));
        CollectionsTest.assertEquals((String)"TestF : Returned wrong lastIndexOfSubList, ", (int)0, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(0, 1));
        CollectionsTest.assertEquals((String)"TestG : Returned wrong lastIndexOfSubList, ", (int)0, (int)Collections.lastIndexOfSubList(src, sub));
        sub = new ArrayList(src.subList(0, 11));
        CollectionsTest.assertEquals((String)"TestH : Returned wrong lastIndexOfSubList, ", (int)0, (int)Collections.lastIndexOfSubList(src, sub));
        CollectionsTest.assertEquals((String)"TestI : Returned wrong lastIndexOfSubList, ", (int)-1, (int)Collections.lastIndexOfSubList(src, sub2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="list", args={Enumeration.class})
    public void test_listLjava_util_Enumeration() {
        Enumeration e = Collections.enumeration(this.ll);
        ArrayList al = Collections.list(e);
        int size = al.size();
        CollectionsTest.assertEquals((String)"Wrong size", (int)this.ll.size(), (int)size);
        for (int i = 0; i < size; ++i) {
            CollectionsTest.assertEquals((String)("wrong element at position " + i + ","), this.ll.get(i), al.get(i));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="synchronizedCollection", args={Collection.class})
    public void test_synchronizedCollectionLjava_util_Collection() {
        LinkedList<Object> smallList = new LinkedList<Object>();
        for (int i = 0; i < 50; ++i) {
            smallList.add(this.objArray[i]);
        }
        int numberOfLoops = 200;
        Collection synchCol = Collections.synchronizedCollection(smallList);
        SynchCollectionChecker normalSynchChecker = new SynchCollectionChecker(synchCol, false, 200);
        SynchCollectionChecker offsetSynchChecker = new SynchCollectionChecker(synchCol, true, 200);
        Thread normalThread = new Thread(normalSynchChecker);
        Thread offsetThread = new Thread(offsetSynchChecker);
        normalThread.start();
        offsetThread.start();
        while (normalSynchChecker.getNumberOfChecks() < 200 || offsetSynchChecker.getNumberOfChecks() < 200) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        CollectionsTest.assertTrue((String)"Returned collection corrupted by multiple thread access", (normalSynchChecker.getResult() && offsetSynchChecker.getResult() ? 1 : 0) != 0);
        try {
            normalThread.join(5000L);
            offsetThread.join(5000L);
        }
        catch (InterruptedException e) {
            CollectionsTest.fail((String)"join() interrupted");
        }
        synchCol.add(null);
        CollectionsTest.assertTrue((String)"Trying to use nulls in collection failed", (boolean)synchCol.contains(null));
        smallList = new LinkedList();
        for (int i = 0; i < 100; ++i) {
            smallList.add(this.objArray[i]);
        }
        new Support_CollectionTest("", Collections.synchronizedCollection(smallList)).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="synchronizedList", args={List.class})
    public void test_synchronizedListLjava_util_List() {
        int i;
        try {
            Collections.synchronizedList(null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        AbstractList smallList = new LinkedList<Object>();
        this.testSynchronizedList(smallList, "Sequential Access");
        smallList = new LinkedList();
        for (i = 0; i < 100; ++i) {
            smallList.add(this.objArray[i]);
        }
        List<Integer> myList = Collections.synchronizedList(smallList);
        new Support_ListTest("", myList).runTest();
        smallList = new ArrayList();
        this.testSynchronizedList(smallList, "Random Access");
        smallList = new ArrayList();
        for (i = 0; i < 100; ++i) {
            smallList.add(this.objArray[i]);
        }
        myList = Collections.synchronizedList(smallList);
        new Support_ListTest("", myList).runTest();
    }

    private void testSynchronizedList(List smallList, String type) {
        for (int i = 0; i < 50; ++i) {
            smallList.add(this.objArray[i]);
        }
        int numberOfLoops = 200;
        List synchList = Collections.synchronizedList(smallList);
        if (type.equals("Random Access")) {
            CollectionsTest.assertTrue((String)"Returned synchronized list should implement the Random Access interface", (boolean)(synchList instanceof RandomAccess));
        } else {
            CollectionsTest.assertTrue((String)"Returned synchronized list should not implement the Random Access interface", (!(synchList instanceof RandomAccess) ? 1 : 0) != 0);
        }
        SynchCollectionChecker normalSynchChecker = new SynchCollectionChecker(synchList, false, 200);
        SynchCollectionChecker offsetSynchChecker = new SynchCollectionChecker(synchList, true, 200);
        Thread normalThread = new Thread(normalSynchChecker);
        Thread offsetThread = new Thread(offsetSynchChecker);
        normalThread.start();
        offsetThread.start();
        while (normalSynchChecker.getNumberOfChecks() < 200 || offsetSynchChecker.getNumberOfChecks() < 200) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        CollectionsTest.assertTrue((String)(type + " list tests: Returned list corrupted by multiple thread access"), (normalSynchChecker.getResult() && offsetSynchChecker.getResult() ? 1 : 0) != 0);
        try {
            normalThread.join(5000L);
            offsetThread.join(5000L);
        }
        catch (InterruptedException e) {
            CollectionsTest.fail((String)(type + " list tests: join() interrupted"));
        }
        synchList.set(25, null);
        CollectionsTest.assertNull((String)(type + " list tests: Trying to use nulls in list failed"), synchList.get(25));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="synchronizedMap", args={Map.class})
    public void test_synchronizedMapLjava_util_Map() {
        HashMap<Object, Object> smallMap = new HashMap<Object, Object>();
        for (int i = 0; i < 50; ++i) {
            smallMap.put(this.objArray[i], this.objArray[i]);
        }
        int numberOfLoops = 200;
        Map<String, Integer> synchMap = Collections.synchronizedMap(smallMap);
        SynchMapChecker normalSynchChecker = new SynchMapChecker(synchMap, false, 200);
        SynchMapChecker offsetSynchChecker = new SynchMapChecker(synchMap, true, 200);
        Thread normalThread = new Thread(normalSynchChecker);
        Thread offsetThread = new Thread(offsetSynchChecker);
        normalThread.start();
        offsetThread.start();
        while (normalSynchChecker.getNumberOfChecks() < 200 || offsetSynchChecker.getNumberOfChecks() < 200) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        CollectionsTest.assertTrue((String)"Returned map corrupted by multiple thread access", (normalSynchChecker.getResult() && offsetSynchChecker.getResult() ? 1 : 0) != 0);
        try {
            normalThread.join(5000L);
            offsetThread.join(5000L);
        }
        catch (InterruptedException e) {
            CollectionsTest.fail((String)"join() interrupted");
        }
        synchMap.put((String)((Object)new Long(25L)), (Integer)null);
        synchMap.put((String)null, (Integer)((Object)new Long(30L)));
        CollectionsTest.assertNull((String)"Trying to use a null value in map failed", synchMap.get(new Long(25L)));
        CollectionsTest.assertTrue((String)"Trying to use a null key in map failed", (boolean)synchMap.get(null).equals(new Long(30L)));
        smallMap = new HashMap();
        for (int i = 0; i < 100; ++i) {
            smallMap.put(this.objArray[i].toString(), this.objArray[i]);
        }
        synchMap = Collections.synchronizedMap(smallMap);
        new Support_UnmodifiableMapTest("", synchMap).runTest();
        synchMap.keySet().remove(this.objArray[50].toString());
        CollectionsTest.assertNull((String)"Removing a key from the keySet of the synchronized map did not remove it from the synchronized map: ", (Object)synchMap.get(this.objArray[50].toString()));
        CollectionsTest.assertNull((String)"Removing a key from the keySet of the synchronized map did not remove it from the original map", smallMap.get(this.objArray[50].toString()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="synchronizedSet", args={Set.class})
    public void test_synchronizedSetLjava_util_Set() {
        HashSet<Object> smallSet = new HashSet<Object>();
        for (int i = 0; i < 50; ++i) {
            smallSet.add(this.objArray[i]);
        }
        int numberOfLoops = 200;
        Set synchSet = Collections.synchronizedSet(smallSet);
        SynchCollectionChecker normalSynchChecker = new SynchCollectionChecker(synchSet, false, 200);
        SynchCollectionChecker offsetSynchChecker = new SynchCollectionChecker(synchSet, true, 200);
        Thread normalThread = new Thread(normalSynchChecker);
        Thread offsetThread = new Thread(offsetSynchChecker);
        normalThread.start();
        offsetThread.start();
        while (normalSynchChecker.getNumberOfChecks() < 200 || offsetSynchChecker.getNumberOfChecks() < 200) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        CollectionsTest.assertTrue((String)"Returned set corrupted by multiple thread access", (normalSynchChecker.getResult() && offsetSynchChecker.getResult() ? 1 : 0) != 0);
        try {
            normalThread.join(5000L);
            offsetThread.join(5000L);
        }
        catch (InterruptedException e) {
            CollectionsTest.fail((String)"join() interrupted");
        }
        Set mySet = Collections.synchronizedSet(smallSet);
        mySet.add(null);
        CollectionsTest.assertTrue((String)"Trying to use nulls in list failed", (boolean)mySet.contains(null));
        smallSet = new HashSet();
        for (int i = 0; i < 100; ++i) {
            smallSet.add(this.objArray[i]);
        }
        new Support_SetTest("", Collections.synchronizedSet(smallSet)).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="synchronizedSortedMap", args={SortedMap.class})
    public void test_synchronizedSortedMapLjava_util_SortedMap() {
        TreeMap<Object, Object> smallMap = new TreeMap<Object, Object>();
        for (int i = 0; i < 50; ++i) {
            smallMap.put(this.objArray[i], this.objArray[i]);
        }
        int numberOfLoops = 200;
        Map<String, Integer> synchMap = Collections.synchronizedMap(smallMap);
        SynchMapChecker normalSynchChecker = new SynchMapChecker(synchMap, false, 200);
        SynchMapChecker offsetSynchChecker = new SynchMapChecker(synchMap, true, 200);
        Thread normalThread = new Thread(normalSynchChecker);
        Thread offsetThread = new Thread(offsetSynchChecker);
        normalThread.start();
        offsetThread.start();
        while (normalSynchChecker.getNumberOfChecks() < 200 || offsetSynchChecker.getNumberOfChecks() < 200) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        CollectionsTest.assertTrue((String)"Returned map corrupted by multiple thread access", (normalSynchChecker.getResult() && offsetSynchChecker.getResult() ? 1 : 0) != 0);
        try {
            normalThread.join(5000L);
            offsetThread.join(5000L);
        }
        catch (InterruptedException e) {
            CollectionsTest.fail((String)"join() interrupted");
        }
        smallMap = new TreeMap();
        for (int i = 0; i < 100; ++i) {
            smallMap.put(this.objArray[i].toString(), this.objArray[i]);
        }
        synchMap = Collections.synchronizedSortedMap(smallMap);
        new Support_UnmodifiableMapTest("", synchMap).runTest();
        synchMap.keySet().remove(this.objArray[50].toString());
        CollectionsTest.assertNull((String)"Removing a key from the keySet of the synchronized map did not remove it from the synchronized map", (Object)synchMap.get(this.objArray[50].toString()));
        CollectionsTest.assertNull((String)"Removing a key from the keySet of the synchronized map did not remove it from the original map", smallMap.get(this.objArray[50].toString()));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="synchronizedSortedSet", args={SortedSet.class})
    public void test_synchronizedSortedSetLjava_util_SortedSet() {
        TreeSet<Object> smallSet = new TreeSet<Object>();
        for (int i = 0; i < 50; ++i) {
            smallSet.add(this.objArray[i]);
        }
        int numberOfLoops = 200;
        Set synchSet = Collections.synchronizedSet(smallSet);
        SynchCollectionChecker normalSynchChecker = new SynchCollectionChecker(synchSet, false, 200);
        SynchCollectionChecker offsetSynchChecker = new SynchCollectionChecker(synchSet, true, 200);
        Thread normalThread = new Thread(normalSynchChecker);
        Thread offsetThread = new Thread(offsetSynchChecker);
        normalThread.start();
        offsetThread.start();
        while (normalSynchChecker.getNumberOfChecks() < 200 || offsetSynchChecker.getNumberOfChecks() < 200) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        CollectionsTest.assertTrue((String)"Returned set corrupted by multiple thread access", (normalSynchChecker.getResult() && offsetSynchChecker.getResult() ? 1 : 0) != 0);
        try {
            normalThread.join(5000L);
            offsetThread.join(5000L);
        }
        catch (InterruptedException e) {
            CollectionsTest.fail((String)"join() interrupted");
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="unmodifiableCollection", args={Collection.class})
    public void test_unmodifiableCollectionLjava_util_Collection() {
        boolean exception = false;
        Collection<Object> c = Collections.unmodifiableCollection(this.ll);
        CollectionsTest.assertTrue((String)"Returned collection is of incorrect size", (c.size() == this.ll.size() ? 1 : 0) != 0);
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            CollectionsTest.assertTrue((String)"Returned list missing elements", (boolean)c.contains(i.next()));
        }
        try {
            c.add(new Object());
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        if (!exception) {
            CollectionsTest.fail((String)"Allowed modification of collection");
        }
        try {
            c.remove(new Object());
            CollectionsTest.fail((String)"Allowed modification of collection");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        ArrayList<Object> myCollection = new ArrayList<Object>();
        myCollection.add(new Integer(20));
        myCollection.add(null);
        c = Collections.unmodifiableCollection(myCollection);
        CollectionsTest.assertTrue((String)"Collection should contain null", (boolean)c.contains(null));
        CollectionsTest.assertTrue((String)"Collection should contain Integer(20)", (boolean)c.contains(new Integer(20)));
        myCollection = new ArrayList();
        for (int counter = 0; counter < 100; ++counter) {
            myCollection.add(this.objArray[counter]);
        }
        new Support_UnmodifiableCollectionTest("", Collections.unmodifiableCollection(myCollection)).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="unmodifiableList", args={List.class})
    public void test_unmodifiableListLjava_util_List() {
        boolean exception = false;
        List<Object> c = Collections.unmodifiableList(this.ll);
        try {
            Collections.unmodifiableList(null);
            CollectionsTest.fail((String)"Expected NullPointerException for null list parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        CollectionsTest.assertTrue((String)"Returned list is of incorrect size", (c.size() == this.ll.size() ? 1 : 0) != 0);
        CollectionsTest.assertTrue((String)"Returned List should not implement Random Access interface", (!(c instanceof RandomAccess) ? 1 : 0) != 0);
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            CollectionsTest.assertTrue((String)"Returned list missing elements", (boolean)c.contains(i.next()));
        }
        try {
            c.add(new Object());
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        if (!exception) {
            CollectionsTest.fail((String)"Allowed modification of list");
        }
        try {
            c.remove(new Object());
            CollectionsTest.fail((String)"Allowed modification of list");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        ArrayList<Integer> smallList = new ArrayList<Integer>();
        smallList.add(null);
        smallList.add((Integer)((Object)"yoink"));
        c = Collections.unmodifiableList(smallList);
        CollectionsTest.assertNull((String)"First element should be null", (Object)c.get(0));
        CollectionsTest.assertTrue((String)"List should contain null", (boolean)c.contains(null));
        CollectionsTest.assertTrue((String)"T1. Returned List should implement Random Access interface", (boolean)(c instanceof RandomAccess));
        smallList = new ArrayList();
        for (int counter = 0; counter < 100; ++counter) {
            smallList.add((Integer)this.objArray[counter]);
        }
        List myList = Collections.unmodifiableList(smallList);
        CollectionsTest.assertTrue((String)"List should not contain null", (!myList.contains(null) ? 1 : 0) != 0);
        CollectionsTest.assertTrue((String)"T2. Returned List should implement Random Access interface", (boolean)(myList instanceof RandomAccess));
        CollectionsTest.assertTrue((String)"get failed on unmodifiable list", (boolean)myList.get(50).equals(new Integer(50)));
        ListIterator listIterator = myList.listIterator();
        int counter = 0;
        while (listIterator.hasNext()) {
            CollectionsTest.assertTrue((String)"List has wrong elements", ((Integer)listIterator.next() == counter ? 1 : 0) != 0);
            ++counter;
        }
        new Support_UnmodifiableCollectionTest("", smallList).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="unmodifiableMap", args={Map.class})
    public void test_unmodifiableMapLjava_util_Map() {
        boolean exception = false;
        Map<Object, String> c = Collections.unmodifiableMap(this.hm);
        CollectionsTest.assertTrue((String)"Returned map is of incorrect size", (c.size() == this.hm.size() ? 1 : 0) != 0);
        for (Object x : this.hm.keySet()) {
            CollectionsTest.assertTrue((String)"Returned map missing elements", (boolean)c.get(x).equals(this.hm.get(x)));
        }
        try {
            c.put(new Object(), "");
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        CollectionsTest.assertTrue((String)"Allowed modification of map", (boolean)exception);
        exception = false;
        try {
            c.remove(new Object());
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        CollectionsTest.assertTrue((String)"Allowed modification of map", (boolean)exception);
        exception = false;
        Iterator it = c.entrySet().iterator();
        Map.Entry entry = it.next();
        try {
            entry.setValue("modified");
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        CollectionsTest.assertTrue((String)"Allowed modification of entry", (boolean)exception);
        exception = false;
        Object[] array = c.entrySet().toArray();
        try {
            ((Map.Entry)array[0]).setValue("modified");
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        CollectionsTest.assertTrue((String)"Allowed modification of array entry", (boolean)exception);
        exception = false;
        Map.Entry[] array2 = c.entrySet().toArray(new Map.Entry[0]);
        try {
            array2[0].setValue("modified");
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        CollectionsTest.assertTrue((String)"Allowed modification of array entry2", (boolean)exception);
        HashMap<Object, Object> smallMap = new HashMap<Object, Object>();
        smallMap.put(null, new Long(30L));
        smallMap.put(new Long(25L), null);
        Map<String, Integer> unmodMap = Collections.unmodifiableMap(smallMap);
        CollectionsTest.assertNull((String)"Trying to use a null value in map failed", unmodMap.get(new Long(25L)));
        CollectionsTest.assertTrue((String)"Trying to use a null key in map failed", (boolean)unmodMap.get(null).equals(new Long(30L)));
        smallMap = new HashMap();
        for (int counter = 0; counter < 100; ++counter) {
            smallMap.put(this.objArray[counter].toString(), this.objArray[counter]);
        }
        unmodMap = Collections.unmodifiableMap(smallMap);
        new Support_UnmodifiableMapTest("", unmodMap).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="unmodifiableSet", args={Set.class})
    public void test_unmodifiableSetLjava_util_Set() {
        boolean exception = false;
        Set c = Collections.unmodifiableSet(this.s);
        CollectionsTest.assertTrue((String)"Returned set is of incorrect size", (c.size() == this.s.size() ? 1 : 0) != 0);
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            CollectionsTest.assertTrue((String)"Returned set missing elements", (boolean)c.contains(i.next()));
        }
        try {
            c.add(new Object());
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        if (!exception) {
            CollectionsTest.fail((String)"Allowed modification of set");
        }
        try {
            c.remove(new Object());
            CollectionsTest.fail((String)"Allowed modification of set");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Set<Object> mySet = Collections.unmodifiableSet(new HashSet());
        CollectionsTest.assertTrue((String)"Should not contain null", (!mySet.contains(null) ? 1 : 0) != 0);
        mySet = Collections.unmodifiableSet(Collections.singleton(null));
        CollectionsTest.assertTrue((String)"Should contain null", (boolean)mySet.contains(null));
        mySet = new TreeSet();
        for (int counter = 0; counter < 100; ++counter) {
            mySet.add(this.objArray[counter]);
        }
        new Support_UnmodifiableCollectionTest("", Collections.unmodifiableSet(mySet)).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="unmodifiableSortedMap", args={SortedMap.class})
    public void test_unmodifiableSortedMapLjava_util_SortedMap() {
        boolean exception = false;
        TreeMap tm = new TreeMap();
        tm.putAll(this.hm);
        SortedMap<Object, String> c = Collections.unmodifiableSortedMap(tm);
        CollectionsTest.assertTrue((String)"Returned map is of incorrect size", (c.size() == tm.size() ? 1 : 0) != 0);
        for (Object x : this.hm.keySet()) {
            CollectionsTest.assertTrue((String)"Returned map missing elements", (boolean)c.get(x).equals(tm.get(x)));
        }
        try {
            c.put(new Object(), "");
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        if (!exception) {
            CollectionsTest.fail((String)"Allowed modification of map");
        }
        try {
            c.remove(new Object());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        CollectionsTest.fail((String)"Allowed modification of map");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="unmodifiableSortedSet", args={SortedSet.class})
    public void test_unmodifiableSortedSetLjava_util_SortedSet() {
        boolean exception = false;
        TreeSet ss = new TreeSet();
        ss.addAll(this.s);
        SortedSet<Object> c = Collections.unmodifiableSortedSet(ss);
        CollectionsTest.assertTrue((String)"Returned set is of incorrect size", (c.size() == ss.size() ? 1 : 0) != 0);
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            CollectionsTest.assertTrue((String)"Returned set missing elements", (boolean)c.contains(i.next()));
        }
        try {
            c.add(new Object());
        }
        catch (UnsupportedOperationException e) {
            exception = true;
        }
        if (!exception) {
            CollectionsTest.fail((String)"Allowed modification of set");
        }
        try {
            c.remove(new Object());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        CollectionsTest.fail((String)"Allowed modification of set");
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="toString", args={}), @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="unmodifiableCollection", args={Collection.class}), @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="unmodifiableMap", args={Map.class})})
    public void test_unmodifiable_toString_methods() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("a");
        al.add("b");
        Collection uc = Collections.unmodifiableCollection(al);
        CollectionsTest.assertEquals((String)"[a, b]", (String)uc.toString());
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("one", "1");
        m.put("two", "2");
        Map um = Collections.unmodifiableMap(m);
        CollectionsTest.assertTrue(("{one=1, two=2}".equals(um.toString()) || "{two=2, one=1}".equals(um.toString()) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="singletonList", args={Object.class})
    public void test_singletonListLjava_lang_Object() {
        String str = "Singleton";
        List<String> single = Collections.singletonList(str);
        CollectionsTest.assertEquals((int)1, (int)single.size());
        CollectionsTest.assertTrue((boolean)single.contains(str));
        CollectionsTest.assertFalse((boolean)single.contains(null));
        CollectionsTest.assertFalse((boolean)Collections.singletonList(null).contains(str));
        CollectionsTest.assertTrue((boolean)Collections.singletonList(null).contains(null));
        try {
            single.add("New element");
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="singletonMap", args={Object.class, Object.class})
    public void test_singletonMapLjava_lang_Object() {
        Double key = new Double(3.14);
        String value = "Fundamental constant";
        Map<Double, String> single = Collections.singletonMap(key, value);
        CollectionsTest.assertEquals((int)1, (int)single.size());
        CollectionsTest.assertTrue((boolean)single.containsKey(key));
        CollectionsTest.assertTrue((boolean)single.containsValue(value));
        CollectionsTest.assertFalse((boolean)single.containsKey(null));
        CollectionsTest.assertFalse((boolean)single.containsValue(null));
        CollectionsTest.assertFalse((boolean)Collections.singletonMap(null, null).containsKey(key));
        CollectionsTest.assertFalse((boolean)Collections.singletonMap(null, null).containsValue(value));
        CollectionsTest.assertTrue((boolean)Collections.singletonMap(null, null).containsKey(null));
        CollectionsTest.assertTrue((boolean)Collections.singletonMap(null, null).containsValue(null));
        try {
            single.clear();
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            single.put(new Double(1.0), "one wrong value");
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    protected void setUp() {
        int i;
        this.objArray = new Object[1000];
        this.myobjArray = new Object[1000];
        for (i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
            this.myobjArray[i] = new MyInt(i);
        }
        this.ll = new LinkedList();
        this.myll = new LinkedList();
        this.s = new HashSet();
        this.mys = new HashSet();
        this.reversedLinkedList = new LinkedList();
        this.myReversedLinkedList = new LinkedList();
        this.hm = new HashMap();
        for (i = 0; i < this.objArray.length; ++i) {
            this.ll.add(this.objArray[i]);
            this.myll.add(this.myobjArray[i]);
            this.s.add(this.objArray[i]);
            this.mys.add(this.myobjArray[i]);
            this.reversedLinkedList.add(this.objArray[this.objArray.length - i - 1]);
            this.myReversedLinkedList.add(this.myobjArray[this.myobjArray.length - i - 1]);
            this.hm.put(this.objArray[i].toString(), this.objArray[i]);
        }
    }

    protected void tearDown() {
        this.objArray = null;
        this.myobjArray = null;
        this.ll = null;
        this.myll = null;
        this.reversedLinkedList = null;
        this.myReversedLinkedList = null;
        this.s = null;
        this.mys = null;
        this.hm = null;
    }

    protected void doneSuite() {
        this.objArray = null;
    }

    class Mock_ArrayList
    extends ArrayList {
        Mock_ArrayList() {
        }

        public Object set(int index, Object o) {
            throw new UnsupportedOperationException();
        }
    }

    static class MyInt {
        int data;

        public MyInt(int value) {
            this.data = value;
        }

        public int compareTo(MyInt object) {
            return this.data > object.data ? 1 : (this.data < object.data ? -1 : 0);
        }
    }

    public static class CollectionTest
    extends TestCase {
        Collection col;

        public CollectionTest(String p1) {
            super(p1);
        }

        public CollectionTest(String p1, Collection c) {
            super(p1);
            this.col = c;
        }
    }

    public static class SynchMapChecker
    implements Runnable {
        Map map;
        int mapSize;
        int totalToRun;
        boolean offset;
        volatile int numberOfChecks = 0;
        boolean result = true;
        Map normalCountingMap;
        Map offsetCountingMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object firstNormalValue = this.normalCountingMap.get(new Integer(0));
            Object lastNormalValue = this.normalCountingMap.get(new Integer(this.mapSize - 1));
            Object firstOffsetValue = this.offsetCountingMap.get(new Integer(this.mapSize));
            Object lastOffsetValue = this.offsetCountingMap.get(new Integer(2 * this.mapSize - 1));
            while (this.numberOfChecks < this.totalToRun) {
                Map map = this.map;
                synchronized (map) {
                    if (!(this.map.isEmpty() || this.map.containsValue(firstNormalValue) && this.map.containsValue(lastNormalValue) || this.map.containsValue(firstOffsetValue) && this.map.containsValue(lastOffsetValue))) {
                        this.result = false;
                    }
                    this.map.clear();
                }
                if (this.offset) {
                    this.map.putAll(this.offsetCountingMap);
                } else {
                    this.map.putAll(this.normalCountingMap);
                }
                ++this.numberOfChecks;
            }
        }

        public SynchMapChecker(Map m, boolean offset, int totalChecks) {
            Integer myInt;
            int counter;
            this.totalToRun = totalChecks;
            this.map = m;
            this.mapSize = m.size();
            this.normalCountingMap = new HashMap(this.mapSize);
            this.offsetCountingMap = new HashMap(this.mapSize);
            for (counter = 0; counter < this.mapSize; ++counter) {
                myInt = new Integer(counter);
                this.normalCountingMap.put(myInt, myInt);
            }
            for (counter = 0; counter < this.mapSize; ++counter) {
                myInt = new Integer(counter + this.mapSize);
                this.offsetCountingMap.put(myInt, myInt);
            }
            this.map.clear();
            if (offset) {
                this.map.putAll(this.offsetCountingMap);
            } else {
                this.map.putAll(this.normalCountingMap);
            }
        }

        public boolean offset() {
            return this.offset;
        }

        public boolean getResult() {
            return this.result;
        }

        public int getNumberOfChecks() {
            return this.numberOfChecks;
        }
    }

    public static class SynchCollectionChecker
    implements Runnable {
        Collection col;
        int colSize;
        int totalToRun;
        boolean offset;
        volatile int numberOfChecks = 0;
        boolean result = true;
        ArrayList normalCountingList;
        ArrayList offsetCountingList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.numberOfChecks < this.totalToRun) {
                Collection collection = this.col;
                synchronized (collection) {
                    if (!(this.col.isEmpty() || this.col.containsAll(this.normalCountingList) || this.col.containsAll(this.offsetCountingList))) {
                        this.result = false;
                    }
                    this.col.clear();
                }
                if (this.offset) {
                    this.col.addAll(this.offsetCountingList);
                } else {
                    this.col.addAll(this.normalCountingList);
                }
                ++this.numberOfChecks;
            }
        }

        public SynchCollectionChecker(Collection c, boolean offset, int totalChecks) {
            int counter;
            this.totalToRun = totalChecks;
            this.col = c;
            this.colSize = c.size();
            this.normalCountingList = new ArrayList(this.colSize);
            this.offsetCountingList = new ArrayList(this.colSize);
            for (counter = 0; counter < this.colSize; ++counter) {
                this.normalCountingList.add(new Integer(counter));
            }
            for (counter = 0; counter < this.colSize; ++counter) {
                this.offsetCountingList.add(new Integer(counter + this.colSize));
            }
            this.col.clear();
            if (offset) {
                this.col.addAll(this.offsetCountingList);
            } else {
                this.col.addAll(this.normalCountingList);
            }
        }

        public boolean offset() {
            return this.offset;
        }

        public boolean getResult() {
            return this.result;
        }

        public int getNumberOfChecks() {
            return this.numberOfChecks;
        }
    }

    public static class ReversedMyIntComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return -((MyInt)o1).compareTo((MyInt)o2);
        }

        public int equals(Object o1, Object o2) {
            return ((MyInt)o1).compareTo((MyInt)o2);
        }
    }
}

