/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;
import tests.support.Support_Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarTest
extends TestCase {
    Locale defaultLocale;
    private static final Locale[] locales = new Locale[]{Locale.getDefault(), Locale.US, Locale.UK, Locale.TAIWAN, Locale.PRC, Locale.KOREA, Locale.JAPAN, Locale.ITALIAN, Locale.GERMAN, Locale.ENGLISH, Locale.CHINA, Locale.CANADA, Locale.FRANCE};

    public void test_setII() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        cal.clear();
        cal.set(1, 2002);
        CalendarTest.assertTrue((String)("Incorrect result 0: " + cal.getTime().getTime()), (cal.getTime().getTime() == 1009861200000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(2, 2);
        CalendarTest.assertTrue((String)("Incorrect result 0a: " + cal.getTime()), (cal.getTime().getTime() == 1014958800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 24);
        CalendarTest.assertTrue((String)("Incorrect result 0b: " + cal.getTime()), (cal.getTime().getTime() == 1011848400000L ? 1 : 0) != 0);
        cal.set(2, 9);
        cal.set(5, 31);
        cal.set(2, 10);
        cal.set(5, 26);
        CalendarTest.assertTrue((String)("Incorrect month: " + cal.get(2)), (cal.get(2) == 10 ? 1 : 0) != 0);
        int dow = cal.get(7);
        cal.set(5, 27);
        CalendarTest.assertTrue((String)("Incorrect DAY_OF_WEEK: " + cal.get(7) + " expected: " + dow), (cal.get(7) != dow ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(7, 2);
        CalendarTest.assertTrue((String)("Incorrect result 0c1: " + cal.getTime().getTime()), (cal.getTime().getTime() == 1010379600000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(7, 3);
        CalendarTest.assertTrue((String)("Incorrect result 0c2: " + cal.getTime().getTime()), (cal.getTime().getTime() == 1009861200000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(7, 5);
        CalendarTest.assertTrue((String)("Incorrect result 0c3: " + cal.getTime()), (cal.getTime().getTime() == 1010034000000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(4, 2);
        CalendarTest.assertTrue((String)("Incorrect result 0d: " + cal.getTime()), (cal.getTime().getTime() == 1010293200000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(8, 2);
        CalendarTest.assertTrue((String)("Incorrect result 0e: " + cal.getTime()), (cal.getTime().getTime() == 1010898000000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 11);
        CalendarTest.assertTrue((String)("Incorrect result 0f: " + cal.getTime()), (cal.getTime().getTime() == 1015736400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 24);
        cal.set(3, 11);
        CalendarTest.assertTrue((String)("Incorrect result 0g: " + cal.getTime()), (cal.getTime().getTime() == 1011848400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.get(3);
        cal.set(3, 11);
        CalendarTest.assertTrue((String)("Incorrect result 0h: " + cal.getTime()), (cal.getTime().getTime() == 1015909200000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(6, 170);
        cal.set(3, 11);
        cal.set(2, 0);
        cal.set(5, 5);
        cal.set(7, 2);
        CalendarTest.assertTrue((String)("Incorrect result 1: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 11);
        cal.set(2, 0);
        cal.set(5, 5);
        cal.set(6, 170);
        cal.set(7, 2);
        CalendarTest.assertTrue((String)("Incorrect result 1a: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(2, 2);
        cal.set(5, 11);
        cal.set(7, 3);
        CalendarTest.assertTrue((String)("Incorrect result 1b: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(2, 2);
        cal.set(7, 3);
        CalendarTest.assertEquals((String)("Incorrect result 1b: " + cal.getTime()), (long)1015304400000L, (long)cal.getTime().getTime());
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(8, 1);
        cal.set(4, 3);
        cal.set(2, 2);
        cal.set(5, 5);
        cal.set(7, 2);
        CalendarTest.assertTrue((String)("Incorrect result 2: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(8, 2);
        cal.set(2, 2);
        cal.set(5, 5);
        cal.set(7, 2);
        CalendarTest.assertTrue((String)("Incorrect result 3: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(8, 1);
        cal.set(4, 3);
        cal.set(5, 25);
        cal.set(7, 2);
        CalendarTest.assertTrue((String)("Incorrect result 4: " + cal.getTime()), (cal.getTime().getTime() == 1010984400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 11);
        cal.set(5, 25);
        cal.set(7, 2);
        cal.set(2, 0);
        CalendarTest.assertTrue((String)("Incorrect result 5: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(5, 11);
        cal.set(2, 2);
        CalendarTest.assertTrue((String)("Incorrect result 5a: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(5, 11);
        cal.set(4, 1);
        cal.set(2, 2);
        CalendarTest.assertTrue((String)("Incorrect result 5b: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(5, 5);
        cal.set(4, 3);
        cal.set(7, 2);
        cal.set(2, 2);
        CalendarTest.assertTrue((String)("Incorrect result 5c: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(7, 2);
        cal.set(2, 2);
        cal.set(5, 11);
        CalendarTest.assertTrue((String)("Incorrect result 6: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 12);
        cal.set(7, 2);
        cal.set(5, 14);
        CalendarTest.assertTrue((String)("Incorrect result 7: " + cal.getTime()), (cal.getTime().getTime() == 1010984400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(6, 70);
        cal.set(2, 0);
        CalendarTest.assertTrue((String)("Incorrect result 8: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(6, 170);
        cal.set(5, 11);
        cal.set(2, 2);
        CalendarTest.assertTrue((String)("Incorrect result 8a: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 15);
        cal.set(6, 70);
        cal.set(2, 0);
        CalendarTest.assertTrue((String)("Incorrect result 8b: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(6, 70);
        cal.set(5, 14);
        CalendarTest.assertTrue((String)("Incorrect result 9: " + cal.getTime()), (cal.getTime().getTime() == 1010984400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(3, 15);
        cal.set(7, 5);
        cal.set(5, 14);
        CalendarTest.assertTrue((String)("Incorrect result 9a: " + cal.getTime()), (cal.getTime().getTime() == 1010984400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(7, 2);
        cal.set(5, 14);
        cal.set(3, 11);
        CalendarTest.assertTrue((String)("Incorrect result 9b: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 14);
        cal.set(3, 11);
        CalendarTest.assertTrue((String)("Incorrect result 9c: " + cal.getTime()), (cal.getTime().getTime() == 1010984400000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(4, 1);
        cal.set(7, 5);
        cal.set(2, 2);
        cal.set(5, 11);
        CalendarTest.assertTrue((String)("Incorrect result 9d: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(6, 70);
        cal.set(7, 3);
        CalendarTest.assertTrue((String)("Incorrect result 10: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 11);
        cal.set(2, 2);
        cal.set(8, 1);
        CalendarTest.assertTrue((String)("Incorrect result 11: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 11);
        cal.set(2, 2);
        cal.set(3, 15);
        CalendarTest.assertTrue((String)("Incorrect result 12: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(5, 11);
        cal.set(2, 2);
        cal.set(4, 1);
        CalendarTest.assertTrue((String)("Incorrect result 13: " + cal.getTime()), (cal.getTime().getTime() == 1015822800000L ? 1 : 0) != 0);
        cal.clear();
        cal.set(1, 2002);
        cal.set(6, 111);
        cal.get(1);
        cal.set(2, 2);
        cal.set(9, 0);
        CalendarTest.assertTrue((String)("Incorrect result 14: " + cal.getTime()), (cal.getTime().getTime() == 1016686800000L ? 1 : 0) != 0);
        int hour = cal.get(10);
        cal.set(10, hour);
        cal.set(9, 1);
        CalendarTest.assertEquals((String)"AM_PM not changed", (int)1, (int)cal.get(9));
        cal.set(9, 0);
        CalendarTest.assertEquals((String)"AM_PM was changed 1", (int)0, (int)cal.get(9));
        int hourOfDay = cal.get(11);
        hour = cal.get(10);
        cal.set(9, 1);
        CalendarTest.assertEquals((String)"AM_PM was changed 2", (int)1, (int)cal.get(9));
        CalendarTest.assertEquals((int)hour, (int)cal.get(10));
        CalendarTest.assertEquals((int)(hourOfDay + 12), (int)cal.get(11));
        cal = Calendar.getInstance();
        int oldValue = cal.get(9);
        int newValue = oldValue == 0 ? 1 : 0;
        cal.set(9, newValue);
        newValue = cal.get(9);
        CalendarTest.assertTrue((newValue != oldValue ? 1 : 0) != 0);
    }

    public void test_setTimeLjava_util_Date() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(884581200000L));
        CalendarTest.assertEquals((String)"incorrect millis", (long)884581200000L, (long)cal.getTime().getTime());
        cal.setTimeZone(TimeZone.getTimeZone("EST"));
        cal.setTime(new Date(943506000000L));
        CalendarTest.assertTrue((String)"incorrect fields", (cal.get(1) == 1999 && cal.get(2) == 10 && cal.get(5) == 25 ? 1 : 0) != 0);
    }

    public void test_compareToLjava_util_Calendar_null() {
        Calendar cal = Calendar.getInstance();
        try {
            cal.compareTo(null);
            CalendarTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_compareToLjava_util_Calendar() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1997, 12, 13, 23, 57);
        Calendar anotherCal = Calendar.getInstance();
        anotherCal.clear();
        anotherCal.set(1997, 12, 13, 23, 57);
        CalendarTest.assertEquals((int)0, (int)cal.compareTo(anotherCal));
        anotherCal = Calendar.getInstance();
        anotherCal.clear();
        anotherCal.set(1997, 11, 13, 24, 57);
        CalendarTest.assertEquals((int)1, (int)cal.compareTo(anotherCal));
        anotherCal = Calendar.getInstance();
        anotherCal.clear();
        anotherCal.set(1997, 12, 13, 23, 58);
        CalendarTest.assertEquals((int)-1, (int)cal.compareTo(anotherCal));
    }

    public void test_clone() {
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 5, 6, 11, 35);
        Calendar anotherCal = (Calendar)cal.clone();
        CalendarTest.assertNotSame((String)"getTimeZone", (Object)cal.getTimeZone(), (Object)anotherCal.getTimeZone());
    }

    public void test_getTimeInMillis() {
        Calendar cal = Calendar.getInstance();
        int year = -2147483577;
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(1, year + 1900);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        CalendarTest.assertEquals((long)6017546357372606464L, (long)cal.getTimeInMillis());
    }

    public void test_before_after() {
        Calendar early = Calendar.getInstance();
        Calendar late = Calendar.getInstance();
        early.set(2008, 3, 20, 17, 28, 12);
        late.set(2008, 3, 20, 17, 28, 22);
        CalendarTest.assertTrue((boolean)early.before(late));
        CalendarTest.assertFalse((boolean)early.before(early));
        CalendarTest.assertFalse((boolean)late.before(early));
        CalendarTest.assertTrue((boolean)late.after(early));
        CalendarTest.assertFalse((boolean)late.after(late));
        CalendarTest.assertFalse((boolean)early.after(late));
        early.set(2008, 3, 20, 17, 18, 12);
        late.set(2008, 3, 20, 17, 28, 12);
        CalendarTest.assertTrue((boolean)early.before(late));
        CalendarTest.assertFalse((boolean)early.before(early));
        CalendarTest.assertFalse((boolean)late.before(early));
        CalendarTest.assertTrue((boolean)late.after(early));
        CalendarTest.assertFalse((boolean)late.after(late));
        CalendarTest.assertFalse((boolean)early.after(late));
        early.set(2008, 3, 20, 17, 28, 12);
        late.set(2008, 3, 20, 27, 28, 12);
        CalendarTest.assertTrue((boolean)early.before(late));
        CalendarTest.assertFalse((boolean)early.before(early));
        CalendarTest.assertFalse((boolean)late.before(early));
        CalendarTest.assertTrue((boolean)late.after(early));
        CalendarTest.assertFalse((boolean)late.after(late));
        CalendarTest.assertFalse((boolean)early.after(late));
        early.set(2008, 3, 10, 17, 28, 12);
        late.set(2008, 3, 20, 17, 28, 12);
        CalendarTest.assertTrue((boolean)early.before(late));
        CalendarTest.assertFalse((boolean)early.before(early));
        CalendarTest.assertFalse((boolean)late.before(early));
        CalendarTest.assertTrue((boolean)late.after(early));
        CalendarTest.assertFalse((boolean)late.after(late));
        CalendarTest.assertFalse((boolean)early.after(late));
        early.set(2008, 2, 20, 17, 28, 12);
        late.set(2008, 3, 20, 17, 28, 12);
        CalendarTest.assertTrue((boolean)early.before(late));
        CalendarTest.assertFalse((boolean)early.before(early));
        CalendarTest.assertFalse((boolean)late.before(early));
        CalendarTest.assertTrue((boolean)late.after(early));
        CalendarTest.assertFalse((boolean)late.after(late));
        CalendarTest.assertFalse((boolean)early.after(late));
        early.set(2007, 3, 20, 17, 28, 12);
        late.set(2008, 3, 20, 17, 28, 12);
        CalendarTest.assertTrue((boolean)early.before(late));
        CalendarTest.assertFalse((boolean)early.before(early));
        CalendarTest.assertFalse((boolean)late.before(early));
        CalendarTest.assertTrue((boolean)late.after(early));
        CalendarTest.assertFalse((boolean)late.after(late));
        CalendarTest.assertFalse((boolean)early.after(late));
    }

    public void test_clear() {
        int index;
        int i;
        Calendar calendar = Calendar.getInstance();
        int count = 6;
        int[] fields = new int[count];
        int[] defaults = new int[count];
        fields[0] = 1;
        fields[1] = 2;
        fields[2] = 5;
        fields[3] = 11;
        fields[4] = 12;
        fields[5] = 13;
        defaults[0] = 1970;
        defaults[1] = 0;
        defaults[2] = 1;
        defaults[3] = 0;
        defaults[4] = 0;
        defaults[5] = 0;
        calendar.set(2008, 3, 20, 17, 28, 12);
        for (i = 0; i < fields.length; ++i) {
            index = fields[i];
            calendar.clear(index);
            if (5 == index) {
                CalendarTest.assertEquals((String)("Field " + index + " Should equal to 20."), (int)20, (int)calendar.get(index));
                continue;
            }
            if (11 == index) {
                CalendarTest.assertEquals((String)("Field " + index + " Should equal to 17."), (int)17, (int)calendar.get(index));
                continue;
            }
            CalendarTest.assertEquals((String)("Field " + index + " Should equal to " + defaults[i] + "."), (int)defaults[i], (int)calendar.get(index));
        }
        calendar.set(2008, 3, 20, 17, 28, 12);
        calendar.clear();
        for (i = 0; i < fields.length; ++i) {
            index = fields[i];
            CalendarTest.assertEquals((String)("Field " + index + " Should equal to " + defaults[i] + "."), (int)defaults[i], (int)calendar.get(index));
        }
    }

    public void test_isSet() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        for (int i = 0; i < 17; ++i) {
            CalendarTest.assertFalse((boolean)calendar.isSet(i));
        }
    }

    public void test_getAvailableLocales() {
        Locale[] locales = Calendar.getAvailableLocales();
        boolean exist = false;
        for (int i = 0; i < locales.length; ++i) {
            Locale l = locales[i];
            if (!Locale.US.equals(l)) continue;
            exist = true;
            break;
        }
        CalendarTest.assertTrue((boolean)exist);
    }

    public void test_getInstance() {
        if (Support_Locale.areLocalesAvailable(Locale.US)) {
            Calendar us_calendar = Calendar.getInstance(Locale.US);
            CalendarTest.assertEquals((int)1, (int)us_calendar.getFirstDayOfWeek());
        }
        if (Support_Locale.areLocalesAvailable(Locale.CHINESE)) {
            Calendar ch_calendar = Calendar.getInstance(Locale.CHINESE);
            CalendarTest.assertEquals((int)2, (int)ch_calendar.getFirstDayOfWeek());
        }
        Calendar gmt_calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        CalendarTest.assertEquals((Object)TimeZone.getTimeZone("GMT"), (Object)gmt_calendar.getTimeZone());
        Calendar est_calendar = Calendar.getInstance(TimeZone.getTimeZone("EST"), Locale.US);
        CalendarTest.assertEquals((String)TimeZone.getTimeZone("EST").getID(), (String)est_calendar.getTimeZone().getID());
    }

    public void test_internalGet() {
        MockGregorianCalendar c = new MockGregorianCalendar();
        c.clear(1);
        CalendarTest.assertEquals((int)0, (int)c.internal_get(1));
    }

    public void test_hashcode() {
        Calendar calendar = Calendar.getInstance(Locale.JAPAN);
        CalendarTest.assertTrue((calendar.hashCode() == calendar.hashCode() ? 1 : 0) != 0);
    }

    public void test_roll() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2008, 3, 20, 17, 28, 12);
        calendar.roll(5, 5);
        CalendarTest.assertEquals((int)25, (int)calendar.get(5));
        calendar.roll(5, -5);
        CalendarTest.assertEquals((int)20, (int)calendar.get(5));
        calendar.roll(5, 0);
        CalendarTest.assertEquals((int)20, (int)calendar.get(5));
        calendar.set(2008, 1, 31, 17, 28, 12);
        calendar.roll(2, 1);
        CalendarTest.assertEquals((int)2, (int)calendar.get(5));
    }

    public void test_toString() {
        Calendar calendar = Calendar.getInstance();
        CalendarTest.assertTrue((boolean)(calendar.toString() instanceof String));
        CalendarTest.assertEquals((int)-1, (int)calendar.toString().indexOf("?"));
        calendar.clear();
        CalendarTest.assertTrue((boolean)(calendar.toString() instanceof String));
        CalendarTest.assertTrue((0 <= calendar.toString().indexOf("?") ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2008, 3, 20, 17, 28, 12);
        SerializationTest.verifySelf(calendar);
    }

    public void test_getDisplayNameIILjava_util_Locale() {
        Calendar cal = Calendar.getInstance();
        for (int field = 0; field < 17; ++field) {
            block25: for (Locale locale : locales) {
                DateFormatSymbols symbols = new DateFormatSymbols(locale);
                String value = null;
                switch (field) {
                    case 9: {
                        cal.set(9, 0);
                        value = symbols.getAmPmStrings()[0];
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 1, locale), (String)value);
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 2, locale), (String)value);
                        cal.set(9, 1);
                        value = symbols.getAmPmStrings()[1];
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 1, locale), (String)value);
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 2, locale), (String)value);
                        continue block25;
                    }
                    case 0: {
                        cal.set(0, 0);
                        value = symbols.getEras()[0];
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 1, locale), (String)value);
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 2, locale), (String)value);
                        cal.set(0, 1);
                        value = symbols.getEras()[1];
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 1, locale), (String)value);
                        CalendarTest.assertEquals((String)cal.getDisplayName(field, 2, locale), (String)value);
                        continue block25;
                    }
                    case 2: {
                        cal.set(5, 1);
                        for (int month = 0; month <= 11; ++month) {
                            cal.set(2, month);
                            value = symbols.getShortMonths()[month];
                            CalendarTest.assertEquals((String)cal.getDisplayName(field, 1, locale), (String)value);
                            value = symbols.getMonths()[month];
                            CalendarTest.assertEquals((String)cal.getDisplayName(field, 2, locale), (String)value);
                        }
                        continue block25;
                    }
                    case 7: {
                        for (int day = 1; day <= 7; ++day) {
                            cal.set(7, day);
                            value = symbols.getShortWeekdays()[day];
                            CalendarTest.assertEquals((String)cal.getDisplayName(field, 1, locale), (String)value);
                            value = symbols.getWeekdays()[day];
                            CalendarTest.assertEquals((String)cal.getDisplayName(field, 2, locale), (String)value);
                        }
                        continue block25;
                    }
                    default: {
                        CalendarTest.assertNull((Object)cal.getDisplayName(field, 1, locale));
                        CalendarTest.assertNull((Object)cal.getDisplayName(field, 2, locale));
                    }
                }
            }
        }
        cal.setLenient(true);
        try {
            cal.getDisplayName(-1, 1, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(17, 2, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(2, -1, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(2, 3, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(2, 1, null);
            CalendarTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(-1, 1, null);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(2, -1, null);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        cal.set(13, 999);
        cal.getDisplayName(2, 1, Locale.US);
        for (int field = 0; field < 17; ++field) {
            for (Locale locale : locales) {
                String result = cal.getDisplayName(field, 0, locale);
                if (field == 9 || field == 0 || field == 2 || field == 7) {
                    CalendarTest.assertEquals((String)result, (String)cal.getDisplayName(field, 1, locale));
                    continue;
                }
                CalendarTest.assertNull((Object)result);
            }
        }
        cal.setLenient(false);
        CalendarTest.assertNotNull((Object)cal.getDisplayName(2, 1, Locale.US));
        cal.set(13, 999);
        try {
            cal.getDisplayName(2, 1, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayName(2, 0, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_getDisplayNamesIILjava_util_Locale() {
        CalendarTest.assertEquals((int)0, (int)0);
        CalendarTest.assertEquals((int)1, (int)1);
        CalendarTest.assertEquals((int)2, (int)2);
        Calendar cal = Calendar.getInstance(Locale.US);
        for (int field = 0; field < 17; ++field) {
            block22: for (Locale locale : locales) {
                Map<String, Integer> shortResult = cal.getDisplayNames(field, 1, locale);
                Map<String, Integer> longResult = cal.getDisplayNames(field, 2, locale);
                Map<String, Integer> allResult = cal.getDisplayNames(field, 0, locale);
                DateFormatSymbols symbols = new DateFormatSymbols(locale);
                String[] values = null;
                switch (field) {
                    case 0: 
                    case 9: {
                        values = field == 9 ? symbols.getAmPmStrings() : symbols.getEras();
                        this.assertDisplayNameMap(values, shortResult, 0);
                        this.assertDisplayNameMap(values, longResult, 0);
                        this.assertDisplayNameMap(values, allResult, 0);
                        continue block22;
                    }
                    case 2: {
                        values = symbols.getShortMonths();
                        this.assertDisplayNameMap(values, shortResult, 0);
                        values = symbols.getMonths();
                        this.assertDisplayNameMap(values, longResult, 0);
                        CalendarTest.assertTrue((allResult.size() >= shortResult.size() ? 1 : 0) != 0);
                        CalendarTest.assertTrue((allResult.size() >= longResult.size() ? 1 : 0) != 0);
                        CalendarTest.assertTrue((allResult.size() <= shortResult.size() + longResult.size() ? 1 : 0) != 0);
                        continue block22;
                    }
                    case 7: {
                        values = symbols.getShortWeekdays();
                        this.assertDisplayNameMap(values, shortResult, 1);
                        values = symbols.getWeekdays();
                        this.assertDisplayNameMap(values, longResult, 1);
                        CalendarTest.assertTrue((allResult.size() >= shortResult.size() ? 1 : 0) != 0);
                        CalendarTest.assertTrue((allResult.size() >= longResult.size() ? 1 : 0) != 0);
                        CalendarTest.assertTrue((allResult.size() <= shortResult.size() + longResult.size() ? 1 : 0) != 0);
                        continue block22;
                    }
                    default: {
                        CalendarTest.assertNull(shortResult);
                        CalendarTest.assertNull(longResult);
                        CalendarTest.assertNull(allResult);
                    }
                }
            }
        }
        cal.setLenient(true);
        try {
            cal.getDisplayNames(-1, 1, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayNames(17, 2, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayNames(2, -1, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayNames(2, 3, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayNames(2, 1, null);
            CalendarTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            cal.getDisplayNames(-1, 1, null);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal.getDisplayNames(2, -1, null);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        cal.set(13, 999);
        cal.getDisplayNames(2, 1, Locale.US);
        cal.setLenient(false);
        cal.set(13, 999);
        try {
            cal.getDisplayNames(2, 1, Locale.US);
            CalendarTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertDisplayNameMap(String[] values, Map<String, Integer> result, int shift) {
        ArrayList<String> trimValue = new ArrayList<String>();
        for (String value : values) {
            if (value.trim().length() <= 0) continue;
            trimValue.add(value);
        }
        CalendarTest.assertEquals((int)trimValue.size(), (int)result.size());
        for (int i = 0; i < trimValue.size(); ++i) {
            CalendarTest.assertEquals((int)(i + shift), (int)result.get(trimValue.get(i)));
        }
    }

    public void test_getActualMaximum_I() {
        MockCalendar c = new MockCalendar();
        CalendarTest.assertEquals((String)"should be equal to 0", (int)0, (int)c.getActualMaximum(0));
    }

    public void test_getActualMinimum_I() {
        MockCalendar c = new MockCalendar();
        CalendarTest.assertEquals((String)"should be equal to 0", (int)0, (int)c.getActualMinimum(0));
    }

    protected void setUp() {
        this.defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
    }

    protected void tearDown() {
        Locale.setDefault(this.defaultLocale);
    }

    private class MockCalendar
    extends Calendar {
        public void add(int field, int value) {
        }

        protected void computeFields() {
        }

        protected void computeTime() {
        }

        public int getGreatestMinimum(int field) {
            return 0;
        }

        public int getLeastMaximum(int field) {
            return 0;
        }

        public int getMaximum(int field) {
            return 0;
        }

        public int getMinimum(int field) {
            return 0;
        }

        public void roll(int field, boolean increment) {
        }
    }

    private class MockGregorianCalendar
    extends GregorianCalendar {
        private MockGregorianCalendar() {
        }

        public int internal_get(int field) {
            return super.internalGet(field);
        }
    }
}

