/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.BitSet;
import junit.framework.TestCase;

@TestTargetClass(value=BitSet.class)
public class BitSetTest
extends TestCase {
    BitSet eightbs;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="BitSet", args={})
    public void test_Constructor() {
        BitSet bs = new BitSet();
        BitSetTest.assertEquals((String)"Created BitSet of incorrect size", (int)64, (int)bs.size());
        BitSetTest.assertEquals((String)"New BitSet had invalid string representation", (String)"{}", (String)bs.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="BitSet", args={int.class})
    public void test_ConstructorI() {
        BitSet bs = new BitSet(128);
        BitSetTest.assertEquals((String)"Created BitSet of incorrect size", (int)128, (int)bs.size());
        BitSetTest.assertTrue((String)("New BitSet had invalid string representation: " + bs.toString()), (boolean)bs.toString().equals("{}"));
        bs = new BitSet(89);
        BitSetTest.assertEquals((String)"Failed to round BitSet element size", (int)128, (int)bs.size());
        try {
            bs = new BitSet(-9);
            BitSetTest.fail((String)"Failed to throw exception when creating a new BitSet with negative elements value");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        BitSet bs = (BitSet)this.eightbs.clone();
        BitSetTest.assertTrue((String)"Clone failed to return equal BitSet", (boolean)this.eightbs.equals(bs));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        BitSet bs = (BitSet)this.eightbs.clone();
        BitSetTest.assertTrue((String)"Same BitSet returned false", (boolean)this.eightbs.equals(this.eightbs));
        BitSetTest.assertTrue((String)"Identical BitSets returned false", (boolean)this.eightbs.equals(bs));
        bs.clear(6);
        BitSetTest.assertTrue((String)"Different BitSets returned true", (!this.eightbs.equals(bs) ? 1 : 0) != 0);
        bs = (BitSet)this.eightbs.clone();
        bs.set(128);
        BitSetTest.assertTrue((String)"Different sized BitSet with higher bit set returned true", (!this.eightbs.equals(bs) ? 1 : 0) != 0);
        bs.clear(128);
        BitSetTest.assertTrue((String)"Different sized BitSet with higher bits not set returned false", (boolean)this.eightbs.equals(bs));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        BitSet bs = (BitSet)this.eightbs.clone();
        bs.clear(2);
        bs.clear(6);
        BitSetTest.assertTrue((String)("BitSet returns wrong hash value: " + bs.hashCode()), (bs.hashCode() == 1129 ? 1 : 0) != 0);
        bs.set(10);
        bs.clear(3);
        BitSetTest.assertTrue((String)("BitSet returns wrong hash value: " + bs.hashCode()), (bs.hashCode() == 97 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        this.eightbs.clear();
        for (int i = 0; i < 8; ++i) {
            BitSetTest.assertTrue((String)("Clear didn't clear bit " + i), (!this.eightbs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertEquals((String)"Test1: Wrong length", (int)0, (int)this.eightbs.length());
        BitSet bs = new BitSet(3400);
        bs.set(0, bs.size() - 1);
        bs.set(bs.size() - 1);
        bs.clear();
        BitSetTest.assertEquals((String)"Test2: Wrong length", (int)0, (int)bs.length());
        BitSetTest.assertTrue((String)"Test2: isEmpty() returned incorrect value", (boolean)bs.isEmpty());
        BitSetTest.assertEquals((String)"Test2: cardinality() returned incorrect value", (int)0, (int)bs.cardinality());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={int.class})
    public void test_clearI() {
        this.eightbs.clear(7);
        BitSetTest.assertTrue((String)"Failed to clear bit", (!this.eightbs.get(7) ? 1 : 0) != 0);
        for (int i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)"Clear cleared incorrect bits", (boolean)this.eightbs.get(i));
        }
        this.eightbs.clear(165);
        BitSetTest.assertTrue((String)"Failed to clear bit", (!this.eightbs.get(165) ? 1 : 0) != 0);
        try {
            this.eightbs.clear(-1);
            BitSetTest.fail((String)"Failed to throw expected out of bounds exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        BitSet bs = new BitSet(0);
        BitSetTest.assertTrue((String)("Test1: Wrong length, " + bs.size()), (bs.length() == 0 ? 1 : 0) != 0);
        bs.clear(0);
        BitSetTest.assertTrue((String)("Test2: Wrong length" + bs.size()), (bs.length() == 0 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={int.class, int.class})
    public void test_clearII() {
        int i;
        BitSet bs = new BitSet(16);
        int initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(5);
        bs.clear(15);
        bs.clear(7, 11);
        for (i = 0; i < 7; ++i) {
            if (i == 5) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = 7; i < 11; ++i) {
            BitSetTest.assertTrue((String)("Failed to clear bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 11; i < initialSize; ++i) {
            if (i == 15) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = initialSize; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(16);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(7, 64);
        BitSetTest.assertEquals((String)"Failed to grow BitSet", (int)64, (int)bs.size());
        for (i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = 7; i < 64; ++i) {
            BitSetTest.assertTrue((String)("Failed to clear bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 64; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(32);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(0, 64);
        for (i = 0; i < 64; ++i) {
            BitSetTest.assertTrue((String)("Failed to clear bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 64; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(32);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(0, 65);
        for (i = 0; i < 65; ++i) {
            BitSetTest.assertTrue((String)("Failed to clear bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 65; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(128);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(7);
        bs.clear(110);
        bs.clear(9, 74);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = 9; i < 74; ++i) {
            BitSetTest.assertTrue((String)("Failed to clear bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 74; i < initialSize; ++i) {
            if (i == 110) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = initialSize; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(256);
        bs.set(0, 256);
        bs.clear(7);
        bs.clear(255);
        bs.clear(9, 219);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = 9; i < 219; ++i) {
            BitSetTest.assertTrue((String)("failed to clear bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 219; i < 255; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have cleared bit " + i), (boolean)bs.get(i));
        }
        for (i = 255; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(10);
        try {
            bs.clear(-1, 3);
            BitSetTest.fail((String)"Test1: Attempt to flip with  negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs.clear(2, -1);
            BitSetTest.fail((String)"Test2: Attempt to flip with negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs.clear(4, 2);
            BitSetTest.fail((String)"Test4: Attempt to flip with illegal args failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={int.class})
    public void test_getI() {
        BitSet bs = new BitSet();
        bs.set(8);
        BitSetTest.assertTrue((String)"Get returned true for index out of range", (!this.eightbs.get(99) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Get returned false for set value", (boolean)this.eightbs.get(3));
        BitSetTest.assertTrue((String)"Get returned true for a non set value", (!bs.get(0) ? 1 : 0) != 0);
        try {
            bs.get(-1);
            BitSetTest.fail((String)"Attempt to get at negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        bs = new BitSet(1);
        BitSetTest.assertTrue((String)"Access greater than size", (!bs.get(64) ? 1 : 0) != 0);
        bs = new BitSet();
        bs.set(63);
        BitSetTest.assertTrue((String)"Test highest bit", (boolean)bs.get(63));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={int.class, int.class})
    public void test_getII() {
        BitSet bs = new BitSet(512);
        bs.set(3, 9);
        bs.set(10, 20);
        bs.set(60, 75);
        bs.set(121);
        bs.set(130, 140);
        BitSet resultbs = bs.get(3, 6);
        BitSet correctbs = new BitSet(3);
        correctbs.set(0, 3);
        BitSetTest.assertTrue((String)"Test1: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        resultbs = bs.get(100, 125);
        correctbs = new BitSet(25);
        correctbs.set(21);
        BitSetTest.assertTrue((String)"Test2: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        resultbs = bs.get(15, 125);
        correctbs = new BitSet(25);
        correctbs.set(0, 5);
        correctbs.set(45, 60);
        correctbs.set(106);
        BitSetTest.assertTrue((String)"Test3: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        resultbs = bs.get(70, 145);
        correctbs = new BitSet(75);
        correctbs.set(0, 5);
        correctbs.set(51);
        correctbs.set(60, 70);
        BitSetTest.assertTrue((String)"Test4: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        resultbs = bs.get(5, 145);
        correctbs = new BitSet(140);
        correctbs.set(0, 4);
        correctbs.set(5, 15);
        correctbs.set(55, 70);
        correctbs.set(116);
        correctbs.set(125, 135);
        BitSetTest.assertTrue((String)"Test5: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        resultbs = bs.get(5, 250);
        correctbs = new BitSet(200);
        correctbs.set(0, 4);
        correctbs.set(5, 15);
        correctbs.set(55, 70);
        correctbs.set(116);
        correctbs.set(125, 135);
        BitSetTest.assertTrue((String)"Test6: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        BitSetTest.assertTrue((String)"equality principle", (boolean)bs.equals(bs.get(0, bs.size())));
        BitSet bs2 = new BitSet(129);
        bs2.set(0, 20);
        bs2.set(62, 65);
        bs2.set(121, 123);
        resultbs = bs2.get(1, 124);
        correctbs = new BitSet(129);
        correctbs.set(0, 19);
        correctbs.set(61, 64);
        correctbs.set(120, 122);
        BitSetTest.assertTrue((String)"Test6: Returned incorrect BitSet", (boolean)resultbs.equals(correctbs));
        bs2 = new BitSet(128);
        bs2.set(2, 20);
        bs2.set(62);
        bs2.set(121, 123);
        bs2.set(127);
        resultbs = bs2.get(0, bs2.size());
        BitSetTest.assertTrue((String)"equality principle", (boolean)bs2.equals(resultbs));
        bs2 = new BitSet(128);
        bs2.set(2, 20);
        bs2.set(62);
        bs2.set(121, 123);
        bs2.set(127);
        bs2.flip(0, 128);
        resultbs = bs2.get(0, bs.size());
        BitSetTest.assertTrue((String)"equality principle", (boolean)bs2.equals(resultbs));
        try {
            bs2.get(-1, 0);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs2.get(bs2.size() / 2, 0);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs2.get(bs2.size() / 2, -1);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class})
    public void test_setI() {
        BitSet bs = new BitSet();
        bs.set(8);
        BitSetTest.assertTrue((String)"Failed to set bit", (boolean)bs.get(8));
        try {
            bs.set(-1);
            BitSetTest.fail((String)"Attempt to set at negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        bs.set(128);
        BitSetTest.assertEquals((String)"Failed to grow BitSet", (int)192, (int)bs.size());
        BitSetTest.assertTrue((String)"Failed to set bit", (boolean)bs.get(128));
        bs = new BitSet(64);
        int i = bs.size();
        while (--i >= 0) {
            bs.set(i);
            BitSetTest.assertTrue((String)"Incorrectly set", (boolean)bs.get(i));
            BitSetTest.assertTrue((String)"Incorrect length", (bs.length() == i + 1 ? 1 : 0) != 0);
            int j = bs.size();
            while (--j > i) {
                BitSetTest.assertTrue((String)("Incorrectly set bit " + j), (!bs.get(j) ? 1 : 0) != 0);
            }
            j = i;
            while (--j >= 0) {
                BitSetTest.assertTrue((String)("Incorrectly set bit " + j), (!bs.get(j) ? 1 : 0) != 0);
            }
            bs.clear(i);
        }
        bs = new BitSet(0);
        BitSetTest.assertTrue((String)("Test1: Wrong length, " + bs.size()), (bs.length() == 0 ? 1 : 0) != 0);
        bs.set(0);
        BitSetTest.assertTrue((String)("Test2: Wrong length" + bs.size()), (bs.length() == 1 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, boolean.class})
    public void test_setIZ() {
        this.eightbs.set(5, false);
        BitSetTest.assertTrue((String)"Should have set bit 5 to true", (!this.eightbs.get(5) ? 1 : 0) != 0);
        this.eightbs.set(5, true);
        BitSetTest.assertTrue((String)"Should have set bit 5 to false", (boolean)this.eightbs.get(5));
        try {
            this.eightbs.set(-5, false);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, int.class})
    public void test_setII() {
        int i;
        BitSet bs = new BitSet(16);
        bs.set(5);
        bs.set(15);
        bs.set(7, 11);
        for (i = 0; i < 7; ++i) {
            if (i == 5) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (boolean)bs.get(i));
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 7; i < 11; ++i) {
            BitSetTest.assertTrue((String)("Failed to set bit " + i), (boolean)bs.get(i));
        }
        for (i = 11; i < bs.size(); ++i) {
            if (i == 15) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (boolean)bs.get(i));
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(16);
        bs.set(7, 64);
        BitSetTest.assertEquals((String)"Failed to grow BitSet", (int)64, (int)bs.size());
        for (i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 7; i < 64; ++i) {
            BitSetTest.assertTrue((String)("Failed to set bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have set bit 64", (!bs.get(64) ? 1 : 0) != 0);
        bs = new BitSet(32);
        bs.set(0, 64);
        for (i = 0; i < 64; ++i) {
            BitSetTest.assertTrue((String)("Failed to set bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have set bit 64", (!bs.get(64) ? 1 : 0) != 0);
        bs = new BitSet(32);
        bs.set(0, 65);
        for (i = 0; i < 65; ++i) {
            BitSetTest.assertTrue((String)("Failed to set bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have set bit 65", (!bs.get(65) ? 1 : 0) != 0);
        bs = new BitSet(128);
        bs.set(7);
        bs.set(110);
        bs.set(9, 74);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (boolean)bs.get(i));
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 9; i < 74; ++i) {
            BitSetTest.assertTrue((String)("Failed to set bit " + i), (boolean)bs.get(i));
        }
        for (i = 74; i < bs.size(); ++i) {
            if (i == 110) {
                BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (boolean)bs.get(i));
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(256);
        bs.set(7);
        bs.set(255);
        bs.set(9, 219);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                BitSetTest.assertTrue((String)("Shouldn't have set flipped " + i), (boolean)bs.get(i));
                continue;
            }
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        for (i = 9; i < 219; ++i) {
            BitSetTest.assertTrue((String)("failed to set bit " + i), (boolean)bs.get(i));
        }
        for (i = 219; i < 255; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have set bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 255", (boolean)bs.get(255));
        bs = new BitSet(10);
        try {
            bs.set(-1, 3);
            BitSetTest.fail((String)"Test1: Attempt to flip with  negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs.set(2, -1);
            BitSetTest.fail((String)"Test2: Attempt to flip with negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs.set(4, 2);
            BitSetTest.fail((String)"Test4: Attempt to flip with illegal args failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, int.class, boolean.class})
    public void test_setIIZ() {
        this.eightbs.set(3, 6, false);
        BitSetTest.assertTrue((String)"Should have set bits 3, 4, and 5 to false", (!this.eightbs.get(3) && !this.eightbs.get(4) && !this.eightbs.get(5) ? 1 : 0) != 0);
        this.eightbs.set(3, 6, true);
        BitSetTest.assertTrue((String)"Should have set bits 3, 4, and 5 to true", (this.eightbs.get(3) && this.eightbs.get(4) && this.eightbs.get(5) ? 1 : 0) != 0);
        try {
            this.eightbs.set(-3, 6, false);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.eightbs.set(3, -6, false);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.eightbs.set(6, 3, false);
            BitSetTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="flip", args={int.class})
    public void test_flipI() {
        BitSet bs = new BitSet();
        bs.clear(8);
        bs.clear(9);
        bs.set(10);
        bs.flip(9);
        BitSetTest.assertTrue((String)"Failed to flip bit", (!bs.get(8) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit", (boolean)bs.get(9));
        BitSetTest.assertTrue((String)"Failed to flip bit", (boolean)bs.get(10));
        bs.set(8);
        bs.set(9);
        bs.clear(10);
        bs.flip(9);
        BitSetTest.assertTrue((String)"Failed to flip bit", (boolean)bs.get(8));
        BitSetTest.assertTrue((String)"Failed to flip bit", (!bs.get(9) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit", (!bs.get(10) ? 1 : 0) != 0);
        try {
            bs.flip(-1);
            BitSetTest.fail((String)"Attempt to flip at negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        bs.flip(128);
        BitSetTest.assertEquals((String)"Failed to grow BitSet", (int)192, (int)bs.size());
        BitSetTest.assertTrue((String)"Failed to flip bit", (boolean)bs.get(128));
        bs = new BitSet(64);
        int i = bs.size();
        while (--i >= 0) {
            bs.flip(i);
            BitSetTest.assertTrue((String)("Test1: Incorrectly flipped bit" + i), (boolean)bs.get(i));
            BitSetTest.assertTrue((String)"Incorrect length", (bs.length() == i + 1 ? 1 : 0) != 0);
            int j = bs.size();
            while (--j > i) {
                BitSetTest.assertTrue((String)("Test2: Incorrectly flipped bit" + j), (!bs.get(j) ? 1 : 0) != 0);
            }
            j = i;
            while (--j >= 0) {
                BitSetTest.assertTrue((String)("Test3: Incorrectly flipped bit" + j), (!bs.get(j) ? 1 : 0) != 0);
            }
            bs.flip(i);
        }
        BitSet bs0 = new BitSet(0);
        BitSetTest.assertEquals((String)"Test1: Wrong size", (int)0, (int)bs0.size());
        BitSetTest.assertEquals((String)"Test1: Wrong length", (int)0, (int)bs0.length());
        bs0.flip(0);
        BitSetTest.assertEquals((String)"Test2: Wrong size", (int)64, (int)bs0.size());
        BitSetTest.assertEquals((String)"Test2: Wrong length", (int)1, (int)bs0.length());
        bs0.flip(63);
        BitSetTest.assertEquals((String)"Test3: Wrong size", (int)64, (int)bs0.size());
        BitSetTest.assertEquals((String)"Test3: Wrong length", (int)64, (int)bs0.length());
        this.eightbs.flip(7);
        BitSetTest.assertTrue((String)"Failed to flip bit 7", (!this.eightbs.get(7) ? 1 : 0) != 0);
        for (int i2 = 0; i2 < 7; ++i2) {
            BitSetTest.assertTrue((String)"Flip flipped incorrect bits", (boolean)this.eightbs.get(i2));
        }
        this.eightbs.flip(127);
        BitSetTest.assertTrue((String)"Failed to flip bit 127", (boolean)this.eightbs.get(127));
        this.eightbs.flip(127);
        BitSetTest.assertTrue((String)"Failed to flip bit 127", (!this.eightbs.get(127) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="flip", args={int.class, int.class})
    public void test_flipII() {
        int i;
        BitSet bs = new BitSet(16);
        bs.set(7);
        bs.set(10);
        bs.flip(7, 11);
        for (i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertTrue((String)"Failed to flip bit 7", (!bs.get(7) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit 8", (boolean)bs.get(8));
        BitSetTest.assertTrue((String)"Failed to flip bit 9", (boolean)bs.get(9));
        BitSetTest.assertTrue((String)"Failed to flip bit 10", (!bs.get(10) ? 1 : 0) != 0);
        for (i = 11; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(16);
        bs.set(7);
        bs.set(10);
        bs.flip(7, 64);
        BitSetTest.assertEquals((String)"Failed to grow BitSet", (int)64, (int)bs.size());
        for (i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertTrue((String)"Failed to flip bit 7", (!bs.get(7) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit 8", (boolean)bs.get(8));
        BitSetTest.assertTrue((String)"Failed to flip bit 9", (boolean)bs.get(9));
        BitSetTest.assertTrue((String)"Failed to flip bit 10", (!bs.get(10) ? 1 : 0) != 0);
        for (i = 11; i < 64; ++i) {
            BitSetTest.assertTrue((String)("failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 64", (!bs.get(64) ? 1 : 0) != 0);
        bs = new BitSet(32);
        bs.flip(0, 64);
        for (i = 0; i < 64; ++i) {
            BitSetTest.assertTrue((String)("Failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 64", (!bs.get(64) ? 1 : 0) != 0);
        bs = new BitSet(32);
        bs.flip(0, 65);
        for (i = 0; i < 65; ++i) {
            BitSetTest.assertTrue((String)("Failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 65", (!bs.get(65) ? 1 : 0) != 0);
        bs = new BitSet(128);
        bs.set(7);
        bs.set(10);
        bs.set(72);
        bs.set(110);
        bs.flip(9, 74);
        for (i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 7", (boolean)bs.get(7));
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 8", (!bs.get(8) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit 9", (boolean)bs.get(9));
        BitSetTest.assertTrue((String)"Failed to flip bit 10", (!bs.get(10) ? 1 : 0) != 0);
        for (i = 11; i < 72; ++i) {
            BitSetTest.assertTrue((String)("failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Failed to flip bit 72", (!bs.get(72) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit 73", (boolean)bs.get(73));
        for (i = 74; i < 110; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 110", (boolean)bs.get(110));
        for (i = 111; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(256);
        bs.set(7);
        bs.set(10);
        bs.set(72);
        bs.set(110);
        bs.set(181);
        bs.set(220);
        bs.flip(9, 219);
        for (i = 0; i < 7; ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 7", (boolean)bs.get(7));
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 8", (!bs.get(8) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Failed to flip bit 9", (boolean)bs.get(9));
        BitSetTest.assertTrue((String)"Failed to flip bit 10", (!bs.get(10) ? 1 : 0) != 0);
        for (i = 11; i < 72; ++i) {
            BitSetTest.assertTrue((String)("failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Failed to flip bit 72", (!bs.get(72) ? 1 : 0) != 0);
        for (i = 73; i < 110; ++i) {
            BitSetTest.assertTrue((String)("failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Failed to flip bit 110", (!bs.get(110) ? 1 : 0) != 0);
        for (i = 111; i < 181; ++i) {
            BitSetTest.assertTrue((String)("failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Failed to flip bit 181", (!bs.get(181) ? 1 : 0) != 0);
        for (i = 182; i < 219; ++i) {
            BitSetTest.assertTrue((String)("failed to flip bit " + i), (boolean)bs.get(i));
        }
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 219", (!bs.get(219) ? 1 : 0) != 0);
        BitSetTest.assertTrue((String)"Shouldn't have flipped bit 220", (boolean)bs.get(220));
        for (i = 221; i < bs.size(); ++i) {
            BitSetTest.assertTrue((String)("Shouldn't have flipped bit " + i), (!bs.get(i) ? 1 : 0) != 0);
        }
        bs = new BitSet(10);
        try {
            bs.flip(-1, 3);
            BitSetTest.fail((String)"Test1: Attempt to flip with  negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs.flip(2, -1);
            BitSetTest.fail((String)"Test2: Attempt to flip with negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            bs.flip(4, 2);
            BitSetTest.fail((String)"Test4: Attempt to flip with illegal args failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="flip", args={int.class, int.class}), @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="get", args={int.class, int.class}), @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="set", args={int.class, int.class}), @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="clear", args={int.class, int.class})})
    public void test_111478() {
        try {
            this.eightbs.flip(0, 0);
            BitSetTest.assertTrue((String)"Bit got flipped incorrectly ", (boolean)this.eightbs.get(0));
            BitSet bsnew = this.eightbs.get(2, 2);
            BitSetTest.assertEquals((String)"BitSet retrieved incorrectly ", (int)0, (int)bsnew.cardinality());
            this.eightbs.set(10, 10);
            BitSetTest.assertTrue((String)"Bit got set incorrectly ", (!this.eightbs.get(10) ? 1 : 0) != 0);
            this.eightbs.clear(3, 3);
            BitSetTest.assertTrue((String)"Bit cleared incorrectly ", (boolean)this.eightbs.get(3));
        }
        catch (IndexOutOfBoundsException e) {
            BitSetTest.fail((String)"Unexpected IndexOutOfBoundsException when pos1 ==pos2");
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="intersects", args={BitSet.class})
    public void test_intersectsLjava_util_BitSet() {
        BitSet bs = new BitSet(500);
        bs.set(5);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(192);
        bs.set(450);
        BitSet bs2 = new BitSet(8);
        BitSetTest.assertFalse((String)"Test1: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertFalse((String)"Test1: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.set(4);
        BitSetTest.assertFalse((String)"Test2: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertFalse((String)"Test2: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(5);
        BitSetTest.assertTrue((String)"Test3: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertTrue((String)"Test3: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(63);
        BitSetTest.assertTrue((String)"Test4: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertTrue((String)"Test4: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(80);
        BitSetTest.assertTrue((String)"Test5: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertTrue((String)"Test5: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(127);
        BitSetTest.assertTrue((String)"Test6: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertTrue((String)"Test6: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(192);
        BitSetTest.assertTrue((String)"Test7: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertTrue((String)"Test7: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(450);
        BitSetTest.assertTrue((String)"Test8: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertTrue((String)"Test8: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
        bs2.clear();
        bs2.set(500);
        BitSetTest.assertFalse((String)"Test9: intersects() returned incorrect value", (boolean)bs.intersects(bs2));
        BitSetTest.assertFalse((String)"Test9: intersects() returned incorrect value", (boolean)bs2.intersects(bs));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="and", args={BitSet.class})
    public void test_andLjava_util_BitSet() {
        int i;
        BitSet bs = new BitSet(128);
        for (i = 64; i < 128; ++i) {
            bs.set(i);
        }
        this.eightbs.and(bs);
        BitSetTest.assertTrue((String)"AND failed to clear bits", (!this.eightbs.equals(bs) ? 1 : 0) != 0);
        this.eightbs.set(3);
        bs.set(3);
        this.eightbs.and(bs);
        BitSetTest.assertTrue((String)"AND failed to maintain set bits", (boolean)bs.get(3));
        bs.and(this.eightbs);
        for (i = 64; i < 128; ++i) {
            BitSetTest.assertTrue((String)"Failed to clear extra bits in the receiver BitSet", (!bs.get(i) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="andNot", args={BitSet.class})
    public void test_andNotLjava_util_BitSet() {
        BitSet bs = (BitSet)this.eightbs.clone();
        bs.clear(5);
        BitSet bs2 = new BitSet();
        bs2.set(2);
        bs2.set(3);
        bs.andNot(bs2);
        BitSetTest.assertEquals((String)"Incorrect bitset after andNot", (String)"{0, 1, 4, 6, 7}", (String)bs.toString());
        bs = new BitSet(0);
        bs.andNot(bs2);
        BitSetTest.assertEquals((String)"Incorrect size", (int)0, (int)bs.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="or", args={BitSet.class})
    public void test_orLjava_util_BitSet() {
        int i;
        BitSet bs = new BitSet(128);
        bs.or(this.eightbs);
        for (i = 0; i < 8; ++i) {
            BitSetTest.assertTrue((String)"OR failed to set bits", (boolean)bs.get(i));
        }
        bs = new BitSet(0);
        bs.or(this.eightbs);
        for (i = 0; i < 8; ++i) {
            BitSetTest.assertTrue((String)"OR(0) failed to set bits", (boolean)bs.get(i));
        }
        this.eightbs.clear(5);
        bs = new BitSet(128);
        bs.or(this.eightbs);
        BitSetTest.assertTrue((String)"OR set a bit which should be off", (!bs.get(5) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="xor", args={BitSet.class})
    public void test_xorLjava_util_BitSet() {
        int i;
        BitSet bs = (BitSet)this.eightbs.clone();
        bs.xor(this.eightbs);
        for (i = 0; i < 8; ++i) {
            BitSetTest.assertTrue((String)"XOR failed to clear bits", (!bs.get(i) ? 1 : 0) != 0);
        }
        bs.xor(this.eightbs);
        for (i = 0; i < 8; ++i) {
            BitSetTest.assertTrue((String)"XOR failed to set bits", (boolean)bs.get(i));
        }
        bs = new BitSet(0);
        bs.xor(this.eightbs);
        for (i = 0; i < 8; ++i) {
            BitSetTest.assertTrue((String)"XOR(0) failed to set bits", (boolean)bs.get(i));
        }
        bs = new BitSet();
        bs.set(63);
        BitSetTest.assertEquals((String)"Test highest bit", (String)"{63}", (String)bs.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        BitSetTest.assertEquals((String)"Returned incorrect size", (int)64, (int)this.eightbs.size());
        this.eightbs.set(129);
        BitSetTest.assertTrue((String)"Returned incorrect size", (this.eightbs.size() >= 129 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toString", args={})
    public void test_toString() {
        BitSetTest.assertEquals((String)"Returned incorrect string representation", (String)"{0, 1, 2, 3, 4, 5, 6, 7}", (String)this.eightbs.toString());
        this.eightbs.clear(2);
        BitSetTest.assertEquals((String)"Returned incorrect string representation", (String)"{0, 1, 3, 4, 5, 6, 7}", (String)this.eightbs.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="length", args={})
    public void test_length() {
        BitSet bs = new BitSet();
        BitSetTest.assertTrue((String)("BitSet returned wrong length--wanted 0, got: " + bs.length()), (bs.length() == 0 ? 1 : 0) != 0);
        bs.set(5);
        BitSetTest.assertTrue((String)("BitSet returned wrong length--wanted 6, got: " + bs.length()), (bs.length() == 6 ? 1 : 0) != 0);
        bs.set(10);
        BitSetTest.assertTrue((String)("BitSet returned wrong length--wanted 11, got: " + bs.length()), (bs.length() == 11 ? 1 : 0) != 0);
        bs.set(432);
        BitSetTest.assertTrue((String)("BitSet returned wrong length--wanted 433, got: " + bs.length()), (bs.length() == 433 ? 1 : 0) != 0);
        bs.set(300);
        BitSetTest.assertTrue((String)("BitSet returned wrong length--wanted 433 (again), got: " + bs.length()), (bs.length() == 433 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextSetBit", args={int.class})
    public void test_nextSetBitI() {
        BitSet bs = new BitSet(500);
        bs.set(5);
        bs.set(32);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(193);
        bs.set(450);
        try {
            bs.nextSetBit(-1);
            BitSetTest.fail((String)"Expected IndexOutOfBoundsException for negative index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)5, (int)bs.nextSetBit(0));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)5, (int)bs.nextSetBit(5));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)32, (int)bs.nextSetBit(6));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)32, (int)bs.nextSetBit(32));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)63, (int)bs.nextSetBit(33));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)63, (int)bs.nextSetBit(63));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)64, (int)bs.nextSetBit(64));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)71, (int)bs.nextSetBit(65));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)71, (int)bs.nextSetBit(71));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)72, (int)bs.nextSetBit(72));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)127, (int)bs.nextSetBit(110));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)127, (int)bs.nextSetBit(127));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)128, (int)bs.nextSetBit(128));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)193, (int)bs.nextSetBit(130));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)193, (int)bs.nextSetBit(191));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)193, (int)bs.nextSetBit(192));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)193, (int)bs.nextSetBit(193));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)450, (int)bs.nextSetBit(194));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)450, (int)bs.nextSetBit(255));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)450, (int)bs.nextSetBit(256));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)450, (int)bs.nextSetBit(450));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)-1, (int)bs.nextSetBit(451));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)-1, (int)bs.nextSetBit(511));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)-1, (int)bs.nextSetBit(512));
        BitSetTest.assertEquals((String)"nextSetBit() returned the wrong value", (int)-1, (int)bs.nextSetBit(800));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextClearBit", args={int.class})
    public void test_nextClearBitI() {
        BitSet bs = new BitSet(500);
        bs.set(0, bs.size() - 1);
        bs.set(bs.size() - 1);
        bs.clear(5);
        bs.clear(32);
        bs.clear(63);
        bs.clear(64);
        bs.clear(71, 110);
        bs.clear(127, 130);
        bs.clear(193);
        bs.clear(450);
        try {
            bs.nextClearBit(-1);
            BitSetTest.fail((String)"Expected IndexOutOfBoundsException for negative index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)5, (int)bs.nextClearBit(0));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)5, (int)bs.nextClearBit(5));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)32, (int)bs.nextClearBit(6));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)32, (int)bs.nextClearBit(32));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)63, (int)bs.nextClearBit(33));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)63, (int)bs.nextClearBit(63));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)64, (int)bs.nextClearBit(64));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)71, (int)bs.nextClearBit(65));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)71, (int)bs.nextClearBit(71));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)72, (int)bs.nextClearBit(72));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)127, (int)bs.nextClearBit(110));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)127, (int)bs.nextClearBit(127));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)128, (int)bs.nextClearBit(128));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)193, (int)bs.nextClearBit(130));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)193, (int)bs.nextClearBit(191));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)193, (int)bs.nextClearBit(192));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)193, (int)bs.nextClearBit(193));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)450, (int)bs.nextClearBit(194));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)450, (int)bs.nextClearBit(255));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)450, (int)bs.nextClearBit(256));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)450, (int)bs.nextClearBit(450));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)512, (int)bs.nextClearBit(451));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)512, (int)bs.nextClearBit(511));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)512, (int)bs.nextClearBit(512));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)513, (int)bs.nextClearBit(513));
        BitSetTest.assertEquals((String)"nextClearBit() returned the wrong value", (int)800, (int)bs.nextClearBit(800));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        BitSet bs = new BitSet(500);
        BitSetTest.assertTrue((String)"Test: isEmpty() returned wrong value", (boolean)bs.isEmpty());
        bs.set(3);
        BitSetTest.assertFalse((String)"Test0: isEmpty() returned wrong value", (boolean)bs.isEmpty());
        bs.clear();
        bs.set(12);
        BitSetTest.assertFalse((String)"Test1: isEmpty() returned wrong value", (boolean)bs.isEmpty());
        bs.clear();
        bs.set(128);
        BitSetTest.assertFalse((String)"Test2: isEmpty() returned wrong value", (boolean)bs.isEmpty());
        bs.clear();
        bs.set(459);
        BitSetTest.assertFalse((String)"Test3: isEmpty() returned wrong value", (boolean)bs.isEmpty());
        bs.clear();
        bs.set(511);
        BitSetTest.assertFalse((String)"Test4: isEmpty() returned wrong value", (boolean)bs.isEmpty());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="cardinality", args={})
    public void test_cardinality() {
        BitSet bs = new BitSet(500);
        bs.set(5);
        bs.set(32);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(193);
        bs.set(450);
        BitSetTest.assertEquals((String)"cardinality() returned wrong value", (int)48, (int)bs.cardinality());
        bs.flip(0, 500);
        BitSetTest.assertEquals((String)"cardinality() returned wrong value", (int)452, (int)bs.cardinality());
        bs.clear();
        BitSetTest.assertEquals((String)"cardinality() returned wrong value", (int)0, (int)bs.cardinality());
        bs.set(0, 500);
        BitSetTest.assertEquals((String)"cardinality() returned wrong value", (int)500, (int)bs.cardinality());
    }

    private static void printBitset(BitSet bs) {
        System.out.println();
        for (int i = bs.size() - 1; i >= 0; --i) {
            if (bs.get(i)) {
                System.out.print(1);
                continue;
            }
            System.out.print(0);
        }
    }

    protected void setUp() {
        this.eightbs = new BitSet();
        for (int i = 0; i < 8; ++i) {
            this.eightbs.set(i);
        }
    }

    protected void tearDown() {
    }
}

