/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import tests.support.Support_UnmodifiableCollectionTest;

@TestTargetClass(value=Arrays.class)
public class ArraysTest
extends TestCase {
    static final int arraySize = 100;
    Object[] objArray;
    boolean[] booleanArray;
    byte[] byteArray;
    char[] charArray;
    double[] doubleArray;
    float[] floatArray;
    int[] intArray;
    long[] longArray;
    Object[] objectArray;
    short[] shortArray;
    private static final int[] LENGTHS = new int[]{0, 1, 2, 3, 5, 8, 13, 21, 34, 55, 100, 1000, 10000};

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="asList", args={Object[].class})
    public void test_asList$Ljava_lang_Object() {
        List<Object> convertedList = Arrays.asList(this.objectArray);
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array and List converted from array do not contain identical elements", (convertedList.get(counter) == this.objectArray[counter] ? 1 : 0) != 0);
        }
        convertedList.set(50, new Integer(1000));
        ArraysTest.assertTrue((String)"set/get did not work on coverted list", (boolean)convertedList.get(50).equals(new Integer(1000)));
        convertedList.set(50, new Integer(50));
        new Support_UnmodifiableCollectionTest("", convertedList).runTest();
        Object[] myArray = (Object[])this.objectArray.clone();
        myArray[30] = null;
        myArray[60] = null;
        convertedList = Arrays.asList(myArray);
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array and List converted from array do not contain identical elements", (convertedList.get(counter) == myArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.asList(null);
            ArraysTest.fail((String)"asList with null arg didn't throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={byte[].class, byte.class})
    public void test_binarySearch$BB() {
        int counter;
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on byte[] answered incorrect position", (Arrays.binarySearch(this.byteArray, (byte)counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.intArray, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.intArray, 100) == -101 ? 1 : 0) != 0);
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            int n = counter;
            this.byteArray[n] = (byte)(this.byteArray[n] - 50);
        }
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on byte[] involving negative numbers answered incorrect position", (Arrays.binarySearch(this.byteArray, (byte)(counter - 50)) == counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={char[].class, char.class})
    public void test_binarySearch$CC() {
        for (int counter = 0; counter < 100; counter = (int)((char)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on char[] answered incorrect position", (Arrays.binarySearch(this.charArray, (char)(counter + 1)) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.charArray, '\u0000'));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.charArray, 'e') == -101 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={double[].class, double.class})
    public void test_binarySearch$DD() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on double[] answered incorrect position", ((double)Arrays.binarySearch(this.doubleArray, (double)counter) == (double)counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.doubleArray, -1.0));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.doubleArray, 100.0) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            this.doubleArray[n] = this.doubleArray[n] - 50.0;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on double[] involving negative numbers answered incorrect position", ((double)Arrays.binarySearch(this.doubleArray, (double)(counter - 50)) == (double)counter ? 1 : 0) != 0);
        }
        double[] specials = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -2.0, -4.9E-324, -0.0, 0.0, Double.MIN_VALUE, 2.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};
        for (int i = 0; i < specials.length; ++i) {
            int result = Arrays.binarySearch(specials, specials[i]);
            ArraysTest.assertTrue((String)(specials[i] + " invalid: " + result), (result == i ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"-1d", (int)-4, (int)Arrays.binarySearch(specials, -1.0));
        ArraysTest.assertEquals((String)"1d", (int)-8, (int)Arrays.binarySearch(specials, 1.0));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={float[].class, float.class})
    public void test_binarySearch$FF() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on float[] answered incorrect position", ((float)Arrays.binarySearch(this.floatArray, (float)counter) == (float)counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.floatArray, -1.0f));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.floatArray, 100.0f) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            this.floatArray[n] = this.floatArray[n] - 50.0f;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on float[] involving negative numbers answered incorrect position", ((float)Arrays.binarySearch(this.floatArray, (float)counter - 50.0f) == (float)counter ? 1 : 0) != 0);
        }
        float[] specials = new float[]{Float.NEGATIVE_INFINITY, -3.4028235E38f, -2.0f, -1.4E-45f, -0.0f, 0.0f, Float.MIN_VALUE, 2.0f, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NaN};
        for (int i = 0; i < specials.length; ++i) {
            int result = Arrays.binarySearch(specials, specials[i]);
            ArraysTest.assertTrue((String)(specials[i] + " invalid: " + result), (result == i ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"-1f", (int)-4, (int)Arrays.binarySearch(specials, -1.0f));
        ArraysTest.assertEquals((String)"1f", (int)-8, (int)Arrays.binarySearch(specials, 1.0f));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={int[].class, int.class})
    public void test_binarySearch$II() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on int[] answered incorrect position", (Arrays.binarySearch(this.intArray, counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.intArray, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.intArray, 100) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            this.intArray[n] = this.intArray[n] - 50;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on int[] involving negative numbers answered incorrect position", (Arrays.binarySearch(this.intArray, counter - 50) == counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={long[].class, long.class})
    public void test_binarySearch$JJ() {
        long counter;
        for (counter = 0L; counter < 100L; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on long[] answered incorrect position", ((long)Arrays.binarySearch(this.longArray, counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.longArray, -1L));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.longArray, 100L) == -101 ? 1 : 0) != 0);
        for (counter = 0L; counter < 100L; ++counter) {
            int n = (int)counter;
            this.longArray[n] = this.longArray[n] - 50L;
        }
        for (counter = 0L; counter < 100L; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on long[] involving negative numbers answered incorrect position", ((long)Arrays.binarySearch(this.longArray, counter - 50L) == counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={Object[].class, Object.class})
    public void test_binarySearch$Ljava_lang_ObjectLjava_lang_Object() {
        Object[] sArray;
        ArraysTest.assertEquals((String)"Binary search succeeded for non-comparable value in empty array", (int)-1, (int)Arrays.binarySearch(new Object[0], new Object()));
        ArraysTest.assertEquals((String)"Binary search succeeded for comparable value in empty array", (int)-1, (int)Arrays.binarySearch(new Object[0], new Integer(-1)));
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on Object[] answered incorrect position", (Arrays.binarySearch(this.objectArray, this.objArray[counter]) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.objectArray, new Integer(-1)));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.objectArray, new Integer(100)) == -101 ? 1 : 0) != 0);
        Object[] oArray = sArray = new String[]{"1", "2", "3", "4", ""};
        try {
            Arrays.binarySearch(oArray, new Integer(10));
            ArraysTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify ClassCastException.", method="binarySearch", args={Object[].class, Object.class, Comparator.class})
    public void test_binarySearch$Ljava_lang_ObjectLjava_lang_ObjectLjava_util_Comparator() {
        int counter;
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        for (counter = 0; counter < 100; ++counter) {
            this.objectArray[counter] = this.objArray[100 - counter - 1];
        }
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 1", (Arrays.binarySearch(this.objectArray, new Integer(-1), comp) == -101 ? 1 : 0) != 0);
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 2", (int)-1, (int)Arrays.binarySearch(this.objectArray, new Integer(100), comp));
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on Object[] with custom comparator answered incorrect position", (Arrays.binarySearch(this.objectArray, this.objArray[counter], comp) == 100 - counter - 1 ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={short[].class, short.class})
    public void test_binarySearch$SS() {
        int counter;
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on short[] answered incorrect position", (Arrays.binarySearch(this.shortArray, (short)counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(this.intArray, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(this.intArray, 100) == -101 ? 1 : 0) != 0);
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            int n = counter;
            this.shortArray[n] = (short)(this.shortArray[n] - 50);
        }
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on short[] involving negative numbers answered incorrect position", (Arrays.binarySearch(this.shortArray, (short)(counter - 50)) == counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={byte[].class, byte.class})
    public void test_fill$BB() {
        byte[] d = new byte[1000];
        Arrays.fill(d, (byte)127);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill byte array correctly", (d[i] == 127 ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={byte[].class, int.class, int.class, byte.class})
    public void test_fill$BIIB() {
        int result;
        int i;
        byte val = 127;
        byte[] d = new byte[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill byte array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(new byte[2], 2, 1, (byte)27);
            result = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = 1;
        }
        catch (IllegalArgumentException e) {
            result = 2;
        }
        ArraysTest.assertEquals((String)"Wrong exception1", (int)2, (int)result);
        try {
            Arrays.fill(new byte[2], -1, 1, (byte)27);
            result = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = 1;
        }
        catch (IllegalArgumentException e) {
            result = 2;
        }
        ArraysTest.assertEquals((String)"Wrong exception2", (int)1, (int)result);
        try {
            Arrays.fill(new byte[2], 1, 4, (byte)27);
            result = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = 1;
        }
        catch (IllegalArgumentException e) {
            result = 2;
        }
        ArraysTest.assertEquals((String)"Wrong exception", (int)1, (int)result);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={short[].class, short.class})
    public void test_fill$SS() {
        short[] d = new short[1000];
        Arrays.fill(d, (short)Short.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill short array correctly", (d[i] == Short.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={short[].class, int.class, int.class, short.class})
    public void test_fill$SIIS() {
        int i;
        short val = Short.MAX_VALUE;
        short[] d = new short[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill short array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={char[].class, char.class})
    public void test_fill$CC() {
        char[] d = new char[1000];
        Arrays.fill(d, 'V');
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertEquals((String)"Failed to fill char array correctly", (char)'V', (char)d[i]);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={char[].class, int.class, int.class, char.class})
    public void test_fill$CIIC() {
        int i;
        char val = 'T';
        char[] d = new char[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill char array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={int[].class, int.class})
    public void test_fill$II() {
        int[] d = new int[1000];
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill int array correctly", (d[i] == Integer.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={int[].class, int.class, int.class, int.class})
    public void test_fill$IIII() {
        int i;
        int val = Integer.MAX_VALUE;
        int[] d = new int[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill int array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={long[].class, long.class})
    public void test_fill$JJ() {
        long[] d = new long[1000];
        Arrays.fill(d, Long.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill long array correctly", (d[i] == Long.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={long[].class, int.class, int.class, long.class})
    public void test_fill$JIIJ() {
        int i;
        long[] d = new long[1000];
        Arrays.fill(d, 400, d.length, Long.MAX_VALUE);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != Long.MAX_VALUE ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill long array correctly", (d[i] == Long.MAX_VALUE ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, Long.MIN_VALUE);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, Long.MAX_VALUE);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, Long.MAX_VALUE);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={float[].class, float.class})
    public void test_fill$FF() {
        float[] d = new float[1000];
        Arrays.fill(d, Float.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill float array correctly", (d[i] == Float.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={float[].class, int.class, int.class, float.class})
    public void test_fill$FIIF() {
        int i;
        float val = Float.MAX_VALUE;
        float[] d = new float[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill float array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={double[].class, double.class})
    public void test_fill$DD() {
        double[] d = new double[1000];
        Arrays.fill(d, Double.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill double array correctly", (d[i] == Double.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={double[].class, int.class, int.class, double.class})
    public void test_fill$DIID() {
        int i;
        double val = Double.MAX_VALUE;
        double[] d = new double[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill double array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={boolean[].class, boolean.class})
    public void test_fill$ZZ() {
        boolean[] d = new boolean[1000];
        Arrays.fill(d, true);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill boolean array correctly", (boolean)d[i]);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={boolean[].class, int.class, int.class, boolean.class})
    public void test_fill$ZIIZ() {
        int i;
        boolean val = true;
        boolean[] d = new boolean[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill boolean array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={Object[].class, Object.class})
    public void test_fill$Ljava_lang_ObjectLjava_lang_Object() {
        Object val = new Object();
        Object[] d = new Object[1000];
        Arrays.fill(d, 0, d.length, val);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill Object array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="fill", args={Object[].class, int.class, int.class, Object.class})
    public void test_fill$Ljava_lang_ObjectIILjava_lang_Object() {
        int i;
        Object val = new Object();
        Object[] d = new Object[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill Object array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        Arrays.fill(d, 400, d.length, null);
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertNull((String)"Failed to fill Object array correctly with nulls", (Object)d[i]);
        }
        try {
            Arrays.fill(d, 10, 0, val);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, -10, 0, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.fill(d, 10, d.length + 1, val);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={byte[].class, byte[].class})
    public void test_equals$B$B() {
        byte[] d = new byte[1000];
        byte[] x = new byte[1000];
        Arrays.fill(d, (byte)127);
        Arrays.fill(x, (byte)-128);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, (byte)127);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={short[].class, short[].class})
    public void test_equals$S$S() {
        short[] d = new short[1000];
        short[] x = new short[1000];
        Arrays.fill(d, (short)Short.MAX_VALUE);
        Arrays.fill(x, (short)Short.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, (short)Short.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={char[].class, char[].class})
    public void test_equals$C$C() {
        char[] d = new char[1000];
        char[] x = new char[1000];
        char c = 'T';
        Arrays.fill(d, c);
        Arrays.fill(x, 'L');
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, c);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={int[].class, int[].class})
    public void test_equals$I$I() {
        int[] d = new int[1000];
        int[] x = new int[1000];
        Arrays.fill(d, Integer.MAX_VALUE);
        Arrays.fill(x, Integer.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Integer.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"wrong result for null array1", (!Arrays.equals(new int[2], null) ? 1 : 0) != 0);
        ArraysTest.assertTrue((String)"wrong result for null array2", (!Arrays.equals(null, new int[2]) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={long[].class, long[].class})
    public void test_equals$J$J() {
        long[] d = new long[1000];
        long[] x = new long[1000];
        Arrays.fill(d, Long.MAX_VALUE);
        Arrays.fill(x, Long.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Long.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"should be false", (!Arrays.equals(new long[]{0x100000000L}, new long[]{0x200000000L}) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={float[].class, float[].class})
    public void test_equals$F$F() {
        float[] d = new float[1000];
        float[] x = new float[1000];
        Arrays.fill(d, Float.MAX_VALUE);
        Arrays.fill(x, Float.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Float.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"NaN not equals", (boolean)Arrays.equals(new float[]{Float.NaN}, new float[]{Float.NaN}));
        ArraysTest.assertTrue((String)"0f equals -0f", (!Arrays.equals(new float[]{0.0f}, new float[]{-0.0f}) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={double[].class, double[].class})
    public void test_equals$D$D() {
        double[] d = new double[1000];
        double[] x = new double[1000];
        Arrays.fill(d, Double.MAX_VALUE);
        Arrays.fill(x, Double.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Double.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"should be false", (!Arrays.equals(new double[]{1.0}, new double[]{2.0}) ? 1 : 0) != 0);
        ArraysTest.assertTrue((String)"NaN not equals", (boolean)Arrays.equals(new double[]{Double.NaN}, new double[]{Double.NaN}));
        ArraysTest.assertTrue((String)"0d equals -0d", (!Arrays.equals(new double[]{0.0}, new double[]{-0.0}) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={boolean[].class, boolean[].class})
    public void test_equals$Z$Z() {
        boolean[] d = new boolean[1000];
        boolean[] x = new boolean[1000];
        Arrays.fill(d, true);
        Arrays.fill(x, false);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, true);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object[].class, Object[].class})
    public void test_equals$Ljava_lang_Object$Ljava_lang_Object() {
        Object[] d = new Object[1000];
        Object[] x = new Object[1000];
        Object o = new Object();
        Arrays.fill(d, o);
        Arrays.fill(x, new Object());
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, o);
        d[50] = null;
        x[50] = null;
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={byte[].class})
    public void test_sort$B() {
        int counter;
        byte[] reversedArray = new byte[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (byte)(100 - counter - 1);
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (byte)counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={byte[].class, int.class, int.class})
    public void test_sort$BII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        byte[] reversedArray = new byte[100];
        byte[] originalReversedArray = new byte[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (byte)(100 - counter - 1);
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new byte[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={char[].class})
    public void test_sort$C() {
        int counter;
        char[] reversedArray = new char[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (char)(100 - counter - 1);
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (char)counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={char[].class, int.class, int.class})
    public void test_sort$CII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        char[] reversedArray = new char[100];
        char[] originalReversedArray = new char[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (char)(100 - counter - 1);
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new char[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={double[].class})
    public void test_sort$D() {
        int counter;
        double[] reversedArray = new double[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (double)counter ? 1 : 0) != 0);
        }
        double[] specials1 = new double[]{Double.NaN, Double.MAX_VALUE, Double.MIN_VALUE, 0.0, -0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] specials2 = new double[]{0.0, Double.POSITIVE_INFINITY, -0.0, Double.NEGATIVE_INFINITY, Double.MIN_VALUE, Double.NaN, Double.MAX_VALUE};
        double[] answer = new double[]{Double.NEGATIVE_INFINITY, -0.0, 0.0, Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};
        Arrays.sort(specials1);
        Object[] print1 = new Object[specials1.length];
        for (int i = 0; i < specials1.length; ++i) {
            print1[i] = new Double(specials1[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 1: " + Arrays.asList(print1)), (boolean)Arrays.equals(specials1, answer));
        Arrays.sort(specials2);
        Object[] print2 = new Object[specials2.length];
        for (int i = 0; i < specials2.length; ++i) {
            print2[i] = new Double(specials2[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 2: " + Arrays.asList(print2)), (boolean)Arrays.equals(specials2, answer));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={double[].class, int.class, int.class})
    public void test_sort$DII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        double[] reversedArray = new double[100];
        double[] originalReversedArray = new double[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new double[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={float[].class})
    public void test_sort$F() {
        int counter;
        float[] reversedArray = new float[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (float)counter ? 1 : 0) != 0);
        }
        float[] specials1 = new float[]{Float.NaN, Float.MAX_VALUE, Float.MIN_VALUE, 0.0f, -0.0f, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        float[] specials2 = new float[]{0.0f, Float.POSITIVE_INFINITY, -0.0f, Float.NEGATIVE_INFINITY, Float.MIN_VALUE, Float.NaN, Float.MAX_VALUE};
        float[] answer = new float[]{Float.NEGATIVE_INFINITY, -0.0f, 0.0f, Float.MIN_VALUE, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NaN};
        Arrays.sort(specials1);
        Object[] print1 = new Object[specials1.length];
        for (int i = 0; i < specials1.length; ++i) {
            print1[i] = new Float(specials1[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 1: " + Arrays.asList(print1)), (boolean)Arrays.equals(specials1, answer));
        Arrays.sort(specials2);
        Object[] print2 = new Object[specials2.length];
        for (int i = 0; i < specials2.length; ++i) {
            print2[i] = new Float(specials2[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 2: " + Arrays.asList(print2)), (boolean)Arrays.equals(specials2, answer));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={float[].class, int.class, int.class})
    public void test_sort$FII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        float[] reversedArray = new float[100];
        float[] originalReversedArray = new float[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new float[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={int[].class})
    public void test_sort$I() {
        int counter;
        int[] reversedArray = new int[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={int[].class, int.class, int.class})
    public void test_sort$III() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        int[] reversedArray = new int[100];
        int[] originalReversedArray = new int[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new int[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={long[].class})
    public void test_sort$J() {
        int counter;
        long[] reversedArray = new long[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (long)counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={long[].class, int.class, int.class})
    public void test_sort$JII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        long[] reversedArray = new long[100];
        long[] originalReversedArray = new long[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new long[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={Object[].class})
    public void test_sort$Ljava_lang_Object() {
        int counter;
        Object[] reversedArray = new Object[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = this.objectArray[100 - counter - 1];
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == this.objectArray[counter] ? 1 : 0) != 0);
        }
        Arrays.fill(reversedArray, 0, reversedArray.length / 2, "String");
        Arrays.fill(reversedArray, reversedArray.length / 2, reversedArray.length, new Integer(1));
        try {
            Arrays.sort(reversedArray);
            ArraysTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={Object[].class, int.class, int.class})
    public void test_sort$Ljava_lang_ObjectII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        Object[] reversedArray = new Object[100];
        Object[] originalReversedArray = new Object[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = this.objectArray[100 - counter - 1];
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (((Comparable)reversedArray[counter]).compareTo(reversedArray[counter + 1]) <= 0 ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new Object[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        Arrays.fill(reversedArray, 0, reversedArray.length / 2, "String");
        Arrays.fill(reversedArray, reversedArray.length / 2, reversedArray.length, new Integer(1));
        try {
            Arrays.sort(reversedArray, reversedArray.length / 4, 3 * reversedArray.length / 4);
            ArraysTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        Arrays.sort(reversedArray, 0, reversedArray.length / 4);
        Arrays.sort(reversedArray, 3 * reversedArray.length / 4, reversedArray.length);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={Object[].class, int.class, int.class, Comparator.class})
    public void test_sort$Ljava_lang_ObjectIILjava_util_Comparator() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        Object[] originalArray = new Object[100];
        for (counter = 0; counter < 100; ++counter) {
            originalArray[counter] = this.objectArray[counter];
        }
        Arrays.sort(this.objectArray, startIndex, endIndex, comp);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (this.objectArray[counter] == originalArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (comp.compare(this.objectArray[counter], this.objectArray[counter + 1]) <= 0 ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (this.objectArray[counter] == originalArray[counter] ? 1 : 0) != 0);
        }
        Arrays.fill(originalArray, 0, originalArray.length / 2, "String");
        Arrays.fill(originalArray, originalArray.length / 2, originalArray.length, new Integer(1));
        try {
            Arrays.sort(originalArray, startIndex, endIndex, comp);
            ArraysTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        Arrays.sort(originalArray, endIndex, originalArray.length, comp);
        try {
            Arrays.sort(originalArray, endIndex, originalArray.length + 1, comp);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.sort(originalArray, -1, startIndex, comp);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.sort(originalArray, originalArray.length, endIndex, comp);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={Object[].class, Comparator.class})
    public void test_sort$Ljava_lang_ObjectLjava_util_Comparator() {
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        Arrays.sort(this.objectArray, comp);
        for (int counter = 0; counter < 99; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted correctly with custom comparator", (comp.compare(this.objectArray[counter], this.objectArray[counter + 1]) <= 0 ? 1 : 0) != 0);
        }
        Arrays.fill(this.objectArray, 0, this.objectArray.length / 2, "String");
        Arrays.fill(this.objectArray, this.objectArray.length / 2, this.objectArray.length, new Integer(1));
        try {
            Arrays.sort(this.objectArray, comp);
            ArraysTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={short[].class})
    public void test_sort$S() {
        int counter;
        short[] reversedArray = new short[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (short)(100 - counter - 1);
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (short)counter ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="sort", args={short[].class, int.class, int.class})
    public void test_sort$SII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        short[] reversedArray = new short[100];
        short[] originalReversedArray = new short[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (short)(100 - counter - 1);
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new short[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={byte[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_byte_array_NPE() {
        byte[] byte_array_null = null;
        try {
            Arrays.sort(byte_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(byte_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={char[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_char_array_NPE() {
        char[] char_array_null = null;
        try {
            Arrays.sort(char_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(char_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={double[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_double_array_NPE() {
        double[] double_array_null = null;
        try {
            Arrays.sort(double_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(double_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={float[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_float_array_NPE() {
        float[] float_array_null = null;
        try {
            Arrays.sort(float_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(float_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={int[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_int_array_NPE() {
        int[] int_array_null = null;
        try {
            Arrays.sort(int_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(int_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={Object[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_object_array_NPE() {
        T[] object_array_null = null;
        try {
            Arrays.sort(object_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(object_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(object_array_null, -1, 1, null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={long[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_long_array_NPE() {
        long[] long_array_null = null;
        try {
            Arrays.sort(long_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(long_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="sort", args={short[].class, int.class, int.class})
    public void test_java_util_Arrays_sort_short_array_NPE() {
        short[] short_array_null = null;
        try {
            Arrays.sort(short_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(short_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Agressive test of the sort methods for *all* primitive array types", method="sort")
    public void test_sort() {
        for (int len : LENGTHS) {
            PrimitiveTypeArrayBuilder.reset();
            int[] golden = new int[len];
            for (int m = 1; m < 2 * len; m *= 2) {
                for (PrimitiveTypeArrayBuilder builder : PrimitiveTypeArrayBuilder.values()) {
                    builder.build(golden, m);
                    int[] test = (int[])golden.clone();
                    for (PrimitiveTypeConverter converter : PrimitiveTypeConverter.values()) {
                        Object convertedGolden = converter.convert(golden);
                        Object convertedTest = converter.convert(test);
                        this.sort(convertedTest);
                        this.checkSorted(convertedTest);
                        ArraysTest.assertEquals((int)this.checkSum(convertedGolden), (int)this.checkSum(convertedTest));
                    }
                }
            }
        }
    }

    private void sort(Object array) {
        if (array instanceof int[]) {
            Arrays.sort((int[])array);
        } else if (array instanceof long[]) {
            Arrays.sort((long[])array);
        } else if (array instanceof short[]) {
            Arrays.sort((short[])array);
        } else if (array instanceof byte[]) {
            Arrays.sort((byte[])array);
        } else if (array instanceof char[]) {
            Arrays.sort((char[])array);
        } else if (array instanceof float[]) {
            Arrays.sort((float[])array);
        } else if (array instanceof double[]) {
            Arrays.sort((double[])array);
        } else {
            ArraysTest.fail((String)("Unknow type of array: " + array.getClass()));
        }
    }

    private void checkSorted(Object array) {
        if (array instanceof int[]) {
            this.checkSorted((int[])array);
        } else if (array instanceof long[]) {
            this.checkSorted((long[])array);
        } else if (array instanceof short[]) {
            this.checkSorted((short[])array);
        } else if (array instanceof byte[]) {
            this.checkSorted((byte[])array);
        } else if (array instanceof char[]) {
            this.checkSorted((char[])array);
        } else if (array instanceof float[]) {
            this.checkSorted((float[])array);
        } else if (array instanceof double[]) {
            this.checkSorted((double[])array);
        } else {
            ArraysTest.fail((String)("Unknow type of array: " + array.getClass()));
        }
    }

    private void checkSorted(int[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i] <= a[i + 1]) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void checkSorted(long[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i] <= a[i + 1]) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void checkSorted(short[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i] <= a[i + 1]) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void checkSorted(byte[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i] <= a[i + 1]) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void checkSorted(char[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i] <= a[i + 1]) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void checkSorted(float[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (!(a[i] > a[i + 1])) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void checkSorted(double[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (!(a[i] > a[i + 1])) continue;
            this.orderFail(i, "" + a[i], "" + a[i + 1]);
        }
    }

    private void orderFail(int index, String value1, String value2) {
        ArraysTest.fail((String)("Array is not sorted at " + index + "-th position: " + value1 + " and " + value2));
    }

    private int checkSum(Object array) {
        if (array instanceof int[]) {
            return this.checkSum((int[])array);
        }
        if (array instanceof long[]) {
            return this.checkSum((long[])array);
        }
        if (array instanceof short[]) {
            return this.checkSum((short[])array);
        }
        if (array instanceof byte[]) {
            return this.checkSum((byte[])array);
        }
        if (array instanceof char[]) {
            return this.checkSum((char[])array);
        }
        if (array instanceof float[]) {
            return this.checkSum((float[])array);
        }
        if (array instanceof double[]) {
            return this.checkSum((double[])array);
        }
        ArraysTest.fail((String)("Unknow type of array: " + array.getClass()));
        throw new AssertionError();
    }

    private int checkSum(int[] a) {
        int checkSum = 0;
        for (int e : a) {
            checkSum ^= e;
        }
        return checkSum;
    }

    private int checkSum(long[] a) {
        long checkSum = 0L;
        for (long e : a) {
            checkSum ^= e;
        }
        return (int)checkSum;
    }

    private int checkSum(short[] a) {
        int checkSum = 0;
        for (short e : a) {
            checkSum = (short)(checkSum ^ e);
        }
        return checkSum;
    }

    private int checkSum(byte[] a) {
        int checkSum = 0;
        for (byte e : a) {
            checkSum = (byte)(checkSum ^ e);
        }
        return checkSum;
    }

    private int checkSum(char[] a) {
        int checkSum = 0;
        for (char e : a) {
            checkSum = (char)(checkSum ^ e);
        }
        return checkSum;
    }

    private int checkSum(float[] a) {
        int checkSum = 0;
        for (float e : a) {
            checkSum ^= (int)e;
        }
        return checkSum;
    }

    private int checkSum(double[] a) {
        int checkSum = 0;
        for (double e : a) {
            checkSum ^= (int)e;
        }
        return checkSum;
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="deepEquals", args={Object[].class, Object[].class})
    public void test_deepEquals$Ljava_lang_ObjectLjava_lang_Object() {
        int[] a1 = new int[]{1, 2, 3};
        short[] a2 = new short[]{0, 1};
        Object[] a3 = new Object[]{new Integer(1), a2};
        int[] a4 = new int[]{6, 5, 4};
        int[] b1 = new int[]{1, 2, 3};
        short[] b2 = new short[]{0, 1};
        Object[] b3 = new Object[]{new Integer(1), b2};
        Object[] a = new Object[]{a1, a2, a3};
        Object[] b = new Object[]{b1, b2, b3};
        ArraysTest.assertFalse((boolean)Arrays.equals(a, b));
        ArraysTest.assertTrue((boolean)Arrays.deepEquals(a, b));
        a[2] = a4;
        ArraysTest.assertFalse((boolean)Arrays.deepEquals(a, b));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="deepHashCode", args={Object[].class})
    public void test_deepHashCode$Ljava_lang_Object() {
        int[] a1 = new int[]{1, 2, 3};
        short[] a2 = new short[]{0, 1};
        Object[] a3 = new Object[]{new Integer(1), a2};
        int[] b1 = new int[]{1, 2, 3};
        short[] b2 = new short[]{0, 1};
        Object[] b3 = new Object[]{new Integer(1), b2};
        Object[] a = new Object[]{a1, a2, a3};
        Object[] b = new Object[]{b1, b2, b3};
        int deep_hash_a = Arrays.deepHashCode(a);
        int deep_hash_b = Arrays.deepHashCode(b);
        ArraysTest.assertEquals((int)deep_hash_a, (int)deep_hash_b);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={boolean[].class})
    public void test_hashCode$LZ() {
        boolean[] boolArr = new boolean[]{true, false, false, true, false};
        LinkedList<Boolean> listOfBoolean = new LinkedList<Boolean>();
        for (int i = 0; i < boolArr.length; ++i) {
            listOfBoolean.add(new Boolean(boolArr[i]));
        }
        int listHashCode = ((Object)listOfBoolean).hashCode();
        int arrayHashCode = Arrays.hashCode(boolArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={int[].class})
    public void test_hashCode$LI() {
        int[] intArr = new int[]{10, 5, 134, 7, 19};
        LinkedList<Integer> listOfInteger = new LinkedList<Integer>();
        for (int i = 0; i < intArr.length; ++i) {
            listOfInteger.add(new Integer(intArr[i]));
        }
        int listHashCode = ((Object)listOfInteger).hashCode();
        int arrayHashCode = Arrays.hashCode(intArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
        int[] intArr2 = new int[]{10, 5, 134, 7, 19};
        ArraysTest.assertEquals((int)Arrays.hashCode(intArr2), (int)Arrays.hashCode(intArr));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={char[].class})
    public void test_hashCode$LC() {
        char[] charArr = new char[]{'a', 'g', 'x', 'c', 'm'};
        LinkedList<Character> listOfCharacter = new LinkedList<Character>();
        for (int i = 0; i < charArr.length; ++i) {
            listOfCharacter.add(new Character(charArr[i]));
        }
        int listHashCode = ((Object)listOfCharacter).hashCode();
        int arrayHashCode = Arrays.hashCode(charArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={byte[].class})
    public void test_hashCode$LB() {
        byte[] byteArr = new byte[]{5, 9, 7, 6, 17};
        LinkedList<Byte> listOfByte = new LinkedList<Byte>();
        for (int i = 0; i < byteArr.length; ++i) {
            listOfByte.add(new Byte(byteArr[i]));
        }
        int listHashCode = ((Object)listOfByte).hashCode();
        int arrayHashCode = Arrays.hashCode(byteArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={long[].class})
    public void test_hashCode$LJ() {
        long[] longArr = new long[]{67890234512L, 97587236923425L, 257421912912L, 6754268100L, 5L};
        LinkedList<Long> listOfLong = new LinkedList<Long>();
        for (int i = 0; i < longArr.length; ++i) {
            listOfLong.add(new Long(longArr[i]));
        }
        int listHashCode = ((Object)listOfLong).hashCode();
        int arrayHashCode = Arrays.hashCode(longArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={float[].class})
    public void test_hashCode$LF() {
        float[] floatArr = new float[]{0.13497f, 0.268934f, 1.2E-4f, -300.0f, 0.001f};
        LinkedList<Float> listOfFloat = new LinkedList<Float>();
        for (int i = 0; i < floatArr.length; ++i) {
            listOfFloat.add(new Float(floatArr[i]));
        }
        int listHashCode = ((Object)listOfFloat).hashCode();
        int arrayHashCode = Arrays.hashCode(floatArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
        float[] floatArr2 = new float[]{0.13497f, 0.268934f, 1.2E-4f, -300.0f, 0.001f};
        ArraysTest.assertEquals((int)Arrays.hashCode(floatArr2), (int)Arrays.hashCode(floatArr));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={double[].class})
    public void test_hashCode$LD() {
        double[] doubleArr = new double[]{0.134945657, 0.0038754, 1.1E-149, -3.0E-299, 0.001};
        LinkedList<Double> listOfDouble = new LinkedList<Double>();
        for (int i = 0; i < doubleArr.length; ++i) {
            listOfDouble.add(new Double(doubleArr[i]));
        }
        int listHashCode = ((Object)listOfDouble).hashCode();
        int arrayHashCode = Arrays.hashCode(doubleArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={short[].class})
    public void test_hashCode$LS() {
        short[] shortArr = new short[]{35, 13, 45, 2, 91};
        LinkedList<Short> listOfShort = new LinkedList<Short>();
        for (int i = 0; i < shortArr.length; ++i) {
            listOfShort.add(new Short(shortArr[i]));
        }
        int listHashCode = ((Object)listOfShort).hashCode();
        int arrayHashCode = Arrays.hashCode(shortArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={Object[].class})
    public void test_hashCode$Ljava_lang_Object() {
        Object[] objectArr = new Object[]{new Integer(1), new Float(1.0E-11f), null};
        LinkedList<Object> listOfObject = new LinkedList<Object>();
        for (int i = 0; i < objectArr.length; ++i) {
            listOfObject.add(objectArr[i]);
        }
        int listHashCode = ((Object)listOfObject).hashCode();
        int arrayHashCode = Arrays.hashCode(objectArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    protected void setUp() {
        int counter;
        this.objArray = new Object[100];
        for (int i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
        }
        this.booleanArray = new boolean[100];
        this.byteArray = new byte[100];
        this.charArray = new char[100];
        this.doubleArray = new double[100];
        this.floatArray = new float[100];
        this.intArray = new int[100];
        this.longArray = new long[100];
        this.objectArray = new Object[100];
        this.shortArray = new short[100];
        for (counter = 0; counter < 100; ++counter) {
            this.byteArray[counter] = (byte)counter;
            this.charArray[counter] = (char)(counter + 1);
            this.doubleArray[counter] = counter;
            this.floatArray[counter] = counter;
            this.intArray[counter] = counter;
            this.longArray[counter] = counter;
            this.objectArray[counter] = this.objArray[counter];
            this.shortArray[counter] = (short)counter;
        }
        for (counter = 0; counter < 100; counter += 2) {
            this.booleanArray[counter] = false;
            this.booleanArray[counter + 1] = true;
        }
    }

    protected void tearDown() {
        this.objArray = null;
        this.booleanArray = null;
        this.byteArray = null;
        this.charArray = null;
        this.doubleArray = null;
        this.floatArray = null;
        this.intArray = null;
        this.longArray = null;
        this.objectArray = null;
        this.shortArray = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PrimitiveTypeConverter {
        INT{

            Object convert(int[] a) {
                return a;
            }
        }
        ,
        LONG{

            Object convert(int[] a) {
                long[] b = new long[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = a[i];
                }
                return b;
            }
        }
        ,
        BYTE{

            Object convert(int[] a) {
                byte[] b = new byte[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = (byte)a[i];
                }
                return b;
            }
        }
        ,
        SHORT{

            Object convert(int[] a) {
                short[] b = new short[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = (short)a[i];
                }
                return b;
            }
        }
        ,
        CHAR{

            Object convert(int[] a) {
                char[] b = new char[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = (char)a[i];
                }
                return b;
            }
        }
        ,
        FLOAT{

            Object convert(int[] a) {
                float[] b = new float[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = a[i];
                }
                return b;
            }
        }
        ,
        DOUBLE{

            Object convert(int[] a) {
                double[] b = new double[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = a[i];
                }
                return b;
            }
        };


        abstract Object convert(int[] var1);

        public String toString() {
            String name = this.name();
            for (int i = name.length(); i < 9; ++i) {
                name = name + " ";
            }
            return name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PrimitiveTypeArrayBuilder {
        RANDOM{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = ourRandom.nextInt();
                }
            }
        }
        ,
        ASCENDING{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = m + i;
                }
            }
        }
        ,
        DESCENDING{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = a.length - m - i;
                }
            }
        }
        ,
        ALL_EQUAL{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = m;
                }
            }
        }
        ,
        SAW{

            void build(int[] a, int m) {
                int incCount = 1;
                int decCount = a.length;
                int i = 0;
                int period = m--;
                while (true) {
                    int k;
                    for (k = 1; k <= period; ++k) {
                        if (i >= a.length) {
                            return;
                        }
                        a[i++] = incCount++;
                    }
                    period += m;
                    for (k = 1; k <= period; ++k) {
                        if (i >= a.length) {
                            return;
                        }
                        a[i++] = decCount--;
                    }
                    period += m;
                }
            }
        }
        ,
        REPEATED{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = i % m;
                }
            }
        }
        ,
        DUPLICATED{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = ourRandom.nextInt(m);
                }
            }
        }
        ,
        ORGAN_PIPES{

            void build(int[] a, int m) {
                int i;
                int middle = a.length / (m + 1);
                for (i = 0; i < middle; ++i) {
                    a[i] = i;
                }
                for (i = middle; i < a.length; ++i) {
                    a[i] = a.length - i - 1;
                }
            }
        }
        ,
        STAGGER{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = (i * m + i) % a.length;
                }
            }
        }
        ,
        PLATEAU{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = Math.min(i, m);
                }
            }
        }
        ,
        SHUFFLE{

            void build(int[] a, int m) {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = ourRandom.nextBoolean() ? (ourFirst += 2) : (ourSecond += 2);
                }
            }
        };

        private static int ourFirst;
        private static int ourSecond;
        private static Random ourRandom;

        abstract void build(int[] var1, int var2);

        static void reset() {
            ourRandom = new Random(666L);
            ourFirst = 0;
            ourSecond = 0;
        }

        public String toString() {
            String name = this.name();
            for (int i = name.length(); i < 12; ++i) {
                name = name + " ";
            }
            return name;
        }

        static {
            ourRandom = new Random(666L);
        }
    }

    public static class ReversedIntegerComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return -((Integer)o1).compareTo((Integer)o2);
        }

        public boolean equals(Object o1, Object o2) {
            return ((Integer)o1).compareTo((Integer)o2) == 0;
        }
    }
}

