/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import tests.support.Support_ListTest;

@TestTargetClass(value=ArrayList.class)
public class ArrayListTest
extends TestCase {
    List alist;
    Object[] objArray;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ArrayList", args={})
    public void test_Constructor() {
        new Support_ListTest("", this.alist).runTest();
        ArrayList<Integer> subList = new ArrayList<Integer>();
        for (int i = -50; i < 150; ++i) {
            subList.add(new Integer(i));
        }
        new Support_ListTest("", subList.subList(50, 150)).runTest();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ArrayList", args={int.class})
    public void test_ConstructorI() {
        ArrayList al = new ArrayList(5);
        ArrayListTest.assertEquals((String)"Incorrect arrayList created", (int)0, (int)al.size());
        try {
            new ArrayList(-10);
            ArrayListTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Doesn't verify NullPointerException.", method="ArrayList", args={Collection.class})
    public void test_ConstructorLjava_util_Collection() {
        ArrayList<Object> al = new ArrayList<Object>(Arrays.asList(this.objArray));
        ArrayListTest.assertTrue((String)"arrayList created from collection has incorrect size", (al.size() == this.objArray.length ? 1 : 0) != 0);
        for (int counter = 0; counter < this.objArray.length; ++counter) {
            ArrayListTest.assertTrue((String)"arrayList created from collection has incorrect elements", (al.get(counter) == this.objArray[counter] ? 1 : 0) != 0);
        }
        try {
            new ArrayList(null);
            ArrayListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={int.class, Object.class})
    public void test_addILjava_lang_Object() {
        Object o = new Object();
        this.alist.add(50, o);
        ArrayListTest.assertTrue((String)"Failed to add Object", (this.alist.get(50) == o ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)"Failed to fix up list after insert", (this.alist.get(51) == this.objArray[50] && this.alist.get(52) == this.objArray[51] ? 1 : 0) != 0);
        Object oldItem = this.alist.get(25);
        this.alist.add(25, null);
        ArrayListTest.assertNull((String)"Should have returned null", this.alist.get(25));
        ArrayListTest.assertTrue((String)"Should have returned the old item from slot 25", (this.alist.get(26) == oldItem ? 1 : 0) != 0);
        try {
            this.alist.add(-1, null);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.alist.add(this.alist.size() + 1, null);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void test_addLjava_lang_Object() {
        Object o = new Object();
        this.alist.add(o);
        ArrayListTest.assertTrue((String)"Failed to add Object", (this.alist.get(this.alist.size() - 1) == o ? 1 : 0) != 0);
        this.alist.add(null);
        ArrayListTest.assertNull((String)"Failed to add null", this.alist.get(this.alist.size() - 1));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={int.class, Collection.class})
    public void test_addAllILjava_util_Collection() {
        int i;
        this.alist.addAll(50, this.alist);
        ArrayListTest.assertEquals((String)"Returned incorrect size after adding to existing list", (int)200, (int)this.alist.size());
        for (i = 0; i < 50; ++i) {
            ArrayListTest.assertTrue((String)"Manipulated elements < index", (this.alist.get(i) == this.objArray[i] ? 1 : 0) != 0);
        }
        for (i = 0; i >= 50 && i < 150; ++i) {
            ArrayListTest.assertTrue((String)"Failed to ad elements properly", (this.alist.get(i) == this.objArray[i - 50] ? 1 : 0) != 0);
        }
        for (i = 0; i >= 150 && i < 200; ++i) {
            ArrayListTest.assertTrue((String)"Failed to ad elements properly", (this.alist.get(i) == this.objArray[i - 100] ? 1 : 0) != 0);
        }
        ArrayList<String> listWithNulls = new ArrayList<String>();
        listWithNulls.add(null);
        listWithNulls.add(null);
        listWithNulls.add("yoink");
        listWithNulls.add("kazoo");
        listWithNulls.add(null);
        this.alist.addAll(100, listWithNulls);
        ArrayListTest.assertTrue((String)("Incorrect size: " + this.alist.size()), (this.alist.size() == 205 ? 1 : 0) != 0);
        ArrayListTest.assertNull((String)"Item at slot 100 should be null", this.alist.get(100));
        ArrayListTest.assertNull((String)"Item at slot 101 should be null", this.alist.get(101));
        ArrayListTest.assertEquals((String)"Item at slot 102 should be 'yoink'", (Object)"yoink", this.alist.get(102));
        ArrayListTest.assertEquals((String)"Item at slot 103 should be 'kazoo'", (Object)"kazoo", this.alist.get(103));
        ArrayListTest.assertNull((String)"Item at slot 104 should be null", this.alist.get(104));
        this.alist.addAll(205, listWithNulls);
        ArrayListTest.assertTrue((String)("Incorrect size2: " + this.alist.size()), (this.alist.size() == 210 ? 1 : 0) != 0);
        try {
            this.alist.addAll(-1, listWithNulls);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.alist.addAll(this.alist.size() + 1, listWithNulls);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.alist.addAll(0, null);
            ArrayListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Doesn't verify NullPointerException.", method="addAll", args={Collection.class})
    public void test_addAllLjava_util_Collection() {
        int i;
        ArrayList l = new ArrayList();
        l.addAll(this.alist);
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"Failed to add elements properly", (boolean)l.get(i).equals(this.alist.get(i)));
        }
        this.alist.addAll(this.alist);
        ArrayListTest.assertEquals((String)"Returned incorrect size after adding to existing list", (int)200, (int)this.alist.size());
        for (i = 0; i < 100; ++i) {
            ArrayListTest.assertTrue((String)"Added to list in incorrect order", (boolean)this.alist.get(i).equals(l.get(i)));
            ArrayListTest.assertTrue((String)"Failed to add to existing list", (boolean)this.alist.get(i + 100).equals(l.get(i)));
        }
        HashSet<String> setWithNulls = new HashSet<String>();
        setWithNulls.add(null);
        setWithNulls.add(null);
        setWithNulls.add("yoink");
        setWithNulls.add("kazoo");
        setWithNulls.add(null);
        this.alist.addAll(100, setWithNulls);
        Iterator i2 = setWithNulls.iterator();
        ArrayListTest.assertTrue((String)("Item at slot 100 is wrong: " + this.alist.get(100)), (this.alist.get(100) == i2.next() ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)("Item at slot 101 is wrong: " + this.alist.get(101)), (this.alist.get(101) == i2.next() ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)("Item at slot 103 is wrong: " + this.alist.get(102)), (this.alist.get(102) == i2.next() ? 1 : 0) != 0);
        ArrayList<Integer> originalList = new ArrayList<Integer>(12);
        for (int j = 0; j < 12; ++j) {
            originalList.add(j);
        }
        originalList.remove(0);
        originalList.remove(0);
        ArrayList<Integer> additionalList = new ArrayList<Integer>(11);
        for (int j = 0; j < 11; ++j) {
            additionalList.add(j);
        }
        ArrayListTest.assertTrue((boolean)originalList.addAll(additionalList));
        ArrayListTest.assertEquals((int)21, (int)originalList.size());
        try {
            this.alist.addAll(null);
            ArrayListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        this.alist.clear();
        ArrayListTest.assertEquals((String)"List did not clear", (int)0, (int)this.alist.size());
        this.alist.add(null);
        this.alist.add(null);
        this.alist.add(null);
        this.alist.add("bam");
        this.alist.clear();
        ArrayListTest.assertEquals((String)"List with nulls did not clear", (int)0, (int)this.alist.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        int i;
        ArrayList x = (ArrayList)((ArrayList)this.alist).clone();
        ArrayListTest.assertTrue((String)"Cloned list was inequal to original", (boolean)x.equals(this.alist));
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"Cloned list contains incorrect elements", (this.alist.get(i) == x.get(i) ? 1 : 0) != 0);
        }
        this.alist.add(null);
        this.alist.add(25, null);
        x = (ArrayList)((ArrayList)this.alist).clone();
        ArrayListTest.assertTrue((String)"nulls test - Cloned list was inequal to original", (boolean)x.equals(this.alist));
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"nulls test - Cloned list contains incorrect elements", (this.alist.get(i) == x.get(i) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="contains", args={Object.class})
    public void test_containsLjava_lang_Object() {
        ArrayListTest.assertTrue((String)"Returned false for valid element", (boolean)this.alist.contains(this.objArray[99]));
        ArrayListTest.assertTrue((String)"Returned false for equal element", (boolean)this.alist.contains(new Integer(8)));
        ArrayListTest.assertTrue((String)"Returned true for invalid element", (!this.alist.contains(new Object()) ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)"Returned true for null but should have returned false", (!this.alist.contains(null) ? 1 : 0) != 0);
        this.alist.add(null);
        ArrayListTest.assertTrue((String)"Returned false for null but should have returned true", (boolean)this.alist.contains(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="ensureCapacity", args={int.class})
    public void test_ensureCapacityI() {
        int i;
        Object testObject = new Object();
        int capacity = 20;
        ArrayList<Object> al = new ArrayList<Object>(capacity);
        for (i = 0; i < capacity / 2; ++i) {
            al.add(i, new Object());
        }
        al.add(i, testObject);
        int location = al.indexOf(testObject);
        try {
            al.ensureCapacity(capacity);
            ArrayListTest.assertTrue((String)"EnsureCapacity moved objects around in array1.", (location == al.indexOf(testObject) ? 1 : 0) != 0);
            al.remove(0);
            al.ensureCapacity(capacity);
            ArrayListTest.assertTrue((String)"EnsureCapacity moved objects around in array2.", (--location == al.indexOf(testObject) ? 1 : 0) != 0);
            al.ensureCapacity(capacity + 2);
            ArrayListTest.assertTrue((String)"EnsureCapacity did not change location.", (location == al.indexOf(testObject) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            ArrayListTest.fail((String)("Exception during test : " + e.getMessage()));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={int.class})
    public void test_getI() {
        ArrayListTest.assertTrue((String)"Returned incorrect element", (this.alist.get(22) == this.objArray[22] ? 1 : 0) != 0);
        try {
            this.alist.get(8765);
            ArrayListTest.fail((String)"Failed to throw expected exception for index > size");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="indexOf", args={Object.class})
    public void test_indexOfLjava_lang_Object() {
        ArrayListTest.assertEquals((String)"Returned incorrect index", (int)87, (int)this.alist.indexOf(this.objArray[87]));
        ArrayListTest.assertEquals((String)"Returned index for invalid Object", (int)-1, (int)this.alist.indexOf(new Object()));
        this.alist.add(25, null);
        this.alist.add(50, null);
        ArrayListTest.assertTrue((String)("Wrong indexOf for null.  Wanted 25 got: " + this.alist.indexOf(null)), (this.alist.indexOf(null) == 25 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        ArrayListTest.assertTrue((String)"isEmpty returned false for new list", (boolean)new ArrayList().isEmpty());
        ArrayListTest.assertTrue((String)"Returned true for existing list with elements", (!this.alist.isEmpty() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastIndexOf", args={Object.class})
    public void test_lastIndexOfLjava_lang_Object() {
        this.alist.add(new Integer(99));
        ArrayListTest.assertEquals((String)"Returned incorrect index", (int)100, (int)this.alist.lastIndexOf(this.objArray[99]));
        ArrayListTest.assertEquals((String)"Returned index for invalid Object", (int)-1, (int)this.alist.lastIndexOf(new Object()));
        this.alist.add(25, null);
        this.alist.add(50, null);
        ArrayListTest.assertTrue((String)("Wrong lastIndexOf for null.  Wanted 50 got: " + this.alist.lastIndexOf(null)), (this.alist.lastIndexOf(null) == 50 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={int.class})
    public void test_removeI() {
        this.alist.remove(10);
        ArrayListTest.assertEquals((String)"Failed to remove element", (int)-1, (int)this.alist.indexOf(this.objArray[10]));
        try {
            this.alist.remove(999);
            ArrayListTest.fail((String)"Failed to throw exception when index out of range");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        ArrayList myList = (ArrayList)((ArrayList)this.alist).clone();
        this.alist.add(25, null);
        this.alist.add(50, null);
        this.alist.remove(50);
        this.alist.remove(25);
        ArrayListTest.assertTrue((String)"Removing nulls did not work", (boolean)((Object)this.alist).equals(myList));
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
        ArrayListTest.assertTrue((String)"Removed wrong element 1", (list.remove(0) == "a" ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)"Removed wrong element 2", (list.remove(4) == "f" ? 1 : 0) != 0);
        Object[] result = new String[5];
        list.toArray(result);
        ArrayListTest.assertTrue((String)"Removed wrong element 3", (boolean)Arrays.equals(result, new String[]{"b", "c", "d", "e", "g"}));
        ArrayList<Object> l = new ArrayList<Object>(0);
        l.add(new Object());
        l.add(new Object());
        l.remove(0);
        l.remove(0);
        try {
            l.remove(-1);
            ArrayListTest.fail((String)"-1 should cause exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            l.remove(0);
            ArrayListTest.fail((String)"0 should case exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, Object.class})
    public void test_setILjava_lang_Object() {
        Object obj = new Object();
        this.alist.set(65, obj);
        ArrayListTest.assertTrue((String)"Failed to set object", (this.alist.get(65) == obj ? 1 : 0) != 0);
        this.alist.set(50, null);
        ArrayListTest.assertNull((String)"Setting to null did not work", this.alist.get(50));
        ArrayListTest.assertTrue((String)("Setting increased the list's size to: " + this.alist.size()), (this.alist.size() == 100 ? 1 : 0) != 0);
        try {
            this.alist.set(-1, null);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.alist.set(this.alist.size() + 1, null);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        ArrayListTest.assertEquals((String)"Returned incorrect size for exiting list", (int)100, (int)this.alist.size());
        ArrayListTest.assertEquals((String)"Returned incorrect size for new list", (int)0, (int)new ArrayList().size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={})
    public void test_toArray() {
        this.alist.set(25, null);
        this.alist.set(75, null);
        Object[] obj = this.alist.toArray();
        ArrayListTest.assertEquals((String)"Returned array of incorrect size", (int)this.objArray.length, (int)obj.length);
        for (int i = 0; i < obj.length; ++i) {
            if (i == 25 || i == 75) {
                ArrayListTest.assertNull((String)("Should be null at: " + i + " but instead got: " + obj[i]), (Object)obj[i]);
                continue;
            }
            ArrayListTest.assertTrue((String)("Returned incorrect array: " + i), (obj[i] == this.objArray[i] ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="toArray", args={Object[].class})
    public void test_toArray$Ljava_lang_Object() {
        this.alist.set(25, null);
        this.alist.set(75, null);
        Integer[] argArray = new Integer[100];
        Integer[] retArray = this.alist.toArray(argArray);
        ArrayListTest.assertTrue((String)"Returned different array than passed", (retArray == argArray ? 1 : 0) != 0);
        argArray = new Integer[1000];
        retArray = this.alist.toArray(argArray);
        ArrayListTest.assertNull((String)"Failed to set first extra element to null", (Object)argArray[this.alist.size()]);
        for (int i = 0; i < 100; ++i) {
            if (i == 25 || i == 75) {
                ArrayListTest.assertNull((String)("Should be null: " + i), (Object)retArray[i]);
                continue;
            }
            ArrayListTest.assertTrue((String)("Returned incorrect array: " + i), (retArray[i] == this.objArray[i] ? 1 : 0) != 0);
        }
        String[] strArray = new String[100];
        try {
            this.alist.toArray(strArray);
            ArrayListTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="trimToSize", args={})
    public void test_trimToSize_01() {
        int i;
        for (i = 99; i > 24; --i) {
            this.alist.remove(i);
        }
        ((ArrayList)this.alist).trimToSize();
        ArrayListTest.assertEquals((String)"Returned incorrect size after trim", (int)25, (int)this.alist.size());
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"Trimmed list contained incorrect elements", (this.alist.get(i) == this.objArray[i] ? 1 : 0) != 0);
        }
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("b");
        ArrayList al = new ArrayList(v);
        Iterator it = al.iterator();
        al.remove(0);
        al.trimToSize();
        try {
            it.next();
            ArrayListTest.fail((String)"should throw a ConcurrentModificationException");
        }
        catch (ConcurrentModificationException ioobe) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="trimToSize", args={})
    public void test_trimToSize_02() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
        list.remove("a");
        list.remove("f");
        list.trimToSize();
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify NullPointerException.", method="addAll", args={int.class, Collection.class})
    public void test_addAll() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        ArrayListTest.assertEquals((int)2, (int)list.size());
        list.remove(0);
        ArrayListTest.assertEquals((int)1, (int)list.size());
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("1");
        collection.add("2");
        collection.add("3");
        ArrayListTest.assertEquals((int)3, (int)collection.size());
        list.addAll(0, collection);
        ArrayListTest.assertEquals((int)4, (int)list.size());
        list.remove(0);
        list.remove(0);
        ArrayListTest.assertEquals((int)2, (int)list.size());
        collection.add("4");
        collection.add("5");
        collection.add("6");
        collection.add("7");
        collection.add("8");
        collection.add("9");
        collection.add("10");
        collection.add("11");
        collection.add("12");
        ArrayListTest.assertEquals((int)12, (int)collection.size());
        list.addAll(0, collection);
        ArrayListTest.assertEquals((int)14, (int)list.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
        ArrayListTest.assertTrue((String)"Removed wrong element 1", (boolean)list.remove("a"));
        ArrayListTest.assertTrue((String)"Removed wrong element 2", (boolean)list.remove("f"));
        Object[] result = new String[5];
        list.toArray(result);
        ArrayListTest.assertTrue((String)"Removed wrong element 3", (boolean)Arrays.equals(result, new String[]{"b", "c", "d", "e", "g"}));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeRange", args={int.class, int.class})
    public void test_removeRangeII() {
        Mock_ArrayList mal = new Mock_ArrayList();
        mal.add("a");
        mal.add("b");
        mal.add("c");
        mal.add("d");
        mal.add("e");
        mal.add("f");
        mal.add("g");
        mal.add("h");
        mal.removeRange(2, 4);
        Object[] result = new String[6];
        mal.toArray(result);
        ArrayListTest.assertTrue((String)"Removed wrong element 3", (boolean)Arrays.equals(result, new String[]{"a", "b", "e", "f", "g", "h"}));
    }

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        this.objArray = new Object[100];
        for (i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = new Integer(i);
        }
        this.alist = new ArrayList();
        for (i = 0; i < this.objArray.length; ++i) {
            this.alist.add(this.objArray[i]);
        }
    }

    protected void tearDown() throws Exception {
        this.objArray = null;
        this.alist = null;
        super.tearDown();
    }

    class Mock_ArrayList
    extends ArrayList {
        public void removeRange(int begin, int end) {
            super.removeRange(begin, end);
        }
    }
}

