/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=AbstractSequentialList.class)
public class AbstractSequentialListTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify all exceptions according to the specification.", method="addAll", args={int.class, Collection.class})
    public void test_addAll_ILCollection() {
        ASLT<String> al = new ASLT<String>();
        String[] someList = new String[]{"Aardvark", "Bear", "Chimpanzee", "Duck"};
        List<String> c = Arrays.asList(someList);
        al.addAll(c);
        AbstractSequentialListTest.assertTrue((String)"Should return true", (boolean)al.addAll(2, c));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={int.class, Collection.class})
    public void test_addAllILjava_util_Collection() {
        AbstractSequentialList asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_unsupportedListIterator();
            }
        };
        Vector<String> strV = new Vector<String>();
        strV.add("String");
        strV.add("1");
        strV.add("3.14");
        try {
            asl.addAll(0, strV);
            AbstractSequentialListTest.fail((String)"UnsupportedOperationException expected.");
        }
        catch (UnsupportedOperationException ee) {
            // empty catch block
        }
        try {
            asl.addAll(0, null);
            AbstractSequentialListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_ListIterator();
            }
        };
        try {
            asl.addAll(0, strV);
            AbstractSequentialListTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        strV.remove("String");
        strV.add(null);
        try {
            asl.addAll(0, strV);
            AbstractSequentialListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        strV.remove(null);
        asl.addAll(0, strV);
        asl = new LinkedList();
        try {
            asl.addAll(-10, strV);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            asl.addAll(1, strV);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={int.class, Object.class})
    public void test_addILjava_lang_Object() {
        AbstractSequentialList asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_unsupportedListIterator();
            }
        };
        try {
            asl.add(0, 1);
            AbstractSequentialListTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_ListIterator();
            }
        };
        try {
            asl.add(0, "String");
            AbstractSequentialListTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ee) {
            // empty catch block
        }
        try {
            asl.add(0, null);
            AbstractSequentialListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        asl.add(0, 1);
        asl = new LinkedList();
        try {
            asl.add(-1, 1);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        asl.add(0, 1);
        try {
            asl.add(2, 1);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={int.class})
    public void test_getI() {
        final String[] buff = new String[]{"0", "1", "2", "3", "4", "5"};
        AbstractSequentialList asl = new AbstractSequentialList(){
            int currPos = 0;

            public int size() {
                return buff.length;
            }

            public ListIterator listIterator(int index) {
                this.currPos = index;
                return new ListIterator(){

                    public void add(Object o) {
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public boolean hasPrevious() {
                        return false;
                    }

                    public Object next() {
                        return buff[currPos];
                    }

                    public int nextIndex() {
                        return 0;
                    }

                    public Object previous() {
                        return null;
                    }

                    public int previousIndex() {
                        return 0;
                    }

                    public void remove() {
                    }

                    public void set(Object o) {
                    }
                };
            }
        };
        for (int i = 0; i < buff.length; ++i) {
            AbstractSequentialListTest.assertEquals((Object)buff[i], asl.get(i));
        }
        try {
            asl.get(asl.size() + 1);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            asl.get(-1);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="iterator", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="AbstractSequentialList", args={})})
    public void test_iterrator() {
        AbstractSequentialList asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_unsupportedListIterator();
            }
        };
        AbstractSequentialListTest.assertTrue((boolean)asl.iterator().getClass().toString().contains("Mock_unsupportedListIterator"));
        asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_ListIterator();
            }
        };
        AbstractSequentialListTest.assertTrue((boolean)asl.iterator().getClass().toString().contains("Mock_ListIterator"));
        asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return null;
            }
        };
        AbstractSequentialListTest.assertNull(asl.iterator());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={int.class})
    public void test_removeI() {
        AbstractSequentialList asl = new AbstractSequentialList(){
            String[] buff = new String[]{"0", "1", "2", "3", "4", "5"};
            int currPos = 0;

            public int size() {
                return this.buff.length;
            }

            public ListIterator listIterator(int index) {
                this.currPos = index;
                return new ListIterator(){

                    public void add(Object o) {
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public boolean hasPrevious() {
                        return false;
                    }

                    public Object next() {
                        return buff[currPos];
                    }

                    public int nextIndex() {
                        return 0;
                    }

                    public Object previous() {
                        return null;
                    }

                    public int previousIndex() {
                        return 0;
                    }

                    public void remove() {
                        buff[currPos] = "removed element";
                    }

                    public void set(Object o) {
                    }
                };
            }
        };
        try {
            asl.remove(asl.size() + 1);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            asl.remove(-1);
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        for (int i = 0; i < asl.size(); ++i) {
            AbstractSequentialListTest.assertFalse((boolean)asl.get(i).toString().contains("removed element"));
            asl.remove(i);
            AbstractSequentialListTest.assertTrue((boolean)asl.get(i).toString().contains("removed element"));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={int.class, Object.class})
    public void test_setILjava_lang_Object() {
        AbstractSequentialList asl = new AbstractSequentialList(){
            String[] buff = new String[]{"0", "1", "2", "3", "4", "5"};
            final String illegalStr = "Illegal element";
            int currPos = 0;

            public int size() {
                return this.buff.length;
            }

            public ListIterator listIterator(int index) {
                this.currPos = index;
                return new ListIterator(){

                    public void add(Object o) {
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public boolean hasPrevious() {
                        return false;
                    }

                    public Object next() {
                        return buff[currPos];
                    }

                    public int nextIndex() {
                        return 0;
                    }

                    public Object previous() {
                        return null;
                    }

                    public int previousIndex() {
                        return 0;
                    }

                    public void remove() {
                        buff[currPos] = "removed element";
                    }

                    public void set(Object o) {
                        if (o == null) {
                            throw new NullPointerException();
                        }
                        if (o.equals("Illegal element")) {
                            throw new IllegalArgumentException();
                        }
                        buff[currPos] = (String)o;
                    }
                };
            }
        };
        try {
            asl.set(asl.size() + 1, "new element");
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            asl.set(-1, "new element");
            AbstractSequentialListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        for (int i = 0; i < asl.size(); ++i) {
            AbstractSequentialListTest.assertFalse((boolean)asl.get(i).toString().contains("new element"));
            asl.set(i, "new element");
            AbstractSequentialListTest.assertTrue((boolean)asl.get(i).toString().contains("new element"));
        }
        try {
            asl.set(1, new Double(1.0));
            AbstractSequentialListTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            asl.set(1, "Illegal element");
            AbstractSequentialListTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ee) {
            // empty catch block
        }
        try {
            asl.set(1, null);
            AbstractSequentialListTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
        asl = new AbstractSequentialList(){

            public int size() {
                return 0;
            }

            public ListIterator listIterator(int index) {
                return new Mock_unsupportedListIterator();
            }
        };
        try {
            asl.set(0, "New element");
            AbstractSequentialListTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Mock_ListIterator<E>
    implements ListIterator<E> {
        final String wrongElement = "String";

        Mock_ListIterator() {
        }

        @Override
        public void add(E o) {
            if (o.equals("String")) {
                throw new IllegalArgumentException();
            }
            if (o == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E next() {
            return null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public E previous() {
            return null;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void remove() {
        }

        @Override
        public void set(E o) {
        }
    }

    class Mock_unsupportedListIterator
    implements ListIterator {
        Mock_unsupportedListIterator() {
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return true;
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object next() {
            return null;
        }

        public int nextIndex() {
            return 0;
        }

        public Object previous() {
            return null;
        }

        public int previousIndex() {
            return 0;
        }

        public void remove() {
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ASLT<E>
    extends AbstractSequentialList<E> {
        LinkedList<E> l = new LinkedList();

        ASLT() {
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.l.listIterator(index);
        }

        @Override
        public int size() {
            return this.l.size();
        }
    }
}

