/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=AbstractQueue.class)
public class AbstractQueueTest
extends TestCase {
    private MockAbstractQueue<Object> queue;

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="add", args={Object.class})
    public void test_addLE_null() {
        try {
            this.queue.add(null);
            AbstractQueueTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies IllegalStateException.", method="add", args={Object.class})
    public void test_addLE_Full() {
        Object o = new Object();
        for (int i = 0; i < 10; ++i) {
            this.queue.add(o);
        }
        try {
            this.queue.add(o);
            AbstractQueueTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify NullPointerException, IllegalStateException.", method="add", args={Object.class})
    public void test_addLE() {
        Object o = new Object();
        int LAST_INDEX = 4;
        for (int i = 0; i < 4; ++i) {
            this.queue.add(o);
        }
        Integer I2 = new Integer(123456);
        this.queue.add(I2);
        AbstractQueueTest.assertTrue((boolean)this.queue.contains(I2));
        Iterator<Object> iter = this.queue.iterator();
        for (int i = 0; i < 4; ++i) {
            iter.next();
        }
        AbstractQueueTest.assertTrue((I2 == iter.next() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="addAll", args={Collection.class})
    public void test_addAllLE_null() {
        try {
            this.queue.addAll(null);
            AbstractQueueTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="addAll", args={Collection.class})
    public void test_addAllLE_with_null() {
        List<Serializable> list = Arrays.asList("MYTESTSTRING", null, new Float(123.456));
        try {
            this.queue.addAll(list);
            AbstractQueueTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies IllegalStateException.", method="addAll", args={Collection.class})
    public void test_addAllLE_full() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        try {
            this.queue.addAll(list);
            AbstractQueueTest.fail((String)"should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Regression test. Doesn't verify returned true value.", method="addAll", args={Collection.class})
    public void test_addAllLE_empty() {
        ArrayList list = new ArrayList(0);
        AbstractQueueTest.assertFalse((String)"Non modification to queue should return false", (boolean)this.queue.addAll(list));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies IllegalArgumentException.", method="addAll", args={Collection.class})
    public void test_addAllLE_this() {
        try {
            this.queue.addAll(this.queue);
            AbstractQueueTest.fail((String)"should throw IllegalArgumentException ");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Checks functionality", method="addAll", args={Collection.class})
    public void test_addAllLjava_lang_Object() {
        Vector<Integer> c = new Vector<Integer>();
        c.add(0);
        c.add(1);
        c.add(2);
        c.add(3);
        c.add(4);
        c.add(5);
        AbstractQueueTest.assertTrue((boolean)this.queue.addAll(c));
        AbstractQueueTest.assertEquals((int)6, (int)this.queue.size());
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies clear method for empty queue.", method="clear", args={})
    public void test_clear_empty() {
        this.queue.clear();
        AbstractQueueTest.assertTrue((boolean)this.queue.isEmpty());
        AbstractQueueTest.assertNull((Object)this.queue.peek());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        List<Object> list = Arrays.asList(123.456, "MYTESTSTRING", new Object(), Character.valueOf('c'));
        this.queue.addAll(list);
        this.queue.clear();
        AbstractQueueTest.assertTrue((boolean)this.queue.isEmpty());
        AbstractQueueTest.assertNull((Object)this.queue.peek());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="AbstractQueue", args={})
    public void test_Constructor() {
        MockAbstractQueue queue = new MockAbstractQueue();
        AbstractQueueTest.assertNotNull(queue);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NoSuchElementException.", method="remove", args={})
    public void test_remove_null() {
        try {
            this.queue.remove();
            AbstractQueueTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Verifies positive functionality, NoSuchElementException.", method="remove", args={})
    public void test_remove() {
        char c = 'a';
        this.queue.add(Character.valueOf(c));
        c = 'b';
        this.queue.add(Character.valueOf(c));
        AbstractQueueTest.assertEquals((Object)Character.valueOf('a'), this.queue.remove());
        AbstractQueueTest.assertEquals((Object)Character.valueOf('b'), this.queue.remove());
        try {
            this.queue.remove();
            AbstractQueueTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NoSuchElementException.", method="element", args={})
    public void test_element_empty() {
        try {
            this.queue.element();
            AbstractQueueTest.fail((String)"should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify NoSuchElementException.", method="element", args={})
    public void test_element() {
        String s = "MYTESTSTRING_ONE";
        this.queue.add(s);
        s = "MYTESTSTRING_TWO";
        this.queue.add(s);
        AbstractQueueTest.assertEquals((Object)"MYTESTSTRING_ONE", this.queue.element());
        AbstractQueueTest.assertEquals((Object)"MYTESTSTRING_ONE", this.queue.element());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.queue = new MockAbstractQueue();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.queue = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockAbstractQueue<E>
    extends AbstractQueue<E> {
        static final int CAPACITY = 10;
        private int size = 0;
        private Object[] elements = new Object[10];

        private MockAbstractQueue() {
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int currentIndex = -1;

                @Override
                public boolean hasNext() {
                    return MockAbstractQueue.this.size > 0 && this.currentIndex < MockAbstractQueue.this.size;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++this.currentIndex;
                    return MockAbstractQueue.this.elements[this.currentIndex];
                }

                @Override
                public void remove() {
                    if (-1 == this.currentIndex) {
                        throw new IllegalStateException();
                    }
                    for (int i = this.currentIndex; i < MockAbstractQueue.this.size - 1; ++i) {
                        ((MockAbstractQueue)MockAbstractQueue.this).elements[i] = MockAbstractQueue.this.elements[i + 1];
                    }
                    MockAbstractQueue.this.size--;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean offer(E o) {
            if (null == o) {
                throw new NullPointerException();
            }
            if (this.size >= 10) {
                return false;
            }
            this.elements[this.size++] = o;
            return true;
        }

        @Override
        public E poll() {
            if (this.isEmpty()) {
                return null;
            }
            Object e = this.elements[0];
            for (int i = 0; i < this.size - 1; ++i) {
                this.elements[i] = this.elements[i + 1];
            }
            --this.size;
            return (E)e;
        }

        @Override
        public E peek() {
            if (this.isEmpty()) {
                return null;
            }
            return (E)this.elements[0];
        }
    }
}

