/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestTargetClass(value=AbstractMap.class)
public class AbstractMapTest
extends TestCase {
    static final String specialKey = "specialKey".intern();
    static final String specialValue = "specialValue".intern();

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify returned set of keys.", method="keySet", args={})
    public void test_keySet() {
        HashMap map1 = new HashMap(0);
        AbstractMapTest.assertSame((String)"HashMap(0)", ((AbstractMap)map1).keySet(), ((AbstractMap)map1).keySet());
        HashMap map2 = new HashMap(10);
        AbstractMapTest.assertSame((String)"HashMap(10)", ((AbstractMap)map2).keySet(), ((AbstractMap)map2).keySet());
        Map map3 = Collections.EMPTY_MAP;
        AbstractMapTest.assertSame((String)"EMPTY_MAP", map3.keySet(), map3.keySet());
        IdentityHashMap map4 = new IdentityHashMap(1);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map4).keySet(), ((AbstractMap)map4).keySet());
        LinkedHashMap map5 = new LinkedHashMap(122);
        AbstractMapTest.assertSame((String)"LinkedHashMap", ((AbstractMap)map5).keySet(), ((AbstractMap)map5).keySet());
        TreeMap map6 = new TreeMap();
        AbstractMapTest.assertSame((String)"TreeMap", ((AbstractMap)map6).keySet(), ((AbstractMap)map6).keySet());
        WeakHashMap map7 = new WeakHashMap();
        AbstractMapTest.assertSame((String)"WeakHashMap", ((AbstractMap)map7).keySet(), ((AbstractMap)map7).keySet());
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify UnsupportedOperationException.", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        Object key = new Object();
        Object value = new Object();
        HashMap<String, Object> map1 = new HashMap<String, Object>(0);
        ((AbstractMap)map1).put("key", value);
        AbstractMapTest.assertSame((String)"HashMap(0)", ((AbstractMap)map1).remove("key"), (Object)value);
        IdentityHashMap<Object, Object> map4 = new IdentityHashMap<Object, Object>(1);
        ((AbstractMap)map4).put(key, value);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map4).remove(key), (Object)value);
        LinkedHashMap<Object, Object> map5 = new LinkedHashMap<Object, Object>(122);
        ((AbstractMap)map5).put(key, value);
        AbstractMapTest.assertSame((String)"LinkedHashMap", ((AbstractMap)map5).remove(key), (Object)value);
        TreeMap<Object, Object> map6 = new TreeMap<Object, Object>(new Comparator(){

            public int compare(Object object1, Object object2) {
                return 0;
            }
        });
        ((AbstractMap)map6).put(key, value);
        AbstractMapTest.assertSame((String)"TreeMap", ((AbstractMap)map6).remove(key), (Object)value);
        WeakHashMap<Object, Object> map7 = new WeakHashMap<Object, Object>();
        ((AbstractMap)map7).put(key, value);
        AbstractMapTest.assertSame((String)"WeakHashMap", ((AbstractMap)map7).remove(key), (Object)value);
        MyMap aSpecialMap = new MyMap();
        ((AbstractMap)aSpecialMap).put(specialKey, specialValue);
        Object valueOut = aSpecialMap.remove(specialKey);
        AbstractMapTest.assertSame((String)"MyMap", valueOut, (Object)specialValue);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify returned Collection.", method="values", args={})
    public void test_values() {
        HashMap map1 = new HashMap(0);
        AbstractMapTest.assertSame((String)"HashMap(0)", ((AbstractMap)map1).values(), ((AbstractMap)map1).values());
        HashMap map2 = new HashMap(10);
        AbstractMapTest.assertSame((String)"HashMap(10)", ((AbstractMap)map2).values(), ((AbstractMap)map2).values());
        Map map3 = Collections.EMPTY_MAP;
        AbstractMapTest.assertSame((String)"EMPTY_MAP", map3.values(), map3.values());
        IdentityHashMap map4 = new IdentityHashMap(1);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map4).values(), ((AbstractMap)map4).values());
        LinkedHashMap map5 = new LinkedHashMap(122);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map5).values(), ((AbstractMap)map5).values());
        TreeMap map6 = new TreeMap();
        AbstractMapTest.assertSame((String)"TreeMap", ((AbstractMap)map6).values(), ((AbstractMap)map6).values());
        WeakHashMap map7 = new WeakHashMap();
        AbstractMapTest.assertSame((String)"WeakHashMap", ((AbstractMap)map7).values(), ((AbstractMap)map7).values());
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify CloneNotSupportedException.", method="clone", args={})
    public void test_clone() {
        class MyMap
        extends AbstractMap
        implements Cloneable {
            private Map map = new HashMap();

            MyMap() {
            }

            public Set entrySet() {
                return this.map.entrySet();
            }

            public Object put(Object key, Object value) {
                return this.map.put(key, value);
            }

            public Map getMap() {
                return this.map;
            }

            public Object clone() {
                try {
                    return super.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        MyMap map = new MyMap();
        map.put("one", "1");
        Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
        AbstractMapTest.assertTrue((String)"entry not added", (entry.getKey() == "one" && entry.getValue() == "1" ? 1 : 0) != 0);
        MyMap mapClone = (MyMap)map.clone();
        AbstractMapTest.assertTrue((String)"clone not shallow", (map.getMap() == mapClone.getMap() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify exceptions.", method="putAll", args={Map.class})
    public void test_putAllLMap() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        AMT amt = new AMT();
        ht.put("this", "that");
        amt.putAll(ht);
        AbstractMapTest.assertEquals((String)"Should be equal", (Object)amt, ht);
    }

    public void testEqualsWithNullValues() {
        HashMap<String, String> a = new HashMap<String, String>();
        a.put("a", null);
        a.put("b", null);
        HashMap b = new HashMap();
        a.put("c", "cat");
        a.put("d", "dog");
        AbstractMapTest.assertFalse((boolean)((Object)a).equals(b));
        AbstractMapTest.assertFalse((boolean)((Object)b).equals(a));
    }

    public void testNullsOnViews() {
        Hashtable<String, String> nullHostile = new Hashtable<String, String>();
        nullHostile.put("a", "apple");
        this.testNullsOnView(nullHostile.entrySet());
        nullHostile.put("a", "apple");
        this.testNullsOnView(nullHostile.keySet());
        nullHostile.put("a", "apple");
        this.testNullsOnView(nullHostile.values());
    }

    private void testNullsOnView(Collection<?> view) {
        try {
            AbstractMapTest.assertFalse((boolean)view.contains(null));
        }
        catch (NullPointerException optional) {
            // empty catch block
        }
        try {
            AbstractMapTest.assertFalse((boolean)view.remove(null));
        }
        catch (NullPointerException optional) {
            // empty catch block
        }
        Set<Object> setOfNull = Collections.singleton(null);
        AbstractMapTest.assertFalse((boolean)((Object)view).equals(setOfNull));
        try {
            AbstractMapTest.assertFalse((boolean)view.removeAll(setOfNull));
        }
        catch (NullPointerException optional) {
            // empty catch block
        }
        try {
            AbstractMapTest.assertTrue((boolean)view.retainAll(setOfNull));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public class AMT
    extends AbstractMap {
        Vector values = new Vector();
        Vector keys = new Vector();

        public Set entrySet() {
            return new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        int index = 0;

                        public boolean hasNext() {
                            return this.index < AMT.this.values.size();
                        }

                        public Object next() {
                            if (this.index < AMT.this.values.size()) {
                                Map.Entry me = new Map.Entry(){
                                    Object v;
                                    Object k;
                                    {
                                        this.v = AMT.this.values.elementAt(index);
                                        this.k = AMT.this.keys.elementAt(index);
                                    }

                                    public Object getKey() {
                                        return this.k;
                                    }

                                    public Object getValue() {
                                        return this.v;
                                    }

                                    public Object setValue(Object value) {
                                        return null;
                                    }
                                };
                                ++this.index;
                                return me;
                            }
                            return null;
                        }

                        public void remove() {
                        }
                    };
                }

                public int size() {
                    return AMT.this.values.size();
                }
            };
        }

        public Object put(Object k, Object v) {
            this.keys.add(k);
            this.values.add(v);
            return v;
        }
    }

    class MyMap
    extends AbstractMap {
        final Set mySet = new HashSet(1);

        MyMap() {
            this.mySet.add(new Map.Entry(){

                public Object getKey() {
                    return specialKey;
                }

                public Object getValue() {
                    return specialValue;
                }

                public Object setValue(Object object) {
                    return null;
                }
            });
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Set entrySet() {
            return this.mySet;
        }
    }
}

