/*
 * Decompiled with CFR 0.152.
 */
package tests.api.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import junit.framework.TestCase;

@TestTargetClass(value=AbstractList.class)
public class AbstractListTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void test_hashCode() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(3));
        list.add(new Integer(15));
        list.add(new Integer(5));
        list.add(new Integer(1));
        list.add(new Integer(7));
        int hashCode = 1;
        for (Object e : list) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        AbstractListTest.assertTrue((String)("Incorrect hashCode returned.  Wanted: " + hashCode + " got: " + ((Object)list).hashCode()), (hashCode == ((Object)list).hashCode() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="iterator", args={})
    public void test_iterator() {
        SimpleList list = new SimpleList();
        list.add(new Object());
        list.add(new Object());
        Iterator it = list.iterator();
        it.next();
        it.remove();
        it.next();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="listIterator", args={})
    public void test_listIterator() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(3));
        list.add(new Integer(15));
        list.add(new Integer(5));
        list.add(new Integer(1));
        list.add(new Integer(7));
        ListIterator lit = list.listIterator();
        AbstractListTest.assertTrue((String)"Should not have previous", (!lit.hasPrevious() ? 1 : 0) != 0);
        AbstractListTest.assertTrue((String)"Should have next", (boolean)lit.hasNext());
        Integer tempValue = (Integer)lit.next();
        AbstractListTest.assertTrue((String)("next returned wrong value.  Wanted 3, got: " + tempValue), (tempValue == 3 ? 1 : 0) != 0);
        tempValue = (Integer)lit.previous();
        SimpleList list2 = new SimpleList();
        list2.add(new Object());
        ListIterator<Object> lit2 = list2.listIterator();
        lit2.add(new Object());
        lit2.next();
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies each of the SubList operations to ensure a ConcurrentModificationException does not occur on an AbstractList which does not update modCount.", method="subList", args={int.class, int.class})
    public void test_subListII() {
        SimpleList mList = new SimpleList();
        mList.add(new Object());
        mList.add(new Object());
        List<Object> sList = mList.subList(0, 2);
        sList.add(new Object());
        sList.get(0);
        sList.add(0, new Object());
        sList.get(0);
        sList.addAll(Arrays.asList("1", "2"));
        sList.get(0);
        sList.addAll(0, Arrays.asList("3", "4"));
        sList.get(0);
        sList.remove(0);
        sList.get(0);
        ListIterator<Object> lit = sList.listIterator();
        lit.add(new Object());
        lit.next();
        lit.remove();
        lit.next();
        sList.clear();
        sList.add(new Object());
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            al.add(new Integer(i));
        }
        AbstractListTest.assertTrue((String)"Sublist returned should have implemented Random Access interface", (boolean)(al.subList(3, 7) instanceof RandomAccess));
        LinkedList<Integer> ll = new LinkedList<Integer>();
        for (int i = 0; i < 10; ++i) {
            ll.add(new Integer(i));
        }
        AbstractListTest.assertTrue((String)"Sublist returned should not have implemented Random Access interface", (!(ll.subList(3, 7) instanceof RandomAccess) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies IndexOutOfBoundsException.", method="subList", args={int.class, int.class})
    public void test_subList_empty() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("one");
        List<String> emptySubList = al.subList(0, 0);
        try {
            emptySubList.get(0);
            AbstractListTest.fail((String)"emptySubList.get(0) should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            emptySubList.set(0, "one");
            AbstractListTest.fail((String)"emptySubList.set(0,Object) should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            emptySubList.remove(0);
            AbstractListTest.fail((String)"emptySubList.remove(0) should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify IndexOutOfBoundsException, IllegalArgumentException.", method="subList", args={int.class, int.class})
    public void test_subList_addAll() {
        ArrayList<Object> mainList = new ArrayList<Object>();
        Object[] mainObjects = new Object[]{"a", "b", "c"};
        mainList.addAll(Arrays.asList(mainObjects));
        List<Object> subList = mainList.subList(1, 2);
        AbstractListTest.assertFalse((String)"subList should not contain \"a\"", (boolean)subList.contains("a"));
        AbstractListTest.assertFalse((String)"subList should not contain \"c\"", (boolean)subList.contains("c"));
        AbstractListTest.assertTrue((String)"subList should contain \"b\"", (boolean)subList.contains("b"));
        Object[] subObjects = new Object[]{"one", "two", "three"};
        subList.addAll(Arrays.asList(subObjects));
        AbstractListTest.assertFalse((String)"subList should not contain \"a\"", (boolean)subList.contains("a"));
        AbstractListTest.assertFalse((String)"subList should not contain \"c\"", (boolean)subList.contains("c"));
        Object[] expected = new Object[]{"b", "one", "two", "three"};
        ListIterator iter = subList.listIterator();
        for (int i = 0; i < expected.length; ++i) {
            AbstractListTest.assertTrue((String)("subList should contain " + expected[i]), (boolean)subList.contains(expected[i]));
            AbstractListTest.assertTrue((String)"should be more elements", (boolean)iter.hasNext());
            AbstractListTest.assertEquals((String)"element in incorrect position", (Object)expected[i], iter.next());
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="indexOf", args={Object.class})
    public void test_indexOfLjava_lang_Object() {
        ArrayList<Integer> al = new ArrayList<Integer>();
        ((AbstractList)al).add(0);
        ((AbstractList)al).add(1);
        ((AbstractList)al).add(2);
        ((AbstractList)al).add(3);
        ((AbstractList)al).add(4);
        AbstractListTest.assertEquals((int)-1, (int)((AbstractList)al).indexOf(5));
        AbstractListTest.assertEquals((int)2, (int)((AbstractList)al).indexOf(2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="lastIndexOf", args={Object.class})
    public void test_lastIndexOfLjava_lang_Object() {
        ArrayList<Integer> al = new ArrayList<Integer>();
        ((AbstractList)al).add(0);
        ((AbstractList)al).add(1);
        ((AbstractList)al).add(2);
        ((AbstractList)al).add(2);
        ((AbstractList)al).add(2);
        ((AbstractList)al).add(2);
        ((AbstractList)al).add(2);
        ((AbstractList)al).add(3);
        ((AbstractList)al).add(4);
        AbstractListTest.assertEquals((int)-1, (int)((AbstractList)al).lastIndexOf(5));
        AbstractListTest.assertEquals((int)6, (int)((AbstractList)al).lastIndexOf(2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="listIterator", args={int.class})
    public void test_listIteratorI() {
        ArrayList<Integer> al1 = new ArrayList<Integer>();
        ArrayList<Integer> al2 = new ArrayList<Integer>();
        ((AbstractList)al1).add(0);
        ((AbstractList)al1).add(1);
        ((AbstractList)al1).add(2);
        ((AbstractList)al1).add(3);
        ((AbstractList)al1).add(4);
        ((AbstractList)al2).add(2);
        ((AbstractList)al2).add(3);
        ((AbstractList)al2).add(4);
        ListIterator li1 = ((AbstractList)al1).listIterator(2);
        ListIterator li2 = ((AbstractList)al2).listIterator();
        while (li1.hasNext() && li2.hasNext()) {
            AbstractListTest.assertEquals(li1.next(), li2.next());
        }
        AbstractListTest.assertSame((Object)li1.hasNext(), (Object)li2.hasNext());
        try {
            ((AbstractList)al1).listIterator(-1);
            AbstractListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
        try {
            ((AbstractList)al1).listIterator(((AbstractCollection)al1).size() + 1);
            AbstractListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException ee) {
            // empty catch block
        }
    }

    protected void doneSuite() {
    }

    static class SimpleList
    extends AbstractList {
        ArrayList arrayList = new ArrayList();

        SimpleList() {
        }

        public Object get(int index) {
            return this.arrayList.get(index);
        }

        public void add(int i, Object o) {
            this.arrayList.add(i, o);
        }

        public Object remove(int i) {
            return this.arrayList.remove(i);
        }

        public int size() {
            return this.arrayList.size();
        }
    }
}

