/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.tests.support;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.X509KeyManager;

public class X509KeyManagerImpl
implements X509KeyManager {
    private String keyType;
    private String client = "CLIENT";
    private String server = "SERVER";
    private KeyStore keyTest;
    private X509Certificate[] cert = null;
    String certificate = "-----BEGIN CERTIFICATE-----\nMIICZTCCAdICBQL3AAC2MA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMSAw\nHgYDVQQKExdSU0EgRGF0YSBTZWN1cml0eSwgSW5jLjEuMCwGA1UECxMlU2VjdXJl\nIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NzAyMjAwMDAwMDBa\nFw05ODAyMjAyMzU5NTlaMIGWMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZv\ncm5pYTESMBAGA1UEBxMJUGFsbyBBbHRvMR8wHQYDVQQKExZTdW4gTWljcm9zeXN0\nZW1zLCBJbmMuMSEwHwYDVQQLExhUZXN0IGFuZCBFdmFsdWF0aW9uIE9ubHkxGjAY\nBgNVBAMTEWFyZ29uLmVuZy5zdW4uY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB\niQKBgQCofmdY+PiUWN01FOzEewf+GaG+lFf132UpzATmYJkA4AEA/juW7jSi+LJk\nwJKi5GO4RyZoyimAL/5yIWDV6l1KlvxyKslr0REhMBaD/3Z3EsLTTEf5gVrQS6sT\nWMoSZAyzB39kFfsB6oUXNtV8+UKKxSxKbxvhQn267PeCz5VX2QIDAQABMA0GCSqG\nSIb3DQEBAgUAA34AXl3at6luiV/7I9MN5CXYoPJYI8Bcdc1hBagJvTMcmlqL2uOZ\nH9T5hNMEL9Tk6aI7yZPXcw/xI2K6pOR/FrMp0UwJmdxX7ljV6ZtUZf7pY492UqwC\n1777XQ9UEZyrKJvF5ntleeO0ayBqLGVKCWzWZX9YsXCpv47FNLZbupE=\n-----END CERTIFICATE-----\n";
    ByteArrayInputStream certArray = new ByteArrayInputStream(this.certificate.getBytes());
    String certificate2 = "-----BEGIN CERTIFICATE-----\nMIICZzCCAdCgAwIBAgIBGzANBgkqhkiG9w0BAQUFADBhMQswCQYDVQQGEwJVUzEY\nMBYGA1UEChMPVS5TLiBHb3Zlcm5tZW50MQwwCgYDVQQLEwNEb0QxDDAKBgNVBAsT\nA1BLSTEcMBoGA1UEAxMTRG9EIFBLSSBNZWQgUm9vdCBDQTAeFw05ODA4MDMyMjAy\nMjlaFw0wODA4MDQyMjAyMjlaMGExCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9VLlMu\nIEdvdmVybm1lbnQxDDAKBgNVBAsTA0RvRDEMMAoGA1UECxMDUEtJMRwwGgYDVQQD\nExNEb0QgUEtJIE1lZCBSb290IENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQDbrM/J9FrJSX+zxFUbsI9Vw5QbguVBIa95rwW/0M8+sM0r5gd+DY6iubm6wnXk\nCSvbfQlFEDSKr4WYeeGp+d9WlDnQdtDFLdA45tCi5SHjnW+hGAmZnld0rz6wQekF\n5xQaa5A6wjhMlLOjbh27zyscrorMJ1O5FBOWnEHcRv6xqQIDAQABoy8wLTAdBgNV\nHQ4EFgQUVrmYR6m9701cHQ3r5kXyG7zsCN0wDAYDVR0TBAUwAwEB/zANBgkqhkiG\n9w0BAQUFAAOBgQDVX1Y0YqC7vekeZjVxtyuC8Mnxbrz6D109AX07LEIRzNYzwZ0w\nMTImSp9sEzWW+3FueBIU7AxGys2O7X0qmN3zgszPfSiocBuQuXIYQctJhKjF5KVc\nVGQRYYlt+myhl2vy6yPzEVCjiKwMEb1Spu0irCf+lFW2hsdjvmSQMtZvOw==\n-----END CERTIFICATE-----\n";
    ByteArrayInputStream certArray2 = new ByteArrayInputStream(this.certificate2.getBytes());
    String certificate3 = "-----BEGIN CERTIFICATE-----\nMIIDXDCCAsWgAwIBAgIBSjANBgkqhkiG9w0BAQUFADBWMQswCQYDVQQGEwJVUzEY\nMBYGA1UEChMPVS5TLiBHb3Zlcm5tZW50MQwwCgYDVQQLEwNEb0QxDDAKBgNVBAsT\nA1BLSTERMA8GA1UEAxMITWVkIENBLTEwHhcNOTgwODAyMTgwMjQwWhcNMDEwODAy\nMTgwMjQwWjB0MQswCQYDVQQGEwJVUzEYMBYGA1UEChMPVS5TLiBHb3Zlcm5tZW50\nMQwwCgYDVQQLEwNEb0QxDDAKBgNVBAsTA1BLSTENMAsGA1UECxMEVVNBRjEgMB4G\nA1UEAxMXR3VtYnkuSm9zZXBoLjAwMDAwMDUwNDQwgZ8wDQYJKoZIhvcNAQEBBQAD\ngY0AMIGJAoGBALT/R7bPqs1c1YqXAg5HNpZLgW2HuAc7RCaP06cE4R44GBLw/fQc\nVRNLn5pgbTXsDnjiZVd8qEgYqjKFQka4/tNhaF7No2tBZB+oYL/eP0IWtP+h/W6D\nKR5+UvIIdgmx7k3t9jp2Q51JpHhhKEb9WN54trCO9Yu7PYU+LI85jEIBAgMBAAGj\nggEaMIIBFjAWBgNVHSAEDzANMAsGCWCGSAFlAgELAzAfBgNVHSMEGDAWgBQzOhTo\nCWdhiGUkIOx5cELXppMe9jAdBgNVHQ4EFgQUkLBJl+ayKgzOp/wwBX9M1lSkCg4w\nDgYDVR0PAQH/BAQDAgbAMAwGA1UdEwEB/wQCMAAwgZ0GA1UdHwSBlTCBkjCBj6CB\njKCBiYaBhmxkYXA6Ly9kcy0xLmNoYW1iLmRpc2EubWlsL2NuJTNkTWVkJTIwQ0El\nMmQxJTJjb3UlM2RQS0klMmNvdSUzZERvRCUyY28lM2RVLlMuJTIwR292ZXJubWVu\ndCUyY2MlM2RVUz9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0JTNiYmluYXJ5MA0G\nCSqGSIb3DQEBBQUAA4GBAFjapuDHMvIdUeYRyEYdShBR1JZC20tJ3MQnyBQveddz\nLGFDGpIkRAQU7T/5/ne8lMexyxViC21xOlK9LdbJCbVyywvb9uEm/1je9wieQQtr\nkjykuB+WB6qTCIslAO/eUmgzfzIENvnH8O+fH7QTr2PdkFkiPIqBJYHvw7F3XDqy\n-----END CERTIFICATE-----\n";
    ByteArrayInputStream certArray3 = new ByteArrayInputStream(this.certificate3.getBytes());

    public X509KeyManagerImpl(String name) {
        this.keyType = name;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.keyTest = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyTest.load(null, null);
            if (this.keyType.equals(this.client)) {
                this.cert = new X509Certificate[2];
                this.cert[0] = (X509Certificate)cf.generateCertificate(this.certArray);
                this.cert[1] = (X509Certificate)cf.generateCertificate(this.certArray2);
                this.keyTest.setCertificateEntry("clientAlias_01", this.cert[0]);
                this.keyTest.setCertificateEntry("clientAlias_02", this.cert[0]);
                this.keyTest.setCertificateEntry("clientAlias_03", this.cert[1]);
            } else if (this.keyType.equals(this.server)) {
                this.cert = new X509Certificate[1];
                this.cert[0] = (X509Certificate)cf.generateCertificate(this.certArray3);
                this.keyTest.setCertificateEntry("serverAlias_00", this.cert[0]);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String[] getClientAliases(String s, Principal[] aprincipal) {
        if (s == null || s.equals("")) {
            return null;
        }
        try {
            if (s.equals(this.client)) {
                Enumeration<String> aliase = this.keyTest.aliases();
                Vector<String> vec = new Vector<String>();
                int i = 0;
                while (aliase.hasMoreElements()) {
                    vec.addElement(aliase.nextElement());
                    ++i;
                }
                String[] res = new String[vec.size()];
                for (i = 0; i < vec.size(); ++i) {
                    res[i] = vec.elementAt(i).toString();
                }
                return res;
            }
            return null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String chooseClientAlias(String[] as, Principal[] aprincipal, Socket socket) {
        String alias = null;
        if (as == null || as.length == 0) {
            return null;
        }
        try {
            if (as.length == 1 && as[0].equals(this.client)) {
                alias = socket == null ? this.keyTest.getCertificateAlias(this.cert[0]) : this.keyTest.getCertificateAlias(this.cert[1]);
                return alias;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return null;
    }

    public String[] getServerAliases(String s, Principal[] aprincipal) {
        if (s == null || s.equals("")) {
            return null;
        }
        try {
            if (s.equals(this.server)) {
                Enumeration<String> aliase = this.keyTest.aliases();
                Vector<String> vec = new Vector<String>();
                int i = 0;
                while (aliase.hasMoreElements()) {
                    vec.addElement(aliase.nextElement());
                    ++i;
                }
                String[] res = new String[vec.size()];
                for (i = 0; i < vec.size(); ++i) {
                    res[i] = vec.elementAt(i).toString();
                }
                return res;
            }
            return null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String chooseServerAlias(String as, Principal[] aprincipal, Socket socket) {
        String alias = null;
        if (as == null || as.equals("")) {
            return null;
        }
        try {
            if (as.equals(this.server) && socket != null) {
                alias = this.keyTest.getCertificateAlias(this.cert[0]);
                return alias;
            }
            return null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public X509Certificate[] getCertificateChain(String s) {
        return null;
    }

    public PrivateKey getPrivateKey(String s) {
        return null;
    }
}

