/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.testframework.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import libcore.base.Objects;

public abstract class SerializationTest
extends TestCase {
    public static final String MODE_KEY = "test.mode";
    public static String mode = System.getProperty("test.mode");
    public static final String SERIAL_REFERENCE_MODE = "serial.reference";
    public static final String GOLDEN_PATH = "RESOURCE_DIR";
    private static final String outputPath = System.getProperty("RESOURCE_DIR", "src/test/resources/serialization");
    private static final SerializableAssert DEFAULT_COMPARATOR = new SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            Assert.assertEquals((Object)initial, (Object)deserialized);
        }
    };
    public static final SerializableAssert SAME_COMPARATOR = new SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            Assert.assertSame((Object)initial, (Object)deserialized);
        }
    };
    public static final SerializableAssert THROWABLE_COMPARATOR = new SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            Throwable initThr = (Throwable)initial;
            Throwable dserThr = (Throwable)deserialized;
            Assert.assertEquals(initThr.getClass(), dserThr.getClass());
            Assert.assertEquals((String)initThr.getMessage(), (String)dserThr.getMessage());
            if (initThr.getCause() == null) {
                Assert.assertNull((Object)dserThr.getCause());
            } else {
                Assert.assertNotNull((Object)dserThr.getCause());
                THROWABLE_COMPARATOR.assertDeserialized(initThr.getCause(), dserThr.getCause());
            }
        }
    };
    public static final SerializableAssert PERMISSION_COLLECTION_COMPARATOR = new SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            PermissionCollection initPC = (PermissionCollection)initial;
            PermissionCollection dserPC = (PermissionCollection)deserialized;
            Assert.assertEquals(initPC.getClass(), dserPC.getClass());
            Assert.assertEquals((boolean)initPC.isReadOnly(), (boolean)dserPC.isReadOnly());
            HashSet<Permission> refCollection = new HashSet<Permission>(Collections.list(initPC.elements()));
            HashSet<Permission> tstCollection = new HashSet<Permission>(Collections.list(dserPC.elements()));
            Assert.assertEquals(refCollection, tstCollection);
        }
    };

    public SerializationTest(String name) {
        super(name);
    }

    public SerializationTest() {
    }

    public void runBare() throws Throwable {
        if (Objects.equal((Object)mode, (Object)SERIAL_REFERENCE_MODE)) {
            this.produceGoldenFiles();
        } else {
            super.runBare();
        }
    }

    protected abstract Object[] getData();

    public void testSelf() throws Throwable {
        if (this instanceof SerializableAssert) {
            SerializationTest.verifySelf(this.getData(), (SerializableAssert)((Object)this));
        } else {
            SerializationTest.verifySelf(this.getData());
        }
    }

    public void testGolden() throws Throwable {
        SerializationTest.verifyGolden((TestCase)this, this.getData());
    }

    protected File getDataFile(int index) {
        String name = ((Object)((Object)this)).getClass().getName();
        int dot = name.lastIndexOf(".");
        String path = name.substring(0, dot).replace('.', File.separatorChar);
        if (outputPath != null && outputPath.length() != 0) {
            path = outputPath + File.separator + path;
        }
        return new File(path, name.substring(dot + 1) + "." + index + ".dat");
    }

    protected void produceGoldenFiles() throws IOException {
        String goldenPath = outputPath + File.separatorChar + ((Object)((Object)this)).getClass().getName().replace('.', File.separatorChar) + ".golden.";
        Object[] data = this.getData();
        for (int i = 0; i < data.length; ++i) {
            File goldenFile = new File(goldenPath + i + ".ser");
            goldenFile.getParentFile().mkdirs();
            goldenFile.createNewFile();
            SerializationTest.putObjectToStream(data[i], new FileOutputStream(goldenFile));
        }
    }

    public static void putObjectToStream(Object obj, OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
    }

    public static Serializable getObjectFromStream(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Object result = ois.readObject();
        ois.close();
        return (Serializable)result;
    }

    public static SerializableAssert defineComparator(TestCase test, Object object) throws Exception {
        if (test instanceof SerializableAssert) {
            return (SerializableAssert)test;
        }
        Method m = object.getClass().getMethod("equals", Object.class);
        if (m.getDeclaringClass() != Object.class) {
            return DEFAULT_COMPARATOR;
        }
        if (object instanceof Throwable) {
            return THROWABLE_COMPARATOR;
        }
        if (object instanceof PermissionCollection) {
            return PERMISSION_COLLECTION_COMPARATOR;
        }
        throw new RuntimeException("Failed to detect comparator");
    }

    public static void verifyGolden(TestCase test, Object object) throws Exception {
        SerializationTest.verifyGolden(test, object, SerializationTest.defineComparator(test, object));
    }

    public static void verifyGolden(TestCase test, Object object, SerializableAssert comparator) throws Exception {
        Assert.assertNotNull((String)"Null comparator", (Object)comparator);
        Serializable deserialized = SerializationTest.getObject(test, ".golden.ser");
        comparator.assertDeserialized((Serializable)object, deserialized);
    }

    public static void verifyGolden(TestCase test, Object[] objects) throws Exception {
        Assert.assertFalse((String)"Empty array", (objects.length == 0 ? 1 : 0) != 0);
        SerializationTest.verifyGolden(test, objects, SerializationTest.defineComparator(test, objects[0]));
    }

    public static void verifyGolden(TestCase test, Object[] objects, SerializableAssert comparator) throws Exception {
        Assert.assertFalse((String)"Empty array", (objects.length == 0 ? 1 : 0) != 0);
        for (int i = 0; i < objects.length; ++i) {
            Serializable deserialized = SerializationTest.getObject(test, ".golden." + i + ".ser");
            comparator.assertDeserialized((Serializable)objects[i], deserialized);
        }
    }

    public static void verifySelf(Object object) throws Exception {
        SerializationTest.verifySelf(object, SerializationTest.defineComparator(null, object));
    }

    public static void verifySelf(Object object, SerializableAssert comparator) throws Exception {
        Serializable initial = (Serializable)object;
        comparator.assertDeserialized(initial, SerializationTest.copySerializable(initial));
    }

    public static void verifySelf(Object[] objects) throws Exception {
        Assert.assertFalse((String)"Empty array", (objects.length == 0 ? 1 : 0) != 0);
        SerializationTest.verifySelf(objects, SerializationTest.defineComparator(null, objects[0]));
    }

    public static void verifySelf(Object[] objects, SerializableAssert comparator) throws Exception {
        Assert.assertFalse((String)"Empty array", (objects.length == 0 ? 1 : 0) != 0);
        for (Object entry : objects) {
            SerializationTest.verifySelf(entry, comparator);
        }
    }

    private static Serializable getObject(TestCase test, String toAppend) throws Exception {
        StringBuilder path = new StringBuilder("/serialization");
        path.append(File.separatorChar);
        path.append(test.getClass().getName().replace('.', File.separatorChar));
        path.append(toAppend);
        InputStream in = SerializationTest.class.getResourceAsStream(path.toString());
        Assert.assertNotNull((String)("Failed to load serialization resource file: " + path), (Object)in);
        return SerializationTest.getObjectFromStream(in);
    }

    public static void createGoldenFile(String root, TestCase test, Object object) throws IOException {
        String goldenPath = test.getClass().getName().replace('.', File.separatorChar) + ".golden.ser";
        if (root != null) {
            goldenPath = root + File.separatorChar + goldenPath;
        }
        File goldenFile = new File(goldenPath);
        goldenFile.getParentFile().mkdirs();
        goldenFile.createNewFile();
        SerializationTest.putObjectToStream(object, new FileOutputStream(goldenFile));
        Assert.fail((String)("Generating golden file.\nGolden file name:" + goldenFile.getAbsolutePath()));
    }

    public static Serializable copySerializable(Serializable initial) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SerializationTest.putObjectToStream(initial, out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return SerializationTest.getObjectFromStream(in);
    }

    public static interface SerializableAssert {
        public void assertDeserialized(Serializable var1, Serializable var2);
    }
}

