/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support.interfaces;

import java.security.InvalidParameterException;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAParams;

public class DSAKeyPairGeneratorImpl
implements DSAKeyPairGenerator {
    private KeyPairGenerator dsaKeyPairGenerator = null;
    private SecureRandom secureRandom = null;
    private DSAParams dsaParams = null;
    private int lengthModulus = 0;

    public DSAKeyPairGeneratorImpl(DSAParams dsap) {
        try {
            this.dsaKeyPairGenerator = KeyPairGenerator.getInstance("DSA");
        }
        catch (Exception e) {
            this.dsaKeyPairGenerator = null;
        }
        this.dsaParams = dsap;
    }

    public void initialize(DSAParams params, SecureRandom random) throws InvalidParameterException {
        if (random == null) {
            throw new InvalidParameterException("Incorrect random");
        }
        if (params == null) {
            throw new InvalidParameterException("Incorrect params");
        }
        this.secureRandom = random;
        this.dsaParams = params;
    }

    public void initialize(int modlen, boolean genParams, SecureRandom random) throws InvalidParameterException {
        int len = 512;
        while (len <= 1024) {
            if (len == modlen) {
                this.lengthModulus = modlen;
                break;
            }
            if ((len += 8) != 1032) continue;
            throw new InvalidParameterException("Incorrect modlen");
        }
        if (modlen < 512 || modlen > 1024) {
            throw new InvalidParameterException("Incorrect modlen");
        }
        if (random == null) {
            throw new InvalidParameterException("Incorrect random");
        }
        if (!genParams && this.dsaParams == null) {
            throw new InvalidParameterException("there are not precomputed parameters");
        }
        this.secureRandom = random;
    }
}

