/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support.cert;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.harmony.security.tests.support.cert.MyCRL;
import tests.support.resource.Support_Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    private static final String certType = "X.509";
    private static final String keyStoreType = "BKS";
    private static final String keyStoreFileName = "test.BKS.ks";
    public static final int UNTRUSTED = 1;
    public static final int TRUSTED = 2;
    public static final int TRUSTED_AND_UNTRUSTED = 3;
    private static final char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'w', 'd'};
    private static final String ENCODED_X509_CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIDHTCCAtsCBEFT72swCwYHKoZIzjgEAwUAMHQxCzAJBgNVBAYTAlJVMQwwCgYDVQQIEwNOU08x\nFDASBgNVBAcTC05vdm9zaWJpcnNrMQ4wDAYDVQQKEwVJbnRlbDEVMBMGA1UECxMMRFJMIFNlY3Vy\naXR5MRowGAYDVQQDExFWbGFkaW1pciBNb2xvdGtvdjAeFw0wNDA5MjQwOTU2NTlaFw0wNjA1MTcw\nOTU2NTlaMHQxCzAJBgNVBAYTAlJVMQwwCgYDVQQIEwNOU08xFDASBgNVBAcTC05vdm9zaWJpcnNr\nMQ4wDAYDVQQKEwVJbnRlbDEVMBMGA1UECxMMRFJMIFNlY3VyaXR5MRowGAYDVQQDExFWbGFkaW1p\nciBNb2xvdGtvdjCCAbgwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3Ujzv\nRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7\nqdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8V\nIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrU\nWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEk\nO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GFAAKBgQDiNmj9jgWu1ILYqYWcUhNN\n8CjjRitf80yWP/s/565wZz3anb2w72jum63mdShDko9eOOOd1hiVuiBnNhSL7D6JfIYBJvNXr1av\nGw583BBv12OBgg0eAW/GRWBn2Ak2JjsoBc5x2c1HAEufakep7T6RoC+n3lqbKPKyHWVdfqQ9KTAL\nBgcqhkjOOAQDBQADLwAwLAIUaRS3C9dXcMbrOAhmidFBr7oMvH0CFEC3LUwfLJX5gY8P6uxpkPx3\nJDSM\n-----END CERTIFICATE-----\n";
    public static final String rootCert = "-----BEGIN CERTIFICATE-----\nMIIDLTCCApagAwIBAgIJAIoSN+0trQJuMA0GCSqGSIb3DQEBBQUAMG0xCzAJBgNV\nBAYTAkFOMRAwDgYDVQQIEwdBbmRyb2lkMRAwDgYDVQQKEwdBbmRyb2lkMRAwDgYD\nVQQLEwdBbmRyb2lkMRAwDgYDVQQDEwdBbmRyb2lkMRYwFAYJKoZIhvcNAQkBFgdh\nbmRyb2lkMCAXDTEwMTAwNDAyMjAyOFoYDzIxMTAwOTEwMDIyMDI4WjBtMQswCQYD\nVQQGEwJBTjEQMA4GA1UECBMHQW5kcm9pZDEQMA4GA1UEChMHQW5kcm9pZDEQMA4G\nA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEWMBQGCSqGSIb3DQEJARYH\nYW5kcm9pZDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAykvqj9pIKmAbcGOE\nKCeadMshJd+bAa9mSrQFp+ki+L14L2iK4yu7xvdwrxtt/W132nJ4hjBAYrXnQZXK\no3T0RBGNA0J94y18gDnd7Z5SnLrTR90YwHz5Zw1jRii5w3UnfUGRHNBtTLDIPx6x\nET5tYTH2UBvOc3bW2Jotgif40ucCAwEAAaOB0jCBzzAdBgNVHQ4EFgQUFH027WNE\nv0/bfSiWeGrn7M4sQL8wgZ8GA1UdIwSBlzCBlIAUFH027WNEv0/bfSiWeGrn7M4s\nQL+hcaRvMG0xCzAJBgNVBAYTAkFOMRAwDgYDVQQIEwdBbmRyb2lkMRAwDgYDVQQK\nEwdBbmRyb2lkMRAwDgYDVQQLEwdBbmRyb2lkMRAwDgYDVQQDEwdBbmRyb2lkMRYw\nFAYJKoZIhvcNAQkBFgdhbmRyb2lkggkAihI37S2tAm4wDAYDVR0TBAUwAwEB/zAN\nBgkqhkiG9w0BAQUFAAOBgQB88oTA7kCluZSFGas2Ah0XS5j5ucjFGrDBTw8dHOjE\nz8eHUhmeZFU1uzThOC8nCMXK55cCkP0nzY5aCED1NP9wZcTWH3BP1izLKNjtkbfr\nNQbNDgKoUc23PvmFFpcxe0JMy2/eS92uXp3vhIOJ+Q+mX+STzDC16R30CPTm6VhL\nug==\n-----END CERTIFICATE-----\n";
    public static final String endCert = "-----BEGIN CERTIFICATE-----\nMIICcjCCAdsCCQCJNF/VAS6iKzANBgkqhkiG9w0BAQUFADBtMQswCQYDVQQGEwJB\nTjEQMA4GA1UECBMHQW5kcm9pZDEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMH\nQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEWMBQGCSqGSIb3DQEJARYHYW5kcm9p\nZDAgFw0xMDEwMDQwNDQxNTRaGA8yMTEwMDkxMDA0NDE1NFowgYsxCzAJBgNVBAYT\nAkFOMRAwDgYDVQQIEwdBbmRyb2lkMRAwDgYDVQQHEwdBbmRyb2lkMRAwDgYDVQQK\nEwdBbmRyb2lkMRAwDgYDVQQLEwdBbmRyb2lkMRwwGgYDVQQDExNBbmRyb2lkIENl\ncnRpZmljYXRlMRYwFAYJKoZIhvcNAQkBFgdhbmRyb2lkMIGfMA0GCSqGSIb3DQEB\nAQUAA4GNADCBiQKBgQDGvQZRB7fsuLvnZ0Sx43sTCkvwv/SEYrzRumyV16OC+lvK\nGC2XlYW9qv7of88hqSVq5823MB+uEP1xZLWaiKkYyEn72RwgV/HqB8KEgGYXEbMK\nKzUvj0D1X8kZ/EDGqsZjFKlk/7sZYcg3UqCcGUiEEszTadhyJ6FcowHM1EhrcQID\nAQABMA0GCSqGSIb3DQEBBQUAA4GBAIAGVLpMog0ua9WwsYmy+sL91gKrdK/7HLxH\nQ1iJV4CtWXnpLtlgp6YPnBCf4YChZhlZfhEoFxcKHemNeOjCYTYD/EKxVL0oOTxI\n/Tx558oaFsOKd0IHlhSM0lHKjtu4gjGEXj9osaXwlq6pyobzAXZjmGXdQYER13HI\nrhfHIOci\n-----END CERTIFICATE-----\n";
    public static X509Certificate rootCertificateSS;
    public static X509Certificate endCertificate;
    public static MyCRL crl;
    public static X509CertSelector theCertSelector;
    public static CertPathBuilder builder;
    private static CertStore store;

    public static TrustAnchor getTrustAnchor() {
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance(certType);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new ByteArrayInputStream(TestUtils.getEncodedX509Certificate()));
            X509Certificate c1 = (X509Certificate)cf.generateCertificate(bis);
            TrustAnchor trustAnchor = new TrustAnchor(c1, null);
            return trustAnchor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ign) {}
            }
        }
    }

    public static Set<TrustAnchor> getTrustAnchorSet() {
        TrustAnchor ta = TestUtils.getTrustAnchor();
        if (ta == null) {
            return null;
        }
        HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
        if (!set.add(ta)) {
            throw new RuntimeException("Could not create trust anchor set");
        }
        return set;
    }

    public static KeyStore getKeyStore(boolean initialize, int testKeyStoreType) {
        BufferedInputStream bis = null;
        try {
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            if (initialize) {
                String fileName = keyStoreFileName + testKeyStoreType;
                ks.load(Support_Resources.getResourceStream(fileName), storepass);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (initialize && bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ign) {}
            }
        }
    }

    public static List<CertStore> getCollectionCertStoresList() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ArrayList<CertStore> l = new ArrayList<CertStore>();
        CertStore cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters());
        if (!l.add(cs)) {
            throw new RuntimeException("Could not create cert stores list");
        }
        return l;
    }

    public static PKIXCertPathChecker getTestCertPathChecker() {
        return new PKIXCertPathChecker(){
            private boolean forward = false;

            public void check(Certificate arg0, Collection arg1) throws CertPathValidatorException {
            }

            @Override
            public Set<String> getSupportedExtensions() {
                return null;
            }

            @Override
            public void init(boolean arg0) throws CertPathValidatorException {
                this.forward = arg0;
            }

            @Override
            public boolean isForwardCheckingSupported() {
                return this.forward;
            }
        };
    }

    public static PolicyNode getPolicyTree() {
        return new PolicyNode(){
            final PolicyNode parent = this;

            @Override
            public int getDepth() {
                return 0;
            }

            @Override
            public boolean isCritical() {
                return false;
            }

            @Override
            public String getValidPolicy() {
                return null;
            }

            @Override
            public PolicyNode getParent() {
                return null;
            }

            public Iterator<PolicyNode> getChildren() {
                PolicyNode child = new PolicyNode(){

                    @Override
                    public int getDepth() {
                        return 1;
                    }

                    @Override
                    public boolean isCritical() {
                        return false;
                    }

                    @Override
                    public String getValidPolicy() {
                        return null;
                    }

                    @Override
                    public PolicyNode getParent() {
                        return parent;
                    }

                    public Iterator<PolicyNode> getChildren() {
                        return null;
                    }

                    @Override
                    public Set<String> getExpectedPolicies() {
                        return null;
                    }

                    @Override
                    public Set<? extends PolicyQualifierInfo> getPolicyQualifiers() {
                        return null;
                    }
                };
                HashSet<1> s = new HashSet<1>();
                s.add(child);
                return s.iterator();
            }

            @Override
            public Set<String> getExpectedPolicies() {
                return null;
            }

            @Override
            public Set<? extends PolicyQualifierInfo> getPolicyQualifiers() {
                return null;
            }
        };
    }

    public static byte[] getEncodedX509Certificate() {
        return ENCODED_X509_CERTIFICATE.getBytes();
    }

    public static byte[] getX509Certificate_v1() {
        return new byte[]{48, 107, 48, 92, -96, 3, 2, 1, 0, 2, 1, 5, 48, 7, 6, 2, 3, 5, 1, 1, 7, 48, 12, 49, 10, 48, 8, 6, 3, 85, 4, 3, 19, 1, 90, 48, 30, 23, 13, 57, 57, 49, 50, 49, 51, 49, 52, 49, 53, 49, 54, 90, 23, 13, 48, 48, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 48, 12, 49, 10, 48, 8, 6, 3, 85, 4, 3, 19, 1, 89, 48, 13, 48, 7, 6, 2, 3, 5, 1, 1, 7, 3, 2, 0, 1, 48, 7, 6, 2, 3, 5, 1, 1, 7, 3, 2, 0, 1};
    }

    public static byte[] getX509Certificate_v3() {
        return new byte[]{48, 125, 48, 110, -96, 3, 2, 1, 2, 2, 1, 5, 48, 7, 6, 2, 3, 5, 1, 1, 7, 48, 12, 49, 10, 48, 8, 6, 3, 85, 4, 3, 19, 1, 90, 48, 30, 23, 13, 57, 57, 49, 50, 49, 51, 49, 52, 49, 53, 49, 54, 90, 23, 13, 48, 48, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 48, 12, 49, 10, 48, 8, 6, 3, 85, 4, 3, 19, 1, 89, 48, 13, 48, 7, 6, 2, 3, 5, 1, 1, 7, 3, 2, 0, 1, -93, 16, 48, 14, 48, 12, 6, 3, 85, 29, 35, 1, 1, 0, 4, 2, 48, 0, 48, 7, 6, 2, 3, 5, 1, 1, 7, 3, 2, 0, 1};
    }

    public static byte[] getX509CRL_v1() {
        return new byte[]{48, 53, 48, 39, 48, 6, 6, 1, 1, 1, 1, 17, 48, 12, 49, 10, 48, 8, 6, 3, 85, 4, 3, 19, 1, 90, 24, 15, 50, 48, 48, 49, 48, 49, 48, 49, 48, 49, 48, 50, 48, 51, 90, 48, 6, 6, 1, 1, 1, 1, 17, 3, 2, 0, 1};
    }

    public static void initCertPathSSCertChain() throws CertificateException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance(certType);
        ByteArrayInputStream bi = new ByteArrayInputStream(rootCert.getBytes());
        rootCertificateSS = (X509Certificate)cf.generateCertificate(bi);
        bi = new ByteArrayInputStream(endCert.getBytes());
        endCertificate = (X509Certificate)cf.generateCertificate(bi);
        BigInteger revokedSerialNumber = BigInteger.valueOf(1L);
        crl = new MyCRL(certType);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(rootCertificateSS);
        list.add(endCertificate);
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(list);
        store = CertStore.getInstance("Collection", params);
        theCertSelector = new X509CertSelector();
        theCertSelector.setCertificate(endCertificate);
        theCertSelector.setIssuer(endCertificate.getIssuerX500Principal().getEncoded());
        builder = CertPathBuilder.getInstance("PKIX");
    }

    public static CertPathBuilder getCertPathBuilder() {
        if (builder == null) {
            throw new RuntimeException("Call initCertPathSSCertChain prior to initCertPathSSCertChain");
        }
        return builder;
    }

    public static CertPath buildCertPathSSCertChain() throws Exception {
        return builder.build(TestUtils.getCertPathParameters()).getCertPath();
    }

    public static CertPathParameters getCertPathParameters() throws InvalidAlgorithmParameterException {
        if (rootCertificateSS == null || theCertSelector == null || builder == null) {
            throw new RuntimeException("Call initCertPathSSCertChain prior to buildCertPath");
        }
        PKIXBuilderParameters buildParams = new PKIXBuilderParameters(Collections.singleton(new TrustAnchor(rootCertificateSS, null)), (CertSelector)theCertSelector);
        buildParams.addCertStore(store);
        buildParams.setRevocationEnabled(false);
        return buildParams;
    }
}

