/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support.cert;

import java.io.DataInputStream;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCertificateFactorySpi
extends CertificateFactorySpi {
    private static boolean mode;
    private Set<String> list;

    public MyCertificateFactorySpi() {
        mode = true;
        this.list = new HashSet<String>();
        this.list.add("aa");
        this.list.add("bb");
    }

    public static void putMode(boolean newMode) {
        mode = newMode;
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException {
        if (!(inStream instanceof DataInputStream)) {
            throw new CertificateException("Incorrect inputstream");
        }
        return null;
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        if (!(inStream instanceof DataInputStream)) {
            throw new CertificateException("Incorrect inputstream");
        }
        return null;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        if (!(inStream instanceof DataInputStream)) {
            throw new CRLException("Incorrect inputstream");
        }
        return null;
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        if (!(inStream instanceof DataInputStream)) {
            throw new CRLException("Incorrect inputstream");
        }
        return null;
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        if (!(inStream instanceof DataInputStream)) {
            throw new CertificateException("Incorrect inputstream");
        }
        Iterator<String> it = this.engineGetCertPathEncodings();
        if (!it.hasNext()) {
            throw new CertificateException("There are no CertPath encodings");
        }
        return this.engineGenerateCertPath(inStream, it.next());
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        if (!(inStream instanceof DataInputStream)) {
            throw new CertificateException("Incorrect inputstream");
        }
        if (encoding.length() == 0 && mode) {
            throw new IllegalArgumentException("Encoding is empty");
        }
        return null;
    }

    @Override
    public CertPath engineGenerateCertPath(List<? extends Certificate> certificates) {
        if (certificates == null && mode) {
            throw new NullPointerException("certificates is null");
        }
        return null;
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        if (!mode) {
            this.list.clear();
        }
        return this.list.iterator();
    }
}

