/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support.cert;

import java.io.ObjectStreamException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Extension;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCertificate
extends Certificate
implements X509Extension {
    private static final long serialVersionUID = -1835303280727190066L;
    private final byte[] encoding;
    public Certificate.CertificateRep rep;

    public MyCertificate(String type, byte[] encoding) {
        super(type);
        this.encoding = encoding;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.encoding.clone();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    @Override
    public String toString() {
        return "[My test Certificate, type: " + this.getType() + "]";
    }

    @Override
    public Object writeReplace() throws ObjectStreamException {
        return super.writeReplace();
    }

    @Override
    public PublicKey getPublicKey() {
        return new PublicKey(){
            private static final long serialVersionUID = 788077928335589816L;

            public String getAlgorithm() {
                return "TEST";
            }

            public byte[] getEncoded() {
                return new byte[]{1, 2, 3};
            }

            public String getFormat() {
                return "TEST_FORMAT";
            }
        };
    }

    public Certificate.CertificateRep getCertificateRep() throws ObjectStreamException {
        Object obj = super.writeReplace();
        return (MyCertificateRep)obj;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return null;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public class MyCertificateRep
    extends Certificate.CertificateRep {
        private static final long serialVersionUID = -3474284043994635553L;
        private String type;
        private byte[] data;

        public MyCertificateRep(String type, byte[] data) {
            super(type, data);
            this.data = data;
            this.type = type;
        }

        public Object readResolve() throws ObjectStreamException {
            return super.readResolve();
        }

        public String getType() {
            return this.type;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

