/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support.cert;

import java.io.ObjectStreamException;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.harmony.security.tests.support.cert.MyCertificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCertPath
extends CertPath {
    private static final long serialVersionUID = 7444835599161870893L;
    private final Vector<MyCertificate> certificates;
    private final Vector<String> encodingNames;
    private final byte[] encoding;

    public MyCertPath(byte[] encoding) {
        super("MyEncoding");
        this.encoding = encoding;
        this.certificates = new Vector();
        this.certificates.add(new MyCertificate("MyEncoding", encoding));
        this.encodingNames = new Vector();
        this.encodingNames.add("MyEncoding");
    }

    public List<MyCertificate> getCertificates() {
        return Collections.unmodifiableList(this.certificates);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.encoding.clone();
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (this.getType().equals(encoding)) {
            return (byte[])this.encoding.clone();
        }
        throw new CertificateEncodingException("Encoding not supported: " + encoding);
    }

    @Override
    public Iterator<String> getEncodings() {
        return Collections.unmodifiableCollection(this.encodingNames).iterator();
    }

    @Override
    public Object writeReplace() throws ObjectStreamException {
        return super.writeReplace();
    }

    public class MyCertPathRep
    extends CertPath.CertPathRep {
        private static final long serialVersionUID = 1609000085450479173L;
        private String type;
        private byte[] data;

        public MyCertPathRep(String type, byte[] data) {
            super(type, data);
            this.data = data;
            this.type = type;
        }

        public Object readResolve() throws ObjectStreamException {
            return super.readResolve();
        }

        public String getType() {
            return this.type;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

