/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.harmony.security.tests.support.cert.MyCertificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestKeyStoreSpi
extends KeyStoreSpi {
    Map<String, Object> aliases = new HashMap<String, Object>();
    public static final Certificate CERT = new MyCertificate("certtype", new byte[0]);
    public static final Certificate[] CERTCHAIN = new Certificate[]{new MyCertificate("cert1", new byte[0]), new MyCertificate("cert2", new byte[0])};
    public static final Key KEY = new SecretKey(){

        public String getAlgorithm() {
            return "secret";
        }

        public byte[] getEncoded() {
            return new byte[]{42};
        }

        public String getFormat() {
            return "format";
        }
    };
    public static final Object DUMMY = new Object();

    public TestKeyStoreSpi() {
        this.aliases.put("certalias", CERT);
        this.aliases.put("chainalias", CERTCHAIN);
        this.aliases.put("keyalias", KEY);
        this.aliases.put("unknownalias", DUMMY);
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliases.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.aliases.containsKey(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("entry " + alias + " cannot be deleted");
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return (Certificate)this.aliases.get(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<String, Object> alias : this.aliases.entrySet()) {
            if (alias.getValue() != cert) continue;
            return alias.getKey();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return (Certificate[])this.aliases.get(alias);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date(0x2A00000L);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(alias)) {
            if (!this.engineIsKeyEntry(alias)) {
                if (password == null) {
                    throw new NoSuchAlgorithmException("no such alg");
                }
                throw new UnrecoverableKeyException();
            }
            return (Key)this.aliases.get(alias);
        }
        throw new UnrecoverableKeyException();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            Certificate c = (Certificate)this.aliases.get(alias);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            Key k = (Key)this.aliases.get(alias);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null && stream.available() == 0) {
            throw new IOException();
        }
        if (password == null) {
            throw new NoSuchAlgorithmException();
        }
        if (password.length == 0) {
            throw new CertificateException();
        }
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            this.engineLoad(null, null);
            return;
        }
        KeyStore.ProtectionParameter pParam = param.getProtectionParameter();
        if (pParam == null) {
            throw new NoSuchAlgorithmException();
        }
        if (pParam instanceof KeyStore.PasswordProtection) {
            char[] password = ((KeyStore.PasswordProtection)pParam).getPassword();
            if (password == null) {
                throw new NoSuchAlgorithmException();
            }
            return;
        }
        throw new CertificateException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (this.engineContainsAlias(alias) && !this.engineIsCertificateEntry(alias)) {
            throw new KeyStoreException("alias is not a cert entry");
        }
        this.aliases.put(alias, cert);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (this.engineContainsAlias(alias) && !this.engineIsKeyEntry(alias)) {
            throw new KeyStoreException("alias is not a key enrty");
        }
        if (key instanceof PrivateKey && (chain == null || chain.length == 0)) {
            throw new IllegalArgumentException();
        }
        this.aliases.put(alias, key);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("set entry failed");
    }

    @Override
    public int engineSize() {
        return this.aliases.size();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            throw new IOException("store failed");
        }
        if (password == null) {
            throw new NoSuchAlgorithmException();
        }
        if (password.length == 0) {
            throw new CertificateException();
        }
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            throw new IOException();
        }
        KeyStore.ProtectionParameter pParam = param.getProtectionParameter();
        if (pParam instanceof KeyStore.PasswordProtection) {
            char[] password = ((KeyStore.PasswordProtection)pParam).getPassword();
            if (password == null) {
                throw new NoSuchAlgorithmException();
            }
            if (password.length == 0) {
                throw new CertificateException();
            }
            return;
        }
        throw new UnsupportedOperationException();
    }
}

