/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;

public class TestKeyPair {
    private static final HashMap<String, byte[]> privateKeyEncoding = new HashMap();
    private static final HashMap<String, byte[]> publicKeyEncoding = new HashMap();
    private final String algorithmName;
    private final KeyFactory kf;

    public TestKeyPair(String algorithmName) throws NoSuchAlgorithmException {
        this.algorithmName = algorithmName;
        if (!privateKeyEncoding.containsKey(this.algorithmName)) {
            throw new NoSuchAlgorithmException("Encoded form not available for " + this.algorithmName);
        }
        this.kf = KeyFactory.getInstance(this.algorithmName);
    }

    public PublicKey getPublic() throws InvalidKeySpecException {
        return this.kf.generatePublic(new X509EncodedKeySpec(publicKeyEncoding.get(this.algorithmName)));
    }

    public PrivateKey getPrivate() throws InvalidKeySpecException {
        return this.kf.generatePrivate(new PKCS8EncodedKeySpec(privateKeyEncoding.get(this.algorithmName)));
    }

    static {
        privateKeyEncoding.put("RSA", new byte[]{48, -126, 2, 119, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 97, 48, -126, 2, 93, 2, 1, 0, 2, -127, -127, 0, -78, 74, -101, 91, -70, 1, -64, -51, 101, 9, 99, 112, 11, 90, 27, -110, 8, -8, 85, 94, 124, 27, 80, 23, -20, 68, 76, 88, 66, 43, 65, 9, 89, -14, -31, 93, 67, 113, 77, -110, 3, 29, -74, 108, 127, 93, 72, -51, 23, -20, -41, 76, 57, -79, 123, -30, -65, -106, 119, -66, -48, -96, -16, 45, 107, 36, -86, 20, -70, -126, 121, 16, -101, 22, 104, 71, -127, 84, -94, -6, -111, -98, 10, 42, 83, -90, -25, -98, 125, 41, 51, -40, 5, -4, 2, 63, -67, -57, 110, -19, -86, 48, 108, 95, 82, -19, 53, 101, 75, 14, -56, -89, 18, 16, 86, 55, -81, 17, -6, 33, 14, -103, -1, -6, -116, 101, -114, 109, 2, 3, 1, 0, 1, 2, -127, -128, 120, 65, 114, 64, -112, 89, -106, 93, -13, -124, 61, -103, -39, 78, 81, -62, 82, 98, -115, -46, 73, 11, 115, 30, 111, -78, 49, 124, 102, 69, 30, 124, -36, 58, -62, 95, 81, -102, 30, -92, 25, -115, -12, -7, -127, 126, -66, 23, -9, -57, 60, 0, -95, -7, 96, -126, 52, -113, -100, -3, 11, 99, 66, 27, 127, 69, -15, 49, -61, 99, 71, 92, -63, -78, 95, 87, -18, 2, -97, 94, 8, 72, -70, 116, -70, -127, -73, 48, -84, 76, 1, 53, -50, 70, 71, -116, -28, 98, 54, 26, 101, 14, 51, 86, -7, -73, -96, -60, -74, -126, 85, 125, 54, 85, -64, 82, 94, 53, 84, -67, -105, 1, 0, -65, 16, -36, 27, 81, 2, 65, 0, -25, 104, 3, 62, 33, 100, 104, 36, 123, -48, 49, -96, -94, -39, -121, 109, 121, -127, -113, -113, 45, 122, -107, 46, 85, -97, -41, -122, 41, -109, -67, 4, 126, 79, -37, 86, -15, 117, -48, 75, 0, 58, -32, 38, -10, -85, -98, 11, 42, -12, -88, -41, -1, -66, 1, -21, -101, -127, -57, 95, 2, 115, -31, 43, 2, 65, 0, -59, 61, 120, -85, -26, -85, 62, 41, -3, -104, -48, -92, 62, 88, -18, 72, 69, -93, 102, -84, -23, 77, -67, 96, -22, 36, -1, -19, 12, 103, -59, -3, 54, 40, -22, 116, -120, -47, -47, -83, 88, -41, -16, 103, 32, -63, -29, -77, -37, 82, -83, -13, -60, 33, -40, -116, 76, 65, 39, -37, -48, 53, -110, -57, 2, 65, 0, -32, -103, 66, -76, 118, 2, -105, 85, -7, -38, 59, -96, -41, 14, -36, -12, 51, 127, -67, -49, -48, -21, 110, -119, -9, 79, 90, 7, 124, -87, 73, 71, 104, 53, -88, 5, 61, -3, 4, 123, 23, 49, 13, -56, -93, -104, 52, -96, 80, 68, 0, -15, 12, -26, -27, -60, 65, 61, -8, 61, 78, 11, 28, -37, 2, 65, 0, -126, -101, -118, -3, -95, -104, 65, 104, -62, -47, -33, 78, -13, 46, 38, 83, 91, 49, -79, 122, -52, 94, -69, 9, -94, -30, 111, 74, 4, 13, -17, -112, 21, -66, 16, 74, -84, -110, -21, -38, 114, -37, 67, 8, -73, 43, 76, -31, -69, 88, -53, 113, -128, -83, -68, -36, 98, 94, 62, -53, -110, -38, -10, -33, 2, 64, 77, -127, -112, -59, 119, 48, -73, 41, 0, -88, -15, -76, -82, 82, 99, 0, -78, 45, 62, 125, -42, 77, -7, -118, -63, -79, -104, -119, 82, 64, 20, 27, 14, 97, -113, -12, -66, 89, 121, 121, -107, 25, 92, 81, 8, 102, -63, 66, 48, -77, 122, -122, -97, 62, -11, 25, -93, -82, 100, 105, 20, 7, 80, -105});
        publicKeyEncoding.put("RSA", new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -78, 74, -101, 91, -70, 1, -64, -51, 101, 9, 99, 112, 11, 90, 27, -110, 8, -8, 85, 94, 124, 27, 80, 23, -20, 68, 76, 88, 66, 43, 65, 9, 89, -14, -31, 93, 67, 113, 77, -110, 3, 29, -74, 108, 127, 93, 72, -51, 23, -20, -41, 76, 57, -79, 123, -30, -65, -106, 119, -66, -48, -96, -16, 45, 107, 36, -86, 20, -70, -126, 121, 16, -101, 22, 104, 71, -127, 84, -94, -6, -111, -98, 10, 42, 83, -90, -25, -98, 125, 41, 51, -40, 5, -4, 2, 63, -67, -57, 110, -19, -86, 48, 108, 95, 82, -19, 53, 101, 75, 14, -56, -89, 18, 16, 86, 55, -81, 17, -6, 33, 14, -103, -1, -6, -116, 101, -114, 109, 2, 3, 1, 0, 1});
        privateKeyEncoding.put("DSA", new byte[]{48, -126, 1, 74, 2, 1, 0, 48, -126, 1, 43, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 30, 2, -127, -127, 0, -54, -124, 29, -93, -85, -71, -104, -12, 97, -117, 102, -37, 78, 58, -78, 17, 78, -87, -38, 53, -111, -55, 78, -61, 22, -89, -19, -72, -113, -41, -22, -22, -37, 119, -31, 119, 122, -55, -13, 55, 51, 1, 114, -68, -48, -119, -101, 24, -3, -124, -42, -23, -65, 19, 53, 94, 64, -10, -99, -39, 26, -70, -87, -61, -116, -29, -107, -56, -33, 46, 65, -95, -65, -34, 93, -83, 33, -52, 13, 66, 86, -96, 50, -64, -112, 115, 62, -92, 14, 88, -28, 100, 0, -93, 39, 73, 86, -78, 67, -68, 114, -88, -46, 38, -119, 53, 55, 41, -115, 33, -75, -114, 89, -6, -98, -33, 55, 13, -98, -85, -3, -65, 26, -98, -13, -24, 58, -5, 2, 21, 0, -94, 78, 93, -29, 16, 93, -87, 58, 106, 77, 7, 59, -85, -54, 125, 9, -42, 6, 121, 73, 2, -127, -128, 90, -111, -125, 28, 4, 51, -54, 37, -80, 104, -77, -77, -85, 85, 41, 51, 77, -87, 51, 57, -17, 113, -54, -107, -13, -40, 39, 86, 95, 66, -38, 54, -125, -59, -15, 83, 98, -91, -36, -26, 78, 105, 69, 113, 26, 74, -61, -12, 127, 10, -47, 120, -19, -66, 110, -90, 54, 52, 78, -61, 27, 23, -86, -92, 118, 68, 70, -81, 38, 22, 20, -5, -97, 93, 8, -81, -110, -37, -70, -48, -53, -117, 30, -61, -117, 54, 59, 76, 2, -61, 102, 40, 105, -48, 116, 79, 28, 79, -105, 117, 127, -98, -119, -128, -49, -78, 23, -42, 102, -111, 18, 58, -80, 60, 60, -62, 49, -47, 49, 42, 53, -66, -99, 84, 113, 3, -53, -52, 4, 22, 2, 20, 82, -5, -7, 18, 64, 5, 89, -113, -34, -99, -84, -95, -30, -19, 86, 98, 95, 86, 103, 116});
        publicKeyEncoding.put("DSA", new byte[]{48, -126, 1, -73, 48, -126, 1, 43, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 30, 2, -127, -127, 0, -54, -124, 29, -93, -85, -71, -104, -12, 97, -117, 102, -37, 78, 58, -78, 17, 78, -87, -38, 53, -111, -55, 78, -61, 22, -89, -19, -72, -113, -41, -22, -22, -37, 119, -31, 119, 122, -55, -13, 55, 51, 1, 114, -68, -48, -119, -101, 24, -3, -124, -42, -23, -65, 19, 53, 94, 64, -10, -99, -39, 26, -70, -87, -61, -116, -29, -107, -56, -33, 46, 65, -95, -65, -34, 93, -83, 33, -52, 13, 66, 86, -96, 50, -64, -112, 115, 62, -92, 14, 88, -28, 100, 0, -93, 39, 73, 86, -78, 67, -68, 114, -88, -46, 38, -119, 53, 55, 41, -115, 33, -75, -114, 89, -6, -98, -33, 55, 13, -98, -85, -3, -65, 26, -98, -13, -24, 58, -5, 2, 21, 0, -94, 78, 93, -29, 16, 93, -87, 58, 106, 77, 7, 59, -85, -54, 125, 9, -42, 6, 121, 73, 2, -127, -128, 90, -111, -125, 28, 4, 51, -54, 37, -80, 104, -77, -77, -85, 85, 41, 51, 77, -87, 51, 57, -17, 113, -54, -107, -13, -40, 39, 86, 95, 66, -38, 54, -125, -59, -15, 83, 98, -91, -36, -26, 78, 105, 69, 113, 26, 74, -61, -12, 127, 10, -47, 120, -19, -66, 110, -90, 54, 52, 78, -61, 27, 23, -86, -92, 118, 68, 70, -81, 38, 22, 20, -5, -97, 93, 8, -81, -110, -37, -70, -48, -53, -117, 30, -61, -117, 54, 59, 76, 2, -61, 102, 40, 105, -48, 116, 79, 28, 79, -105, 117, 127, -98, -119, -128, -49, -78, 23, -42, 102, -111, 18, 58, -80, 60, 60, -62, 49, -47, 49, 42, 53, -66, -99, 84, 113, 3, -53, -52, 3, -127, -123, 0, 2, -127, -127, 0, -107, -52, 17, -44, 83, 61, -100, 92, 115, -12, 112, -16, -31, -84, -29, 44, 50, 22, 29, 52, 26, 56, 99, 105, 26, 114, 57, 78, 65, 80, -6, -36, 120, -92, -72, 23, 90, -28, -7, -94, 82, 65, -123, -85, 63, -12, 115, 46, -82, -87, 33, -117, 94, -107, 21, -94, -122, 99, 13, -70, 1, -53, -29, 104, -58, -81, 86, 81, 123, -88, -123, 63, 1, -128, -117, 31, -76, 76, -109, 107, 66, -90, -67, 103, 42, -107, 5, -1, 3, 46, 111, -44, -45, -16, 23, -34, -53, 125, -39, 66, 77, -105, 44, 83, -26, 57, 97, -46, 105, -47, 28, -102, -117, 91, -100, -6, -6, 80, 80, -69, -28, 46, -125, 6, 8, -106, 42, 104});
        privateKeyEncoding.put("DH", new byte[]{48, -127, -31, 2, 1, 0, 48, -127, -105, 6, 9, 42, -122, 72, -122, -9, 13, 1, 3, 1, 48, -127, -119, 2, 65, 0, -16, -86, 34, 90, 41, -78, 63, -55, 11, -121, 93, -111, 81, 1, -92, -71, 78, 30, -123, -4, -90, 90, -106, -79, -53, -127, -93, 110, -112, -67, -94, 14, -76, -70, 44, 69, 9, 28, -104, 57, 38, 36, 64, -128, -50, 21, -117, -31, 103, 72, -13, 112, -104, -54, -89, 113, 51, -74, 4, 19, -27, 97, 60, 31, 2, 64, 30, -40, 111, -50, 35, 113, 106, 42, -93, 77, 98, -23, 95, 23, -88, -24, -86, -118, -107, 38, 124, 56, -87, 43, 72, 90, 22, 25, -6, -125, -72, 118, -81, -72, 98, 114, 69, -97, -107, 30, 98, 54, -105, -65, -85, 32, -80, 97, -59, 33, -98, -28, -34, -111, 28, 106, 7, 72, 119, 112, 29, -1, 88, 35, 2, 2, 1, -1, 4, 66, 2, 64, 105, -122, 72, 87, -65, -34, 8, -58, 36, 109, 15, 32, -108, 74, 34, 110, 36, 96, -39, -87, -67, 30, 100, -119, -125, 60, -25, 112, 36, -31, -113, 60, 77, 57, 95, -98, -109, 19, -122, -23, -128, 15, -60, 65, -117, -12, -117, 101, -92, 27, 13, 4, 72, 64, -42, -94, 0, -123, -23, -60, 119, -78, 37, -40});
        publicKeyEncoding.put("DH", new byte[]{48, -127, -32, 48, -127, -105, 6, 9, 42, -122, 72, -122, -9, 13, 1, 3, 1, 48, -127, -119, 2, 65, 0, -16, -86, 34, 90, 41, -78, 63, -55, 11, -121, 93, -111, 81, 1, -92, -71, 78, 30, -123, -4, -90, 90, -106, -79, -53, -127, -93, 110, -112, -67, -94, 14, -76, -70, 44, 69, 9, 28, -104, 57, 38, 36, 64, -128, -50, 21, -117, -31, 103, 72, -13, 112, -104, -54, -89, 113, 51, -74, 4, 19, -27, 97, 60, 31, 2, 64, 30, -40, 111, -50, 35, 113, 106, 42, -93, 77, 98, -23, 95, 23, -88, -24, -86, -118, -107, 38, 124, 56, -87, 43, 72, 90, 22, 25, -6, -125, -72, 118, -81, -72, 98, 114, 69, -97, -107, 30, 98, 54, -105, -65, -85, 32, -80, 97, -59, 33, -98, -28, -34, -111, 28, 106, 7, 72, 119, 112, 29, -1, 88, 35, 2, 2, 1, -1, 3, 68, 0, 2, 65, 0, -99, -60, -51, 16, -33, 102, -110, -31, 51, -79, -55, -97, -73, -35, -124, 75, -27, -122, -16, 83, 42, -43, -58, 21, -108, -82, 19, 123, -99, 55, -117, -58, -58, 120, -100, 96, -118, 111, 53, 57, -32, 120, 51, 96, -119, 48, 97, -124, -118, -68, -128, 108, 28, 85, -106, 80, -79, -106, 5, 33, 101, 85, -69, -92});
    }
}

