/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.harmony.security.tests.support.KeyStoreTestSupport;
import org.apache.harmony.security.tests.support.MyLoadStoreParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyKeyStore
extends KeyStoreSpi {
    private Hashtable<String, Object> Keys = new Hashtable();
    private Hashtable<String, Object> Cert = new Hashtable();
    private Hashtable<String, Object> Chain = new Hashtable();
    private Hashtable<String, Object> Dates = new Hashtable();
    private Hashtable<String, Object> KeysSL = new Hashtable();
    private Hashtable<String, Object> CertSL = new Hashtable();
    private Hashtable<String, Object> ChainSL = new Hashtable();
    private Hashtable<String, Object> DatesSL = new Hashtable();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.Keys.containsKey(alias)) {
            return (Key)this.Keys.get(alias);
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (this.Chain.containsKey(alias)) {
            return (Certificate[])this.Chain.get(alias);
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (this.Cert.containsKey(alias)) {
            return (Certificate)this.Cert.get(alias);
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (this.Dates.containsKey(alias)) {
            return (Date)this.Dates.get(alias);
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (this.Cert.containsKey(alias)) {
            this.Cert.remove(alias);
        }
        this.Keys.put(alias, key);
        if (chain != null) {
            this.Chain.put(alias, chain);
        }
        this.Dates.put(alias, new Date());
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (key == null) {
            throw new KeyStoreException("Not Supported for null key");
        }
        if (this.Cert.containsKey(alias)) {
            this.Cert.remove(alias);
        }
        if (this.Chain.containsKey(alias)) {
            this.Chain.remove(alias);
        }
        KeyStoreTestSupport.MyPrivateKey keyK = new KeyStoreTestSupport.MyPrivateKey(alias, alias, key);
        this.Keys.put(alias, keyK);
        if (chain != null) {
            this.Chain.put(alias, chain);
        }
        this.Dates.put(alias, new Date());
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.Cert.put(alias, cert);
        this.Dates.put(alias, new Date());
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (this.Keys.containsKey(alias)) {
            this.Keys.remove(alias);
            this.Chain.remove(alias);
            return;
        }
        if (this.Cert.containsKey(alias)) {
            this.Cert.remove(alias);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return null;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (this.Keys.containsKey(alias)) {
            return true;
        }
        return this.Cert.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.Keys.size() + this.Cert.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.Keys.containsKey(alias);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.Cert.containsKey(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return "";
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        String alias;
        if (!(stream instanceof ByteArrayOutputStream)) {
            throw new IOException("Incorrect stream");
        }
        Enumeration<String> e = this.Keys.keys();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            this.KeysSL.put(alias, this.Keys.get(alias));
            this.DatesSL.put(alias, this.Dates.get(alias));
            if (!this.Chain.containsKey(alias)) continue;
            this.ChainSL.put(alias, this.Chain.get(alias));
        }
        e = this.Cert.keys();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            this.CertSL.put(alias, this.Cert.get(alias));
            this.DatesSL.put(alias, this.Dates.get(alias));
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        String alias;
        this.Keys.clear();
        this.Cert.clear();
        this.Chain.clear();
        this.Dates.clear();
        Enumeration<String> e = this.KeysSL.keys();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            this.Keys.put(alias, this.KeysSL.get(alias));
            this.Dates.put(alias, this.DatesSL.get(alias));
            if (!this.ChainSL.containsKey(alias)) continue;
            this.Chain.put(alias, this.ChainSL.get(alias));
        }
        e = this.CertSL.keys();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            this.Cert.put(alias, this.CertSL.get(alias));
            this.Dates.put(alias, this.DatesSL.get(alias));
        }
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            throw new IOException("param is null");
        }
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (!(param instanceof MyLoadStoreParams)) {
            throw new IllegalArgumentException("param is not MyLoadStoreParams: " + param);
        }
    }
}

